/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.implementation.DeploymentSlotImpl;
import com.azure.resourcemanager.appservice.implementation.WebAppImpl;
import com.azure.resourcemanager.appservice.implementation.WebDeploymentSlotBasicImpl;
import com.azure.resourcemanager.appservice.models.DeploymentSlot;
import com.azure.resourcemanager.appservice.models.DeploymentSlots;
import com.azure.resourcemanager.appservice.models.WebApp;
import com.azure.resourcemanager.appservice.models.WebDeploymentSlotBasic;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.IndependentChildResourcesImpl;
import reactor.core.publisher.Mono;

class DeploymentSlotsImpl
extends IndependentChildResourcesImpl<DeploymentSlot, DeploymentSlotImpl, SiteInner, WebAppsClient, AppServiceManager, WebApp>
implements DeploymentSlots {
    private final WebAppImpl parent;

    DeploymentSlotsImpl(WebAppImpl parent) {
        super((Object)((WebSiteManagementClient)((AppServiceManager)parent.manager()).serviceClient()).getWebApps(), (Manager)((AppServiceManager)parent.manager()));
        this.parent = parent;
    }

    protected DeploymentSlotImpl wrapModel(String name) {
        return (DeploymentSlotImpl)((DeploymentSlotImpl)new DeploymentSlotImpl(name, new SiteInner(), null, null, this.parent).withRegion(this.parent.regionName())).withExistingResourceGroup(this.parent.resourceGroupName());
    }

    protected DeploymentSlotImpl wrapModel(SiteInner inner) {
        return this.wrapModel(inner, null, null);
    }

    public DeploymentSlotImpl define(String name) {
        return this.wrapModel(name);
    }

    public Mono<DeploymentSlot> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((WebAppsClient)this.innerCollection).getSlotAsync(resourceGroup, parentName, name).flatMap(siteInner -> Mono.zip(((WebAppsClient)this.innerCollection).getConfigurationSlotAsync(resourceGroup, parentName, name.replaceAll(".*/", "")), ((WebAppsClient)this.innerCollection).getDiagnosticLogsConfigurationSlotAsync(resourceGroup, parentName, name.replaceAll(".*/", "")), (siteConfigResourceInner, logsConfigInner) -> this.wrapModel((SiteInner)((Object)siteInner), (SiteConfigResourceInner)((Object)((Object)siteConfigResourceInner)), (SiteLogsConfigInner)((Object)((Object)logsConfigInner)))));
    }

    public PagedIterable<DeploymentSlot> listByParent(String resourceGroupName, String parentName) {
        return new PagedIterable(this.wrapPageAsync(((WebAppsClient)this.innerCollection).listSlotsAsync(resourceGroupName, parentName)));
    }

    public Mono<Void> deleteByParentAsync(String groupName, String parentName, String name) {
        return ((WebAppsClient)this.innerCollection).deleteSlotAsync(groupName, parentName, name);
    }

    public void deleteByName(String name) {
        this.deleteByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.deleteByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public PagedIterable<WebDeploymentSlotBasic> list() {
        return new PagedIterable(this.listAsync());
    }

    public DeploymentSlot getByName(String name) {
        return (DeploymentSlot)this.getByParent(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public Mono<DeploymentSlot> getByNameAsync(String name) {
        return this.getByParentAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public WebApp parent() {
        return this.parent;
    }

    public PagedFlux<WebDeploymentSlotBasic> listAsync() {
        return ((WebAppsClient)this.innerCollection).listSlotsAsync(this.parent.resourceGroupName(), this.parent.name()).mapPage(inner -> new WebDeploymentSlotBasicImpl((SiteInner)((Object)inner), this.parent));
    }

    private DeploymentSlotImpl wrapModel(SiteInner inner, SiteConfigResourceInner siteConfig, SiteLogsConfigInner logConfig) {
        if (inner == null) {
            return null;
        }
        return new DeploymentSlotImpl(inner.name(), inner, siteConfig, logConfig, this.parent);
    }
}

