/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.FluxUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class Utils {
    Utils() {
    }

    static String base16Encode(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            stringBuilder.append(String.format("%02X", b));
        }
        return stringBuilder.toString();
    }

    static String smartCompletionPrivateRegistryImage(String imageAndTag, String serverUrl) {
        try {
            URL url = new URL(serverUrl);
            String registryServer = url.getAuthority();
            String path = url.getPath();
            if (!registryServer.isEmpty() && !imageAndTag.trim().startsWith(registryServer)) {
                String segment;
                String[] segments = imageAndTag.split(Pattern.quote("/"));
                if (segments.length == 1) {
                    imageAndTag = Utils.completePrivateRegistryImage(imageAndTag, registryServer, path);
                }
                if (!(segments.length <= 1 || (segment = segments[0]).isEmpty() || segment.contains(".") || segment.contains(":") || segment.equals(registryServer))) {
                    imageAndTag = Utils.completePrivateRegistryImage(imageAndTag, registryServer, path);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return imageAndTag;
    }

    private static String completePrivateRegistryImage(String imageAndTag, String registryServer, String path) {
        imageAndTag = (path = Utils.removeLeadingChar(Utils.removeTrailingChar(path, '/'), '/')).isEmpty() ? String.format("%s/%s", registryServer, imageAndTag.trim()) : String.format("%s/%s/%s", registryServer, path, imageAndTag.trim());
        return imageAndTag;
    }

    private static String removeLeadingChar(String s, char c) {
        int index;
        for (index = 0; index < s.length() && s.charAt(index) == c; ++index) {
        }
        return s.substring(index);
    }

    private static String removeTrailingChar(String s, char c) {
        int index;
        for (index = s.length() - 1; index >= 0 && s.charAt(index) == c; --index) {
        }
        return s.substring(0, index + 1);
    }

    static Mono<byte[]> downloadFileAsync(String url, HttpPipeline httpPipeline) {
        FileService service = (FileService)RestProxy.create(FileService.class, (HttpPipeline)httpPipeline);
        try {
            return service.download(Utils.getHost(url), Utils.getPathAndQuery(url)).flatMap(response -> FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)response.getValue())));
        }
        catch (MalformedURLException ex) {
            return Mono.error(() -> ex);
        }
    }

    private static String getHost(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        String protocol = url.getProtocol();
        String host = url.getAuthority();
        return protocol + "://" + host;
    }

    private static String getPathAndQuery(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        String path = url.getPath();
        String query = url.getQuery();
        if (query != null && !query.isEmpty()) {
            path = path + "?" + query;
        }
        return path;
    }

    @Host(value="{$host}")
    @ServiceInterface(name="FileService")
    private static interface FileService {
        @Get(value="{path}")
        public Mono<SimpleResponse<Flux<ByteBuffer>>> download(@HostParam(value="$host") String var1, @PathParam(value="path", encoded=true) String var2);
    }
}

