// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** AseV3NetworkingConfiguration resource specific properties. */
@Fluent
public final class AseV3NetworkingConfigurationProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AseV3NetworkingConfigurationProperties.class);

    /*
     * The windowsOutboundIpAddresses property.
     */
    @JsonProperty(value = "windowsOutboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> windowsOutboundIpAddresses;

    /*
     * The linuxOutboundIpAddresses property.
     */
    @JsonProperty(value = "linuxOutboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> linuxOutboundIpAddresses;

    /*
     * The externalInboundIpAddresses property.
     */
    @JsonProperty(value = "externalInboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> externalInboundIpAddresses;

    /*
     * The internalInboundIpAddresses property.
     */
    @JsonProperty(value = "internalInboundIpAddresses", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> internalInboundIpAddresses;

    /*
     * Property to enable and disable new private endpoint connection creation
     * on ASE
     */
    @JsonProperty(value = "allowNewPrivateEndpointConnections")
    private Boolean allowNewPrivateEndpointConnections;

    /**
     * Get the windowsOutboundIpAddresses property: The windowsOutboundIpAddresses property.
     *
     * @return the windowsOutboundIpAddresses value.
     */
    public List<String> windowsOutboundIpAddresses() {
        return this.windowsOutboundIpAddresses;
    }

    /**
     * Get the linuxOutboundIpAddresses property: The linuxOutboundIpAddresses property.
     *
     * @return the linuxOutboundIpAddresses value.
     */
    public List<String> linuxOutboundIpAddresses() {
        return this.linuxOutboundIpAddresses;
    }

    /**
     * Get the externalInboundIpAddresses property: The externalInboundIpAddresses property.
     *
     * @return the externalInboundIpAddresses value.
     */
    public List<String> externalInboundIpAddresses() {
        return this.externalInboundIpAddresses;
    }

    /**
     * Get the internalInboundIpAddresses property: The internalInboundIpAddresses property.
     *
     * @return the internalInboundIpAddresses value.
     */
    public List<String> internalInboundIpAddresses() {
        return this.internalInboundIpAddresses;
    }

    /**
     * Get the allowNewPrivateEndpointConnections property: Property to enable and disable new private endpoint
     * connection creation on ASE.
     *
     * @return the allowNewPrivateEndpointConnections value.
     */
    public Boolean allowNewPrivateEndpointConnections() {
        return this.allowNewPrivateEndpointConnections;
    }

    /**
     * Set the allowNewPrivateEndpointConnections property: Property to enable and disable new private endpoint
     * connection creation on ASE.
     *
     * @param allowNewPrivateEndpointConnections the allowNewPrivateEndpointConnections value to set.
     * @return the AseV3NetworkingConfigurationProperties object itself.
     */
    public AseV3NetworkingConfigurationProperties withAllowNewPrivateEndpointConnections(
        Boolean allowNewPrivateEndpointConnections) {
        this.allowNewPrivateEndpointConnections = allowNewPrivateEndpointConnections;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
