// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.AppLogsConfiguration;
import com.azure.resourcemanager.appservice.models.ArcConfiguration;
import com.azure.resourcemanager.appservice.models.ExtendedLocation;
import com.azure.resourcemanager.appservice.models.KubeEnvironmentProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** A Kubernetes cluster specialized for web workloads by Azure App Service. */
@Fluent
public final class KubeEnvironmentInner extends Resource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(KubeEnvironmentInner.class);

    /*
     * KubeEnvironment resource specific properties
     */
    @JsonProperty(value = "properties")
    private KubeEnvironmentProperties innerProperties;

    /*
     * Extended Location.
     */
    @JsonProperty(value = "extendedLocation")
    private ExtendedLocation extendedLocation;

    /*
     * Kind of resource.
     */
    @JsonProperty(value = "kind")
    private String kind;

    /**
     * Get the innerProperties property: KubeEnvironment resource specific properties.
     *
     * @return the innerProperties value.
     */
    private KubeEnvironmentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the extendedLocation property: Extended Location.
     *
     * @return the extendedLocation value.
     */
    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    /**
     * Set the extendedLocation property: Extended Location.
     *
     * @param extendedLocation the extendedLocation value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    /**
     * Get the kind property: Kind of resource.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Kind of resource.
     *
     * @param kind the kind value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KubeEnvironmentInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KubeEnvironmentInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the Kubernetes Environment.
     *
     * @return the provisioningState value.
     */
    public KubeEnvironmentProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the deploymentErrors property: Any errors that occurred during deployment or deployment validation.
     *
     * @return the deploymentErrors value.
     */
    public String deploymentErrors() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentErrors();
    }

    /**
     * Get the internalLoadBalancerEnabled property: Only visible within Vnet/Subnet.
     *
     * @return the internalLoadBalancerEnabled value.
     */
    public Boolean internalLoadBalancerEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancerEnabled();
    }

    /**
     * Set the internalLoadBalancerEnabled property: Only visible within Vnet/Subnet.
     *
     * @param internalLoadBalancerEnabled the internalLoadBalancerEnabled value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withInternalLoadBalancerEnabled(Boolean internalLoadBalancerEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withInternalLoadBalancerEnabled(internalLoadBalancerEnabled);
        return this;
    }

    /**
     * Get the defaultDomain property: Default Domain Name for the cluster.
     *
     * @return the defaultDomain value.
     */
    public String defaultDomain() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultDomain();
    }

    /**
     * Get the staticIp property: Static IP of the KubeEnvironment.
     *
     * @return the staticIp value.
     */
    public String staticIp() {
        return this.innerProperties() == null ? null : this.innerProperties().staticIp();
    }

    /**
     * Set the staticIp property: Static IP of the KubeEnvironment.
     *
     * @param staticIp the staticIp value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withStaticIp(String staticIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withStaticIp(staticIp);
        return this;
    }

    /**
     * Get the arcConfiguration property: Cluster configuration which determines the ARC cluster components types. Eg:
     * Choosing between BuildService kind, FrontEnd Service ArtifactsStorageType etc.
     *
     * @return the arcConfiguration value.
     */
    public ArcConfiguration arcConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().arcConfiguration();
    }

    /**
     * Set the arcConfiguration property: Cluster configuration which determines the ARC cluster components types. Eg:
     * Choosing between BuildService kind, FrontEnd Service ArtifactsStorageType etc.
     *
     * @param arcConfiguration the arcConfiguration value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withArcConfiguration(ArcConfiguration arcConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withArcConfiguration(arcConfiguration);
        return this;
    }

    /**
     * Get the appLogsConfiguration property: Cluster configuration which enables the log daemon to export app logs to a
     * destination. Currently only "log-analytics" is supported.
     *
     * @return the appLogsConfiguration value.
     */
    public AppLogsConfiguration appLogsConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().appLogsConfiguration();
    }

    /**
     * Set the appLogsConfiguration property: Cluster configuration which enables the log daemon to export app logs to a
     * destination. Currently only "log-analytics" is supported.
     *
     * @param appLogsConfiguration the appLogsConfiguration value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withAppLogsConfiguration(AppLogsConfiguration appLogsConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withAppLogsConfiguration(appLogsConfiguration);
        return this;
    }

    /**
     * Get the aksResourceId property: The aksResourceID property.
     *
     * @return the aksResourceId value.
     */
    public String aksResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().aksResourceId();
    }

    /**
     * Set the aksResourceId property: The aksResourceID property.
     *
     * @param aksResourceId the aksResourceId value to set.
     * @return the KubeEnvironmentInner object itself.
     */
    public KubeEnvironmentInner withAksResourceId(String aksResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubeEnvironmentProperties();
        }
        this.innerProperties().withAksResourceId(aksResourceId);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (extendedLocation() != null) {
            extendedLocation().validate();
        }
    }
}
