// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** A static site. */
@Fluent
public final class StaticSite {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(StaticSite.class);

    /*
     * The default autogenerated hostname for the static site.
     */
    @JsonProperty(value = "defaultHostname", access = JsonProperty.Access.WRITE_ONLY)
    private String defaultHostname;

    /*
     * URL for the repository of the static site.
     */
    @JsonProperty(value = "repositoryUrl")
    private String repositoryUrl;

    /*
     * The target branch in the repository.
     */
    @JsonProperty(value = "branch")
    private String branch;

    /*
     * The custom domains associated with this static site.
     */
    @JsonProperty(value = "customDomains", access = JsonProperty.Access.WRITE_ONLY)
    private List<String> customDomains;

    /*
     * A user's github repository token. This is used to setup the Github
     * Actions workflow file and API secrets.
     */
    @JsonProperty(value = "repositoryToken")
    private String repositoryToken;

    /*
     * Build properties to configure on the repository.
     */
    @JsonProperty(value = "buildProperties")
    private StaticSiteBuildProperties buildProperties;

    /*
     * Private endpoint connections
     */
    @JsonProperty(value = "privateEndpointConnections", access = JsonProperty.Access.WRITE_ONLY)
    private List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections;

    /*
     * State indicating whether staging environments are allowed or not allowed
     * for a static web app.
     */
    @JsonProperty(value = "stagingEnvironmentPolicy")
    private StagingEnvironmentPolicy stagingEnvironmentPolicy;

    /*
     * <code>false</code> if config file is locked for this static web app;
     * otherwise, <code>true</code>.
     */
    @JsonProperty(value = "allowConfigFileUpdates")
    private Boolean allowConfigFileUpdates;

    /*
     * Template options for generating a new repository.
     */
    @JsonProperty(value = "templateProperties")
    private StaticSiteTemplateOptions templateProperties;

    /*
     * The content distribution endpoint for the static site.
     */
    @JsonProperty(value = "contentDistributionEndpoint", access = JsonProperty.Access.WRITE_ONLY)
    private String contentDistributionEndpoint;

    /*
     * Identity to use for Key Vault Reference authentication.
     */
    @JsonProperty(value = "keyVaultReferenceIdentity", access = JsonProperty.Access.WRITE_ONLY)
    private String keyVaultReferenceIdentity;

    /*
     * User provided function apps registered with the static site
     */
    @JsonProperty(value = "userProvidedFunctionApps", access = JsonProperty.Access.WRITE_ONLY)
    private List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps;

    /*
     * The provider that submitted the last deployment to the primary
     * environment of the static site.
     */
    @JsonProperty(value = "provider", access = JsonProperty.Access.WRITE_ONLY)
    private String provider;

    /**
     * Get the defaultHostname property: The default autogenerated hostname for the static site.
     *
     * @return the defaultHostname value.
     */
    public String defaultHostname() {
        return this.defaultHostname;
    }

    /**
     * Get the repositoryUrl property: URL for the repository of the static site.
     *
     * @return the repositoryUrl value.
     */
    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    /**
     * Set the repositoryUrl property: URL for the repository of the static site.
     *
     * @param repositoryUrl the repositoryUrl value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    /**
     * Get the branch property: The target branch in the repository.
     *
     * @return the branch value.
     */
    public String branch() {
        return this.branch;
    }

    /**
     * Set the branch property: The target branch in the repository.
     *
     * @param branch the branch value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    /**
     * Get the customDomains property: The custom domains associated with this static site.
     *
     * @return the customDomains value.
     */
    public List<String> customDomains() {
        return this.customDomains;
    }

    /**
     * Get the repositoryToken property: A user's github repository token. This is used to setup the Github Actions
     * workflow file and API secrets.
     *
     * @return the repositoryToken value.
     */
    public String repositoryToken() {
        return this.repositoryToken;
    }

    /**
     * Set the repositoryToken property: A user's github repository token. This is used to setup the Github Actions
     * workflow file and API secrets.
     *
     * @param repositoryToken the repositoryToken value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withRepositoryToken(String repositoryToken) {
        this.repositoryToken = repositoryToken;
        return this;
    }

    /**
     * Get the buildProperties property: Build properties to configure on the repository.
     *
     * @return the buildProperties value.
     */
    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    /**
     * Set the buildProperties property: Build properties to configure on the repository.
     *
     * @param buildProperties the buildProperties value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    /**
     * Get the privateEndpointConnections property: Private endpoint connections.
     *
     * @return the privateEndpointConnections value.
     */
    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Get the stagingEnvironmentPolicy property: State indicating whether staging environments are allowed or not
     * allowed for a static web app.
     *
     * @return the stagingEnvironmentPolicy value.
     */
    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.stagingEnvironmentPolicy;
    }

    /**
     * Set the stagingEnvironmentPolicy property: State indicating whether staging environments are allowed or not
     * allowed for a static web app.
     *
     * @param stagingEnvironmentPolicy the stagingEnvironmentPolicy value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        this.stagingEnvironmentPolicy = stagingEnvironmentPolicy;
        return this;
    }

    /**
     * Get the allowConfigFileUpdates property: &lt;code&gt;false&lt;/code&gt; if config file is locked for this static
     * web app; otherwise, &lt;code&gt;true&lt;/code&gt;.
     *
     * @return the allowConfigFileUpdates value.
     */
    public Boolean allowConfigFileUpdates() {
        return this.allowConfigFileUpdates;
    }

    /**
     * Set the allowConfigFileUpdates property: &lt;code&gt;false&lt;/code&gt; if config file is locked for this static
     * web app; otherwise, &lt;code&gt;true&lt;/code&gt;.
     *
     * @param allowConfigFileUpdates the allowConfigFileUpdates value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        this.allowConfigFileUpdates = allowConfigFileUpdates;
        return this;
    }

    /**
     * Get the templateProperties property: Template options for generating a new repository.
     *
     * @return the templateProperties value.
     */
    public StaticSiteTemplateOptions templateProperties() {
        return this.templateProperties;
    }

    /**
     * Set the templateProperties property: Template options for generating a new repository.
     *
     * @param templateProperties the templateProperties value to set.
     * @return the StaticSite object itself.
     */
    public StaticSite withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        this.templateProperties = templateProperties;
        return this;
    }

    /**
     * Get the contentDistributionEndpoint property: The content distribution endpoint for the static site.
     *
     * @return the contentDistributionEndpoint value.
     */
    public String contentDistributionEndpoint() {
        return this.contentDistributionEndpoint;
    }

    /**
     * Get the keyVaultReferenceIdentity property: Identity to use for Key Vault Reference authentication.
     *
     * @return the keyVaultReferenceIdentity value.
     */
    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    /**
     * Get the userProvidedFunctionApps property: User provided function apps registered with the static site.
     *
     * @return the userProvidedFunctionApps value.
     */
    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.userProvidedFunctionApps;
    }

    /**
     * Get the provider property: The provider that submitted the last deployment to the primary environment of the
     * static site.
     *
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (buildProperties() != null) {
            buildProperties().validate();
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
        if (templateProperties() != null) {
            templateProperties().validate();
        }
        if (userProvidedFunctionApps() != null) {
            userProvidedFunctionApps().forEach(e -> e.validate());
        }
    }
}
