// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.appservice.fluent.models.RemotePrivateEndpointConnectionArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteBuildArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteCustomDomainOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteFunctionOverviewArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserInvitationResponseResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteUserProvidedFunctionAppArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.StaticSitesWorkflowPreviewInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.StringListInner;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionApprovalRequestResource;
import com.azure.resourcemanager.appservice.models.StaticSiteCustomDomainRequestPropertiesArmResource;
import com.azure.resourcemanager.appservice.models.StaticSitePatchResource;
import com.azure.resourcemanager.appservice.models.StaticSiteResetPropertiesArmResource;
import com.azure.resourcemanager.appservice.models.StaticSiteUserInvitationRequestResource;
import com.azure.resourcemanager.appservice.models.StaticSiteZipDeploymentArmResource;
import com.azure.resourcemanager.appservice.models.StaticSitesWorkflowPreviewRequest;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in StaticSitesClient. */
public interface StaticSitesClient
    extends InnerSupportsGet<StaticSiteArmResourceInner>,
        InnerSupportsListing<StaticSiteArmResourceInner>,
        InnerSupportsDelete<Void> {
    /**
     * Description for Generates a preview workflow file for the static site.
     *
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     *     properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSitesWorkflowPreviewInner>> previewWorkflowWithResponseAsync(
        String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest);

    /**
     * Description for Generates a preview workflow file for the static site.
     *
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     *     properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSitesWorkflowPreviewInner> previewWorkflowAsync(
        String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest);

    /**
     * Description for Generates a preview workflow file for the static site.
     *
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     *     properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSitesWorkflowPreviewInner previewWorkflow(
        String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest);

    /**
     * Description for Generates a preview workflow file for the static site.
     *
     * @param location Location where you plan to create the static site.
     * @param staticSitesWorkflowPreviewRequest A JSON representation of the StaticSitesWorkflowPreviewRequest
     *     properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return preview for the Static Site Workflow to be generated.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSitesWorkflowPreviewInner> previewWorkflowWithResponse(
        String location, StaticSitesWorkflowPreviewRequest staticSitesWorkflowPreviewRequest, Context context);

    /**
     * Description for Get all Static Sites for a subscription.
     *
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteArmResourceInner> listAsync();

    /**
     * Description for Get all Static Sites for a subscription.
     *
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteArmResourceInner> list();

    /**
     * Description for Get all Static Sites for a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteArmResourceInner> list(Context context);

    /**
     * Description for Gets all static sites in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteArmResourceInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Description for Gets all static sites in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName);

    /**
     * Description for Gets all static sites in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static sites.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteArmResourceInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Description for Gets the details of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteArmResourceInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the details of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteArmResourceInner> getByResourceGroupAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the details of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteArmResourceInner getByResourceGroup(String resourceGroupName, String name);

    /**
     * Description for Gets the details of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteArmResourceInner> getByResourceGroupWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteWithResponseAsync(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSiteAsync(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSite(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StaticSiteArmResourceInner>, StaticSiteArmResourceInner> beginCreateOrUpdateStaticSite(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteArmResourceInner> createOrUpdateStaticSiteAsync(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteArmResourceInner createOrUpdateStaticSite(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteArmResourceInner createOrUpdateStaticSite(
        String resourceGroupName, String name, StaticSiteArmResourceInner staticSiteEnvelope, Context context);

    /**
     * Description for Deletes a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name);

    /**
     * Description for Deletes a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String name, Context context);

    /**
     * Description for Deletes a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name);

    /**
     * Description for Deletes a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name, Context context);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteArmResourceInner>> updateStaticSiteWithResponseAsync(
        String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteArmResourceInner> updateStaticSiteAsync(
        String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteArmResourceInner updateStaticSite(
        String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope);

    /**
     * Description for Creates a new static site in an existing resource group, or updates an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to create or update.
     * @param staticSiteEnvelope A JSON representation of the staticsite properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteArmResourceInner> updateStaticSiteWithResponse(
        String resourceGroupName, String name, StaticSitePatchResource staticSiteEnvelope, Context context);

    /**
     * Description for Gets the list of users of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteUserArmResourceInner> listStaticSiteUsersAsync(
        String resourceGroupName, String name, String authprovider);

    /**
     * Description for Gets the list of users of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(
        String resourceGroupName, String name, String authprovider);

    /**
     * Description for Gets the list of users of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for the users.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom users.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteUserArmResourceInner> listStaticSiteUsers(
        String resourceGroupName, String name, String authprovider, Context context);

    /**
     * Description for Deletes the user entry from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteStaticSiteUserWithResponseAsync(
        String resourceGroupName, String name, String authprovider, String userid);

    /**
     * Description for Deletes the user entry from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteStaticSiteUserAsync(String resourceGroupName, String name, String authprovider, String userid);

    /**
     * Description for Deletes the user entry from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteStaticSiteUser(String resourceGroupName, String name, String authprovider, String userid);

    /**
     * Description for Deletes the user entry from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the staticsite.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteStaticSiteUserWithResponse(
        String resourceGroupName, String name, String authprovider, String userid, Context context);

    /**
     * Description for Updates a user entry with the listed roles.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteUserArmResourceInner>> updateStaticSiteUserWithResponseAsync(
        String resourceGroupName,
        String name,
        String authprovider,
        String userid,
        StaticSiteUserArmResourceInner staticSiteUserEnvelope);

    /**
     * Description for Updates a user entry with the listed roles.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserArmResourceInner> updateStaticSiteUserAsync(
        String resourceGroupName,
        String name,
        String authprovider,
        String userid,
        StaticSiteUserArmResourceInner staticSiteUserEnvelope);

    /**
     * Description for Updates a user entry with the listed roles.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserArmResourceInner updateStaticSiteUser(
        String resourceGroupName,
        String name,
        String authprovider,
        String userid,
        StaticSiteUserArmResourceInner staticSiteUserEnvelope);

    /**
     * Description for Updates a user entry with the listed roles.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param authprovider The auth provider for this user.
     * @param userid The user id of the user.
     * @param staticSiteUserEnvelope A JSON representation of the StaticSiteUser properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteUserArmResourceInner> updateStaticSiteUserWithResponse(
        String resourceGroupName,
        String name,
        String authprovider,
        String userid,
        StaticSiteUserArmResourceInner staticSiteUserEnvelope,
        Context context);

    /**
     * Description for Gets all static site builds for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteBuildArmResourceInner> getStaticSiteBuildsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets all static site builds for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(String resourceGroupName, String name);

    /**
     * Description for Gets all static site builds for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site builds.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteBuildArmResourceInner> getStaticSiteBuilds(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the details of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteBuildArmResourceInner>> getStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the details of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteBuildArmResourceInner> getStaticSiteBuildAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the details of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteBuildArmResourceInner getStaticSiteBuild(String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the details of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Build ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteBuildArmResourceInner> getStaticSiteBuildWithResponse(
        String resourceGroupName, String name, String environmentName, Context context);

    /**
     * Description for Deletes a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Deletes a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteBuildAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Deletes a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteBuild(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Deletes a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteBuild(
        String resourceGroupName, String name, String environmentName, Context context);

    /**
     * Description for Deletes a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteStaticSiteBuildAsync(String resourceGroupName, String name, String environmentName);

    /**
     * Description for Deletes a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteStaticSiteBuild(String resourceGroupName, String name, String environmentName);

    /**
     * Description for Deletes a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteStaticSiteBuild(String resourceGroupName, String name, String environmentName, Context context);

    /**
     * Description for Creates or updates the app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> createOrUpdateStaticSiteBuildAppSettingsAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner createOrUpdateStaticSiteBuildAppSettings(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> createOrUpdateStaticSiteBuildAppSettingsWithResponse(
        String resourceGroupName,
        String name,
        String environmentName,
        StringDictionaryInner appSettings,
        Context context);

    /**
     * Description for Creates or updates the function app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the function app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsAsync(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the function app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner createOrUpdateStaticSiteBuildFunctionAppSettings(
        String resourceGroupName, String name, String environmentName, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the function app settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> createOrUpdateStaticSiteBuildFunctionAppSettingsWithResponse(
        String resourceGroupName,
        String name,
        String environmentName,
        StringDictionaryInner appSettings,
        Context context);

    /**
     * Description for Gets the functions of a particular static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctionsAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the functions of a particular static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctions(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the functions of a particular static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteBuildFunctions(
        String resourceGroupName, String name, String environmentName, Context context);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listStaticSiteBuildAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listStaticSiteBuildAppSettingsAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listStaticSiteBuildAppSettings(String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listStaticSiteBuildAppSettingsWithResponse(
        String resourceGroupName, String name, String environmentName, Context context);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listStaticSiteBuildFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listStaticSiteBuildFunctionAppSettings(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the application settings of a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listStaticSiteBuildFunctionAppSettingsWithResponse(
        String resourceGroupName, String name, String environmentName, Context context);

    /**
     * Description for Gets the details of the user provided function apps registered with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteBuildAsync(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the details of the user provided function apps registered with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteBuild(
        String resourceGroupName, String name, String environmentName);

    /**
     * Description for Gets the details of the user provided function apps registered with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteBuild(
        String resourceGroupName, String name, String environmentName, Context context);

    /**
     * Description for Gets the details of the user provided function app registered with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppForStaticSiteBuildWithResponseAsync(
            String resourceGroupName, String name, String environmentName, String functionAppName);

    /**
     * Description for Gets the details of the user provided function app registered with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteBuildAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName);

    /**
     * Description for Gets the details of the user provided function app registered with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner getUserProvidedFunctionAppForStaticSiteBuild(
        String resourceGroupName, String name, String environmentName, String functionAppName);

    /**
     * Description for Gets the details of the user provided function app registered with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteUserProvidedFunctionAppArmResourceInner>
        getUserProvidedFunctionAppForStaticSiteBuildWithResponse(
            String resourceGroupName, String name, String environmentName, String functionAppName, Context context);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteBuildWithResponseAsync(
        String resourceGroupName,
        String name,
        String environmentName,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<
            PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>,
            StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuildAsync(
            String resourceGroupName,
            String name,
            String environmentName,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>,
            StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuild(
            String resourceGroupName,
            String name,
            String environmentName,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>,
            StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteBuild(
            String resourceGroupName,
            String name,
            String environmentName,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced,
            Context context);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteBuildAsync(
        String resourceGroupName,
        String name,
        String environmentName,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteBuildAsync(
        String resourceGroupName,
        String name,
        String environmentName,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(
        String resourceGroupName,
        String name,
        String environmentName,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(
        String resourceGroupName,
        String name,
        String environmentName,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope);

    /**
     * Description for Register a user provided function app with a static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app to register with the static site build.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSiteBuild(
        String resourceGroupName,
        String name,
        String environmentName,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced,
        Context context);

    /**
     * Description for Detach the user provided function app from the static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponseAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName);

    /**
     * Description for Detach the user provided function app from the static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> detachUserProvidedFunctionAppFromStaticSiteBuildAsync(
        String resourceGroupName, String name, String environmentName, String functionAppName);

    /**
     * Description for Detach the user provided function app from the static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void detachUserProvidedFunctionAppFromStaticSiteBuild(
        String resourceGroupName, String name, String environmentName, String functionAppName);

    /**
     * Description for Detach the user provided function app from the static site build.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName The stage site identifier.
     * @param functionAppName Name of the function app registered with the static site build.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> detachUserProvidedFunctionAppFromStaticSiteBuildWithResponse(
        String resourceGroupName, String name, String environmentName, String functionAppName, Context context);

    /**
     * Description for Deploys zipped content to a specific environment of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteBuildWithResponseAsync(
        String resourceGroupName,
        String name,
        String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a specific environment of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuildAsync(
        String resourceGroupName,
        String name,
        String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a specific environment of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuild(
        String resourceGroupName,
        String name,
        String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a specific environment of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteBuild(
        String resourceGroupName,
        String name,
        String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
        Context context);

    /**
     * Description for Deploys zipped content to a specific environment of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> createZipDeploymentForStaticSiteBuildAsync(
        String resourceGroupName,
        String name,
        String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a specific environment of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void createZipDeploymentForStaticSiteBuild(
        String resourceGroupName,
        String name,
        String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a specific environment of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param environmentName Name of the environment.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void createZipDeploymentForStaticSiteBuild(
        String resourceGroupName,
        String name,
        String environmentName,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
        Context context);

    /**
     * Description for Creates or updates the app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteAppSettingsWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> createOrUpdateStaticSiteAppSettingsAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner createOrUpdateStaticSiteAppSettings(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> createOrUpdateStaticSiteAppSettingsWithResponse(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context);

    /**
     * Description for Creates or updates the function app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> createOrUpdateStaticSiteFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the function app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the function app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner createOrUpdateStaticSiteFunctionAppSettings(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Creates or updates the function app settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param appSettings The dictionary containing the static site function app settings to update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> createOrUpdateStaticSiteFunctionAppSettingsWithResponse(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context);

    /**
     * Description for Creates an invitation link for a user with the role.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteUserInvitationResponseResourceInner>> createUserRolesInvitationLinkWithResponseAsync(
        String resourceGroupName,
        String name,
        StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope);

    /**
     * Description for Creates an invitation link for a user with the role.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkAsync(
        String resourceGroupName,
        String name,
        StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope);

    /**
     * Description for Creates an invitation link for a user with the role.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserInvitationResponseResourceInner createUserRolesInvitationLink(
        String resourceGroupName,
        String name,
        StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope);

    /**
     * Description for Creates an invitation link for a user with the role.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteUserRolesInvitationEnvelope Static sites user roles invitation resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static sites user roles invitation link resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteUserInvitationResponseResourceInner> createUserRolesInvitationLinkWithResponse(
        String resourceGroupName,
        String name,
        StaticSiteUserInvitationRequestResource staticSiteUserRolesInvitationEnvelope,
        Context context);

    /**
     * Description for Gets all static site custom domains for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomainsAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets all static site custom domains for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomains(
        String resourceGroupName, String name);

    /**
     * Description for Gets all static site custom domains for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site custom domains.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteCustomDomainOverviewArmResourceInner> listStaticSiteCustomDomains(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets an existing custom domain for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteCustomDomainOverviewArmResourceInner>> getStaticSiteCustomDomainWithResponseAsync(
        String resourceGroupName, String name, String domainName);

    /**
     * Description for Gets an existing custom domain for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteCustomDomainOverviewArmResourceInner> getStaticSiteCustomDomainAsync(
        String resourceGroupName, String name, String domainName);

    /**
     * Description for Gets an existing custom domain for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteCustomDomainOverviewArmResourceInner getStaticSiteCustomDomain(
        String resourceGroupName, String name, String domainName);

    /**
     * Description for Gets an existing custom domain for a particular static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site resource to search in.
     * @param domainName The custom domain name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteCustomDomainOverviewArmResourceInner> getStaticSiteCustomDomainWithResponse(
        String resourceGroupName, String name, String domainName, Context context);

    /**
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateStaticSiteCustomDomainWithResponseAsync(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<
            PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner>
        beginCreateOrUpdateStaticSiteCustomDomainAsync(
            String resourceGroupName,
            String name,
            String domainName,
            StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner>
        beginCreateOrUpdateStaticSiteCustomDomain(
            String resourceGroupName,
            String name,
            String domainName,
            StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<StaticSiteCustomDomainOverviewArmResourceInner>, StaticSiteCustomDomainOverviewArmResourceInner>
        beginCreateOrUpdateStaticSiteCustomDomain(
            String resourceGroupName,
            String name,
            String domainName,
            StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
            Context context);

    /**
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteCustomDomainOverviewArmResourceInner> createOrUpdateStaticSiteCustomDomainAsync(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteCustomDomainOverviewArmResourceInner createOrUpdateStaticSiteCustomDomain(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Creates a new static site custom domain in an existing resource group and static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to create.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site Custom Domain Overview ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteCustomDomainOverviewArmResourceInner createOrUpdateStaticSiteCustomDomain(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context);

    /**
     * Description for Deletes a custom domain.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteStaticSiteCustomDomainWithResponseAsync(
        String resourceGroupName, String name, String domainName);

    /**
     * Description for Deletes a custom domain.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomainAsync(
        String resourceGroupName, String name, String domainName);

    /**
     * Description for Deletes a custom domain.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomain(
        String resourceGroupName, String name, String domainName);

    /**
     * Description for Deletes a custom domain.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDeleteStaticSiteCustomDomain(
        String resourceGroupName, String name, String domainName, Context context);

    /**
     * Description for Deletes a custom domain.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteStaticSiteCustomDomainAsync(String resourceGroupName, String name, String domainName);

    /**
     * Description for Deletes a custom domain.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName);

    /**
     * Description for Deletes a custom domain.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to delete.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteStaticSiteCustomDomain(String resourceGroupName, String name, String domainName, Context context);

    /**
     * Description for Validates a particular custom domain can be added to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> validateCustomDomainCanBeAddedToStaticSiteWithResponseAsync(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Validates a particular custom domain can be added to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSiteAsync(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Validates a particular custom domain can be added to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSite(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Validates a particular custom domain can be added to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginValidateCustomDomainCanBeAddedToStaticSite(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context);

    /**
     * Description for Validates a particular custom domain can be added to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> validateCustomDomainCanBeAddedToStaticSiteAsync(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Validates a particular custom domain can be added to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void validateCustomDomainCanBeAddedToStaticSite(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope);

    /**
     * Description for Validates a particular custom domain can be added to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param domainName The custom domain to validate.
     * @param staticSiteCustomDomainRequestPropertiesEnvelope A JSON representation of the static site custom domain
     *     request properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void validateCustomDomainCanBeAddedToStaticSite(
        String resourceGroupName,
        String name,
        String domainName,
        StaticSiteCustomDomainRequestPropertiesArmResource staticSiteCustomDomainRequestPropertiesEnvelope,
        Context context);

    /**
     * Description for Detaches a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> detachStaticSiteWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Detaches a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDetachStaticSiteAsync(String resourceGroupName, String name);

    /**
     * Description for Detaches a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDetachStaticSite(String resourceGroupName, String name);

    /**
     * Description for Detaches a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDetachStaticSite(String resourceGroupName, String name, Context context);

    /**
     * Description for Detaches a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> detachStaticSiteAsync(String resourceGroupName, String name);

    /**
     * Description for Detaches a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void detachStaticSite(String resourceGroupName, String name);

    /**
     * Description for Detaches a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site to detach.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void detachStaticSite(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the functions of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctionsAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the functions of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(
        String resourceGroupName, String name);

    /**
     * Description for Gets the functions of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site functions.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteFunctionOverviewArmResourceInner> listStaticSiteFunctions(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listStaticSiteAppSettingsWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listStaticSiteAppSettingsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listStaticSiteAppSettings(String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listStaticSiteAppSettingsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Lists the roles configured for the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringListInner>> listStaticSiteConfiguredRolesWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Lists the roles configured for the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringListInner> listStaticSiteConfiguredRolesAsync(String resourceGroupName, String name);

    /**
     * Description for Lists the roles configured for the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringListInner listStaticSiteConfiguredRoles(String resourceGroupName, String name);

    /**
     * Description for Lists the roles configured for the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string list resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringListInner> listStaticSiteConfiguredRolesWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listStaticSiteFunctionAppSettingsWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listStaticSiteFunctionAppSettingsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listStaticSiteFunctionAppSettings(String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listStaticSiteFunctionAppSettingsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Lists the secrets for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listStaticSiteSecretsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Lists the secrets for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listStaticSiteSecretsAsync(String resourceGroupName, String name);

    /**
     * Description for Lists the secrets for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listStaticSiteSecrets(String resourceGroupName, String name);

    /**
     * Description for Lists the secrets for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listStaticSiteSecretsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the list of private endpoint connections associated with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionListAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the list of private endpoint connections associated with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(
        String resourceGroupName, String name);

    /**
     * Description for Gets the list of private endpoint connections associated with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RemotePrivateEndpointConnectionArmResourceInner getPrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionWithResponse(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<
            PollResult<RemotePrivateEndpointConnectionArmResourceInner>,
            RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnectionAsync(
            String resourceGroupName,
            String name,
            String privateEndpointConnectionName,
            PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<RemotePrivateEndpointConnectionArmResourceInner>,
            RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnection(
            String resourceGroupName,
            String name,
            String privateEndpointConnectionName,
            PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<RemotePrivateEndpointConnectionArmResourceInner>,
            RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnection(
            String resourceGroupName,
            String name,
            String privateEndpointConnectionName,
            PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper,
            Context context);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param privateEndpointWrapper Request body.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper,
        Context context);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> deletePrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object deletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object deletePrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResourcesWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateLinkResourcesWrapperInner getPrivateLinkResources(String resourceGroupName, String name);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Resets the api key for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> resetStaticSiteApiKeyWithResponseAsync(
        String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope);

    /**
     * Description for Resets the api key for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> resetStaticSiteApiKeyAsync(
        String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope);

    /**
     * Description for Resets the api key for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetStaticSiteApiKey(
        String resourceGroupName, String name, StaticSiteResetPropertiesArmResource resetPropertiesEnvelope);

    /**
     * Description for Resets the api key for an existing static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param resetPropertiesEnvelope Static Site Reset Properties ARM resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> resetStaticSiteApiKeyWithResponse(
        String resourceGroupName,
        String name,
        StaticSiteResetPropertiesArmResource resetPropertiesEnvelope,
        Context context);

    /**
     * Description for Gets the details of the user provided function apps registered with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSiteAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the details of the user provided function apps registered with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSite(
        String resourceGroupName, String name);

    /**
     * Description for Gets the details of the user provided function apps registered with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of static site user provided function apps.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppsForStaticSite(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the details of the user provided function app registered with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StaticSiteUserProvidedFunctionAppArmResourceInner>>
        getUserProvidedFunctionAppForStaticSiteWithResponseAsync(
            String resourceGroupName, String name, String functionAppName);

    /**
     * Description for Gets the details of the user provided function app registered with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteAsync(
        String resourceGroupName, String name, String functionAppName);

    /**
     * Description for Gets the details of the user provided function app registered with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner getUserProvidedFunctionAppForStaticSite(
        String resourceGroupName, String name, String functionAppName);

    /**
     * Description for Gets the details of the user provided function app registered with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StaticSiteUserProvidedFunctionAppArmResourceInner> getUserProvidedFunctionAppForStaticSiteWithResponse(
        String resourceGroupName, String name, String functionAppName, Context context);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> registerUserProvidedFunctionAppWithStaticSiteWithResponseAsync(
        String resourceGroupName,
        String name,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<
            PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>,
            StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSiteAsync(
            String resourceGroupName,
            String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>,
            StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSite(
            String resourceGroupName,
            String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<StaticSiteUserProvidedFunctionAppArmResourceInner>,
            StaticSiteUserProvidedFunctionAppArmResourceInner>
        beginRegisterUserProvidedFunctionAppWithStaticSite(
            String resourceGroupName,
            String name,
            String functionAppName,
            StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
            Boolean isForced,
            Context context);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(
        String resourceGroupName,
        String name,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StaticSiteUserProvidedFunctionAppArmResourceInner> registerUserProvidedFunctionAppWithStaticSiteAsync(
        String resourceGroupName,
        String name,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(
        String resourceGroupName,
        String name,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(
        String resourceGroupName,
        String name,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope);

    /**
     * Description for Register a user provided function app with a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app to register with the static site.
     * @param staticSiteUserProvidedFunctionEnvelope A JSON representation of the user provided function app properties.
     *     See example.
     * @param isForced Specify &lt;code&gt;true&lt;/code&gt; to force the update of the auth configuration on the
     *     function app even if an AzureStaticWebApps provider is already configured on the function app. The default is
     *     &lt;code&gt;false&lt;/code&gt;.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return static Site User Provided Function App ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StaticSiteUserProvidedFunctionAppArmResourceInner registerUserProvidedFunctionAppWithStaticSite(
        String resourceGroupName,
        String name,
        String functionAppName,
        StaticSiteUserProvidedFunctionAppArmResourceInner staticSiteUserProvidedFunctionEnvelope,
        Boolean isForced,
        Context context);

    /**
     * Description for Detach the user provided function app from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> detachUserProvidedFunctionAppFromStaticSiteWithResponseAsync(
        String resourceGroupName, String name, String functionAppName);

    /**
     * Description for Detach the user provided function app from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> detachUserProvidedFunctionAppFromStaticSiteAsync(
        String resourceGroupName, String name, String functionAppName);

    /**
     * Description for Detach the user provided function app from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void detachUserProvidedFunctionAppFromStaticSite(String resourceGroupName, String name, String functionAppName);

    /**
     * Description for Detach the user provided function app from the static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param functionAppName Name of the function app registered with the static site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> detachUserProvidedFunctionAppFromStaticSiteWithResponse(
        String resourceGroupName, String name, String functionAppName, Context context);

    /**
     * Description for Deploys zipped content to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createZipDeploymentForStaticSiteWithResponseAsync(
        String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSiteAsync(
        String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSite(
        String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginCreateZipDeploymentForStaticSite(
        String resourceGroupName,
        String name,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
        Context context);

    /**
     * Description for Deploys zipped content to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> createZipDeploymentForStaticSiteAsync(
        String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void createZipDeploymentForStaticSite(
        String resourceGroupName, String name, StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope);

    /**
     * Description for Deploys zipped content to a static site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the static site.
     * @param staticSiteZipDeploymentEnvelope A JSON representation of the StaticSiteZipDeployment properties. See
     *     example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void createZipDeploymentForStaticSite(
        String resourceGroupName,
        String name,
        StaticSiteZipDeploymentArmResource staticSiteZipDeploymentEnvelope,
        Context context);
}
