// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteCustomDomainRequestPropertiesArmResourceProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Static Site Custom Domain Request Properties ARM resource. */
@Fluent
public final class StaticSiteCustomDomainRequestPropertiesArmResource extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StaticSiteCustomDomainRequestPropertiesArmResource.class);

    /*
     * StaticSiteCustomDomainRequestPropertiesARMResource resource specific
     * properties
     */
    @JsonProperty(value = "properties")
    private StaticSiteCustomDomainRequestPropertiesArmResourceProperties innerProperties;

    /**
     * Get the innerProperties property: StaticSiteCustomDomainRequestPropertiesARMResource resource specific
     * properties.
     *
     * @return the innerProperties value.
     */
    private StaticSiteCustomDomainRequestPropertiesArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSiteCustomDomainRequestPropertiesArmResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the validationMethod property: Validation method for adding a custom domain.
     *
     * @return the validationMethod value.
     */
    public String validationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().validationMethod();
    }

    /**
     * Set the validationMethod property: Validation method for adding a custom domain.
     *
     * @param validationMethod the validationMethod value to set.
     * @return the StaticSiteCustomDomainRequestPropertiesArmResource object itself.
     */
    public StaticSiteCustomDomainRequestPropertiesArmResource withValidationMethod(String validationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteCustomDomainRequestPropertiesArmResourceProperties();
        }
        this.innerProperties().withValidationMethod(validationMethod);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
