/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.EnterpriseGradeCdnStatus;
import com.azure.resourcemanager.appservice.models.ResponseMessageEnvelopeRemotePrivateEndpointConnection;
import com.azure.resourcemanager.appservice.models.StagingEnvironmentPolicy;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import com.azure.resourcemanager.appservice.models.StaticSiteTemplateOptions;
import com.azure.resourcemanager.appservice.models.StaticSiteUserProvidedFunctionApp;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class StaticSite {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(StaticSite.class);
    @JsonProperty(value="defaultHostname", access=JsonProperty.Access.WRITE_ONLY)
    private String defaultHostname;
    @JsonProperty(value="repositoryUrl")
    private String repositoryUrl;
    @JsonProperty(value="branch")
    private String branch;
    @JsonProperty(value="customDomains", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> customDomains;
    @JsonProperty(value="repositoryToken")
    private String repositoryToken;
    @JsonProperty(value="buildProperties")
    private StaticSiteBuildProperties buildProperties;
    @JsonProperty(value="privateEndpointConnections", access=JsonProperty.Access.WRITE_ONLY)
    private List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections;
    @JsonProperty(value="stagingEnvironmentPolicy")
    private StagingEnvironmentPolicy stagingEnvironmentPolicy;
    @JsonProperty(value="allowConfigFileUpdates")
    private Boolean allowConfigFileUpdates;
    @JsonProperty(value="templateProperties")
    private StaticSiteTemplateOptions templateProperties;
    @JsonProperty(value="contentDistributionEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String contentDistributionEndpoint;
    @JsonProperty(value="keyVaultReferenceIdentity", access=JsonProperty.Access.WRITE_ONLY)
    private String keyVaultReferenceIdentity;
    @JsonProperty(value="userProvidedFunctionApps", access=JsonProperty.Access.WRITE_ONLY)
    private List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps;
    @JsonProperty(value="provider")
    private String provider;
    @JsonProperty(value="enterpriseGradeCdnStatus")
    private EnterpriseGradeCdnStatus enterpriseGradeCdnStatus;

    public String defaultHostname() {
        return this.defaultHostname;
    }

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public StaticSite withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public StaticSite withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public List<String> customDomains() {
        return this.customDomains;
    }

    public String repositoryToken() {
        return this.repositoryToken;
    }

    public StaticSite withRepositoryToken(String repositoryToken) {
        this.repositoryToken = repositoryToken;
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    public StaticSite withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    public List<ResponseMessageEnvelopeRemotePrivateEndpointConnection> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public StagingEnvironmentPolicy stagingEnvironmentPolicy() {
        return this.stagingEnvironmentPolicy;
    }

    public StaticSite withStagingEnvironmentPolicy(StagingEnvironmentPolicy stagingEnvironmentPolicy) {
        this.stagingEnvironmentPolicy = stagingEnvironmentPolicy;
        return this;
    }

    public Boolean allowConfigFileUpdates() {
        return this.allowConfigFileUpdates;
    }

    public StaticSite withAllowConfigFileUpdates(Boolean allowConfigFileUpdates) {
        this.allowConfigFileUpdates = allowConfigFileUpdates;
        return this;
    }

    public StaticSiteTemplateOptions templateProperties() {
        return this.templateProperties;
    }

    public StaticSite withTemplateProperties(StaticSiteTemplateOptions templateProperties) {
        this.templateProperties = templateProperties;
        return this;
    }

    public String contentDistributionEndpoint() {
        return this.contentDistributionEndpoint;
    }

    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    public List<StaticSiteUserProvidedFunctionApp> userProvidedFunctionApps() {
        return this.userProvidedFunctionApps;
    }

    public String provider() {
        return this.provider;
    }

    public StaticSite withProvider(String provider) {
        this.provider = provider;
        return this;
    }

    public EnterpriseGradeCdnStatus enterpriseGradeCdnStatus() {
        return this.enterpriseGradeCdnStatus;
    }

    public StaticSite withEnterpriseGradeCdnStatus(EnterpriseGradeCdnStatus enterpriseGradeCdnStatus) {
        this.enterpriseGradeCdnStatus = enterpriseGradeCdnStatus;
        return this;
    }

    public void validate() {
        if (this.buildProperties() != null) {
            this.buildProperties().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
        if (this.templateProperties() != null) {
            this.templateProperties().validate();
        }
        if (this.userProvidedFunctionApps() != null) {
            this.userProvidedFunctionApps().forEach(e -> e.validate());
        }
    }
}

