/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appservice.fluent.WebAppsClient;
import com.azure.resourcemanager.appservice.fluent.models.ApiKVReferenceInner;
import com.azure.resourcemanager.appservice.fluent.models.AzureStoragePropertyDictionaryResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.BackupItemInner;
import com.azure.resourcemanager.appservice.fluent.models.BackupRequestInner;
import com.azure.resourcemanager.appservice.fluent.models.ConnectionStringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.ContinuousWebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmPublishingCredentialsPoliciesEntityInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmUsageQuotaInner;
import com.azure.resourcemanager.appservice.fluent.models.CustomHostnameAnalysisResultInner;
import com.azure.resourcemanager.appservice.fluent.models.DeploymentInner;
import com.azure.resourcemanager.appservice.fluent.models.FunctionEnvelopeInner;
import com.azure.resourcemanager.appservice.fluent.models.FunctionSecretsInner;
import com.azure.resourcemanager.appservice.fluent.models.HostKeysInner;
import com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionInner;
import com.azure.resourcemanager.appservice.fluent.models.IdentifierInner;
import com.azure.resourcemanager.appservice.fluent.models.KeyInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployLogInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.MigrateMySqlStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.NetworkFeaturesInner;
import com.azure.resourcemanager.appservice.fluent.models.NetworkTraceInner;
import com.azure.resourcemanager.appservice.fluent.models.OperationInner;
import com.azure.resourcemanager.appservice.fluent.models.PerfMonResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.PremierAddOnInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateAccessInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessModuleInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessThreadInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.PublicCertificateInner;
import com.azure.resourcemanager.appservice.fluent.models.PushSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.RelayServiceConnectionEntityInner;
import com.azure.resourcemanager.appservice.fluent.models.RemotePrivateEndpointConnectionArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.RestoreRequestInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsV2Inner;
import com.azure.resourcemanager.appservice.fluent.models.SiteCloneabilityInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigurationSnapshotInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteExtensionInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePhpErrorLogFlagInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotConfigNamesResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotDifferenceInner;
import com.azure.resourcemanager.appservice.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appservice.fluent.models.StorageMigrationResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.SwiftVirtualNetworkInner;
import com.azure.resourcemanager.appservice.fluent.models.TriggeredJobHistoryInner;
import com.azure.resourcemanager.appservice.fluent.models.TriggeredWebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.UserInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetGatewayInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetInfoResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.WebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.WebSiteInstanceStatusInner;
import com.azure.resourcemanager.appservice.implementation.WebSiteManagementClientImpl;
import com.azure.resourcemanager.appservice.models.ApiKVReferenceCollection;
import com.azure.resourcemanager.appservice.models.BackupItemCollection;
import com.azure.resourcemanager.appservice.models.ContinuousWebJobCollection;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.CsmSlotEntity;
import com.azure.resourcemanager.appservice.models.CsmUsageQuotaCollection;
import com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException;
import com.azure.resourcemanager.appservice.models.DeletedAppRestoreRequest;
import com.azure.resourcemanager.appservice.models.DeploymentCollection;
import com.azure.resourcemanager.appservice.models.FunctionEnvelopeCollection;
import com.azure.resourcemanager.appservice.models.HostnameBindingCollection;
import com.azure.resourcemanager.appservice.models.IdentifierCollection;
import com.azure.resourcemanager.appservice.models.MSDeploy;
import com.azure.resourcemanager.appservice.models.MigrateMySqlRequest;
import com.azure.resourcemanager.appservice.models.PerfMonCounterCollection;
import com.azure.resourcemanager.appservice.models.PremierAddOnPatchResource;
import com.azure.resourcemanager.appservice.models.PrivateEndpointConnectionCollection;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionApprovalRequestResource;
import com.azure.resourcemanager.appservice.models.ProcessInfoCollection;
import com.azure.resourcemanager.appservice.models.ProcessModuleInfoCollection;
import com.azure.resourcemanager.appservice.models.ProcessThreadInfoCollection;
import com.azure.resourcemanager.appservice.models.PublicCertificateCollection;
import com.azure.resourcemanager.appservice.models.PublishingCredentialsPoliciesCollection;
import com.azure.resourcemanager.appservice.models.SiteConfigResourceCollection;
import com.azure.resourcemanager.appservice.models.SiteConfigurationSnapshotInfoCollection;
import com.azure.resourcemanager.appservice.models.SiteExtensionInfoCollection;
import com.azure.resourcemanager.appservice.models.SlotDifferenceCollection;
import com.azure.resourcemanager.appservice.models.SnapshotCollection;
import com.azure.resourcemanager.appservice.models.SnapshotRestoreRequest;
import com.azure.resourcemanager.appservice.models.StorageMigrationOptions;
import com.azure.resourcemanager.appservice.models.TriggeredJobHistoryCollection;
import com.azure.resourcemanager.appservice.models.TriggeredWebJobCollection;
import com.azure.resourcemanager.appservice.models.WebAppCollection;
import com.azure.resourcemanager.appservice.models.WebAppInstanceStatusCollection;
import com.azure.resourcemanager.appservice.models.WebJobCollection;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class WebAppsClientImpl
implements InnerSupportsGet<SiteInner>,
InnerSupportsListing<SiteInner>,
InnerSupportsDelete<Void>,
WebAppsClient {
    private final ClientLogger logger = new ClientLogger(WebAppsClientImpl.class);
    private final WebAppsService service;
    private final WebSiteManagementClientImpl client;

    WebAppsClientImpl(WebSiteManagementClientImpl client) {
        this.service = (WebAppsService)RestProxy.create(WebAppsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppCollection)res.getValue()).value(), ((WebAppCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listSinglePageAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppCollection)res.getValue()).value(), ((WebAppCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteInner> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteInner> list() {
        return new PagedIterable(this.listAsync());
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteInner> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Boolean includeSlots) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, includeSlots, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppCollection)res.getValue()).value(), ((WebAppCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listByResourceGroupSinglePageAsync(String resourceGroupName, Boolean includeSlots, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByResourceGroup(this.client.getEndpoint(), resourceGroupName, includeSlots, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppCollection)res.getValue()).value(), ((WebAppCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName, Boolean includeSlots) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName) {
        Boolean includeSlots = null;
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName, Boolean includeSlots, Context context) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName, includeSlots, context), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteInner> listByResourceGroup(String resourceGroupName) {
        Boolean includeSlots = null;
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, includeSlots));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteInner> listByResourceGroup(String resourceGroupName, Boolean includeSlots, Context context) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName, includeSlots, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getByResourceGroup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteInner> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner getByResourceGroup(String resourceGroupName, String name) {
        return (SiteInner)((Object)this.getByResourceGroupAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteInner> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getByResourceGroupWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String name, SiteInner siteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, name, siteEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SiteInner.class), (Type)((Object)SiteInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, name, siteEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SiteInner.class), (Type)((Object)SiteInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteInner> createOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SiteInner> createOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, name, siteEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner createOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope) {
        return (SiteInner)((Object)this.createOrUpdateAsync(resourceGroupName, name, siteEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner createOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope, Context context) {
        return (SiteInner)((Object)this.createOrUpdateAsync(resourceGroupName, name, siteEnvelope, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm) {
        return this.deleteWithResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String name) {
        Boolean deleteMetrics = null;
        Boolean deleteEmptyServerFarm = null;
        return this.deleteWithResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String name) {
        Boolean deleteMetrics = null;
        Boolean deleteEmptyServerFarm = null;
        this.deleteAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, name, deleteMetrics, deleteEmptyServerFarm, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteInner>> updateWithResponseAsync(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteInner>> updateWithResponseAsync(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteInner> updateAsync(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope) {
        return this.updateWithResponseAsync(resourceGroupName, name, siteEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner update(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope) {
        return (SiteInner)((Object)this.updateAsync(resourceGroupName, name, siteEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteInner> updateWithResponse(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope, Context context) {
        return (Response)this.updateWithResponseAsync(resourceGroupName, name, siteEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameWithResponseAsync(String resourceGroupName, String name, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeCustomHostname(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameWithResponseAsync(String resourceGroupName, String name, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.analyzeCustomHostname(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name, String hostname) {
        return this.analyzeCustomHostnameWithResponseAsync(resourceGroupName, name, hostname).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CustomHostnameAnalysisResultInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name) {
        String hostname = null;
        return this.analyzeCustomHostnameWithResponseAsync(resourceGroupName, name, hostname).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CustomHostnameAnalysisResultInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomHostnameAnalysisResultInner analyzeCustomHostname(String resourceGroupName, String name) {
        String hostname = null;
        return (CustomHostnameAnalysisResultInner)((Object)this.analyzeCustomHostnameAsync(resourceGroupName, name, hostname).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomHostnameAnalysisResultInner> analyzeCustomHostnameWithResponse(String resourceGroupName, String name, String hostname, Context context) {
        return (Response)this.analyzeCustomHostnameWithResponseAsync(resourceGroupName, name, hostname, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> applySlotConfigToProductionWithResponseAsync(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotSwapEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slotSwapEntity is required and cannot be null."));
        }
        slotSwapEntity.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.applySlotConfigToProduction(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), slotSwapEntity, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> applySlotConfigToProductionWithResponseAsync(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotSwapEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slotSwapEntity is required and cannot be null."));
        }
        slotSwapEntity.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.applySlotConfigToProduction(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), slotSwapEntity, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> applySlotConfigToProductionAsync(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity) {
        return this.applySlotConfigToProductionWithResponseAsync(resourceGroupName, name, slotSwapEntity).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void applySlotConfigToProduction(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity) {
        this.applySlotConfigToProductionAsync(resourceGroupName, name, slotSwapEntity).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> applySlotConfigToProductionWithResponse(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity, Context context) {
        return (Response)this.applySlotConfigToProductionWithResponseAsync(resourceGroupName, name, slotSwapEntity, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> backupWithResponseAsync(String resourceGroupName, String name, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.backup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> backupWithResponseAsync(String resourceGroupName, String name, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.backup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupItemInner> backupAsync(String resourceGroupName, String name, BackupRequestInner request) {
        return this.backupWithResponseAsync(resourceGroupName, name, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupItemInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupItemInner backup(String resourceGroupName, String name, BackupRequestInner request) {
        return (BackupItemInner)((Object)this.backupAsync(resourceGroupName, name, request).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupItemInner> backupWithResponse(String resourceGroupName, String name, BackupRequestInner request, Context context) {
        return (Response)this.backupWithResponseAsync(resourceGroupName, name, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listBackupsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBackups(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupItemCollection)res.getValue()).value(), ((BackupItemCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listBackupsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBackups(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupItemCollection)res.getValue()).value(), ((BackupItemCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BackupItemInner> listBackupsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listBackupsSinglePageAsync(resourceGroupName, name), nextLink -> this.listBackupsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BackupItemInner> listBackupsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listBackupsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listBackupsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listBackups(String resourceGroupName, String name) {
        return new PagedIterable(this.listBackupsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listBackups(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listBackupsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> getBackupStatusWithResponseAsync(String resourceGroupName, String name, String backupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBackupStatus(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> getBackupStatusWithResponseAsync(String resourceGroupName, String name, String backupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBackupStatus(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupItemInner> getBackupStatusAsync(String resourceGroupName, String name, String backupId) {
        return this.getBackupStatusWithResponseAsync(resourceGroupName, name, backupId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupItemInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupItemInner getBackupStatus(String resourceGroupName, String name, String backupId) {
        return (BackupItemInner)((Object)this.getBackupStatusAsync(resourceGroupName, name, backupId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupItemInner> getBackupStatusWithResponse(String resourceGroupName, String name, String backupId, Context context) {
        return (Response)this.getBackupStatusWithResponseAsync(resourceGroupName, name, backupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBackupWithResponseAsync(String resourceGroupName, String name, String backupId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteBackup(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteBackupWithResponseAsync(String resourceGroupName, String name, String backupId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteBackup(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBackupAsync(String resourceGroupName, String name, String backupId) {
        return this.deleteBackupWithResponseAsync(resourceGroupName, name, backupId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBackup(String resourceGroupName, String name, String backupId) {
        this.deleteBackupAsync(resourceGroupName, name, backupId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBackupWithResponse(String resourceGroupName, String name, String backupId, Context context) {
        return (Response)this.deleteBackupWithResponseAsync(resourceGroupName, name, backupId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> listBackupStatusSecretsWithResponseAsync(String resourceGroupName, String name, String backupId, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBackupStatusSecrets(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> listBackupStatusSecretsWithResponseAsync(String resourceGroupName, String name, String backupId, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBackupStatusSecrets(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupItemInner> listBackupStatusSecretsAsync(String resourceGroupName, String name, String backupId, BackupRequestInner request) {
        return this.listBackupStatusSecretsWithResponseAsync(resourceGroupName, name, backupId, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupItemInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupItemInner listBackupStatusSecrets(String resourceGroupName, String name, String backupId, BackupRequestInner request) {
        return (BackupItemInner)((Object)this.listBackupStatusSecretsAsync(resourceGroupName, name, backupId, request).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupItemInner> listBackupStatusSecretsWithResponse(String resourceGroupName, String name, String backupId, BackupRequestInner request, Context context) {
        return (Response)this.listBackupStatusSecretsWithResponseAsync(resourceGroupName, name, backupId, request, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restoreWithResponseAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restore(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreWithResponseAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restore(this.client.getEndpoint(), resourceGroupName, name, backupId, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreWithResponseAsync(resourceGroupName, name, backupId, request);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreWithResponseAsync(resourceGroupName, name, backupId, request, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestore(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        return this.beginRestoreAsync(resourceGroupName, name, backupId, request).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestore(String resourceGroupName, String name, String backupId, RestoreRequestInner request, Context context) {
        return this.beginRestoreAsync(resourceGroupName, name, backupId, request, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        return this.beginRestoreAsync(resourceGroupName, name, backupId, request).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request, Context context) {
        return this.beginRestoreAsync(resourceGroupName, name, backupId, request, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restore(String resourceGroupName, String name, String backupId, RestoreRequestInner request) {
        this.restoreAsync(resourceGroupName, name, backupId, request).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restore(String resourceGroupName, String name, String backupId, RestoreRequestInner request, Context context) {
        this.restoreAsync(resourceGroupName, name, backupId, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmPublishingCredentialsPoliciesEntityInner>> listBasicPublishingCredentialsPoliciesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBasicPublishingCredentialsPolicies(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PublishingCredentialsPoliciesCollection)res.getValue()).value(), ((PublishingCredentialsPoliciesCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmPublishingCredentialsPoliciesEntityInner>> listBasicPublishingCredentialsPoliciesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBasicPublishingCredentialsPolicies(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PublishingCredentialsPoliciesCollection)res.getValue()).value(), ((PublishingCredentialsPoliciesCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listBasicPublishingCredentialsPoliciesSinglePageAsync(resourceGroupName, name), nextLink -> this.listBasicPublishingCredentialsPoliciesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listBasicPublishingCredentialsPoliciesSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listBasicPublishingCredentialsPoliciesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPolicies(String resourceGroupName, String name) {
        return new PagedIterable(this.listBasicPublishingCredentialsPoliciesAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPolicies(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listBasicPublishingCredentialsPoliciesAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowedWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFtpAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowedWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFtpAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedAsync(String resourceGroupName, String name) {
        return this.getFtpAllowedWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner getFtpAllowed(String resourceGroupName, String name) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.getFtpAllowedAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getFtpAllowedWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedWithResponseAsync(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateFtpAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedWithResponseAsync(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateFtpAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedAsync(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return this.updateFtpAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner updateFtpAllowed(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.updateFtpAllowedAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedWithResponse(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        return (Response)this.updateFtpAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowedWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getScmAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowedWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getScmAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedAsync(String resourceGroupName, String name) {
        return this.getScmAllowedWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner getScmAllowed(String resourceGroupName, String name) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.getScmAllowedAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getScmAllowedWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedWithResponseAsync(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateScmAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedWithResponseAsync(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateScmAllowed(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedAsync(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return this.updateScmAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner updateScmAllowed(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.updateScmAllowedAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedWithResponse(String resourceGroupName, String name, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        return (Response)this.updateScmAllowedWithResponseAsync(resourceGroupName, name, csmPublishingAccessPoliciesEntity, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigResourceInner>> listConfigurationsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConfigurations(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigResourceCollection)res.getValue()).value(), ((SiteConfigResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigResourceInner>> listConfigurationsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listConfigurations(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigResourceCollection)res.getValue()).value(), ((SiteConfigResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteConfigResourceInner> listConfigurationsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listConfigurationsSinglePageAsync(resourceGroupName, name), nextLink -> this.listConfigurationsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteConfigResourceInner> listConfigurationsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listConfigurationsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listConfigurationsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigResourceInner> listConfigurations(String resourceGroupName, String name) {
        return new PagedIterable(this.listConfigurationsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigResourceInner> listConfigurations(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listConfigurationsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> updateApplicationSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateApplicationSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> updateApplicationSettingsWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateApplicationSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> updateApplicationSettingsAsync(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return this.updateApplicationSettingsWithResponseAsync(resourceGroupName, name, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner updateApplicationSettings(String resourceGroupName, String name, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.updateApplicationSettingsAsync(resourceGroupName, name, appSettings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> updateApplicationSettingsWithResponse(String resourceGroupName, String name, StringDictionaryInner appSettings, Context context) {
        return (Response)this.updateApplicationSettingsWithResponseAsync(resourceGroupName, name, appSettings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listApplicationSettingsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listApplicationSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listApplicationSettingsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listApplicationSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listApplicationSettingsAsync(String resourceGroupName, String name) {
        return this.listApplicationSettingsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner listApplicationSettings(String resourceGroupName, String name) {
        return (StringDictionaryInner)((Object)this.listApplicationSettingsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> listApplicationSettingsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listApplicationSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsWithResponseAsync(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettings is required and cannot be null."));
        }
        siteAuthSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAuthSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsWithResponseAsync(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettings is required and cannot be null."));
        }
        siteAuthSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAuthSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsInner> updateAuthSettingsAsync(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings) {
        return this.updateAuthSettingsWithResponseAsync(resourceGroupName, name, siteAuthSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsInner updateAuthSettings(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings) {
        return (SiteAuthSettingsInner)((Object)this.updateAuthSettingsAsync(resourceGroupName, name, siteAuthSettings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsInner> updateAuthSettingsWithResponse(String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings, Context context) {
        return (Response)this.updateAuthSettingsWithResponseAsync(resourceGroupName, name, siteAuthSettings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsInner>> getAuthSettingsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAuthSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsInner>> getAuthSettingsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAuthSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsInner> getAuthSettingsAsync(String resourceGroupName, String name) {
        return this.getAuthSettingsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsInner getAuthSettings(String resourceGroupName, String name) {
        return (SiteAuthSettingsInner)((Object)this.getAuthSettingsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsInner> getAuthSettingsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getAuthSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithoutSecretsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAuthSettingsV2WithoutSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithoutSecretsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAuthSettingsV2WithoutSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsAsync(String resourceGroupName, String name) {
        return this.getAuthSettingsV2WithoutSecretsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsV2Inner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner getAuthSettingsV2WithoutSecrets(String resourceGroupName, String name) {
        return (SiteAuthSettingsV2Inner)((Object)this.getAuthSettingsV2WithoutSecretsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getAuthSettingsV2WithoutSecretsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2WithResponseAsync(String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettingsV2 == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettingsV2 is required and cannot be null."));
        }
        siteAuthSettingsV2.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettingsV2, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2WithResponseAsync(String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettingsV2 == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettingsV2 is required and cannot be null."));
        }
        siteAuthSettingsV2.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettingsV2, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> updateAuthSettingsV2Async(String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        return this.updateAuthSettingsV2WithResponseAsync(resourceGroupName, name, siteAuthSettingsV2).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsV2Inner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner updateAuthSettingsV2(String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        return (SiteAuthSettingsV2Inner)((Object)this.updateAuthSettingsV2Async(resourceGroupName, name, siteAuthSettingsV2).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> updateAuthSettingsV2WithResponse(String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2, Context context) {
        return (Response)this.updateAuthSettingsV2WithResponseAsync(resourceGroupName, name, siteAuthSettingsV2, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAuthSettingsV2(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2Async(String resourceGroupName, String name) {
        return this.getAuthSettingsV2WithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsV2Inner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner getAuthSettingsV2(String resourceGroupName, String name) {
        return (SiteAuthSettingsV2Inner)((Object)this.getAuthSettingsV2Async(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> getAuthSettingsV2WithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getAuthSettingsV2WithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsWithResponseAsync(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (azureStorageAccounts == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureStorageAccounts is required and cannot be null."));
        }
        azureStorageAccounts.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), azureStorageAccounts, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsWithResponseAsync(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (azureStorageAccounts == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureStorageAccounts is required and cannot be null."));
        }
        azureStorageAccounts.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), azureStorageAccounts, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsAsync(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return this.updateAzureStorageAccountsWithResponseAsync(resourceGroupName, name, azureStorageAccounts).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AzureStoragePropertyDictionaryResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureStoragePropertyDictionaryResourceInner updateAzureStorageAccounts(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return (AzureStoragePropertyDictionaryResourceInner)((Object)this.updateAzureStorageAccountsAsync(resourceGroupName, name, azureStorageAccounts).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsWithResponse(String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts, Context context) {
        return (Response)this.updateAzureStorageAccountsWithResponseAsync(resourceGroupName, name, azureStorageAccounts, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAzureStorageAccounts(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsAsync(String resourceGroupName, String name) {
        return this.listAzureStorageAccountsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AzureStoragePropertyDictionaryResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureStoragePropertyDictionaryResourceInner listAzureStorageAccounts(String resourceGroupName, String name) {
        return (AzureStoragePropertyDictionaryResourceInner)((Object)this.listAzureStorageAccountsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listAzureStorageAccountsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupRequestInner>> updateBackupConfigurationWithResponseAsync(String resourceGroupName, String name, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupRequestInner>> updateBackupConfigurationWithResponseAsync(String resourceGroupName, String name, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupRequestInner> updateBackupConfigurationAsync(String resourceGroupName, String name, BackupRequestInner request) {
        return this.updateBackupConfigurationWithResponseAsync(resourceGroupName, name, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupRequestInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupRequestInner updateBackupConfiguration(String resourceGroupName, String name, BackupRequestInner request) {
        return (BackupRequestInner)((Object)this.updateBackupConfigurationAsync(resourceGroupName, name, request).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupRequestInner> updateBackupConfigurationWithResponse(String resourceGroupName, String name, BackupRequestInner request, Context context) {
        return (Response)this.updateBackupConfigurationWithResponseAsync(resourceGroupName, name, request, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBackupConfigurationWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteBackupConfigurationWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBackupConfigurationAsync(String resourceGroupName, String name) {
        return this.deleteBackupConfigurationWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBackupConfiguration(String resourceGroupName, String name) {
        this.deleteBackupConfigurationAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBackupConfigurationWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.deleteBackupConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupRequestInner>> getBackupConfigurationWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupRequestInner>> getBackupConfigurationWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBackupConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupRequestInner> getBackupConfigurationAsync(String resourceGroupName, String name) {
        return this.getBackupConfigurationWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupRequestInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupRequestInner getBackupConfiguration(String resourceGroupName, String name) {
        return (BackupRequestInner)((Object)this.getBackupConfigurationAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupRequestInner> getBackupConfigurationWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getBackupConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getAppSettingsKeyVaultReferencesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAppSettingsKeyVaultReferences(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getAppSettingsKeyVaultReferencesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAppSettingsKeyVaultReferences(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.getAppSettingsKeyVaultReferencesSinglePageAsync(resourceGroupName, name), nextLink -> this.getAppSettingsKeyVaultReferencesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.getAppSettingsKeyVaultReferencesSinglePageAsync(resourceGroupName, name, context), nextLink -> this.getAppSettingsKeyVaultReferencesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferences(String resourceGroupName, String name) {
        return new PagedIterable(this.getAppSettingsKeyVaultReferencesAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferences(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.getAppSettingsKeyVaultReferencesAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceWithResponseAsync(String resourceGroupName, String name, String appSettingKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (appSettingKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettingKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAppSettingKeyVaultReference(this.client.getEndpoint(), resourceGroupName, name, appSettingKey, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceWithResponseAsync(String resourceGroupName, String name, String appSettingKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (appSettingKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettingKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAppSettingKeyVaultReference(this.client.getEndpoint(), resourceGroupName, name, appSettingKey, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApiKVReferenceInner> getAppSettingKeyVaultReferenceAsync(String resourceGroupName, String name, String appSettingKey) {
        return this.getAppSettingKeyVaultReferenceWithResponseAsync(resourceGroupName, name, appSettingKey).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ApiKVReferenceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiKVReferenceInner getAppSettingKeyVaultReference(String resourceGroupName, String name, String appSettingKey) {
        return (ApiKVReferenceInner)((Object)this.getAppSettingKeyVaultReferenceAsync(resourceGroupName, name, appSettingKey).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApiKVReferenceInner> getAppSettingKeyVaultReferenceWithResponse(String resourceGroupName, String name, String appSettingKey, Context context) {
        return (Response)this.getAppSettingKeyVaultReferenceWithResponseAsync(resourceGroupName, name, appSettingKey, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferencesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSiteConnectionStringKeyVaultReferences(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferencesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSiteConnectionStringKeyVaultReferences(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.getSiteConnectionStringKeyVaultReferencesSinglePageAsync(resourceGroupName, name), nextLink -> this.getSiteConnectionStringKeyVaultReferencesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.getSiteConnectionStringKeyVaultReferencesSinglePageAsync(resourceGroupName, name, context), nextLink -> this.getSiteConnectionStringKeyVaultReferencesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferences(String resourceGroupName, String name) {
        return new PagedIterable(this.getSiteConnectionStringKeyVaultReferencesAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferences(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.getSiteConnectionStringKeyVaultReferencesAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceWithResponseAsync(String resourceGroupName, String name, String connectionStringKey) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (connectionStringKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStringKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSiteConnectionStringKeyVaultReference(this.client.getEndpoint(), resourceGroupName, name, connectionStringKey, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceWithResponseAsync(String resourceGroupName, String name, String connectionStringKey, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (connectionStringKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStringKey is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSiteConnectionStringKeyVaultReference(this.client.getEndpoint(), resourceGroupName, name, connectionStringKey, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceAsync(String resourceGroupName, String name, String connectionStringKey) {
        return this.getSiteConnectionStringKeyVaultReferenceWithResponseAsync(resourceGroupName, name, connectionStringKey).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ApiKVReferenceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiKVReferenceInner getSiteConnectionStringKeyVaultReference(String resourceGroupName, String name, String connectionStringKey) {
        return (ApiKVReferenceInner)((Object)this.getSiteConnectionStringKeyVaultReferenceAsync(resourceGroupName, name, connectionStringKey).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceWithResponse(String resourceGroupName, String name, String connectionStringKey, Context context) {
        return (Response)this.getSiteConnectionStringKeyVaultReferenceWithResponseAsync(resourceGroupName, name, connectionStringKey, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsWithResponseAsync(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionStrings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStrings is required and cannot be null."));
        }
        connectionStrings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateConnectionStrings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionStrings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsWithResponseAsync(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionStrings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStrings is required and cannot be null."));
        }
        connectionStrings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateConnectionStrings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionStrings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionStringDictionaryInner> updateConnectionStringsAsync(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings) {
        return this.updateConnectionStringsWithResponseAsync(resourceGroupName, name, connectionStrings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConnectionStringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionStringDictionaryInner updateConnectionStrings(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings) {
        return (ConnectionStringDictionaryInner)((Object)this.updateConnectionStringsAsync(resourceGroupName, name, connectionStrings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectionStringDictionaryInner> updateConnectionStringsWithResponse(String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings, Context context) {
        return (Response)this.updateConnectionStringsWithResponseAsync(resourceGroupName, name, connectionStrings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectionStringDictionaryInner>> listConnectionStringsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConnectionStrings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectionStringDictionaryInner>> listConnectionStringsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listConnectionStrings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionStringDictionaryInner> listConnectionStringsAsync(String resourceGroupName, String name) {
        return this.listConnectionStringsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConnectionStringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionStringDictionaryInner listConnectionStrings(String resourceGroupName, String name) {
        return (ConnectionStringDictionaryInner)((Object)this.listConnectionStringsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectionStringDictionaryInner> listConnectionStringsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listConnectionStringsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDiagnosticLogsConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDiagnosticLogsConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteLogsConfigInner> getDiagnosticLogsConfigurationAsync(String resourceGroupName, String name) {
        return this.getDiagnosticLogsConfigurationWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteLogsConfigInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteLogsConfigInner getDiagnosticLogsConfiguration(String resourceGroupName, String name) {
        return (SiteLogsConfigInner)((Object)this.getDiagnosticLogsConfigurationAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteLogsConfigInner> getDiagnosticLogsConfigurationWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getDiagnosticLogsConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigWithResponseAsync(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteLogsConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteLogsConfig is required and cannot be null."));
        }
        siteLogsConfig.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDiagnosticLogsConfig(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteLogsConfig, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigWithResponseAsync(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteLogsConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteLogsConfig is required and cannot be null."));
        }
        siteLogsConfig.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDiagnosticLogsConfig(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteLogsConfig, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteLogsConfigInner> updateDiagnosticLogsConfigAsync(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig) {
        return this.updateDiagnosticLogsConfigWithResponseAsync(resourceGroupName, name, siteLogsConfig).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteLogsConfigInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteLogsConfigInner updateDiagnosticLogsConfig(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig) {
        return (SiteLogsConfigInner)((Object)this.updateDiagnosticLogsConfigAsync(resourceGroupName, name, siteLogsConfig).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteLogsConfigInner> updateDiagnosticLogsConfigWithResponse(String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig, Context context) {
        return (Response)this.updateDiagnosticLogsConfigWithResponseAsync(resourceGroupName, name, siteLogsConfig, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> updateMetadataWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner metadata) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (metadata == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metadata is required and cannot be null."));
        }
        metadata.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateMetadata(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), metadata, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> updateMetadataWithResponseAsync(String resourceGroupName, String name, StringDictionaryInner metadata, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (metadata == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metadata is required and cannot be null."));
        }
        metadata.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateMetadata(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), metadata, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> updateMetadataAsync(String resourceGroupName, String name, StringDictionaryInner metadata) {
        return this.updateMetadataWithResponseAsync(resourceGroupName, name, metadata).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner updateMetadata(String resourceGroupName, String name, StringDictionaryInner metadata) {
        return (StringDictionaryInner)((Object)this.updateMetadataAsync(resourceGroupName, name, metadata).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> updateMetadataWithResponse(String resourceGroupName, String name, StringDictionaryInner metadata, Context context) {
        return (Response)this.updateMetadataWithResponseAsync(resourceGroupName, name, metadata, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listMetadataWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetadata(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listMetadataWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listMetadata(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listMetadataAsync(String resourceGroupName, String name) {
        return this.listMetadataWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner listMetadata(String resourceGroupName, String name) {
        return (StringDictionaryInner)((Object)this.listMetadataAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> listMetadataWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listMetadataWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPublishingCredentials(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPublishingCredentials(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsAsync(String resourceGroupName, String name) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.listPublishingCredentialsWithResponseAsync(resourceGroupName, name);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)UserInner.class), (Type)((Object)UserInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsAsync(String resourceGroupName, String name, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.listPublishingCredentialsWithResponseAsync(resourceGroupName, name, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)UserInner.class), (Type)((Object)UserInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentials(String resourceGroupName, String name) {
        return this.beginListPublishingCredentialsAsync(resourceGroupName, name).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentials(String resourceGroupName, String name, Context context) {
        return this.beginListPublishingCredentialsAsync(resourceGroupName, name, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserInner> listPublishingCredentialsAsync(String resourceGroupName, String name) {
        return this.beginListPublishingCredentialsAsync(resourceGroupName, name).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<UserInner> listPublishingCredentialsAsync(String resourceGroupName, String name, Context context) {
        return this.beginListPublishingCredentialsAsync(resourceGroupName, name, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserInner listPublishingCredentials(String resourceGroupName, String name) {
        return (UserInner)((Object)this.listPublishingCredentialsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserInner listPublishingCredentials(String resourceGroupName, String name, Context context) {
        return (UserInner)((Object)this.listPublishingCredentialsAsync(resourceGroupName, name, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PushSettingsInner>> updateSitePushSettingsWithResponseAsync(String resourceGroupName, String name, PushSettingsInner pushSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pushSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pushSettings is required and cannot be null."));
        }
        pushSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSitePushSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), pushSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PushSettingsInner>> updateSitePushSettingsWithResponseAsync(String resourceGroupName, String name, PushSettingsInner pushSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pushSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pushSettings is required and cannot be null."));
        }
        pushSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSitePushSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), pushSettings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PushSettingsInner> updateSitePushSettingsAsync(String resourceGroupName, String name, PushSettingsInner pushSettings) {
        return this.updateSitePushSettingsWithResponseAsync(resourceGroupName, name, pushSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PushSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PushSettingsInner updateSitePushSettings(String resourceGroupName, String name, PushSettingsInner pushSettings) {
        return (PushSettingsInner)((Object)this.updateSitePushSettingsAsync(resourceGroupName, name, pushSettings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PushSettingsInner> updateSitePushSettingsWithResponse(String resourceGroupName, String name, PushSettingsInner pushSettings, Context context) {
        return (Response)this.updateSitePushSettingsWithResponseAsync(resourceGroupName, name, pushSettings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PushSettingsInner>> listSitePushSettingsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSitePushSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PushSettingsInner>> listSitePushSettingsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSitePushSettings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PushSettingsInner> listSitePushSettingsAsync(String resourceGroupName, String name) {
        return this.listSitePushSettingsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PushSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PushSettingsInner listSitePushSettings(String resourceGroupName, String name) {
        return (PushSettingsInner)((Object)this.listSitePushSettingsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PushSettingsInner> listSitePushSettingsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listSitePushSettingsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SlotConfigNamesResourceInner>> listSlotConfigurationNamesWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SlotConfigNamesResourceInner>> listSlotConfigurationNamesWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SlotConfigNamesResourceInner> listSlotConfigurationNamesAsync(String resourceGroupName, String name) {
        return this.listSlotConfigurationNamesWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SlotConfigNamesResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SlotConfigNamesResourceInner listSlotConfigurationNames(String resourceGroupName, String name) {
        return (SlotConfigNamesResourceInner)((Object)this.listSlotConfigurationNamesAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SlotConfigNamesResourceInner> listSlotConfigurationNamesWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listSlotConfigurationNamesWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SlotConfigNamesResourceInner>> updateSlotConfigurationNamesWithResponseAsync(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotConfigNames == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slotConfigNames is required and cannot be null."));
        }
        slotConfigNames.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), slotConfigNames, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SlotConfigNamesResourceInner>> updateSlotConfigurationNamesWithResponseAsync(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotConfigNames == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slotConfigNames is required and cannot be null."));
        }
        slotConfigNames.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSlotConfigurationNames(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), slotConfigNames, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SlotConfigNamesResourceInner> updateSlotConfigurationNamesAsync(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames) {
        return this.updateSlotConfigurationNamesWithResponseAsync(resourceGroupName, name, slotConfigNames).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SlotConfigNamesResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SlotConfigNamesResourceInner updateSlotConfigurationNames(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames) {
        return (SlotConfigNamesResourceInner)((Object)this.updateSlotConfigurationNamesAsync(resourceGroupName, name, slotConfigNames).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SlotConfigNamesResourceInner> updateSlotConfigurationNamesWithResponse(String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames, Context context) {
        return (Response)this.updateSlotConfigurationNamesWithResponseAsync(resourceGroupName, name, slotConfigNames, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> getConfigurationWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> getConfigurationWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> getConfigurationAsync(String resourceGroupName, String name) {
        return this.getConfigurationWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner getConfiguration(String resourceGroupName, String name) {
        return (SiteConfigResourceInner)((Object)this.getConfigurationAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> getConfigurationWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getConfigurationWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> createOrUpdateConfigurationWithResponseAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> createOrUpdateConfigurationWithResponseAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> createOrUpdateConfigurationAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return this.createOrUpdateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner createOrUpdateConfiguration(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return (SiteConfigResourceInner)((Object)this.createOrUpdateConfigurationAsync(resourceGroupName, name, siteConfig).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> createOrUpdateConfigurationWithResponse(String resourceGroupName, String name, SiteConfigResourceInner siteConfig, Context context) {
        return (Response)this.createOrUpdateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> updateConfigurationWithResponseAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> updateConfigurationWithResponseAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateConfiguration(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> updateConfigurationAsync(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return this.updateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner updateConfiguration(String resourceGroupName, String name, SiteConfigResourceInner siteConfig) {
        return (SiteConfigResourceInner)((Object)this.updateConfigurationAsync(resourceGroupName, name, siteConfig).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> updateConfigurationWithResponse(String resourceGroupName, String name, SiteConfigResourceInner siteConfig, Context context) {
        return (Response)this.updateConfigurationWithResponseAsync(resourceGroupName, name, siteConfig, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigurationSnapshotInfoInner>> listConfigurationSnapshotInfoSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConfigurationSnapshotInfo(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).value(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigurationSnapshotInfoInner>> listConfigurationSnapshotInfoSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listConfigurationSnapshotInfo(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).value(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listConfigurationSnapshotInfoSinglePageAsync(resourceGroupName, name), nextLink -> this.listConfigurationSnapshotInfoNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listConfigurationSnapshotInfoSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listConfigurationSnapshotInfoNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfo(String resourceGroupName, String name) {
        return new PagedIterable(this.listConfigurationSnapshotInfoAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfo(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listConfigurationSnapshotInfoAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotWithResponseAsync(String resourceGroupName, String name, String snapshotId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotWithResponseAsync(String resourceGroupName, String name, String snapshotId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> getConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId) {
        return this.getConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner getConfigurationSnapshot(String resourceGroupName, String name, String snapshotId) {
        return (SiteConfigResourceInner)((Object)this.getConfigurationSnapshotAsync(resourceGroupName, name, snapshotId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> getConfigurationSnapshotWithResponse(String resourceGroupName, String name, String snapshotId, Context context) {
        return (Response)this.getConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> recoverSiteConfigurationSnapshotWithResponseAsync(String resourceGroupName, String name, String snapshotId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.recoverSiteConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> recoverSiteConfigurationSnapshotWithResponseAsync(String resourceGroupName, String name, String snapshotId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.recoverSiteConfigurationSnapshot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> recoverSiteConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId) {
        return this.recoverSiteConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void recoverSiteConfigurationSnapshot(String resourceGroupName, String name, String snapshotId) {
        this.recoverSiteConfigurationSnapshotAsync(resourceGroupName, name, snapshotId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> recoverSiteConfigurationSnapshotWithResponse(String resourceGroupName, String name, String snapshotId, Context context) {
        return (Response)this.recoverSiteConfigurationSnapshotWithResponseAsync(resourceGroupName, name, snapshotId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getWebSiteContainerLogsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> this.service.getWebSiteContainerLogs(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/octet-stream", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getWebSiteContainerLogsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/octet-stream";
        context = this.client.mergeContext(context);
        return this.service.getWebSiteContainerLogs(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/octet-stream", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getWebSiteContainerLogsAsync(String resourceGroupName, String name) {
        return this.getWebSiteContainerLogsWithResponseAsync(resourceGroupName, name).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getWebSiteContainerLogs(String resourceGroupName, String name) {
        final Iterator iterator = this.getWebSiteContainerLogsAsync(resourceGroupName, name).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getWebSiteContainerLogsWithResponse(String resourceGroupName, String name, Context context) {
        return (StreamResponse)this.getWebSiteContainerLogsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getContainerLogsZipWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/zip";
        return FluxUtil.withContext(context -> this.service.getContainerLogsZip(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/zip", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getContainerLogsZipWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/zip";
        context = this.client.mergeContext(context);
        return this.service.getContainerLogsZip(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/zip", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getContainerLogsZipAsync(String resourceGroupName, String name) {
        return this.getContainerLogsZipWithResponseAsync(resourceGroupName, name).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getContainerLogsZip(String resourceGroupName, String name) {
        final Iterator iterator = this.getContainerLogsZipAsync(resourceGroupName, name).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getContainerLogsZipWithResponse(String resourceGroupName, String name, Context context) {
        return (StreamResponse)this.getContainerLogsZipWithResponseAsync(resourceGroupName, name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ContinuousWebJobInner>> listContinuousWebJobsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listContinuousWebJobs(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ContinuousWebJobCollection)res.getValue()).value(), ((ContinuousWebJobCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ContinuousWebJobInner>> listContinuousWebJobsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listContinuousWebJobs(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ContinuousWebJobCollection)res.getValue()).value(), ((ContinuousWebJobCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ContinuousWebJobInner> listContinuousWebJobsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listContinuousWebJobsSinglePageAsync(resourceGroupName, name), nextLink -> this.listContinuousWebJobsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ContinuousWebJobInner> listContinuousWebJobsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listContinuousWebJobsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listContinuousWebJobsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ContinuousWebJobInner> listContinuousWebJobs(String resourceGroupName, String name) {
        return new PagedIterable(this.listContinuousWebJobsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ContinuousWebJobInner> listContinuousWebJobs(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listContinuousWebJobsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ContinuousWebJobInner>> getContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ContinuousWebJobInner>> getContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ContinuousWebJobInner> getContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return this.getContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ContinuousWebJobInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ContinuousWebJobInner getContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        return (ContinuousWebJobInner)((Object)this.getContinuousWebJobAsync(resourceGroupName, name, webJobName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ContinuousWebJobInner> getContinuousWebJobWithResponse(String resourceGroupName, String name, String webJobName, Context context) {
        return (Response)this.getContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return this.deleteContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        this.deleteContinuousWebJobAsync(resourceGroupName, name, webJobName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteContinuousWebJobWithResponse(String resourceGroupName, String name, String webJobName, Context context) {
        return (Response)this.deleteContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> startContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.startContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return this.startContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        this.startContinuousWebJobAsync(resourceGroupName, name, webJobName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startContinuousWebJobWithResponse(String resourceGroupName, String name, String webJobName, Context context) {
        return (Response)this.startContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stopContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> stopContinuousWebJobWithResponseAsync(String resourceGroupName, String name, String webJobName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (webJobName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter webJobName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stopContinuousWebJob(this.client.getEndpoint(), resourceGroupName, name, webJobName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopContinuousWebJobAsync(String resourceGroupName, String name, String webJobName) {
        return this.stopContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopContinuousWebJob(String resourceGroupName, String name, String webJobName) {
        this.stopContinuousWebJobAsync(resourceGroupName, name, webJobName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopContinuousWebJobWithResponse(String resourceGroupName, String name, String webJobName, Context context) {
        return (Response)this.stopContinuousWebJobWithResponseAsync(resourceGroupName, name, webJobName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentInner>> listDeploymentsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeployments(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentCollection)res.getValue()).value(), ((DeploymentCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DeploymentInner>> listDeploymentsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeployments(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DeploymentCollection)res.getValue()).value(), ((DeploymentCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DeploymentInner> listDeploymentsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listDeploymentsSinglePageAsync(resourceGroupName, name), nextLink -> this.listDeploymentsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DeploymentInner> listDeploymentsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listDeploymentsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listDeploymentsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentInner> listDeployments(String resourceGroupName, String name) {
        return new PagedIterable(this.listDeploymentsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DeploymentInner> listDeployments(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listDeploymentsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentInner>> getDeploymentWithResponseAsync(String resourceGroupName, String name, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDeployment(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentInner>> getDeploymentWithResponseAsync(String resourceGroupName, String name, String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDeployment(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentInner> getDeploymentAsync(String resourceGroupName, String name, String id) {
        return this.getDeploymentWithResponseAsync(resourceGroupName, name, id).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentInner getDeployment(String resourceGroupName, String name, String id) {
        return (DeploymentInner)((Object)this.getDeploymentAsync(resourceGroupName, name, id).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentInner> getDeploymentWithResponse(String resourceGroupName, String name, String id, Context context) {
        return (Response)this.getDeploymentWithResponseAsync(resourceGroupName, name, id, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentInner>> createDeploymentWithResponseAsync(String resourceGroupName, String name, String id, DeploymentInner deployment) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deployment == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deployment is required and cannot be null."));
        }
        deployment.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDeployment(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), deployment, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentInner>> createDeploymentWithResponseAsync(String resourceGroupName, String name, String id, DeploymentInner deployment, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (deployment == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter deployment is required and cannot be null."));
        }
        deployment.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createDeployment(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), deployment, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentInner> createDeploymentAsync(String resourceGroupName, String name, String id, DeploymentInner deployment) {
        return this.createDeploymentWithResponseAsync(resourceGroupName, name, id, deployment).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentInner createDeployment(String resourceGroupName, String name, String id, DeploymentInner deployment) {
        return (DeploymentInner)((Object)this.createDeploymentAsync(resourceGroupName, name, id, deployment).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentInner> createDeploymentWithResponse(String resourceGroupName, String name, String id, DeploymentInner deployment, Context context) {
        return (Response)this.createDeploymentWithResponseAsync(resourceGroupName, name, id, deployment, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDeploymentWithResponseAsync(String resourceGroupName, String name, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDeployment(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDeploymentWithResponseAsync(String resourceGroupName, String name, String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDeployment(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDeploymentAsync(String resourceGroupName, String name, String id) {
        return this.deleteDeploymentWithResponseAsync(resourceGroupName, name, id).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDeployment(String resourceGroupName, String name, String id) {
        this.deleteDeploymentAsync(resourceGroupName, name, id).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDeploymentWithResponse(String resourceGroupName, String name, String id, Context context) {
        return (Response)this.deleteDeploymentWithResponseAsync(resourceGroupName, name, id, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DeploymentInner>> listDeploymentLogWithResponseAsync(String resourceGroupName, String name, String id) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDeploymentLog(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DeploymentInner>> listDeploymentLogWithResponseAsync(String resourceGroupName, String name, String id, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (id == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter id is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDeploymentLog(this.client.getEndpoint(), resourceGroupName, name, id, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DeploymentInner> listDeploymentLogAsync(String resourceGroupName, String name, String id) {
        return this.listDeploymentLogWithResponseAsync(resourceGroupName, name, id).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((DeploymentInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DeploymentInner listDeploymentLog(String resourceGroupName, String name, String id) {
        return (DeploymentInner)((Object)this.listDeploymentLogAsync(resourceGroupName, name, id).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DeploymentInner> listDeploymentLogWithResponse(String resourceGroupName, String name, String id, Context context) {
        return (Response)this.listDeploymentLogWithResponseAsync(resourceGroupName, name, id, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RestoreRequestInner>> discoverBackupWithResponseAsync(String resourceGroupName, String name, RestoreRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.discoverBackup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RestoreRequestInner>> discoverBackupWithResponseAsync(String resourceGroupName, String name, RestoreRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.discoverBackup(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RestoreRequestInner> discoverBackupAsync(String resourceGroupName, String name, RestoreRequestInner request) {
        return this.discoverBackupWithResponseAsync(resourceGroupName, name, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RestoreRequestInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RestoreRequestInner discoverBackup(String resourceGroupName, String name, RestoreRequestInner request) {
        return (RestoreRequestInner)((Object)this.discoverBackupAsync(resourceGroupName, name, request).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RestoreRequestInner> discoverBackupWithResponse(String resourceGroupName, String name, RestoreRequestInner request, Context context) {
        return (Response)this.discoverBackupWithResponseAsync(resourceGroupName, name, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IdentifierInner>> listDomainOwnershipIdentifiersSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listDomainOwnershipIdentifiers(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IdentifierCollection)res.getValue()).value(), ((IdentifierCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<IdentifierInner>> listDomainOwnershipIdentifiersSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listDomainOwnershipIdentifiers(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((IdentifierCollection)res.getValue()).value(), ((IdentifierCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<IdentifierInner> listDomainOwnershipIdentifiersAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listDomainOwnershipIdentifiersSinglePageAsync(resourceGroupName, name), nextLink -> this.listDomainOwnershipIdentifiersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<IdentifierInner> listDomainOwnershipIdentifiersAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listDomainOwnershipIdentifiersSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listDomainOwnershipIdentifiersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IdentifierInner> listDomainOwnershipIdentifiers(String resourceGroupName, String name) {
        return new PagedIterable(this.listDomainOwnershipIdentifiersAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<IdentifierInner> listDomainOwnershipIdentifiers(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listDomainOwnershipIdentifiersAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IdentifierInner>> getDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IdentifierInner>> getDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IdentifierInner> getDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        return this.getDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((IdentifierInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IdentifierInner getDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        return (IdentifierInner)((Object)this.getDomainOwnershipIdentifierAsync(resourceGroupName, name, domainOwnershipIdentifierName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IdentifierInner> getDomainOwnershipIdentifierWithResponse(String resourceGroupName, String name, String domainOwnershipIdentifierName, Context context) {
        return (Response)this.getDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (domainOwnershipIdentifier == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null."));
        }
        domainOwnershipIdentifier.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), domainOwnershipIdentifier, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (domainOwnershipIdentifier == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null."));
        }
        domainOwnershipIdentifier.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), domainOwnershipIdentifier, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IdentifierInner> createOrUpdateDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return this.createOrUpdateDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((IdentifierInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IdentifierInner createOrUpdateDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return (IdentifierInner)((Object)this.createOrUpdateDomainOwnershipIdentifierAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IdentifierInner> createOrUpdateDomainOwnershipIdentifierWithResponse(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier, Context context) {
        return (Response)this.createOrUpdateDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        return this.deleteDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName) {
        this.deleteDomainOwnershipIdentifierAsync(resourceGroupName, name, domainOwnershipIdentifierName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDomainOwnershipIdentifierWithResponse(String resourceGroupName, String name, String domainOwnershipIdentifierName, Context context) {
        return (Response)this.deleteDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<IdentifierInner>> updateDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (domainOwnershipIdentifier == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null."));
        }
        domainOwnershipIdentifier.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), domainOwnershipIdentifier, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<IdentifierInner>> updateDomainOwnershipIdentifierWithResponseAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (domainOwnershipIdentifierName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifierName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (domainOwnershipIdentifier == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter domainOwnershipIdentifier is required and cannot be null."));
        }
        domainOwnershipIdentifier.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDomainOwnershipIdentifier(this.client.getEndpoint(), resourceGroupName, name, domainOwnershipIdentifierName, this.client.getSubscriptionId(), this.client.getApiVersion(), domainOwnershipIdentifier, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<IdentifierInner> updateDomainOwnershipIdentifierAsync(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return this.updateDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((IdentifierInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public IdentifierInner updateDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier) {
        return (IdentifierInner)((Object)this.updateDomainOwnershipIdentifierAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<IdentifierInner> updateDomainOwnershipIdentifierWithResponse(String resourceGroupName, String name, String domainOwnershipIdentifierName, IdentifierInner domainOwnershipIdentifier, Context context) {
        return (Response)this.updateDomainOwnershipIdentifierWithResponseAsync(resourceGroupName, name, domainOwnershipIdentifierName, domainOwnershipIdentifier, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MSDeployStatusInner>> getMSDeployStatusWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMSDeployStatus(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MSDeployStatusInner>> getMSDeployStatusWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMSDeployStatus(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MSDeployStatusInner> getMSDeployStatusAsync(String resourceGroupName, String name) {
        return this.getMSDeployStatusWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MSDeployStatusInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployStatusInner getMSDeployStatus(String resourceGroupName, String name) {
        return (MSDeployStatusInner)((Object)this.getMSDeployStatusAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MSDeployStatusInner> getMSDeployStatusWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getMSDeployStatusWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createMSDeployOperationWithResponseAsync(String resourceGroupName, String name, MSDeploy mSDeploy) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (mSDeploy == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mSDeploy is required and cannot be null."));
        }
        mSDeploy.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createMSDeployOperation(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), mSDeploy, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createMSDeployOperationWithResponseAsync(String resourceGroupName, String name, MSDeploy mSDeploy, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (mSDeploy == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mSDeploy is required and cannot be null."));
        }
        mSDeploy.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createMSDeployOperation(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), mSDeploy, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createMSDeployOperationWithResponseAsync(resourceGroupName, name, mSDeploy);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MSDeployStatusInner.class), (Type)((Object)MSDeployStatusInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createMSDeployOperationWithResponseAsync(resourceGroupName, name, mSDeploy, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MSDeployStatusInner.class), (Type)((Object)MSDeployStatusInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperation(String resourceGroupName, String name, MSDeploy mSDeploy) {
        return this.beginCreateMSDeployOperationAsync(resourceGroupName, name, mSDeploy).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperation(String resourceGroupName, String name, MSDeploy mSDeploy, Context context) {
        return this.beginCreateMSDeployOperationAsync(resourceGroupName, name, mSDeploy, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MSDeployStatusInner> createMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy) {
        return this.beginCreateMSDeployOperationAsync(resourceGroupName, name, mSDeploy).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MSDeployStatusInner> createMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy, Context context) {
        return this.beginCreateMSDeployOperationAsync(resourceGroupName, name, mSDeploy, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployStatusInner createMSDeployOperation(String resourceGroupName, String name, MSDeploy mSDeploy) {
        return (MSDeployStatusInner)((Object)this.createMSDeployOperationAsync(resourceGroupName, name, mSDeploy).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployStatusInner createMSDeployOperation(String resourceGroupName, String name, MSDeploy mSDeploy, Context context) {
        return (MSDeployStatusInner)((Object)this.createMSDeployOperationAsync(resourceGroupName, name, mSDeploy, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MSDeployLogInner>> getMSDeployLogWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMSDeployLog(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MSDeployLogInner>> getMSDeployLogWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMSDeployLog(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MSDeployLogInner> getMSDeployLogAsync(String resourceGroupName, String name) {
        return this.getMSDeployLogWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MSDeployLogInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployLogInner getMSDeployLog(String resourceGroupName, String name) {
        return (MSDeployLogInner)((Object)this.getMSDeployLogAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MSDeployLogInner> getMSDeployLogWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getMSDeployLogWithResponseAsync(resourceGroupName, name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionEnvelopeInner>> listFunctionsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionEnvelopeCollection)res.getValue()).value(), ((FunctionEnvelopeCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FunctionEnvelopeInner>> listFunctionsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FunctionEnvelopeCollection)res.getValue()).value(), ((FunctionEnvelopeCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FunctionEnvelopeInner> listFunctionsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listFunctionsSinglePageAsync(resourceGroupName, name), nextLink -> this.listFunctionsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FunctionEnvelopeInner> listFunctionsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listFunctionsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listFunctionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FunctionEnvelopeInner> listFunctions(String resourceGroupName, String name) {
        return new PagedIterable(this.listFunctionsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FunctionEnvelopeInner> listFunctions(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listFunctionsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> getFunctionsAdminTokenWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFunctionsAdminToken(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<String>> getFunctionsAdminTokenWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFunctionsAdminToken(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getFunctionsAdminTokenAsync(String resourceGroupName, String name) {
        return this.getFunctionsAdminTokenWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((String)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getFunctionsAdminToken(String resourceGroupName, String name) {
        return (String)this.getFunctionsAdminTokenAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> getFunctionsAdminTokenWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getFunctionsAdminTokenWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FunctionEnvelopeInner>> getFunctionWithResponseAsync(String resourceGroupName, String name, String functionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFunction(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FunctionEnvelopeInner>> getFunctionWithResponseAsync(String resourceGroupName, String name, String functionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFunction(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FunctionEnvelopeInner> getFunctionAsync(String resourceGroupName, String name, String functionName) {
        return this.getFunctionWithResponseAsync(resourceGroupName, name, functionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((FunctionEnvelopeInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FunctionEnvelopeInner getFunction(String resourceGroupName, String name, String functionName) {
        return (FunctionEnvelopeInner)((Object)this.getFunctionAsync(resourceGroupName, name, functionName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FunctionEnvelopeInner> getFunctionWithResponse(String resourceGroupName, String name, String functionName, Context context) {
        return (Response)this.getFunctionWithResponseAsync(resourceGroupName, name, functionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createFunctionWithResponseAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (functionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionEnvelope is required and cannot be null."));
        }
        functionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createFunction(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), functionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createFunctionWithResponseAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (functionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionEnvelope is required and cannot be null."));
        }
        functionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createFunction(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), functionEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createFunctionWithResponseAsync(resourceGroupName, name, functionName, functionEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FunctionEnvelopeInner.class), (Type)((Object)FunctionEnvelopeInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createFunctionWithResponseAsync(resourceGroupName, name, functionName, functionEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)FunctionEnvelopeInner.class), (Type)((Object)FunctionEnvelopeInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateFunction(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        return this.beginCreateFunctionAsync(resourceGroupName, name, functionName, functionEnvelope).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateFunction(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope, Context context) {
        return this.beginCreateFunctionAsync(resourceGroupName, name, functionName, functionEnvelope, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FunctionEnvelopeInner> createFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        return this.beginCreateFunctionAsync(resourceGroupName, name, functionName, functionEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<FunctionEnvelopeInner> createFunctionAsync(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope, Context context) {
        return this.beginCreateFunctionAsync(resourceGroupName, name, functionName, functionEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FunctionEnvelopeInner createFunction(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope) {
        return (FunctionEnvelopeInner)((Object)this.createFunctionAsync(resourceGroupName, name, functionName, functionEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FunctionEnvelopeInner createFunction(String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope, Context context) {
        return (FunctionEnvelopeInner)((Object)this.createFunctionAsync(resourceGroupName, name, functionName, functionEnvelope, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFunctionWithResponseAsync(String resourceGroupName, String name, String functionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteFunction(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteFunctionWithResponseAsync(String resourceGroupName, String name, String functionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteFunction(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFunctionAsync(String resourceGroupName, String name, String functionName) {
        return this.deleteFunctionWithResponseAsync(resourceGroupName, name, functionName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFunction(String resourceGroupName, String name, String functionName) {
        this.deleteFunctionAsync(resourceGroupName, name, functionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFunctionWithResponse(String resourceGroupName, String name, String functionName, Context context) {
        return (Response)this.deleteFunctionWithResponseAsync(resourceGroupName, name, functionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyInfoInner>> createOrUpdateFunctionSecretWithResponseAsync(String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (key == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter key is required and cannot be null."));
        }
        key.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateFunctionSecret(this.client.getEndpoint(), resourceGroupName, name, functionName, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), key, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KeyInfoInner>> createOrUpdateFunctionSecretWithResponseAsync(String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (key == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter key is required and cannot be null."));
        }
        key.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateFunctionSecret(this.client.getEndpoint(), resourceGroupName, name, functionName, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), key, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyInfoInner> createOrUpdateFunctionSecretAsync(String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key) {
        return this.createOrUpdateFunctionSecretWithResponseAsync(resourceGroupName, name, functionName, keyName, key).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((KeyInfoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyInfoInner createOrUpdateFunctionSecret(String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key) {
        return (KeyInfoInner)this.createOrUpdateFunctionSecretAsync(resourceGroupName, name, functionName, keyName, key).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyInfoInner> createOrUpdateFunctionSecretWithResponse(String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key, Context context) {
        return (Response)this.createOrUpdateFunctionSecretWithResponseAsync(resourceGroupName, name, functionName, keyName, key, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteFunctionSecretWithResponseAsync(String resourceGroupName, String name, String functionName, String keyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteFunctionSecret(this.client.getEndpoint(), resourceGroupName, name, functionName, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteFunctionSecretWithResponseAsync(String resourceGroupName, String name, String functionName, String keyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteFunctionSecret(this.client.getEndpoint(), resourceGroupName, name, functionName, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteFunctionSecretAsync(String resourceGroupName, String name, String functionName, String keyName) {
        return this.deleteFunctionSecretWithResponseAsync(resourceGroupName, name, functionName, keyName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteFunctionSecret(String resourceGroupName, String name, String functionName, String keyName) {
        this.deleteFunctionSecretAsync(resourceGroupName, name, functionName, keyName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteFunctionSecretWithResponse(String resourceGroupName, String name, String functionName, String keyName, Context context) {
        return (Response)this.deleteFunctionSecretWithResponseAsync(resourceGroupName, name, functionName, keyName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listFunctionKeysWithResponseAsync(String resourceGroupName, String name, String functionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFunctionKeys(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listFunctionKeysWithResponseAsync(String resourceGroupName, String name, String functionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listFunctionKeys(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listFunctionKeysAsync(String resourceGroupName, String name, String functionName) {
        return this.listFunctionKeysWithResponseAsync(resourceGroupName, name, functionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner listFunctionKeys(String resourceGroupName, String name, String functionName) {
        return (StringDictionaryInner)((Object)this.listFunctionKeysAsync(resourceGroupName, name, functionName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> listFunctionKeysWithResponse(String resourceGroupName, String name, String functionName, Context context) {
        return (Response)this.listFunctionKeysWithResponseAsync(resourceGroupName, name, functionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FunctionSecretsInner>> listFunctionSecretsWithResponseAsync(String resourceGroupName, String name, String functionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listFunctionSecrets(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FunctionSecretsInner>> listFunctionSecretsWithResponseAsync(String resourceGroupName, String name, String functionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (functionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter functionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listFunctionSecrets(this.client.getEndpoint(), resourceGroupName, name, functionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FunctionSecretsInner> listFunctionSecretsAsync(String resourceGroupName, String name, String functionName) {
        return this.listFunctionSecretsWithResponseAsync(resourceGroupName, name, functionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((FunctionSecretsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FunctionSecretsInner listFunctionSecrets(String resourceGroupName, String name, String functionName) {
        return (FunctionSecretsInner)this.listFunctionSecretsAsync(resourceGroupName, name, functionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FunctionSecretsInner> listFunctionSecretsWithResponse(String resourceGroupName, String name, String functionName, Context context) {
        return (Response)this.listFunctionSecretsWithResponseAsync(resourceGroupName, name, functionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HostKeysInner>> listHostKeysWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHostKeys(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HostKeysInner>> listHostKeysWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listHostKeys(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HostKeysInner> listHostKeysAsync(String resourceGroupName, String name) {
        return this.listHostKeysWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((HostKeysInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HostKeysInner listHostKeys(String resourceGroupName, String name) {
        return (HostKeysInner)this.listHostKeysAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HostKeysInner> listHostKeysWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listHostKeysWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> listSyncStatusWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSyncStatus(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> listSyncStatusWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSyncStatus(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> listSyncStatusAsync(String resourceGroupName, String name) {
        return this.listSyncStatusWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void listSyncStatus(String resourceGroupName, String name) {
        this.listSyncStatusAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> listSyncStatusWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listSyncStatusWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> syncFunctionsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.syncFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> syncFunctionsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.syncFunctions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> syncFunctionsAsync(String resourceGroupName, String name) {
        return this.syncFunctionsWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void syncFunctions(String resourceGroupName, String name) {
        this.syncFunctionsAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> syncFunctionsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.syncFunctionsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<KeyInfoInner>> createOrUpdateHostSecretWithResponseAsync(String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyType is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (key == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter key is required and cannot be null."));
        }
        key.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateHostSecret(this.client.getEndpoint(), resourceGroupName, name, keyType, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), key, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<KeyInfoInner>> createOrUpdateHostSecretWithResponseAsync(String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyType is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (key == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter key is required and cannot be null."));
        }
        key.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateHostSecret(this.client.getEndpoint(), resourceGroupName, name, keyType, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), key, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<KeyInfoInner> createOrUpdateHostSecretAsync(String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key) {
        return this.createOrUpdateHostSecretWithResponseAsync(resourceGroupName, name, keyType, keyName, key).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((KeyInfoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public KeyInfoInner createOrUpdateHostSecret(String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key) {
        return (KeyInfoInner)this.createOrUpdateHostSecretAsync(resourceGroupName, name, keyType, keyName, key).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<KeyInfoInner> createOrUpdateHostSecretWithResponse(String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key, Context context) {
        return (Response)this.createOrUpdateHostSecretWithResponseAsync(resourceGroupName, name, keyType, keyName, key, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHostSecretWithResponseAsync(String resourceGroupName, String name, String keyType, String keyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyType is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteHostSecret(this.client.getEndpoint(), resourceGroupName, name, keyType, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteHostSecretWithResponseAsync(String resourceGroupName, String name, String keyType, String keyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (keyType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyType is required and cannot be null."));
        }
        if (keyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter keyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteHostSecret(this.client.getEndpoint(), resourceGroupName, name, keyType, keyName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteHostSecretAsync(String resourceGroupName, String name, String keyType, String keyName) {
        return this.deleteHostSecretWithResponseAsync(resourceGroupName, name, keyType, keyName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteHostSecret(String resourceGroupName, String name, String keyType, String keyName) {
        this.deleteHostSecretAsync(resourceGroupName, name, keyType, keyName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteHostSecretWithResponse(String resourceGroupName, String name, String keyType, String keyName, Context context) {
        return (Response)this.deleteHostSecretWithResponseAsync(resourceGroupName, name, keyType, keyName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HostnameBindingInner>> listHostnameBindingsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHostnameBindings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HostnameBindingCollection)res.getValue()).value(), ((HostnameBindingCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<HostnameBindingInner>> listHostnameBindingsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listHostnameBindings(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((HostnameBindingCollection)res.getValue()).value(), ((HostnameBindingCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<HostnameBindingInner> listHostnameBindingsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listHostnameBindingsSinglePageAsync(resourceGroupName, name), nextLink -> this.listHostnameBindingsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<HostnameBindingInner> listHostnameBindingsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listHostnameBindingsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listHostnameBindingsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HostnameBindingInner> listHostnameBindings(String resourceGroupName, String name) {
        return new PagedIterable(this.listHostnameBindingsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<HostnameBindingInner> listHostnameBindings(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listHostnameBindingsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HostnameBindingInner>> getHostnameBindingWithResponseAsync(String resourceGroupName, String name, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getHostnameBinding(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HostnameBindingInner>> getHostnameBindingWithResponseAsync(String resourceGroupName, String name, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getHostnameBinding(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HostnameBindingInner> getHostnameBindingAsync(String resourceGroupName, String name, String hostname) {
        return this.getHostnameBindingWithResponseAsync(resourceGroupName, name, hostname).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((HostnameBindingInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HostnameBindingInner getHostnameBinding(String resourceGroupName, String name, String hostname) {
        return (HostnameBindingInner)((Object)this.getHostnameBindingAsync(resourceGroupName, name, hostname).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HostnameBindingInner> getHostnameBindingWithResponse(String resourceGroupName, String name, String hostname, Context context) {
        return (Response)this.getHostnameBindingWithResponseAsync(resourceGroupName, name, hostname, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HostnameBindingInner>> createOrUpdateHostnameBindingWithResponseAsync(String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostnameBinding == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostnameBinding is required and cannot be null."));
        }
        hostnameBinding.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateHostnameBinding(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), hostnameBinding, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HostnameBindingInner>> createOrUpdateHostnameBindingWithResponseAsync(String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostnameBinding == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostnameBinding is required and cannot be null."));
        }
        hostnameBinding.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateHostnameBinding(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), hostnameBinding, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HostnameBindingInner> createOrUpdateHostnameBindingAsync(String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding) {
        return this.createOrUpdateHostnameBindingWithResponseAsync(resourceGroupName, name, hostname, hostnameBinding).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((HostnameBindingInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HostnameBindingInner createOrUpdateHostnameBinding(String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding) {
        return (HostnameBindingInner)((Object)this.createOrUpdateHostnameBindingAsync(resourceGroupName, name, hostname, hostnameBinding).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HostnameBindingInner> createOrUpdateHostnameBindingWithResponse(String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding, Context context) {
        return (Response)this.createOrUpdateHostnameBindingWithResponseAsync(resourceGroupName, name, hostname, hostnameBinding, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHostnameBindingWithResponseAsync(String resourceGroupName, String name, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteHostnameBinding(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteHostnameBindingWithResponseAsync(String resourceGroupName, String name, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteHostnameBinding(this.client.getEndpoint(), resourceGroupName, name, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteHostnameBindingAsync(String resourceGroupName, String name, String hostname) {
        return this.deleteHostnameBindingWithResponseAsync(resourceGroupName, name, hostname).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteHostnameBinding(String resourceGroupName, String name, String hostname) {
        this.deleteHostnameBindingAsync(resourceGroupName, name, hostname).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteHostnameBindingWithResponse(String resourceGroupName, String name, String hostname, Context context) {
        return (Response)this.deleteHostnameBindingWithResponseAsync(resourceGroupName, name, hostname, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HybridConnectionInner>> getHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridConnectionInner>> getHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HybridConnectionInner> getHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        return this.getHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((HybridConnectionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HybridConnectionInner getHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName) {
        return (HybridConnectionInner)((Object)this.getHybridConnectionAsync(resourceGroupName, name, namespaceName, relayName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HybridConnectionInner> getHybridConnectionWithResponse(String resourceGroupName, String name, String namespaceName, String relayName, Context context) {
        return (Response)this.getHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HybridConnectionInner>> createOrUpdateHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridConnectionInner>> createOrUpdateHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HybridConnectionInner> createOrUpdateHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return this.createOrUpdateHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((HybridConnectionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HybridConnectionInner createOrUpdateHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return (HybridConnectionInner)((Object)this.createOrUpdateHybridConnectionAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HybridConnectionInner> createOrUpdateHybridConnectionWithResponse(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope, Context context) {
        return (Response)this.createOrUpdateHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName) {
        return this.deleteHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName) {
        this.deleteHybridConnectionAsync(resourceGroupName, name, namespaceName, relayName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteHybridConnectionWithResponse(String resourceGroupName, String name, String namespaceName, String relayName, Context context) {
        return (Response)this.deleteHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HybridConnectionInner>> updateHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridConnectionInner>> updateHybridConnectionWithResponseAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (namespaceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter namespaceName is required and cannot be null."));
        }
        if (relayName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter relayName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateHybridConnection(this.client.getEndpoint(), resourceGroupName, name, namespaceName, relayName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HybridConnectionInner> updateHybridConnectionAsync(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return this.updateHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((HybridConnectionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HybridConnectionInner updateHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope) {
        return (HybridConnectionInner)((Object)this.updateHybridConnectionAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HybridConnectionInner> updateHybridConnectionWithResponse(String resourceGroupName, String name, String namespaceName, String relayName, HybridConnectionInner connectionEnvelope, Context context) {
        return (Response)this.updateHybridConnectionWithResponseAsync(resourceGroupName, name, namespaceName, relayName, connectionEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<HybridConnectionInner>> listHybridConnectionsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listHybridConnections(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<HybridConnectionInner>> listHybridConnectionsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listHybridConnections(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<HybridConnectionInner> listHybridConnectionsAsync(String resourceGroupName, String name) {
        return this.listHybridConnectionsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((HybridConnectionInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public HybridConnectionInner listHybridConnections(String resourceGroupName, String name) {
        return (HybridConnectionInner)((Object)this.listHybridConnectionsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<HybridConnectionInner> listHybridConnectionsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listHybridConnectionsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RelayServiceConnectionEntityInner>> listRelayServiceConnectionsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listRelayServiceConnections(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RelayServiceConnectionEntityInner>> listRelayServiceConnectionsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listRelayServiceConnections(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RelayServiceConnectionEntityInner> listRelayServiceConnectionsAsync(String resourceGroupName, String name) {
        return this.listRelayServiceConnectionsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RelayServiceConnectionEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RelayServiceConnectionEntityInner listRelayServiceConnections(String resourceGroupName, String name) {
        return (RelayServiceConnectionEntityInner)((Object)this.listRelayServiceConnectionsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RelayServiceConnectionEntityInner> listRelayServiceConnectionsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listRelayServiceConnectionsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RelayServiceConnectionEntityInner>> getRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RelayServiceConnectionEntityInner>> getRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RelayServiceConnectionEntityInner> getRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName) {
        return this.getRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RelayServiceConnectionEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RelayServiceConnectionEntityInner getRelayServiceConnection(String resourceGroupName, String name, String entityName) {
        return (RelayServiceConnectionEntityInner)((Object)this.getRelayServiceConnectionAsync(resourceGroupName, name, entityName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RelayServiceConnectionEntityInner> getRelayServiceConnectionWithResponse(String resourceGroupName, String name, String entityName, Context context) {
        return (Response)this.getRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RelayServiceConnectionEntityInner>> createOrUpdateRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RelayServiceConnectionEntityInner>> createOrUpdateRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RelayServiceConnectionEntityInner> createOrUpdateRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return this.createOrUpdateRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName, connectionEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RelayServiceConnectionEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RelayServiceConnectionEntityInner createOrUpdateRelayServiceConnection(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return (RelayServiceConnectionEntityInner)((Object)this.createOrUpdateRelayServiceConnectionAsync(resourceGroupName, name, entityName, connectionEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RelayServiceConnectionEntityInner> createOrUpdateRelayServiceConnectionWithResponse(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope, Context context) {
        return (Response)this.createOrUpdateRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName, connectionEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName) {
        return this.deleteRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteRelayServiceConnection(String resourceGroupName, String name, String entityName) {
        this.deleteRelayServiceConnectionAsync(resourceGroupName, name, entityName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteRelayServiceConnectionWithResponse(String resourceGroupName, String name, String entityName, Context context) {
        return (Response)this.deleteRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RelayServiceConnectionEntityInner>> updateRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RelayServiceConnectionEntityInner>> updateRelayServiceConnectionWithResponseAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (entityName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter entityName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateRelayServiceConnection(this.client.getEndpoint(), resourceGroupName, name, entityName, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RelayServiceConnectionEntityInner> updateRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return this.updateRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName, connectionEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RelayServiceConnectionEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RelayServiceConnectionEntityInner updateRelayServiceConnection(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope) {
        return (RelayServiceConnectionEntityInner)((Object)this.updateRelayServiceConnectionAsync(resourceGroupName, name, entityName, connectionEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RelayServiceConnectionEntityInner> updateRelayServiceConnectionWithResponse(String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope, Context context) {
        return (Response)this.updateRelayServiceConnectionWithResponseAsync(resourceGroupName, name, entityName, connectionEnvelope, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebSiteInstanceStatusInner>> listInstanceIdentifiersSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listInstanceIdentifiers(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppInstanceStatusCollection)res.getValue()).value(), ((WebAppInstanceStatusCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<WebSiteInstanceStatusInner>> listInstanceIdentifiersSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listInstanceIdentifiers(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppInstanceStatusCollection)res.getValue()).value(), ((WebAppInstanceStatusCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<WebSiteInstanceStatusInner> listInstanceIdentifiersAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listInstanceIdentifiersSinglePageAsync(resourceGroupName, name), nextLink -> this.listInstanceIdentifiersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<WebSiteInstanceStatusInner> listInstanceIdentifiersAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listInstanceIdentifiersSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listInstanceIdentifiersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebSiteInstanceStatusInner> listInstanceIdentifiers(String resourceGroupName, String name) {
        return new PagedIterable(this.listInstanceIdentifiersAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<WebSiteInstanceStatusInner> listInstanceIdentifiers(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listInstanceIdentifiersAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<WebSiteInstanceStatusInner>> getInstanceInfoWithResponseAsync(String resourceGroupName, String name, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceInfo(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<WebSiteInstanceStatusInner>> getInstanceInfoWithResponseAsync(String resourceGroupName, String name, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceInfo(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<WebSiteInstanceStatusInner> getInstanceInfoAsync(String resourceGroupName, String name, String instanceId) {
        return this.getInstanceInfoWithResponseAsync(resourceGroupName, name, instanceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((WebSiteInstanceStatusInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public WebSiteInstanceStatusInner getInstanceInfo(String resourceGroupName, String name, String instanceId) {
        return (WebSiteInstanceStatusInner)((Object)this.getInstanceInfoAsync(resourceGroupName, name, instanceId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<WebSiteInstanceStatusInner> getInstanceInfoWithResponse(String resourceGroupName, String name, String instanceId, Context context) {
        return (Response)this.getInstanceInfoWithResponseAsync(resourceGroupName, name, instanceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MSDeployStatusInner>> getInstanceMsDeployStatusWithResponseAsync(String resourceGroupName, String name, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceMsDeployStatus(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MSDeployStatusInner>> getInstanceMsDeployStatusWithResponseAsync(String resourceGroupName, String name, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceMsDeployStatus(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MSDeployStatusInner> getInstanceMsDeployStatusAsync(String resourceGroupName, String name, String instanceId) {
        return this.getInstanceMsDeployStatusWithResponseAsync(resourceGroupName, name, instanceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MSDeployStatusInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployStatusInner getInstanceMsDeployStatus(String resourceGroupName, String name, String instanceId) {
        return (MSDeployStatusInner)((Object)this.getInstanceMsDeployStatusAsync(resourceGroupName, name, instanceId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MSDeployStatusInner> getInstanceMsDeployStatusWithResponse(String resourceGroupName, String name, String instanceId, Context context) {
        return (Response)this.getInstanceMsDeployStatusWithResponseAsync(resourceGroupName, name, instanceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createInstanceMSDeployOperationWithResponseAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (mSDeploy == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mSDeploy is required and cannot be null."));
        }
        mSDeploy.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createInstanceMSDeployOperation(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), mSDeploy, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createInstanceMSDeployOperationWithResponseAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (mSDeploy == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter mSDeploy is required and cannot be null."));
        }
        mSDeploy.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createInstanceMSDeployOperation(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), mSDeploy, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createInstanceMSDeployOperationWithResponseAsync(resourceGroupName, name, instanceId, mSDeploy);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MSDeployStatusInner.class), (Type)((Object)MSDeployStatusInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createInstanceMSDeployOperationWithResponseAsync(resourceGroupName, name, instanceId, mSDeploy, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)MSDeployStatusInner.class), (Type)((Object)MSDeployStatusInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateInstanceMSDeployOperation(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        return this.beginCreateInstanceMSDeployOperationAsync(resourceGroupName, name, instanceId, mSDeploy).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateInstanceMSDeployOperation(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, Context context) {
        return this.beginCreateInstanceMSDeployOperationAsync(resourceGroupName, name, instanceId, mSDeploy, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MSDeployStatusInner> createInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        return this.beginCreateInstanceMSDeployOperationAsync(resourceGroupName, name, instanceId, mSDeploy).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<MSDeployStatusInner> createInstanceMSDeployOperationAsync(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, Context context) {
        return this.beginCreateInstanceMSDeployOperationAsync(resourceGroupName, name, instanceId, mSDeploy, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployStatusInner createInstanceMSDeployOperation(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy) {
        return (MSDeployStatusInner)((Object)this.createInstanceMSDeployOperationAsync(resourceGroupName, name, instanceId, mSDeploy).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployStatusInner createInstanceMSDeployOperation(String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, Context context) {
        return (MSDeployStatusInner)((Object)this.createInstanceMSDeployOperationAsync(resourceGroupName, name, instanceId, mSDeploy, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MSDeployLogInner>> getInstanceMSDeployLogWithResponseAsync(String resourceGroupName, String name, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceMSDeployLog(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MSDeployLogInner>> getInstanceMSDeployLogWithResponseAsync(String resourceGroupName, String name, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceMSDeployLog(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MSDeployLogInner> getInstanceMSDeployLogAsync(String resourceGroupName, String name, String instanceId) {
        return this.getInstanceMSDeployLogWithResponseAsync(resourceGroupName, name, instanceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MSDeployLogInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MSDeployLogInner getInstanceMSDeployLog(String resourceGroupName, String name, String instanceId) {
        return (MSDeployLogInner)((Object)this.getInstanceMSDeployLogAsync(resourceGroupName, name, instanceId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MSDeployLogInner> getInstanceMSDeployLogWithResponse(String resourceGroupName, String name, String instanceId, Context context) {
        return (Response)this.getInstanceMSDeployLogWithResponseAsync(resourceGroupName, name, instanceId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessInfoInner>> listInstanceProcessesSinglePageAsync(String resourceGroupName, String name, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listInstanceProcesses(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessInfoCollection)res.getValue()).value(), ((ProcessInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessInfoInner>> listInstanceProcessesSinglePageAsync(String resourceGroupName, String name, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listInstanceProcesses(this.client.getEndpoint(), resourceGroupName, name, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessInfoCollection)res.getValue()).value(), ((ProcessInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ProcessInfoInner> listInstanceProcessesAsync(String resourceGroupName, String name, String instanceId) {
        return new PagedFlux(() -> this.listInstanceProcessesSinglePageAsync(resourceGroupName, name, instanceId), nextLink -> this.listInstanceProcessesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProcessInfoInner> listInstanceProcessesAsync(String resourceGroupName, String name, String instanceId, Context context) {
        return new PagedFlux(() -> this.listInstanceProcessesSinglePageAsync(resourceGroupName, name, instanceId, context), nextLink -> this.listInstanceProcessesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessInfoInner> listInstanceProcesses(String resourceGroupName, String name, String instanceId) {
        return new PagedIterable(this.listInstanceProcessesAsync(resourceGroupName, name, instanceId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessInfoInner> listInstanceProcesses(String resourceGroupName, String name, String instanceId, Context context) {
        return new PagedIterable(this.listInstanceProcessesAsync(resourceGroupName, name, instanceId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ProcessInfoInner>> getInstanceProcessWithResponseAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceProcess(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProcessInfoInner>> getInstanceProcessWithResponseAsync(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceProcess(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ProcessInfoInner> getInstanceProcessAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return this.getInstanceProcessWithResponseAsync(resourceGroupName, name, processId, instanceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ProcessInfoInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProcessInfoInner getInstanceProcess(String resourceGroupName, String name, String processId, String instanceId) {
        return (ProcessInfoInner)((Object)this.getInstanceProcessAsync(resourceGroupName, name, processId, instanceId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProcessInfoInner> getInstanceProcessWithResponse(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        return (Response)this.getInstanceProcessWithResponseAsync(resourceGroupName, name, processId, instanceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteInstanceProcessWithResponseAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteInstanceProcess(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteInstanceProcessWithResponseAsync(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteInstanceProcess(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteInstanceProcessAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return this.deleteInstanceProcessWithResponseAsync(resourceGroupName, name, processId, instanceId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteInstanceProcess(String resourceGroupName, String name, String processId, String instanceId) {
        this.deleteInstanceProcessAsync(resourceGroupName, name, processId, instanceId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteInstanceProcessWithResponse(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        return (Response)this.deleteInstanceProcessWithResponseAsync(resourceGroupName, name, processId, instanceId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getInstanceProcessDumpWithResponseAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceProcessDump(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getInstanceProcessDumpWithResponseAsync(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceProcessDump(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getInstanceProcessDumpAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return this.getInstanceProcessDumpWithResponseAsync(resourceGroupName, name, processId, instanceId).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getInstanceProcessDump(String resourceGroupName, String name, String processId, String instanceId) {
        final Iterator iterator = this.getInstanceProcessDumpAsync(resourceGroupName, name, processId, instanceId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getInstanceProcessDumpWithResponse(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        return (StreamResponse)this.getInstanceProcessDumpWithResponseAsync(resourceGroupName, name, processId, instanceId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessModuleInfoInner>> listInstanceProcessModulesSinglePageAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listInstanceProcessModules(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessModuleInfoCollection)res.getValue()).value(), ((ProcessModuleInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessModuleInfoInner>> listInstanceProcessModulesSinglePageAsync(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listInstanceProcessModules(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessModuleInfoCollection)res.getValue()).value(), ((ProcessModuleInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ProcessModuleInfoInner> listInstanceProcessModulesAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return new PagedFlux(() -> this.listInstanceProcessModulesSinglePageAsync(resourceGroupName, name, processId, instanceId), nextLink -> this.listInstanceProcessModulesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProcessModuleInfoInner> listInstanceProcessModulesAsync(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        return new PagedFlux(() -> this.listInstanceProcessModulesSinglePageAsync(resourceGroupName, name, processId, instanceId, context), nextLink -> this.listInstanceProcessModulesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessModuleInfoInner> listInstanceProcessModules(String resourceGroupName, String name, String processId, String instanceId) {
        return new PagedIterable(this.listInstanceProcessModulesAsync(resourceGroupName, name, processId, instanceId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessModuleInfoInner> listInstanceProcessModules(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        return new PagedIterable(this.listInstanceProcessModulesAsync(resourceGroupName, name, processId, instanceId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ProcessModuleInfoInner>> getInstanceProcessModuleWithResponseAsync(String resourceGroupName, String name, String processId, String baseAddress, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (baseAddress == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baseAddress is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getInstanceProcessModule(this.client.getEndpoint(), resourceGroupName, name, processId, baseAddress, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProcessModuleInfoInner>> getInstanceProcessModuleWithResponseAsync(String resourceGroupName, String name, String processId, String baseAddress, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (baseAddress == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baseAddress is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getInstanceProcessModule(this.client.getEndpoint(), resourceGroupName, name, processId, baseAddress, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ProcessModuleInfoInner> getInstanceProcessModuleAsync(String resourceGroupName, String name, String processId, String baseAddress, String instanceId) {
        return this.getInstanceProcessModuleWithResponseAsync(resourceGroupName, name, processId, baseAddress, instanceId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ProcessModuleInfoInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProcessModuleInfoInner getInstanceProcessModule(String resourceGroupName, String name, String processId, String baseAddress, String instanceId) {
        return (ProcessModuleInfoInner)((Object)this.getInstanceProcessModuleAsync(resourceGroupName, name, processId, baseAddress, instanceId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProcessModuleInfoInner> getInstanceProcessModuleWithResponse(String resourceGroupName, String name, String processId, String baseAddress, String instanceId, Context context) {
        return (Response)this.getInstanceProcessModuleWithResponseAsync(resourceGroupName, name, processId, baseAddress, instanceId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessThreadInfoInner>> listInstanceProcessThreadsSinglePageAsync(String resourceGroupName, String name, String processId, String instanceId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listInstanceProcessThreads(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessThreadInfoCollection)res.getValue()).value(), ((ProcessThreadInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessThreadInfoInner>> listInstanceProcessThreadsSinglePageAsync(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listInstanceProcessThreads(this.client.getEndpoint(), resourceGroupName, name, processId, instanceId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessThreadInfoCollection)res.getValue()).value(), ((ProcessThreadInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ProcessThreadInfoInner> listInstanceProcessThreadsAsync(String resourceGroupName, String name, String processId, String instanceId) {
        return new PagedFlux(() -> this.listInstanceProcessThreadsSinglePageAsync(resourceGroupName, name, processId, instanceId), nextLink -> this.listInstanceProcessThreadsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProcessThreadInfoInner> listInstanceProcessThreadsAsync(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        return new PagedFlux(() -> this.listInstanceProcessThreadsSinglePageAsync(resourceGroupName, name, processId, instanceId, context), nextLink -> this.listInstanceProcessThreadsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessThreadInfoInner> listInstanceProcessThreads(String resourceGroupName, String name, String processId, String instanceId) {
        return new PagedIterable(this.listInstanceProcessThreadsAsync(resourceGroupName, name, processId, instanceId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessThreadInfoInner> listInstanceProcessThreads(String resourceGroupName, String name, String processId, String instanceId, Context context) {
        return new PagedIterable(this.listInstanceProcessThreadsAsync(resourceGroupName, name, processId, instanceId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteCloneabilityInner>> isCloneableWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.isCloneable(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteCloneabilityInner>> isCloneableWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.isCloneable(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteCloneabilityInner> isCloneableAsync(String resourceGroupName, String name) {
        return this.isCloneableWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SiteCloneabilityInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteCloneabilityInner isCloneable(String resourceGroupName, String name) {
        return (SiteCloneabilityInner)this.isCloneableAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteCloneabilityInner> isCloneableWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.isCloneableWithResponseAsync(resourceGroupName, name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listSiteBackupsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSiteBackups(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupItemCollection)res.getValue()).value(), ((BackupItemCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listSiteBackupsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSiteBackups(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupItemCollection)res.getValue()).value(), ((BackupItemCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BackupItemInner> listSiteBackupsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listSiteBackupsSinglePageAsync(resourceGroupName, name), nextLink -> this.listSiteBackupsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BackupItemInner> listSiteBackupsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listSiteBackupsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listSiteBackupsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listSiteBackups(String resourceGroupName, String name) {
        return new PagedIterable(this.listSiteBackupsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listSiteBackups(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listSiteBackupsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FunctionSecretsInner>> listSyncFunctionTriggersWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSyncFunctionTriggers(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FunctionSecretsInner>> listSyncFunctionTriggersWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSyncFunctionTriggers(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FunctionSecretsInner> listSyncFunctionTriggersAsync(String resourceGroupName, String name) {
        return this.listSyncFunctionTriggersWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((FunctionSecretsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FunctionSecretsInner listSyncFunctionTriggers(String resourceGroupName, String name) {
        return (FunctionSecretsInner)this.listSyncFunctionTriggersAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FunctionSecretsInner> listSyncFunctionTriggersWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listSyncFunctionTriggersWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateStorageWithResponseAsync(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (migrationOptions == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationOptions is required and cannot be null."));
        }
        migrationOptions.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.migrateStorage(this.client.getEndpoint(), subscriptionName, resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), migrationOptions, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateStorageWithResponseAsync(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (subscriptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter subscriptionName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (migrationOptions == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationOptions is required and cannot be null."));
        }
        migrationOptions.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.migrateStorage(this.client.getEndpoint(), subscriptionName, resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), migrationOptions, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StorageMigrationResponseInner>, StorageMigrationResponseInner> beginMigrateStorageAsync(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateStorageWithResponseAsync(subscriptionName, resourceGroupName, name, migrationOptions);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StorageMigrationResponseInner.class), (Type)((Object)StorageMigrationResponseInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<StorageMigrationResponseInner>, StorageMigrationResponseInner> beginMigrateStorageAsync(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateStorageWithResponseAsync(subscriptionName, resourceGroupName, name, migrationOptions, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)StorageMigrationResponseInner.class), (Type)((Object)StorageMigrationResponseInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageMigrationResponseInner>, StorageMigrationResponseInner> beginMigrateStorage(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions) {
        return this.beginMigrateStorageAsync(subscriptionName, resourceGroupName, name, migrationOptions).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageMigrationResponseInner>, StorageMigrationResponseInner> beginMigrateStorage(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions, Context context) {
        return this.beginMigrateStorageAsync(subscriptionName, resourceGroupName, name, migrationOptions, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageMigrationResponseInner> migrateStorageAsync(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions) {
        return this.beginMigrateStorageAsync(subscriptionName, resourceGroupName, name, migrationOptions).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StorageMigrationResponseInner> migrateStorageAsync(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions, Context context) {
        return this.beginMigrateStorageAsync(subscriptionName, resourceGroupName, name, migrationOptions, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageMigrationResponseInner migrateStorage(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions) {
        return (StorageMigrationResponseInner)((Object)this.migrateStorageAsync(subscriptionName, resourceGroupName, name, migrationOptions).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageMigrationResponseInner migrateStorage(String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions, Context context) {
        return (StorageMigrationResponseInner)((Object)this.migrateStorageAsync(subscriptionName, resourceGroupName, name, migrationOptions, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> migrateMySqlWithResponseAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (migrationRequestEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationRequestEnvelope is required and cannot be null."));
        }
        migrationRequestEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.migrateMySql(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), migrationRequestEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> migrateMySqlWithResponseAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (migrationRequestEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter migrationRequestEnvelope is required and cannot be null."));
        }
        migrationRequestEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.migrateMySql(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), migrationRequestEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<OperationInner>, OperationInner> beginMigrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateMySqlWithResponseAsync(resourceGroupName, name, migrationRequestEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OperationInner.class), (Type)((Object)OperationInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationInner>, OperationInner> beginMigrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.migrateMySqlWithResponseAsync(resourceGroupName, name, migrationRequestEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)OperationInner.class), (Type)((Object)OperationInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationInner>, OperationInner> beginMigrateMySql(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        return this.beginMigrateMySqlAsync(resourceGroupName, name, migrationRequestEnvelope).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationInner>, OperationInner> beginMigrateMySql(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, Context context) {
        return this.beginMigrateMySqlAsync(resourceGroupName, name, migrationRequestEnvelope, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OperationInner> migrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        return this.beginMigrateMySqlAsync(resourceGroupName, name, migrationRequestEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationInner> migrateMySqlAsync(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, Context context) {
        return this.beginMigrateMySqlAsync(resourceGroupName, name, migrationRequestEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationInner migrateMySql(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope) {
        return (OperationInner)this.migrateMySqlAsync(resourceGroupName, name, migrationRequestEnvelope).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationInner migrateMySql(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, Context context) {
        return (OperationInner)this.migrateMySqlAsync(resourceGroupName, name, migrationRequestEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<MigrateMySqlStatusInner>> getMigrateMySqlStatusWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getMigrateMySqlStatus(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<MigrateMySqlStatusInner>> getMigrateMySqlStatusWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getMigrateMySqlStatus(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<MigrateMySqlStatusInner> getMigrateMySqlStatusAsync(String resourceGroupName, String name) {
        return this.getMigrateMySqlStatusWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((MigrateMySqlStatusInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public MigrateMySqlStatusInner getMigrateMySqlStatus(String resourceGroupName, String name) {
        return (MigrateMySqlStatusInner)((Object)this.getMigrateMySqlStatusAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<MigrateMySqlStatusInner> getMigrateMySqlStatusWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getMigrateMySqlStatusWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SwiftVirtualNetworkInner>> getSwiftVirtualNetworkConnectionWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSwiftVirtualNetworkConnection(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SwiftVirtualNetworkInner>> getSwiftVirtualNetworkConnectionWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSwiftVirtualNetworkConnection(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SwiftVirtualNetworkInner> getSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name) {
        return this.getSwiftVirtualNetworkConnectionWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SwiftVirtualNetworkInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SwiftVirtualNetworkInner getSwiftVirtualNetworkConnection(String resourceGroupName, String name) {
        return (SwiftVirtualNetworkInner)((Object)this.getSwiftVirtualNetworkConnectionAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SwiftVirtualNetworkInner> getSwiftVirtualNetworkConnectionWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getSwiftVirtualNetworkConnectionWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SwiftVirtualNetworkInner>> createOrUpdateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateSwiftVirtualNetworkConnectionWithCheck(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SwiftVirtualNetworkInner>> createOrUpdateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateSwiftVirtualNetworkConnectionWithCheck(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SwiftVirtualNetworkInner> createOrUpdateSwiftVirtualNetworkConnectionWithCheckAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return this.createOrUpdateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(resourceGroupName, name, connectionEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SwiftVirtualNetworkInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SwiftVirtualNetworkInner createOrUpdateSwiftVirtualNetworkConnectionWithCheck(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return (SwiftVirtualNetworkInner)((Object)this.createOrUpdateSwiftVirtualNetworkConnectionWithCheckAsync(resourceGroupName, name, connectionEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SwiftVirtualNetworkInner> createOrUpdateSwiftVirtualNetworkConnectionWithCheckWithResponse(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, Context context) {
        return (Response)this.createOrUpdateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(resourceGroupName, name, connectionEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSwiftVirtualNetworkWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSwiftVirtualNetwork(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteSwiftVirtualNetworkWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteSwiftVirtualNetwork(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSwiftVirtualNetworkAsync(String resourceGroupName, String name) {
        return this.deleteSwiftVirtualNetworkWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSwiftVirtualNetwork(String resourceGroupName, String name) {
        this.deleteSwiftVirtualNetworkAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSwiftVirtualNetworkWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.deleteSwiftVirtualNetworkWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SwiftVirtualNetworkInner>> updateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSwiftVirtualNetworkConnectionWithCheck(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SwiftVirtualNetworkInner>> updateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionEnvelope is required and cannot be null."));
        }
        connectionEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSwiftVirtualNetworkConnectionWithCheck(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SwiftVirtualNetworkInner> updateSwiftVirtualNetworkConnectionWithCheckAsync(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return this.updateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(resourceGroupName, name, connectionEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SwiftVirtualNetworkInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SwiftVirtualNetworkInner updateSwiftVirtualNetworkConnectionWithCheck(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope) {
        return (SwiftVirtualNetworkInner)((Object)this.updateSwiftVirtualNetworkConnectionWithCheckAsync(resourceGroupName, name, connectionEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SwiftVirtualNetworkInner> updateSwiftVirtualNetworkConnectionWithCheckWithResponse(String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, Context context) {
        return (Response)this.updateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(resourceGroupName, name, connectionEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NetworkFeaturesInner>> listNetworkFeaturesWithResponseAsync(String resourceGroupName, String name, String view) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (view == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter view is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNetworkFeatures(this.client.getEndpoint(), resourceGroupName, name, view, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NetworkFeaturesInner>> listNetworkFeaturesWithResponseAsync(String resourceGroupName, String name, String view, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (view == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter view is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNetworkFeatures(this.client.getEndpoint(), resourceGroupName, name, view, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NetworkFeaturesInner> listNetworkFeaturesAsync(String resourceGroupName, String name, String view) {
        return this.listNetworkFeaturesWithResponseAsync(resourceGroupName, name, view).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((NetworkFeaturesInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NetworkFeaturesInner listNetworkFeatures(String resourceGroupName, String name, String view) {
        return (NetworkFeaturesInner)((Object)this.listNetworkFeaturesAsync(resourceGroupName, name, view).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NetworkFeaturesInner> listNetworkFeaturesWithResponse(String resourceGroupName, String name, String view, Context context) {
        return (Response)this.listNetworkFeaturesWithResponseAsync(resourceGroupName, name, view, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getNetworkTraceOperationWithResponseAsync(String resourceGroupName, String name, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNetworkTraceOperation(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Object>> getNetworkTraceOperationWithResponseAsync(String resourceGroupName, String name, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getNetworkTraceOperation(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> getNetworkTraceOperationAsync(String resourceGroupName, String name, String operationId) {
        return this.getNetworkTraceOperationWithResponseAsync(resourceGroupName, name, operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object getNetworkTraceOperation(String resourceGroupName, String name, String operationId) {
        return this.getNetworkTraceOperationAsync(resourceGroupName, name, operationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> getNetworkTraceOperationWithResponse(String resourceGroupName, String name, String operationId, Context context) {
        return (Response)this.getNetworkTraceOperationWithResponseAsync(resourceGroupName, name, operationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<String>> startWebSiteNetworkTraceWithResponseAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startWebSiteNetworkTrace(this.client.getEndpoint(), resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<String>> startWebSiteNetworkTraceWithResponseAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.startWebSiteNetworkTrace(this.client.getEndpoint(), resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> startWebSiteNetworkTraceAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl) {
        return this.startWebSiteNetworkTraceWithResponseAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((String)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> startWebSiteNetworkTraceAsync(String resourceGroupName, String name) {
        Integer durationInSeconds = null;
        Integer maxFrameLength = null;
        String sasUrl = null;
        return this.startWebSiteNetworkTraceWithResponseAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((String)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public String startWebSiteNetworkTrace(String resourceGroupName, String name) {
        Integer durationInSeconds = null;
        Integer maxFrameLength = null;
        String sasUrl = null;
        return (String)this.startWebSiteNetworkTraceAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<String> startWebSiteNetworkTraceWithResponse(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl, Context context) {
        return (Response)this.startWebSiteNetworkTraceWithResponseAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWebSiteNetworkTraceOperationWithResponseAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.startWebSiteNetworkTraceOperation(this.client.getEndpoint(), resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWebSiteNetworkTraceOperationWithResponseAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.startWebSiteNetworkTraceOperation(this.client.getEndpoint(), resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Object>, Object> beginStartWebSiteNetworkTraceOperationAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWebSiteNetworkTraceOperationWithResponseAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Object.class), (Type)((Object)Object.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Object>, Object> beginStartWebSiteNetworkTraceOperationAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.startWebSiteNetworkTraceOperationWithResponseAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Object.class), (Type)((Object)Object.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Object>, Object> beginStartWebSiteNetworkTraceOperation(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl) {
        return this.beginStartWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Object>, Object> beginStartWebSiteNetworkTraceOperation(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl, Context context) {
        return this.beginStartWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> startWebSiteNetworkTraceOperationAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl) {
        return this.beginStartWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> startWebSiteNetworkTraceOperationAsync(String resourceGroupName, String name) {
        Integer durationInSeconds = null;
        Integer maxFrameLength = null;
        String sasUrl = null;
        return this.beginStartWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Object> startWebSiteNetworkTraceOperationAsync(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl, Context context) {
        return this.beginStartWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object startWebSiteNetworkTraceOperation(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl) {
        return this.startWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object startWebSiteNetworkTraceOperation(String resourceGroupName, String name) {
        Integer durationInSeconds = null;
        Integer maxFrameLength = null;
        String sasUrl = null;
        return this.startWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object startWebSiteNetworkTraceOperation(String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl, Context context) {
        return this.startWebSiteNetworkTraceOperationAsync(resourceGroupName, name, durationInSeconds, maxFrameLength, sasUrl, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopWebSiteNetworkTraceWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stopWebSiteNetworkTrace(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> stopWebSiteNetworkTraceWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.stopWebSiteNetworkTrace(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopWebSiteNetworkTraceAsync(String resourceGroupName, String name) {
        return this.stopWebSiteNetworkTraceWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopWebSiteNetworkTrace(String resourceGroupName, String name) {
        this.stopWebSiteNetworkTraceAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopWebSiteNetworkTraceWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.stopWebSiteNetworkTraceWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<NetworkTraceInner>>> getNetworkTracesWithResponseAsync(String resourceGroupName, String name, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNetworkTraces(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<NetworkTraceInner>>> getNetworkTracesWithResponseAsync(String resourceGroupName, String name, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getNetworkTraces(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<NetworkTraceInner>> getNetworkTracesAsync(String resourceGroupName, String name, String operationId) {
        return this.getNetworkTracesWithResponseAsync(resourceGroupName, name, operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<NetworkTraceInner> getNetworkTraces(String resourceGroupName, String name, String operationId) {
        return (List)this.getNetworkTracesAsync(resourceGroupName, name, operationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<NetworkTraceInner>> getNetworkTracesWithResponse(String resourceGroupName, String name, String operationId, Context context) {
        return (Response)this.getNetworkTracesWithResponseAsync(resourceGroupName, name, operationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getNetworkTraceOperationV2WithResponseAsync(String resourceGroupName, String name, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNetworkTraceOperationV2(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Object>> getNetworkTraceOperationV2WithResponseAsync(String resourceGroupName, String name, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getNetworkTraceOperationV2(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> getNetworkTraceOperationV2Async(String resourceGroupName, String name, String operationId) {
        return this.getNetworkTraceOperationV2WithResponseAsync(resourceGroupName, name, operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object getNetworkTraceOperationV2(String resourceGroupName, String name, String operationId) {
        return this.getNetworkTraceOperationV2Async(resourceGroupName, name, operationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Object> getNetworkTraceOperationV2WithResponse(String resourceGroupName, String name, String operationId, Context context) {
        return (Response)this.getNetworkTraceOperationV2WithResponseAsync(resourceGroupName, name, operationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<List<NetworkTraceInner>>> getNetworkTracesV2WithResponseAsync(String resourceGroupName, String name, String operationId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNetworkTracesV2(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<List<NetworkTraceInner>>> getNetworkTracesV2WithResponseAsync(String resourceGroupName, String name, String operationId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (operationId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter operationId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getNetworkTracesV2(this.client.getEndpoint(), resourceGroupName, name, operationId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<NetworkTraceInner>> getNetworkTracesV2Async(String resourceGroupName, String name, String operationId) {
        return this.getNetworkTracesV2WithResponseAsync(resourceGroupName, name, operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((List)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<NetworkTraceInner> getNetworkTracesV2(String resourceGroupName, String name, String operationId) {
        return (List)this.getNetworkTracesV2Async(resourceGroupName, name, operationId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<List<NetworkTraceInner>> getNetworkTracesV2WithResponse(String resourceGroupName, String name, String operationId, Context context) {
        return (Response)this.getNetworkTracesV2WithResponseAsync(resourceGroupName, name, operationId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> generateNewSitePublishingPasswordWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.generateNewSitePublishingPassword(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> generateNewSitePublishingPasswordWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.generateNewSitePublishingPassword(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> generateNewSitePublishingPasswordAsync(String resourceGroupName, String name) {
        return this.generateNewSitePublishingPasswordWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void generateNewSitePublishingPassword(String resourceGroupName, String name) {
        this.generateNewSitePublishingPasswordAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> generateNewSitePublishingPasswordWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.generateNewSitePublishingPasswordWithResponseAsync(resourceGroupName, name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PerfMonResponseInner>> listPerfMonCountersSinglePageAsync(String resourceGroupName, String name, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPerfMonCounters(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), filter, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PerfMonCounterCollection)res.getValue()).value(), ((PerfMonCounterCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PerfMonResponseInner>> listPerfMonCountersSinglePageAsync(String resourceGroupName, String name, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPerfMonCounters(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), filter, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PerfMonCounterCollection)res.getValue()).value(), ((PerfMonCounterCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PerfMonResponseInner> listPerfMonCountersAsync(String resourceGroupName, String name, String filter) {
        return new PagedFlux(() -> this.listPerfMonCountersSinglePageAsync(resourceGroupName, name, filter), nextLink -> this.listPerfMonCountersNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PerfMonResponseInner> listPerfMonCountersAsync(String resourceGroupName, String name) {
        String filter = null;
        return new PagedFlux(() -> this.listPerfMonCountersSinglePageAsync(resourceGroupName, name, filter), nextLink -> this.listPerfMonCountersNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PerfMonResponseInner> listPerfMonCountersAsync(String resourceGroupName, String name, String filter, Context context) {
        return new PagedFlux(() -> this.listPerfMonCountersSinglePageAsync(resourceGroupName, name, filter, context), nextLink -> this.listPerfMonCountersNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PerfMonResponseInner> listPerfMonCounters(String resourceGroupName, String name) {
        String filter = null;
        return new PagedIterable(this.listPerfMonCountersAsync(resourceGroupName, name, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PerfMonResponseInner> listPerfMonCounters(String resourceGroupName, String name, String filter, Context context) {
        return new PagedIterable(this.listPerfMonCountersAsync(resourceGroupName, name, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SitePhpErrorLogFlagInner>> getSitePhpErrorLogFlagWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSitePhpErrorLogFlag(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SitePhpErrorLogFlagInner>> getSitePhpErrorLogFlagWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSitePhpErrorLogFlag(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SitePhpErrorLogFlagInner> getSitePhpErrorLogFlagAsync(String resourceGroupName, String name) {
        return this.getSitePhpErrorLogFlagWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SitePhpErrorLogFlagInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SitePhpErrorLogFlagInner getSitePhpErrorLogFlag(String resourceGroupName, String name) {
        return (SitePhpErrorLogFlagInner)((Object)this.getSitePhpErrorLogFlagAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SitePhpErrorLogFlagInner> getSitePhpErrorLogFlagWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getSitePhpErrorLogFlagWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PremierAddOnInner>> listPremierAddOnsWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPremierAddOns(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PremierAddOnInner>> listPremierAddOnsWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPremierAddOns(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PremierAddOnInner> listPremierAddOnsAsync(String resourceGroupName, String name) {
        return this.listPremierAddOnsWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PremierAddOnInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PremierAddOnInner listPremierAddOns(String resourceGroupName, String name) {
        return (PremierAddOnInner)((Object)this.listPremierAddOnsAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PremierAddOnInner> listPremierAddOnsWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.listPremierAddOnsWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PremierAddOnInner>> getPremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PremierAddOnInner>> getPremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PremierAddOnInner> getPremierAddOnAsync(String resourceGroupName, String name, String premierAddOnName) {
        return this.getPremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PremierAddOnInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PremierAddOnInner getPremierAddOn(String resourceGroupName, String name, String premierAddOnName) {
        return (PremierAddOnInner)((Object)this.getPremierAddOnAsync(resourceGroupName, name, premierAddOnName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PremierAddOnInner> getPremierAddOnWithResponse(String resourceGroupName, String name, String premierAddOnName, Context context) {
        return (Response)this.getPremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PremierAddOnInner>> addPremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (premierAddOn == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOn is required and cannot be null."));
        }
        premierAddOn.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addPremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), premierAddOn, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PremierAddOnInner>> addPremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (premierAddOn == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOn is required and cannot be null."));
        }
        premierAddOn.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.addPremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), premierAddOn, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PremierAddOnInner> addPremierAddOnAsync(String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn) {
        return this.addPremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName, premierAddOn).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PremierAddOnInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PremierAddOnInner addPremierAddOn(String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn) {
        return (PremierAddOnInner)((Object)this.addPremierAddOnAsync(resourceGroupName, name, premierAddOnName, premierAddOn).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PremierAddOnInner> addPremierAddOnWithResponse(String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn, Context context) {
        return (Response)this.addPremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName, premierAddOn, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deletePremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePremierAddOnAsync(String resourceGroupName, String name, String premierAddOnName) {
        return this.deletePremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePremierAddOn(String resourceGroupName, String name, String premierAddOnName) {
        this.deletePremierAddOnAsync(resourceGroupName, name, premierAddOnName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePremierAddOnWithResponse(String resourceGroupName, String name, String premierAddOnName, Context context) {
        return (Response)this.deletePremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PremierAddOnInner>> updatePremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (premierAddOn == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOn is required and cannot be null."));
        }
        premierAddOn.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), premierAddOn, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PremierAddOnInner>> updatePremierAddOnWithResponseAsync(String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (premierAddOnName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOnName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (premierAddOn == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter premierAddOn is required and cannot be null."));
        }
        premierAddOn.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updatePremierAddOn(this.client.getEndpoint(), resourceGroupName, name, premierAddOnName, this.client.getSubscriptionId(), this.client.getApiVersion(), premierAddOn, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PremierAddOnInner> updatePremierAddOnAsync(String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn) {
        return this.updatePremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName, premierAddOn).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PremierAddOnInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PremierAddOnInner updatePremierAddOn(String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn) {
        return (PremierAddOnInner)((Object)this.updatePremierAddOnAsync(resourceGroupName, name, premierAddOnName, premierAddOn).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PremierAddOnInner> updatePremierAddOnWithResponse(String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn, Context context) {
        return (Response)this.updatePremierAddOnWithResponseAsync(resourceGroupName, name, premierAddOnName, premierAddOn, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PrivateAccessInner>> getPrivateAccessWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateAccess(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateAccessInner>> getPrivateAccessWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateAccess(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PrivateAccessInner> getPrivateAccessAsync(String resourceGroupName, String name) {
        return this.getPrivateAccessWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PrivateAccessInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateAccessInner getPrivateAccess(String resourceGroupName, String name) {
        return (PrivateAccessInner)((Object)this.getPrivateAccessAsync(resourceGroupName, name).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateAccessInner> getPrivateAccessWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getPrivateAccessWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PrivateAccessInner>> putPrivateAccessVnetWithResponseAsync(String resourceGroupName, String name, PrivateAccessInner access) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (access == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter access is required and cannot be null."));
        }
        access.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.putPrivateAccessVnet(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), access, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateAccessInner>> putPrivateAccessVnetWithResponseAsync(String resourceGroupName, String name, PrivateAccessInner access, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (access == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter access is required and cannot be null."));
        }
        access.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.putPrivateAccessVnet(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), access, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PrivateAccessInner> putPrivateAccessVnetAsync(String resourceGroupName, String name, PrivateAccessInner access) {
        return this.putPrivateAccessVnetWithResponseAsync(resourceGroupName, name, access).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PrivateAccessInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateAccessInner putPrivateAccessVnet(String resourceGroupName, String name, PrivateAccessInner access) {
        return (PrivateAccessInner)((Object)this.putPrivateAccessVnetAsync(resourceGroupName, name, access).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateAccessInner> putPrivateAccessVnetWithResponse(String resourceGroupName, String name, PrivateAccessInner access, Context context) {
        return (Response)this.putPrivateAccessVnetWithResponseAsync(resourceGroupName, name, access, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionListSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateEndpointConnectionList(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionCollection)res.getValue()).value(), ((PrivateEndpointConnectionCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionListSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateEndpointConnectionList(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PrivateEndpointConnectionCollection)res.getValue()).value(), ((PrivateEndpointConnectionCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionListAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.getPrivateEndpointConnectionListSinglePageAsync(resourceGroupName, name), nextLink -> this.getPrivateEndpointConnectionListNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionListAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.getPrivateEndpointConnectionListSinglePageAsync(resourceGroupName, name, context), nextLink -> this.getPrivateEndpointConnectionListNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(String resourceGroupName, String name) {
        return new PagedIterable(this.getPrivateEndpointConnectionListAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.getPrivateEndpointConnectionListAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.getPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((RemotePrivateEndpointConnectionArmResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemotePrivateEndpointConnectionArmResourceInner getPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return (RemotePrivateEndpointConnectionArmResourceInner)((Object)this.getPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionWithResponse(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return (Response)this.getPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointWrapper == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointWrapper is required and cannot be null."));
        }
        privateEndpointWrapper.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.approveOrRejectPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), privateEndpointWrapper, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (privateEndpointWrapper == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointWrapper is required and cannot be null."));
        }
        privateEndpointWrapper.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.approveOrRejectPrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), privateEndpointWrapper, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.approveOrRejectPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.approveOrRejectPrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), (Type)((Object)RemotePrivateEndpointConnectionArmResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<RemotePrivateEndpointConnectionArmResourceInner>, RemotePrivateEndpointConnectionArmResourceInner> beginApproveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return this.beginApproveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper) {
        return (RemotePrivateEndpointConnectionArmResourceInner)((Object)this.approveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper, Context context) {
        return (RemotePrivateEndpointConnectionArmResourceInner)((Object)this.approveOrRejectPrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, privateEndpointWrapper, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (privateEndpointConnectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateEndpointConnectionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePrivateEndpointConnection(this.client.getEndpoint(), resourceGroupName, name, privateEndpointConnectionName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deletePrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Object.class), (Type)((Object)Object.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deletePrivateEndpointConnectionWithResponseAsync(resourceGroupName, name, privateEndpointConnectionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Object.class), (Type)((Object)Object.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Object> deletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Object> deletePrivateEndpointConnectionAsync(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return this.beginDeletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object deletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName) {
        return this.deletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Object deletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName, Context context) {
        return this.deletePrivateEndpointConnectionAsync(resourceGroupName, name, privateEndpointConnectionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResourcesWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPrivateLinkResources(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesAsync(String resourceGroupName, String name) {
        return this.getPrivateLinkResourcesWithResponseAsync(resourceGroupName, name).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PrivateLinkResourcesWrapperInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PrivateLinkResourcesWrapperInner getPrivateLinkResources(String resourceGroupName, String name) {
        return (PrivateLinkResourcesWrapperInner)this.getPrivateLinkResourcesAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.getPrivateLinkResourcesWithResponseAsync(resourceGroupName, name, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessInfoInner>> listProcessesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listProcesses(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessInfoCollection)res.getValue()).value(), ((ProcessInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessInfoInner>> listProcessesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listProcesses(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessInfoCollection)res.getValue()).value(), ((ProcessInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ProcessInfoInner> listProcessesAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listProcessesSinglePageAsync(resourceGroupName, name), nextLink -> this.listProcessesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProcessInfoInner> listProcessesAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listProcessesSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listProcessesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessInfoInner> listProcesses(String resourceGroupName, String name) {
        return new PagedIterable(this.listProcessesAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessInfoInner> listProcesses(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listProcessesAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ProcessInfoInner>> getProcessWithResponseAsync(String resourceGroupName, String name, String processId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getProcess(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProcessInfoInner>> getProcessWithResponseAsync(String resourceGroupName, String name, String processId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getProcess(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ProcessInfoInner> getProcessAsync(String resourceGroupName, String name, String processId) {
        return this.getProcessWithResponseAsync(resourceGroupName, name, processId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ProcessInfoInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProcessInfoInner getProcess(String resourceGroupName, String name, String processId) {
        return (ProcessInfoInner)((Object)this.getProcessAsync(resourceGroupName, name, processId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProcessInfoInner> getProcessWithResponse(String resourceGroupName, String name, String processId, Context context) {
        return (Response)this.getProcessWithResponseAsync(resourceGroupName, name, processId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteProcessWithResponseAsync(String resourceGroupName, String name, String processId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteProcess(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteProcessWithResponseAsync(String resourceGroupName, String name, String processId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteProcess(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteProcessAsync(String resourceGroupName, String name, String processId) {
        return this.deleteProcessWithResponseAsync(resourceGroupName, name, processId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteProcess(String resourceGroupName, String name, String processId) {
        this.deleteProcessAsync(resourceGroupName, name, processId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteProcessWithResponse(String resourceGroupName, String name, String processId, Context context) {
        return (Response)this.deleteProcessWithResponseAsync(resourceGroupName, name, processId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getProcessDumpWithResponseAsync(String resourceGroupName, String name, String processId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getProcessDump(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getProcessDumpWithResponseAsync(String resourceGroupName, String name, String processId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getProcessDump(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getProcessDumpAsync(String resourceGroupName, String name, String processId) {
        return this.getProcessDumpWithResponseAsync(resourceGroupName, name, processId).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getProcessDump(String resourceGroupName, String name, String processId) {
        final Iterator iterator = this.getProcessDumpAsync(resourceGroupName, name, processId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getProcessDumpWithResponse(String resourceGroupName, String name, String processId, Context context) {
        return (StreamResponse)this.getProcessDumpWithResponseAsync(resourceGroupName, name, processId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessModuleInfoInner>> listProcessModulesSinglePageAsync(String resourceGroupName, String name, String processId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listProcessModules(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessModuleInfoCollection)res.getValue()).value(), ((ProcessModuleInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessModuleInfoInner>> listProcessModulesSinglePageAsync(String resourceGroupName, String name, String processId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listProcessModules(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessModuleInfoCollection)res.getValue()).value(), ((ProcessModuleInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ProcessModuleInfoInner> listProcessModulesAsync(String resourceGroupName, String name, String processId) {
        return new PagedFlux(() -> this.listProcessModulesSinglePageAsync(resourceGroupName, name, processId), nextLink -> this.listProcessModulesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProcessModuleInfoInner> listProcessModulesAsync(String resourceGroupName, String name, String processId, Context context) {
        return new PagedFlux(() -> this.listProcessModulesSinglePageAsync(resourceGroupName, name, processId, context), nextLink -> this.listProcessModulesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessModuleInfoInner> listProcessModules(String resourceGroupName, String name, String processId) {
        return new PagedIterable(this.listProcessModulesAsync(resourceGroupName, name, processId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessModuleInfoInner> listProcessModules(String resourceGroupName, String name, String processId, Context context) {
        return new PagedIterable(this.listProcessModulesAsync(resourceGroupName, name, processId, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ProcessModuleInfoInner>> getProcessModuleWithResponseAsync(String resourceGroupName, String name, String processId, String baseAddress) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (baseAddress == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baseAddress is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getProcessModule(this.client.getEndpoint(), resourceGroupName, name, processId, baseAddress, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ProcessModuleInfoInner>> getProcessModuleWithResponseAsync(String resourceGroupName, String name, String processId, String baseAddress, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (baseAddress == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter baseAddress is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getProcessModule(this.client.getEndpoint(), resourceGroupName, name, processId, baseAddress, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ProcessModuleInfoInner> getProcessModuleAsync(String resourceGroupName, String name, String processId, String baseAddress) {
        return this.getProcessModuleWithResponseAsync(resourceGroupName, name, processId, baseAddress).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ProcessModuleInfoInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ProcessModuleInfoInner getProcessModule(String resourceGroupName, String name, String processId, String baseAddress) {
        return (ProcessModuleInfoInner)((Object)this.getProcessModuleAsync(resourceGroupName, name, processId, baseAddress).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ProcessModuleInfoInner> getProcessModuleWithResponse(String resourceGroupName, String name, String processId, String baseAddress, Context context) {
        return (Response)this.getProcessModuleWithResponseAsync(resourceGroupName, name, processId, baseAddress, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessThreadInfoInner>> listProcessThreadsSinglePageAsync(String resourceGroupName, String name, String processId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listProcessThreads(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessThreadInfoCollection)res.getValue()).value(), ((ProcessThreadInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ProcessThreadInfoInner>> listProcessThreadsSinglePageAsync(String resourceGroupName, String name, String processId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (processId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter processId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listProcessThreads(this.client.getEndpoint(), resourceGroupName, name, processId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ProcessThreadInfoCollection)res.getValue()).value(), ((ProcessThreadInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ProcessThreadInfoInner> listProcessThreadsAsync(String resourceGroupName, String name, String processId) {
        return new PagedFlux(() -> this.listProcessThreadsSinglePageAsync(resourceGroupName, name, processId), nextLink -> this.listProcessThreadsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ProcessThreadInfoInner> listProcessThreadsAsync(String resourceGroupName, String name, String processId, Context context) {
        return new PagedFlux(() -> this.listProcessThreadsSinglePageAsync(resourceGroupName, name, processId, context), nextLink -> this.listProcessThreadsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessThreadInfoInner> listProcessThreads(String resourceGroupName, String name, String processId) {
        return new PagedIterable(this.listProcessThreadsAsync(resourceGroupName, name, processId));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ProcessThreadInfoInner> listProcessThreads(String resourceGroupName, String name, String processId, Context context) {
        return new PagedIterable(this.listProcessThreadsAsync(resourceGroupName, name, processId, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PublicCertificateInner>> listPublicCertificatesSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPublicCertificates(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PublicCertificateCollection)res.getValue()).value(), ((PublicCertificateCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<PublicCertificateInner>> listPublicCertificatesSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPublicCertificates(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PublicCertificateCollection)res.getValue()).value(), ((PublicCertificateCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PublicCertificateInner> listPublicCertificatesAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listPublicCertificatesSinglePageAsync(resourceGroupName, name), nextLink -> this.listPublicCertificatesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<PublicCertificateInner> listPublicCertificatesAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listPublicCertificatesSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listPublicCertificatesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PublicCertificateInner> listPublicCertificates(String resourceGroupName, String name) {
        return new PagedIterable(this.listPublicCertificatesAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PublicCertificateInner> listPublicCertificates(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listPublicCertificatesAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PublicCertificateInner>> getPublicCertificateWithResponseAsync(String resourceGroupName, String name, String publicCertificateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (publicCertificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPublicCertificate(this.client.getEndpoint(), resourceGroupName, name, publicCertificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PublicCertificateInner>> getPublicCertificateWithResponseAsync(String resourceGroupName, String name, String publicCertificateName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (publicCertificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getPublicCertificate(this.client.getEndpoint(), resourceGroupName, name, publicCertificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PublicCertificateInner> getPublicCertificateAsync(String resourceGroupName, String name, String publicCertificateName) {
        return this.getPublicCertificateWithResponseAsync(resourceGroupName, name, publicCertificateName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PublicCertificateInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PublicCertificateInner getPublicCertificate(String resourceGroupName, String name, String publicCertificateName) {
        return (PublicCertificateInner)((Object)this.getPublicCertificateAsync(resourceGroupName, name, publicCertificateName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PublicCertificateInner> getPublicCertificateWithResponse(String resourceGroupName, String name, String publicCertificateName, Context context) {
        return (Response)this.getPublicCertificateWithResponseAsync(resourceGroupName, name, publicCertificateName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PublicCertificateInner>> createOrUpdatePublicCertificateWithResponseAsync(String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (publicCertificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (publicCertificate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificate is required and cannot be null."));
        }
        publicCertificate.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdatePublicCertificate(this.client.getEndpoint(), resourceGroupName, name, publicCertificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), publicCertificate, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PublicCertificateInner>> createOrUpdatePublicCertificateWithResponseAsync(String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (publicCertificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (publicCertificate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificate is required and cannot be null."));
        }
        publicCertificate.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdatePublicCertificate(this.client.getEndpoint(), resourceGroupName, name, publicCertificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), publicCertificate, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PublicCertificateInner> createOrUpdatePublicCertificateAsync(String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate) {
        return this.createOrUpdatePublicCertificateWithResponseAsync(resourceGroupName, name, publicCertificateName, publicCertificate).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PublicCertificateInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PublicCertificateInner createOrUpdatePublicCertificate(String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate) {
        return (PublicCertificateInner)((Object)this.createOrUpdatePublicCertificateAsync(resourceGroupName, name, publicCertificateName, publicCertificate).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PublicCertificateInner> createOrUpdatePublicCertificateWithResponse(String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate, Context context) {
        return (Response)this.createOrUpdatePublicCertificateWithResponseAsync(resourceGroupName, name, publicCertificateName, publicCertificate, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePublicCertificateWithResponseAsync(String resourceGroupName, String name, String publicCertificateName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (publicCertificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePublicCertificate(this.client.getEndpoint(), resourceGroupName, name, publicCertificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deletePublicCertificateWithResponseAsync(String resourceGroupName, String name, String publicCertificateName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (publicCertificateName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicCertificateName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePublicCertificate(this.client.getEndpoint(), resourceGroupName, name, publicCertificateName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePublicCertificateAsync(String resourceGroupName, String name, String publicCertificateName) {
        return this.deletePublicCertificateWithResponseAsync(resourceGroupName, name, publicCertificateName).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePublicCertificate(String resourceGroupName, String name, String publicCertificateName) {
        this.deletePublicCertificateAsync(resourceGroupName, name, publicCertificateName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePublicCertificateWithResponse(String resourceGroupName, String name, String publicCertificateName, Context context) {
        return (Response)this.deletePublicCertificateWithResponseAsync(resourceGroupName, name, publicCertificateName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> listPublishingProfileXmlWithSecretsWithResponseAsync(String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (publishingProfileOptions == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publishingProfileOptions is required and cannot be null."));
        }
        publishingProfileOptions.validate();
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.listPublishingProfileXmlWithSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), publishingProfileOptions, "application/xml", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> listPublishingProfileXmlWithSecretsWithResponseAsync(String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (publishingProfileOptions == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publishingProfileOptions is required and cannot be null."));
        }
        publishingProfileOptions.validate();
        String accept = "application/xml";
        context = this.client.mergeContext(context);
        return this.service.listPublishingProfileXmlWithSecrets(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), publishingProfileOptions, "application/xml", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> listPublishingProfileXmlWithSecretsAsync(String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions) {
        return this.listPublishingProfileXmlWithSecretsWithResponseAsync(resourceGroupName, name, publishingProfileOptions).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream listPublishingProfileXmlWithSecrets(String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions) {
        final Iterator iterator = this.listPublishingProfileXmlWithSecretsAsync(resourceGroupName, name, publishingProfileOptions).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse listPublishingProfileXmlWithSecretsWithResponse(String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions, Context context) {
        return (StreamResponse)this.listPublishingProfileXmlWithSecretsWithResponseAsync(resourceGroupName, name, publishingProfileOptions, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetProductionSlotConfigWithResponseAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resetProductionSlotConfig(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> resetProductionSlotConfigWithResponseAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.resetProductionSlotConfig(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetProductionSlotConfigAsync(String resourceGroupName, String name) {
        return this.resetProductionSlotConfigWithResponseAsync(resourceGroupName, name).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetProductionSlotConfig(String resourceGroupName, String name) {
        this.resetProductionSlotConfigAsync(resourceGroupName, name).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetProductionSlotConfigWithResponse(String resourceGroupName, String name, Context context) {
        return (Response)this.resetProductionSlotConfigWithResponseAsync(resourceGroupName, name, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> restartWithResponseAsync(String resourceGroupName, String name, Boolean softRestart, Boolean synchronous) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restart(this.client.getEndpoint(), resourceGroupName, name, softRestart, synchronous, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> restartWithResponseAsync(String resourceGroupName, String name, Boolean softRestart, Boolean synchronous, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restart(this.client.getEndpoint(), resourceGroupName, name, softRestart, synchronous, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restartAsync(String resourceGroupName, String name, Boolean softRestart, Boolean synchronous) {
        return this.restartWithResponseAsync(resourceGroupName, name, softRestart, synchronous).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restartAsync(String resourceGroupName, String name) {
        Boolean softRestart = null;
        Boolean synchronous = null;
        return this.restartWithResponseAsync(resourceGroupName, name, softRestart, synchronous).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restart(String resourceGroupName, String name) {
        Boolean softRestart = null;
        Boolean synchronous = null;
        this.restartAsync(resourceGroupName, name, softRestart, synchronous).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> restartWithResponse(String resourceGroupName, String name, Boolean softRestart, Boolean synchronous, Context context) {
        return (Response)this.restartWithResponseAsync(resourceGroupName, name, softRestart, synchronous, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restoreFromBackupBlobWithResponseAsync(String resourceGroupName, String name, RestoreRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreFromBackupBlob(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreFromBackupBlobWithResponseAsync(String resourceGroupName, String name, RestoreRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restoreFromBackupBlob(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestoreFromBackupBlobAsync(String resourceGroupName, String name, RestoreRequestInner request) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreFromBackupBlobWithResponseAsync(resourceGroupName, name, request);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreFromBackupBlobAsync(String resourceGroupName, String name, RestoreRequestInner request, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreFromBackupBlobWithResponseAsync(resourceGroupName, name, request, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFromBackupBlob(String resourceGroupName, String name, RestoreRequestInner request) {
        return this.beginRestoreFromBackupBlobAsync(resourceGroupName, name, request).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFromBackupBlob(String resourceGroupName, String name, RestoreRequestInner request, Context context) {
        return this.beginRestoreFromBackupBlobAsync(resourceGroupName, name, request, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreFromBackupBlobAsync(String resourceGroupName, String name, RestoreRequestInner request) {
        return this.beginRestoreFromBackupBlobAsync(resourceGroupName, name, request).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreFromBackupBlobAsync(String resourceGroupName, String name, RestoreRequestInner request, Context context) {
        return this.beginRestoreFromBackupBlobAsync(resourceGroupName, name, request, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFromBackupBlob(String resourceGroupName, String name, RestoreRequestInner request) {
        this.restoreFromBackupBlobAsync(resourceGroupName, name, request).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFromBackupBlob(String resourceGroupName, String name, RestoreRequestInner request, Context context) {
        this.restoreFromBackupBlobAsync(resourceGroupName, name, request, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restoreFromDeletedAppWithResponseAsync(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (restoreRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restoreRequest is required and cannot be null."));
        }
        restoreRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreFromDeletedApp(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), restoreRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreFromDeletedAppWithResponseAsync(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (restoreRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restoreRequest is required and cannot be null."));
        }
        restoreRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restoreFromDeletedApp(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), restoreRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestoreFromDeletedAppAsync(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreFromDeletedAppWithResponseAsync(resourceGroupName, name, restoreRequest);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreFromDeletedAppAsync(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreFromDeletedAppWithResponseAsync(resourceGroupName, name, restoreRequest, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFromDeletedApp(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest) {
        return this.beginRestoreFromDeletedAppAsync(resourceGroupName, name, restoreRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreFromDeletedApp(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest, Context context) {
        return this.beginRestoreFromDeletedAppAsync(resourceGroupName, name, restoreRequest, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreFromDeletedAppAsync(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest) {
        return this.beginRestoreFromDeletedAppAsync(resourceGroupName, name, restoreRequest).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreFromDeletedAppAsync(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest, Context context) {
        return this.beginRestoreFromDeletedAppAsync(resourceGroupName, name, restoreRequest, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFromDeletedApp(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest) {
        this.restoreFromDeletedAppAsync(resourceGroupName, name, restoreRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreFromDeletedApp(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest, Context context) {
        this.restoreFromDeletedAppAsync(resourceGroupName, name, restoreRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restoreSnapshotWithResponseAsync(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (restoreRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restoreRequest is required and cannot be null."));
        }
        restoreRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreSnapshot(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), restoreRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreSnapshotWithResponseAsync(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (restoreRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restoreRequest is required and cannot be null."));
        }
        restoreRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restoreSnapshot(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), restoreRequest, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestoreSnapshotAsync(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreSnapshotWithResponseAsync(resourceGroupName, name, restoreRequest);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreSnapshotAsync(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreSnapshotWithResponseAsync(resourceGroupName, name, restoreRequest, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreSnapshot(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest) {
        return this.beginRestoreSnapshotAsync(resourceGroupName, name, restoreRequest).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreSnapshot(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest, Context context) {
        return this.beginRestoreSnapshotAsync(resourceGroupName, name, restoreRequest, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreSnapshotAsync(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest) {
        return this.beginRestoreSnapshotAsync(resourceGroupName, name, restoreRequest).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreSnapshotAsync(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest, Context context) {
        return this.beginRestoreSnapshotAsync(resourceGroupName, name, restoreRequest, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreSnapshot(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest) {
        this.restoreSnapshotAsync(resourceGroupName, name, restoreRequest).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreSnapshot(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest, Context context) {
        this.restoreSnapshotAsync(resourceGroupName, name, restoreRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteExtensionInfoInner>> listSiteExtensionsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSiteExtensions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteExtensionInfoCollection)res.getValue()).value(), ((SiteExtensionInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteExtensionInfoInner>> listSiteExtensionsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSiteExtensions(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteExtensionInfoCollection)res.getValue()).value(), ((SiteExtensionInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteExtensionInfoInner> listSiteExtensionsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listSiteExtensionsSinglePageAsync(resourceGroupName, name), nextLink -> this.listSiteExtensionsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteExtensionInfoInner> listSiteExtensionsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listSiteExtensionsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listSiteExtensionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteExtensionInfoInner> listSiteExtensions(String resourceGroupName, String name) {
        return new PagedIterable(this.listSiteExtensionsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteExtensionInfoInner> listSiteExtensions(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listSiteExtensionsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteExtensionInfoInner>> getSiteExtensionWithResponseAsync(String resourceGroupName, String name, String siteExtensionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (siteExtensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteExtensionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSiteExtension(this.client.getEndpoint(), resourceGroupName, name, siteExtensionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteExtensionInfoInner>> getSiteExtensionWithResponseAsync(String resourceGroupName, String name, String siteExtensionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (siteExtensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteExtensionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSiteExtension(this.client.getEndpoint(), resourceGroupName, name, siteExtensionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteExtensionInfoInner> getSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId) {
        return this.getSiteExtensionWithResponseAsync(resourceGroupName, name, siteExtensionId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteExtensionInfoInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteExtensionInfoInner getSiteExtension(String resourceGroupName, String name, String siteExtensionId) {
        return (SiteExtensionInfoInner)((Object)this.getSiteExtensionAsync(resourceGroupName, name, siteExtensionId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteExtensionInfoInner> getSiteExtensionWithResponse(String resourceGroupName, String name, String siteExtensionId, Context context) {
        return (Response)this.getSiteExtensionWithResponseAsync(resourceGroupName, name, siteExtensionId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> installSiteExtensionWithResponseAsync(String resourceGroupName, String name, String siteExtensionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (siteExtensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteExtensionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.installSiteExtension(this.client.getEndpoint(), resourceGroupName, name, siteExtensionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> installSiteExtensionWithResponseAsync(String resourceGroupName, String name, String siteExtensionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (siteExtensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteExtensionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.installSiteExtension(this.client.getEndpoint(), resourceGroupName, name, siteExtensionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SiteExtensionInfoInner>, SiteExtensionInfoInner> beginInstallSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.installSiteExtensionWithResponseAsync(resourceGroupName, name, siteExtensionId);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SiteExtensionInfoInner.class), (Type)((Object)SiteExtensionInfoInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SiteExtensionInfoInner>, SiteExtensionInfoInner> beginInstallSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.installSiteExtensionWithResponseAsync(resourceGroupName, name, siteExtensionId, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SiteExtensionInfoInner.class), (Type)((Object)SiteExtensionInfoInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteExtensionInfoInner>, SiteExtensionInfoInner> beginInstallSiteExtension(String resourceGroupName, String name, String siteExtensionId) {
        return this.beginInstallSiteExtensionAsync(resourceGroupName, name, siteExtensionId).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteExtensionInfoInner>, SiteExtensionInfoInner> beginInstallSiteExtension(String resourceGroupName, String name, String siteExtensionId, Context context) {
        return this.beginInstallSiteExtensionAsync(resourceGroupName, name, siteExtensionId, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteExtensionInfoInner> installSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId) {
        return this.beginInstallSiteExtensionAsync(resourceGroupName, name, siteExtensionId).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SiteExtensionInfoInner> installSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId, Context context) {
        return this.beginInstallSiteExtensionAsync(resourceGroupName, name, siteExtensionId, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteExtensionInfoInner installSiteExtension(String resourceGroupName, String name, String siteExtensionId) {
        return (SiteExtensionInfoInner)((Object)this.installSiteExtensionAsync(resourceGroupName, name, siteExtensionId).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteExtensionInfoInner installSiteExtension(String resourceGroupName, String name, String siteExtensionId, Context context) {
        return (SiteExtensionInfoInner)((Object)this.installSiteExtensionAsync(resourceGroupName, name, siteExtensionId, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSiteExtensionWithResponseAsync(String resourceGroupName, String name, String siteExtensionId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (siteExtensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteExtensionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSiteExtension(this.client.getEndpoint(), resourceGroupName, name, siteExtensionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteSiteExtensionWithResponseAsync(String resourceGroupName, String name, String siteExtensionId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (siteExtensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteExtensionId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteSiteExtension(this.client.getEndpoint(), resourceGroupName, name, siteExtensionId, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId) {
        return this.deleteSiteExtensionWithResponseAsync(resourceGroupName, name, siteExtensionId).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSiteExtension(String resourceGroupName, String name, String siteExtensionId) {
        this.deleteSiteExtensionAsync(resourceGroupName, name, siteExtensionId).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSiteExtensionWithResponse(String resourceGroupName, String name, String siteExtensionId, Context context) {
        return (Response)this.deleteSiteExtensionWithResponseAsync(resourceGroupName, name, siteExtensionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listSlotsSinglePageAsync(String resourceGroupName, String name) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSlots(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppCollection)res.getValue()).value(), ((WebAppCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteInner>> listSlotsSinglePageAsync(String resourceGroupName, String name, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSlots(this.client.getEndpoint(), resourceGroupName, name, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((WebAppCollection)res.getValue()).value(), ((WebAppCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteInner> listSlotsAsync(String resourceGroupName, String name) {
        return new PagedFlux(() -> this.listSlotsSinglePageAsync(resourceGroupName, name), nextLink -> this.listSlotsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteInner> listSlotsAsync(String resourceGroupName, String name, Context context) {
        return new PagedFlux(() -> this.listSlotsSinglePageAsync(resourceGroupName, name, context), nextLink -> this.listSlotsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteInner> listSlots(String resourceGroupName, String name) {
        return new PagedIterable(this.listSlotsAsync(resourceGroupName, name));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteInner> listSlots(String resourceGroupName, String name, Context context) {
        return new PagedIterable(this.listSlotsAsync(resourceGroupName, name, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteInner>> getSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteInner>> getSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteInner> getSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner getSlot(String resourceGroupName, String name, String slot) {
        return (SiteInner)((Object)this.getSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteInner> getSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteInner siteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteInner siteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateSlotAsync(String resourceGroupName, String name, String slot, SiteInner siteEnvelope) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateSlotWithResponseAsync(resourceGroupName, name, slot, siteEnvelope);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SiteInner.class), (Type)((Object)SiteInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateSlotAsync(String resourceGroupName, String name, String slot, SiteInner siteEnvelope, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateSlotWithResponseAsync(resourceGroupName, name, slot, siteEnvelope, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SiteInner.class), (Type)((Object)SiteInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateSlot(String resourceGroupName, String name, String slot, SiteInner siteEnvelope) {
        return this.beginCreateOrUpdateSlotAsync(resourceGroupName, name, slot, siteEnvelope).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateSlot(String resourceGroupName, String name, String slot, SiteInner siteEnvelope, Context context) {
        return this.beginCreateOrUpdateSlotAsync(resourceGroupName, name, slot, siteEnvelope, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteInner> createOrUpdateSlotAsync(String resourceGroupName, String name, String slot, SiteInner siteEnvelope) {
        return this.beginCreateOrUpdateSlotAsync(resourceGroupName, name, slot, siteEnvelope).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SiteInner> createOrUpdateSlotAsync(String resourceGroupName, String name, String slot, SiteInner siteEnvelope, Context context) {
        return this.beginCreateOrUpdateSlotAsync(resourceGroupName, name, slot, siteEnvelope, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner createOrUpdateSlot(String resourceGroupName, String name, String slot, SiteInner siteEnvelope) {
        return (SiteInner)((Object)this.createOrUpdateSlotAsync(resourceGroupName, name, slot, siteEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner createOrUpdateSlot(String resourceGroupName, String name, String slot, SiteInner siteEnvelope, Context context) {
        return (SiteInner)((Object)this.createOrUpdateSlotAsync(resourceGroupName, name, slot, siteEnvelope, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSlotWithResponseAsync(String resourceGroupName, String name, String slot, Boolean deleteMetrics, Boolean deleteEmptyServerFarm) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSlot(this.client.getEndpoint(), resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteSlotWithResponseAsync(String resourceGroupName, String name, String slot, Boolean deleteMetrics, Boolean deleteEmptyServerFarm, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteSlot(this.client.getEndpoint(), resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSlotAsync(String resourceGroupName, String name, String slot, Boolean deleteMetrics, Boolean deleteEmptyServerFarm) {
        return this.deleteSlotWithResponseAsync(resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSlotAsync(String resourceGroupName, String name, String slot) {
        Boolean deleteMetrics = null;
        Boolean deleteEmptyServerFarm = null;
        return this.deleteSlotWithResponseAsync(resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSlot(String resourceGroupName, String name, String slot) {
        Boolean deleteMetrics = null;
        Boolean deleteEmptyServerFarm = null;
        this.deleteSlotAsync(resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSlotWithResponse(String resourceGroupName, String name, String slot, Boolean deleteMetrics, Boolean deleteEmptyServerFarm, Context context) {
        return (Response)this.deleteSlotWithResponseAsync(resourceGroupName, name, slot, deleteMetrics, deleteEmptyServerFarm, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteInner>> updateSlotWithResponseAsync(String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteInner>> updateSlotWithResponseAsync(String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteEnvelope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteEnvelope is required and cannot be null."));
        }
        siteEnvelope.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteEnvelope, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteInner> updateSlotAsync(String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope) {
        return this.updateSlotWithResponseAsync(resourceGroupName, name, slot, siteEnvelope).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteInner updateSlot(String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope) {
        return (SiteInner)((Object)this.updateSlotAsync(resourceGroupName, name, slot, siteEnvelope).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteInner> updateSlotWithResponse(String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope, Context context) {
        return (Response)this.updateSlotWithResponseAsync(resourceGroupName, name, slot, siteEnvelope, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameSlotWithResponseAsync(String resourceGroupName, String name, String slot, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.analyzeCustomHostnameSlot(this.client.getEndpoint(), resourceGroupName, name, slot, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameSlotWithResponseAsync(String resourceGroupName, String name, String slot, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.analyzeCustomHostnameSlot(this.client.getEndpoint(), resourceGroupName, name, slot, hostname, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameSlotAsync(String resourceGroupName, String name, String slot, String hostname) {
        return this.analyzeCustomHostnameSlotWithResponseAsync(resourceGroupName, name, slot, hostname).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CustomHostnameAnalysisResultInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameSlotAsync(String resourceGroupName, String name, String slot) {
        String hostname = null;
        return this.analyzeCustomHostnameSlotWithResponseAsync(resourceGroupName, name, slot, hostname).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CustomHostnameAnalysisResultInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CustomHostnameAnalysisResultInner analyzeCustomHostnameSlot(String resourceGroupName, String name, String slot) {
        String hostname = null;
        return (CustomHostnameAnalysisResultInner)((Object)this.analyzeCustomHostnameSlotAsync(resourceGroupName, name, slot, hostname).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CustomHostnameAnalysisResultInner> analyzeCustomHostnameSlotWithResponse(String resourceGroupName, String name, String slot, String hostname, Context context) {
        return (Response)this.analyzeCustomHostnameSlotWithResponseAsync(resourceGroupName, name, slot, hostname, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> applySlotConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotSwapEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slotSwapEntity is required and cannot be null."));
        }
        slotSwapEntity.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.applySlotConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), slotSwapEntity, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> applySlotConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (slotSwapEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slotSwapEntity is required and cannot be null."));
        }
        slotSwapEntity.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.applySlotConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), slotSwapEntity, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> applySlotConfigurationSlotAsync(String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity) {
        return this.applySlotConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, slotSwapEntity).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void applySlotConfigurationSlot(String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity) {
        this.applySlotConfigurationSlotAsync(resourceGroupName, name, slot, slotSwapEntity).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> applySlotConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity, Context context) {
        return (Response)this.applySlotConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, slotSwapEntity, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> backupSlotWithResponseAsync(String resourceGroupName, String name, String slot, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.backupSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> backupSlotWithResponseAsync(String resourceGroupName, String name, String slot, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.backupSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupItemInner> backupSlotAsync(String resourceGroupName, String name, String slot, BackupRequestInner request) {
        return this.backupSlotWithResponseAsync(resourceGroupName, name, slot, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupItemInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupItemInner backupSlot(String resourceGroupName, String name, String slot, BackupRequestInner request) {
        return (BackupItemInner)((Object)this.backupSlotAsync(resourceGroupName, name, slot, request).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupItemInner> backupSlotWithResponse(String resourceGroupName, String name, String slot, BackupRequestInner request, Context context) {
        return (Response)this.backupSlotWithResponseAsync(resourceGroupName, name, slot, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listBackupsSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBackupsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupItemCollection)res.getValue()).value(), ((BackupItemCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<BackupItemInner>> listBackupsSlotSinglePageAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBackupsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((BackupItemCollection)res.getValue()).value(), ((BackupItemCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BackupItemInner> listBackupsSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux(() -> this.listBackupsSlotSinglePageAsync(resourceGroupName, name, slot), nextLink -> this.listBackupsSlotNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<BackupItemInner> listBackupsSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return new PagedFlux(() -> this.listBackupsSlotSinglePageAsync(resourceGroupName, name, slot, context), nextLink -> this.listBackupsSlotNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listBackupsSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable(this.listBackupsSlotAsync(resourceGroupName, name, slot));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BackupItemInner> listBackupsSlot(String resourceGroupName, String name, String slot, Context context) {
        return new PagedIterable(this.listBackupsSlotAsync(resourceGroupName, name, slot, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> getBackupStatusSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBackupStatusSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> getBackupStatusSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBackupStatusSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupItemInner> getBackupStatusSlotAsync(String resourceGroupName, String name, String backupId, String slot) {
        return this.getBackupStatusSlotWithResponseAsync(resourceGroupName, name, backupId, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupItemInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupItemInner getBackupStatusSlot(String resourceGroupName, String name, String backupId, String slot) {
        return (BackupItemInner)((Object)this.getBackupStatusSlotAsync(resourceGroupName, name, backupId, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupItemInner> getBackupStatusSlotWithResponse(String resourceGroupName, String name, String backupId, String slot, Context context) {
        return (Response)this.getBackupStatusSlotWithResponseAsync(resourceGroupName, name, backupId, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBackupSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteBackupSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteBackupSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteBackupSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBackupSlotAsync(String resourceGroupName, String name, String backupId, String slot) {
        return this.deleteBackupSlotWithResponseAsync(resourceGroupName, name, backupId, slot).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBackupSlot(String resourceGroupName, String name, String backupId, String slot) {
        this.deleteBackupSlotAsync(resourceGroupName, name, backupId, slot).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBackupSlotWithResponse(String resourceGroupName, String name, String backupId, String slot, Context context) {
        return (Response)this.deleteBackupSlotWithResponseAsync(resourceGroupName, name, backupId, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupItemInner>> listBackupStatusSecretsSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBackupStatusSecretsSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupItemInner>> listBackupStatusSecretsSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBackupStatusSecretsSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupItemInner> listBackupStatusSecretsSlotAsync(String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request) {
        return this.listBackupStatusSecretsSlotWithResponseAsync(resourceGroupName, name, backupId, slot, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupItemInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupItemInner listBackupStatusSecretsSlot(String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request) {
        return (BackupItemInner)((Object)this.listBackupStatusSecretsSlotAsync(resourceGroupName, name, backupId, slot, request).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupItemInner> listBackupStatusSecretsSlotWithResponse(String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request, Context context) {
        return (Response)this.listBackupStatusSecretsSlotWithResponseAsync(resourceGroupName, name, backupId, slot, request, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restoreSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.restoreSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restoreSlotWithResponseAsync(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (backupId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter backupId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.restoreSlot(this.client.getEndpoint(), resourceGroupName, name, backupId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestoreSlotAsync(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreSlotWithResponseAsync(resourceGroupName, name, backupId, slot, request);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestoreSlotAsync(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.restoreSlotWithResponseAsync(resourceGroupName, name, backupId, slot, request, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreSlot(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request) {
        return this.beginRestoreSlotAsync(resourceGroupName, name, backupId, slot, request).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestoreSlot(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request, Context context) {
        return this.beginRestoreSlotAsync(resourceGroupName, name, backupId, slot, request, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> restoreSlotAsync(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request) {
        return this.beginRestoreSlotAsync(resourceGroupName, name, backupId, slot, request).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> restoreSlotAsync(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request, Context context) {
        return this.beginRestoreSlotAsync(resourceGroupName, name, backupId, slot, request, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreSlot(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request) {
        this.restoreSlotAsync(resourceGroupName, name, backupId, slot, request).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void restoreSlot(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request, Context context) {
        this.restoreSlotAsync(resourceGroupName, name, backupId, slot, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmPublishingCredentialsPoliciesEntityInner>> listBasicPublishingCredentialsPoliciesSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBasicPublishingCredentialsPoliciesSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PublishingCredentialsPoliciesCollection)res.getValue()).value(), ((PublishingCredentialsPoliciesCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CsmPublishingCredentialsPoliciesEntityInner>> listBasicPublishingCredentialsPoliciesSlotSinglePageAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listBasicPublishingCredentialsPoliciesSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PublishingCredentialsPoliciesCollection)res.getValue()).value(), ((PublishingCredentialsPoliciesCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux(() -> this.listBasicPublishingCredentialsPoliciesSlotSinglePageAsync(resourceGroupName, name, slot), nextLink -> this.listBasicPublishingCredentialsPoliciesSlotNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return new PagedFlux(() -> this.listBasicPublishingCredentialsPoliciesSlotSinglePageAsync(resourceGroupName, name, slot, context), nextLink -> this.listBasicPublishingCredentialsPoliciesSlotNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable(this.listBasicPublishingCredentialsPoliciesSlotAsync(resourceGroupName, name, slot));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesSlot(String resourceGroupName, String name, String slot, Context context) {
        return new PagedIterable(this.listBasicPublishingCredentialsPoliciesSlotAsync(resourceGroupName, name, slot, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getFtpAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getFtpAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getFtpAllowedSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner getFtpAllowedSlot(String resourceGroupName, String name, String slot) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.getFtpAllowedSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getFtpAllowedSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateFtpAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateFtpAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedSlotAsync(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return this.updateFtpAllowedSlotWithResponseAsync(resourceGroupName, name, slot, csmPublishingAccessPoliciesEntity).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner updateFtpAllowedSlot(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.updateFtpAllowedSlotAsync(resourceGroupName, name, slot, csmPublishingAccessPoliciesEntity).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedSlotWithResponse(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        return (Response)this.updateFtpAllowedSlotWithResponseAsync(resourceGroupName, name, slot, csmPublishingAccessPoliciesEntity, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getScmAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getScmAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getScmAllowedSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner getScmAllowedSlot(String resourceGroupName, String name, String slot) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.getScmAllowedSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getScmAllowedSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateScmAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedSlotWithResponseAsync(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (csmPublishingAccessPoliciesEntity == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter csmPublishingAccessPoliciesEntity is required and cannot be null."));
        }
        csmPublishingAccessPoliciesEntity.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateScmAllowedSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), csmPublishingAccessPoliciesEntity, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedSlotAsync(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return this.updateScmAllowedSlotWithResponseAsync(resourceGroupName, name, slot, csmPublishingAccessPoliciesEntity).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((CsmPublishingCredentialsPoliciesEntityInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CsmPublishingCredentialsPoliciesEntityInner updateScmAllowedSlot(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity) {
        return (CsmPublishingCredentialsPoliciesEntityInner)((Object)this.updateScmAllowedSlotAsync(resourceGroupName, name, slot, csmPublishingAccessPoliciesEntity).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedSlotWithResponse(String resourceGroupName, String name, String slot, CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity, Context context) {
        return (Response)this.updateScmAllowedSlotWithResponseAsync(resourceGroupName, name, slot, csmPublishingAccessPoliciesEntity, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigResourceInner>> listConfigurationsSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConfigurationsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigResourceCollection)res.getValue()).value(), ((SiteConfigResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigResourceInner>> listConfigurationsSlotSinglePageAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listConfigurationsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigResourceCollection)res.getValue()).value(), ((SiteConfigResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteConfigResourceInner> listConfigurationsSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux(() -> this.listConfigurationsSlotSinglePageAsync(resourceGroupName, name, slot), nextLink -> this.listConfigurationsSlotNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteConfigResourceInner> listConfigurationsSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return new PagedFlux(() -> this.listConfigurationsSlotSinglePageAsync(resourceGroupName, name, slot, context), nextLink -> this.listConfigurationsSlotNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigResourceInner> listConfigurationsSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable(this.listConfigurationsSlotAsync(resourceGroupName, name, slot));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigResourceInner> listConfigurationsSlot(String resourceGroupName, String name, String slot, Context context) {
        return new PagedIterable(this.listConfigurationsSlotAsync(resourceGroupName, name, slot, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> updateApplicationSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, StringDictionaryInner appSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateApplicationSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> updateApplicationSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, StringDictionaryInner appSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (appSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettings is required and cannot be null."));
        }
        appSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateApplicationSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), appSettings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> updateApplicationSettingsSlotAsync(String resourceGroupName, String name, String slot, StringDictionaryInner appSettings) {
        return this.updateApplicationSettingsSlotWithResponseAsync(resourceGroupName, name, slot, appSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner updateApplicationSettingsSlot(String resourceGroupName, String name, String slot, StringDictionaryInner appSettings) {
        return (StringDictionaryInner)((Object)this.updateApplicationSettingsSlotAsync(resourceGroupName, name, slot, appSettings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> updateApplicationSettingsSlotWithResponse(String resourceGroupName, String name, String slot, StringDictionaryInner appSettings, Context context) {
        return (Response)this.updateApplicationSettingsSlotWithResponseAsync(resourceGroupName, name, slot, appSettings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listApplicationSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listApplicationSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listApplicationSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listApplicationSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listApplicationSettingsSlotAsync(String resourceGroupName, String name, String slot) {
        return this.listApplicationSettingsSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner listApplicationSettingsSlot(String resourceGroupName, String name, String slot) {
        return (StringDictionaryInner)((Object)this.listApplicationSettingsSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> listApplicationSettingsSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.listApplicationSettingsSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettings is required and cannot be null."));
        }
        siteAuthSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAuthSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettings is required and cannot be null."));
        }
        siteAuthSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAuthSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsInner> updateAuthSettingsSlotAsync(String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings) {
        return this.updateAuthSettingsSlotWithResponseAsync(resourceGroupName, name, slot, siteAuthSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsInner updateAuthSettingsSlot(String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings) {
        return (SiteAuthSettingsInner)((Object)this.updateAuthSettingsSlotAsync(resourceGroupName, name, slot, siteAuthSettings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsInner> updateAuthSettingsSlotWithResponse(String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings, Context context) {
        return (Response)this.updateAuthSettingsSlotWithResponseAsync(resourceGroupName, name, slot, siteAuthSettings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsInner>> getAuthSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAuthSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsInner>> getAuthSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAuthSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsInner> getAuthSettingsSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getAuthSettingsSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsInner getAuthSettingsSlot(String resourceGroupName, String name, String slot) {
        return (SiteAuthSettingsInner)((Object)this.getAuthSettingsSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsInner> getAuthSettingsSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getAuthSettingsSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2SlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettingsV2 == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettingsV2 is required and cannot be null."));
        }
        siteAuthSettingsV2.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAuthSettingsV2Slot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettingsV2, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2SlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteAuthSettingsV2 == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteAuthSettingsV2 is required and cannot be null."));
        }
        siteAuthSettingsV2.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAuthSettingsV2Slot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteAuthSettingsV2, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> updateAuthSettingsV2SlotAsync(String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        return this.updateAuthSettingsV2SlotWithResponseAsync(resourceGroupName, name, slot, siteAuthSettingsV2).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsV2Inner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner updateAuthSettingsV2Slot(String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2) {
        return (SiteAuthSettingsV2Inner)((Object)this.updateAuthSettingsV2SlotAsync(resourceGroupName, name, slot, siteAuthSettingsV2).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> updateAuthSettingsV2SlotWithResponse(String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2, Context context) {
        return (Response)this.updateAuthSettingsV2SlotWithResponseAsync(resourceGroupName, name, slot, siteAuthSettingsV2, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2SlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAuthSettingsV2Slot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2SlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAuthSettingsV2Slot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2SlotAsync(String resourceGroupName, String name, String slot) {
        return this.getAuthSettingsV2SlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteAuthSettingsV2Inner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteAuthSettingsV2Inner getAuthSettingsV2Slot(String resourceGroupName, String name, String slot) {
        return (SiteAuthSettingsV2Inner)((Object)this.getAuthSettingsV2SlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteAuthSettingsV2Inner> getAuthSettingsV2SlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getAuthSettingsV2SlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsSlotWithResponseAsync(String resourceGroupName, String name, String slot, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (azureStorageAccounts == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureStorageAccounts is required and cannot be null."));
        }
        azureStorageAccounts.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAzureStorageAccountsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), azureStorageAccounts, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsSlotWithResponseAsync(String resourceGroupName, String name, String slot, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (azureStorageAccounts == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter azureStorageAccounts is required and cannot be null."));
        }
        azureStorageAccounts.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAzureStorageAccountsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), azureStorageAccounts, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsSlotAsync(String resourceGroupName, String name, String slot, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return this.updateAzureStorageAccountsSlotWithResponseAsync(resourceGroupName, name, slot, azureStorageAccounts).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AzureStoragePropertyDictionaryResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureStoragePropertyDictionaryResourceInner updateAzureStorageAccountsSlot(String resourceGroupName, String name, String slot, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts) {
        return (AzureStoragePropertyDictionaryResourceInner)((Object)this.updateAzureStorageAccountsSlotAsync(resourceGroupName, name, slot, azureStorageAccounts).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsSlotWithResponse(String resourceGroupName, String name, String slot, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts, Context context) {
        return (Response)this.updateAzureStorageAccountsSlotWithResponseAsync(resourceGroupName, name, slot, azureStorageAccounts, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listAzureStorageAccountsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listAzureStorageAccountsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsSlotAsync(String resourceGroupName, String name, String slot) {
        return this.listAzureStorageAccountsSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AzureStoragePropertyDictionaryResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AzureStoragePropertyDictionaryResourceInner listAzureStorageAccountsSlot(String resourceGroupName, String name, String slot) {
        return (AzureStoragePropertyDictionaryResourceInner)((Object)this.listAzureStorageAccountsSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.listAzureStorageAccountsSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupRequestInner>> updateBackupConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, BackupRequestInner request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateBackupConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupRequestInner>> updateBackupConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, BackupRequestInner request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateBackupConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupRequestInner> updateBackupConfigurationSlotAsync(String resourceGroupName, String name, String slot, BackupRequestInner request) {
        return this.updateBackupConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupRequestInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupRequestInner updateBackupConfigurationSlot(String resourceGroupName, String name, String slot, BackupRequestInner request) {
        return (BackupRequestInner)((Object)this.updateBackupConfigurationSlotAsync(resourceGroupName, name, slot, request).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupRequestInner> updateBackupConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, BackupRequestInner request, Context context) {
        return (Response)this.updateBackupConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, request, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteBackupConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteBackupConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteBackupConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteBackupConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteBackupConfigurationSlotAsync(String resourceGroupName, String name, String slot) {
        return this.deleteBackupConfigurationSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteBackupConfigurationSlot(String resourceGroupName, String name, String slot) {
        this.deleteBackupConfigurationSlotAsync(resourceGroupName, name, slot).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteBackupConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.deleteBackupConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BackupRequestInner>> getBackupConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getBackupConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<BackupRequestInner>> getBackupConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getBackupConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BackupRequestInner> getBackupConfigurationSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getBackupConfigurationSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((BackupRequestInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public BackupRequestInner getBackupConfigurationSlot(String resourceGroupName, String name, String slot) {
        return (BackupRequestInner)((Object)this.getBackupConfigurationSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BackupRequestInner> getBackupConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getBackupConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getAppSettingsKeyVaultReferencesSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAppSettingsKeyVaultReferencesSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getAppSettingsKeyVaultReferencesSlotSinglePageAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAppSettingsKeyVaultReferencesSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux(() -> this.getAppSettingsKeyVaultReferencesSlotSinglePageAsync(resourceGroupName, name, slot), nextLink -> this.getAppSettingsKeyVaultReferencesSlotNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return new PagedFlux(() -> this.getAppSettingsKeyVaultReferencesSlotSinglePageAsync(resourceGroupName, name, slot, context), nextLink -> this.getAppSettingsKeyVaultReferencesSlotNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable(this.getAppSettingsKeyVaultReferencesSlotAsync(resourceGroupName, name, slot));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesSlot(String resourceGroupName, String name, String slot, Context context) {
        return new PagedIterable(this.getAppSettingsKeyVaultReferencesSlotAsync(resourceGroupName, name, slot, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceSlotWithResponseAsync(String resourceGroupName, String name, String appSettingKey, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (appSettingKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettingKey is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getAppSettingKeyVaultReferenceSlot(this.client.getEndpoint(), resourceGroupName, name, appSettingKey, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceSlotWithResponseAsync(String resourceGroupName, String name, String appSettingKey, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (appSettingKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appSettingKey is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getAppSettingKeyVaultReferenceSlot(this.client.getEndpoint(), resourceGroupName, name, appSettingKey, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApiKVReferenceInner> getAppSettingKeyVaultReferenceSlotAsync(String resourceGroupName, String name, String appSettingKey, String slot) {
        return this.getAppSettingKeyVaultReferenceSlotWithResponseAsync(resourceGroupName, name, appSettingKey, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ApiKVReferenceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiKVReferenceInner getAppSettingKeyVaultReferenceSlot(String resourceGroupName, String name, String appSettingKey, String slot) {
        return (ApiKVReferenceInner)((Object)this.getAppSettingKeyVaultReferenceSlotAsync(resourceGroupName, name, appSettingKey, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApiKVReferenceInner> getAppSettingKeyVaultReferenceSlotWithResponse(String resourceGroupName, String name, String appSettingKey, String slot, Context context) {
        return (Response)this.getAppSettingKeyVaultReferenceSlotWithResponseAsync(resourceGroupName, name, appSettingKey, slot, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferencesSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSiteConnectionStringKeyVaultReferencesSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferencesSlotSinglePageAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSiteConnectionStringKeyVaultReferencesSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ApiKVReferenceCollection)res.getValue()).value(), ((ApiKVReferenceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux(() -> this.getSiteConnectionStringKeyVaultReferencesSlotSinglePageAsync(resourceGroupName, name, slot), nextLink -> this.getSiteConnectionStringKeyVaultReferencesSlotNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return new PagedFlux(() -> this.getSiteConnectionStringKeyVaultReferencesSlotSinglePageAsync(resourceGroupName, name, slot, context), nextLink -> this.getSiteConnectionStringKeyVaultReferencesSlotNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable(this.getSiteConnectionStringKeyVaultReferencesSlotAsync(resourceGroupName, name, slot));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesSlot(String resourceGroupName, String name, String slot, Context context) {
        return new PagedIterable(this.getSiteConnectionStringKeyVaultReferencesSlotAsync(resourceGroupName, name, slot, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceSlotWithResponseAsync(String resourceGroupName, String name, String connectionStringKey, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (connectionStringKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStringKey is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSiteConnectionStringKeyVaultReferenceSlot(this.client.getEndpoint(), resourceGroupName, name, connectionStringKey, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceSlotWithResponseAsync(String resourceGroupName, String name, String connectionStringKey, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (connectionStringKey == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStringKey is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getSiteConnectionStringKeyVaultReferenceSlot(this.client.getEndpoint(), resourceGroupName, name, connectionStringKey, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceSlotAsync(String resourceGroupName, String name, String connectionStringKey, String slot) {
        return this.getSiteConnectionStringKeyVaultReferenceSlotWithResponseAsync(resourceGroupName, name, connectionStringKey, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ApiKVReferenceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ApiKVReferenceInner getSiteConnectionStringKeyVaultReferenceSlot(String resourceGroupName, String name, String connectionStringKey, String slot) {
        return (ApiKVReferenceInner)((Object)this.getSiteConnectionStringKeyVaultReferenceSlotAsync(resourceGroupName, name, connectionStringKey, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceSlotWithResponse(String resourceGroupName, String name, String connectionStringKey, String slot, Context context) {
        return (Response)this.getSiteConnectionStringKeyVaultReferenceSlotWithResponseAsync(resourceGroupName, name, connectionStringKey, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsSlotWithResponseAsync(String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionStrings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStrings is required and cannot be null."));
        }
        connectionStrings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateConnectionStringsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionStrings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsSlotWithResponseAsync(String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (connectionStrings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter connectionStrings is required and cannot be null."));
        }
        connectionStrings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateConnectionStringsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), connectionStrings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionStringDictionaryInner> updateConnectionStringsSlotAsync(String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings) {
        return this.updateConnectionStringsSlotWithResponseAsync(resourceGroupName, name, slot, connectionStrings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConnectionStringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionStringDictionaryInner updateConnectionStringsSlot(String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings) {
        return (ConnectionStringDictionaryInner)((Object)this.updateConnectionStringsSlotAsync(resourceGroupName, name, slot, connectionStrings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectionStringDictionaryInner> updateConnectionStringsSlotWithResponse(String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings, Context context) {
        return (Response)this.updateConnectionStringsSlotWithResponseAsync(resourceGroupName, name, slot, connectionStrings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConnectionStringDictionaryInner>> listConnectionStringsSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConnectionStringsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConnectionStringDictionaryInner>> listConnectionStringsSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listConnectionStringsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConnectionStringDictionaryInner> listConnectionStringsSlotAsync(String resourceGroupName, String name, String slot) {
        return this.listConnectionStringsSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConnectionStringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConnectionStringDictionaryInner listConnectionStringsSlot(String resourceGroupName, String name, String slot) {
        return (ConnectionStringDictionaryInner)((Object)this.listConnectionStringsSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConnectionStringDictionaryInner> listConnectionStringsSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.listConnectionStringsSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDiagnosticLogsConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getDiagnosticLogsConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteLogsConfigInner> getDiagnosticLogsConfigurationSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getDiagnosticLogsConfigurationSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteLogsConfigInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteLogsConfigInner getDiagnosticLogsConfigurationSlot(String resourceGroupName, String name, String slot) {
        return (SiteLogsConfigInner)((Object)this.getDiagnosticLogsConfigurationSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteLogsConfigInner> getDiagnosticLogsConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getDiagnosticLogsConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteLogsConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteLogsConfig is required and cannot be null."));
        }
        siteLogsConfig.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateDiagnosticLogsConfigSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteLogsConfig, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteLogsConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteLogsConfig is required and cannot be null."));
        }
        siteLogsConfig.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateDiagnosticLogsConfigSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteLogsConfig, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteLogsConfigInner> updateDiagnosticLogsConfigSlotAsync(String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig) {
        return this.updateDiagnosticLogsConfigSlotWithResponseAsync(resourceGroupName, name, slot, siteLogsConfig).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteLogsConfigInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteLogsConfigInner updateDiagnosticLogsConfigSlot(String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig) {
        return (SiteLogsConfigInner)((Object)this.updateDiagnosticLogsConfigSlotAsync(resourceGroupName, name, slot, siteLogsConfig).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteLogsConfigInner> updateDiagnosticLogsConfigSlotWithResponse(String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig, Context context) {
        return (Response)this.updateDiagnosticLogsConfigSlotWithResponseAsync(resourceGroupName, name, slot, siteLogsConfig, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> updateMetadataSlotWithResponseAsync(String resourceGroupName, String name, String slot, StringDictionaryInner metadata) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (metadata == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metadata is required and cannot be null."));
        }
        metadata.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateMetadataSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), metadata, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> updateMetadataSlotWithResponseAsync(String resourceGroupName, String name, String slot, StringDictionaryInner metadata, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (metadata == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter metadata is required and cannot be null."));
        }
        metadata.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateMetadataSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), metadata, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> updateMetadataSlotAsync(String resourceGroupName, String name, String slot, StringDictionaryInner metadata) {
        return this.updateMetadataSlotWithResponseAsync(resourceGroupName, name, slot, metadata).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner updateMetadataSlot(String resourceGroupName, String name, String slot, StringDictionaryInner metadata) {
        return (StringDictionaryInner)((Object)this.updateMetadataSlotAsync(resourceGroupName, name, slot, metadata).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> updateMetadataSlotWithResponse(String resourceGroupName, String name, String slot, StringDictionaryInner metadata, Context context) {
        return (Response)this.updateMetadataSlotWithResponseAsync(resourceGroupName, name, slot, metadata, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StringDictionaryInner>> listMetadataSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listMetadataSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<StringDictionaryInner>> listMetadataSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listMetadataSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StringDictionaryInner> listMetadataSlotAsync(String resourceGroupName, String name, String slot) {
        return this.listMetadataSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((StringDictionaryInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StringDictionaryInner listMetadataSlot(String resourceGroupName, String name, String slot) {
        return (StringDictionaryInner)((Object)this.listMetadataSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StringDictionaryInner> listMetadataSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.listMetadataSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listPublishingCredentialsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listPublishingCredentialsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsSlotAsync(String resourceGroupName, String name, String slot) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.listPublishingCredentialsSlotWithResponseAsync(resourceGroupName, name, slot);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)UserInner.class), (Type)((Object)UserInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.listPublishingCredentialsSlotWithResponseAsync(resourceGroupName, name, slot, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)UserInner.class), (Type)((Object)UserInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentialsSlot(String resourceGroupName, String name, String slot) {
        return this.beginListPublishingCredentialsSlotAsync(resourceGroupName, name, slot).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentialsSlot(String resourceGroupName, String name, String slot, Context context) {
        return this.beginListPublishingCredentialsSlotAsync(resourceGroupName, name, slot, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UserInner> listPublishingCredentialsSlotAsync(String resourceGroupName, String name, String slot) {
        return this.beginListPublishingCredentialsSlotAsync(resourceGroupName, name, slot).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<UserInner> listPublishingCredentialsSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return this.beginListPublishingCredentialsSlotAsync(resourceGroupName, name, slot, context).last().flatMap(arg_0 -> ((WebSiteManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserInner listPublishingCredentialsSlot(String resourceGroupName, String name, String slot) {
        return (UserInner)((Object)this.listPublishingCredentialsSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UserInner listPublishingCredentialsSlot(String resourceGroupName, String name, String slot, Context context) {
        return (UserInner)((Object)this.listPublishingCredentialsSlotAsync(resourceGroupName, name, slot, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PushSettingsInner>> updateSitePushSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, PushSettingsInner pushSettings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pushSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pushSettings is required and cannot be null."));
        }
        pushSettings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSitePushSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), pushSettings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PushSettingsInner>> updateSitePushSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, PushSettingsInner pushSettings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (pushSettings == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter pushSettings is required and cannot be null."));
        }
        pushSettings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSitePushSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), pushSettings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PushSettingsInner> updateSitePushSettingsSlotAsync(String resourceGroupName, String name, String slot, PushSettingsInner pushSettings) {
        return this.updateSitePushSettingsSlotWithResponseAsync(resourceGroupName, name, slot, pushSettings).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PushSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PushSettingsInner updateSitePushSettingsSlot(String resourceGroupName, String name, String slot, PushSettingsInner pushSettings) {
        return (PushSettingsInner)((Object)this.updateSitePushSettingsSlotAsync(resourceGroupName, name, slot, pushSettings).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PushSettingsInner> updateSitePushSettingsSlotWithResponse(String resourceGroupName, String name, String slot, PushSettingsInner pushSettings, Context context) {
        return (Response)this.updateSitePushSettingsSlotWithResponseAsync(resourceGroupName, name, slot, pushSettings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PushSettingsInner>> listSitePushSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listSitePushSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<PushSettingsInner>> listSitePushSettingsSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listSitePushSettingsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PushSettingsInner> listSitePushSettingsSlotAsync(String resourceGroupName, String name, String slot) {
        return this.listSitePushSettingsSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((PushSettingsInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PushSettingsInner listSitePushSettingsSlot(String resourceGroupName, String name, String slot) {
        return (PushSettingsInner)((Object)this.listSitePushSettingsSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PushSettingsInner> listSitePushSettingsSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.listSitePushSettingsSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> getConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> getConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> getConfigurationSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getConfigurationSlotWithResponseAsync(resourceGroupName, name, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner getConfigurationSlot(String resourceGroupName, String name, String slot) {
        return (SiteConfigResourceInner)((Object)this.getConfigurationSlotAsync(resourceGroupName, name, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> getConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (Response)this.getConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> createOrUpdateConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> createOrUpdateConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdateConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> createOrUpdateConfigurationSlotAsync(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig) {
        return this.createOrUpdateConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, siteConfig).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner createOrUpdateConfigurationSlot(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig) {
        return (SiteConfigResourceInner)((Object)this.createOrUpdateConfigurationSlotAsync(resourceGroupName, name, slot, siteConfig).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> createOrUpdateConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig, Context context) {
        return (Response)this.createOrUpdateConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, siteConfig, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> updateConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> updateConfigurationSlotWithResponseAsync(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (siteConfig == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter siteConfig is required and cannot be null."));
        }
        siteConfig.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateConfigurationSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), siteConfig, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> updateConfigurationSlotAsync(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig) {
        return this.updateConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, siteConfig).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner updateConfigurationSlot(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig) {
        return (SiteConfigResourceInner)((Object)this.updateConfigurationSlotAsync(resourceGroupName, name, slot, siteConfig).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> updateConfigurationSlotWithResponse(String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig, Context context) {
        return (Response)this.updateConfigurationSlotWithResponseAsync(resourceGroupName, name, slot, siteConfig, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigurationSnapshotInfoInner>> listConfigurationSnapshotInfoSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listConfigurationSnapshotInfoSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).value(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<SiteConfigurationSnapshotInfoInner>> listConfigurationSnapshotInfoSlotSinglePageAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listConfigurationSnapshotInfoSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).value(), ((SiteConfigurationSnapshotInfoCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoSlotAsync(String resourceGroupName, String name, String slot) {
        return new PagedFlux(() -> this.listConfigurationSnapshotInfoSlotSinglePageAsync(resourceGroupName, name, slot), nextLink -> this.listConfigurationSnapshotInfoSlotNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoSlotAsync(String resourceGroupName, String name, String slot, Context context) {
        return new PagedFlux(() -> this.listConfigurationSnapshotInfoSlotSinglePageAsync(resourceGroupName, name, slot, context), nextLink -> this.listConfigurationSnapshotInfoSlotNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoSlot(String resourceGroupName, String name, String slot) {
        return new PagedIterable(this.listConfigurationSnapshotInfoSlotAsync(resourceGroupName, name, slot));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoSlot(String resourceGroupName, String name, String slot, Context context) {
        return new PagedIterable(this.listConfigurationSnapshotInfoSlotAsync(resourceGroupName, name, slot, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotSlotWithResponseAsync(String resourceGroupName, String name, String snapshotId, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getConfigurationSnapshotSlot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotSlotWithResponseAsync(String resourceGroupName, String name, String snapshotId, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getConfigurationSnapshotSlot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SiteConfigResourceInner> getConfigurationSnapshotSlotAsync(String resourceGroupName, String name, String snapshotId, String slot) {
        return this.getConfigurationSnapshotSlotWithResponseAsync(resourceGroupName, name, snapshotId, slot).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((SiteConfigResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SiteConfigResourceInner getConfigurationSnapshotSlot(String resourceGroupName, String name, String snapshotId, String slot) {
        return (SiteConfigResourceInner)((Object)this.getConfigurationSnapshotSlotAsync(resourceGroupName, name, snapshotId, slot).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SiteConfigResourceInner> getConfigurationSnapshotSlotWithResponse(String resourceGroupName, String name, String snapshotId, String slot, Context context) {
        return (Response)this.getConfigurationSnapshotSlotWithResponseAsync(resourceGroupName, name, snapshotId, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> recoverSiteConfigurationSnapshotSlotWithResponseAsync(String resourceGroupName, String name, String snapshotId, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.recoverSiteConfigurationSnapshotSlot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> recoverSiteConfigurationSnapshotSlotWithResponseAsync(String resourceGroupName, String name, String snapshotId, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (snapshotId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter snapshotId is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.recoverSiteConfigurationSnapshotSlot(this.client.getEndpoint(), resourceGroupName, name, snapshotId, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> recoverSiteConfigurationSnapshotSlotAsync(String resourceGroupName, String name, String snapshotId, String slot) {
        return this.recoverSiteConfigurationSnapshotSlotWithResponseAsync(resourceGroupName, name, snapshotId, slot).flatMap(res -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void recoverSiteConfigurationSnapshotSlot(String resourceGroupName, String name, String snapshotId, String slot) {
        this.recoverSiteConfigurationSnapshotSlotAsync(resourceGroupName, name, snapshotId, slot).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> recoverSiteConfigurationSnapshotSlotWithResponse(String resourceGroupName, String name, String snapshotId, String slot, Context context) {
        return (Response)this.recoverSiteConfigurationSnapshotSlotWithResponseAsync(resourceGroupName, name, snapshotId, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getWebSiteContainerLogsSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/octet-stream";
        return FluxUtil.withContext(context -> this.service.getWebSiteContainerLogsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/octet-stream", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getWebSiteContainerLogsSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/octet-stream";
        context = this.client.mergeContext(context);
        return this.service.getWebSiteContainerLogsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/octet-stream", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getWebSiteContainerLogsSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getWebSiteContainerLogsSlotWithResponseAsync(resourceGroupName, name, slot).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getWebSiteContainerLogsSlot(String resourceGroupName, String name, String slot) {
        final Iterator iterator = this.getWebSiteContainerLogsSlotAsync(resourceGroupName, name, slot).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getWebSiteContainerLogsSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (StreamResponse)this.getWebSiteContainerLogsSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StreamResponse> getContainerLogsZipSlotWithResponseAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/zip";
        return FluxUtil.withContext(context -> this.service.getContainerLogsZipSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/zip", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<StreamResponse> getContainerLogsZipSlotWithResponseAsync(String resourceGroupName, String name, String slot, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/zip";
        context = this.client.mergeContext(context);
        return this.service.getContainerLogsZipSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/zip", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Flux<ByteBuffer> getContainerLogsZipSlotAsync(String resourceGroupName, String name, String slot) {
        return this.getContainerLogsZipSlotWithResponseAsync(resourceGroupName, name, slot).flatMapMany(StreamResponse::getValue);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public InputStream getContainerLogsZipSlot(String resourceGroupName, String name, String slot) {
        final Iterator iterator = this.getContainerLogsZipSlotAsync(resourceGroupName, name, slot).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public StreamResponse getContainerLogsZipSlotWithResponse(String resourceGroupName, String name, String slot, Context context) {
        return (StreamResponse)this.getContainerLogsZipSlotWithResponseAsync(resourceGroupName, name, slot, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ContinuousWebJobInner>> listContinuousWebJobsSlotSinglePageAsync(String resourceGroupName, String name, String slot) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (name == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter name is required and cannot be null."));
        }
        if (slot == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter slot is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listContinuousWebJobsSlot(this.client.getEndpoint(), resourceGroupName, name, slot, this.client.getSubscriptionId(), this.client.getApiVersion(), "applicatio