/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironment;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AppServiceEnvironmentPatchResource
extends ProxyOnlyResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(AppServiceEnvironmentPatchResource.class);
    @JsonProperty(value="properties")
    private AppServiceEnvironment innerProperties;

    private AppServiceEnvironment innerProperties() {
        return this.innerProperties;
    }

    @Override
    public AppServiceEnvironmentPatchResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HostingEnvironmentStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public AppServiceEnvironmentPatchResource withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public LoadBalancingMode internalLoadBalancingMode() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancingMode();
    }

    public AppServiceEnvironmentPatchResource withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withInternalLoadBalancingMode(internalLoadBalancingMode);
        return this;
    }

    public String multiSize() {
        return this.innerProperties() == null ? null : this.innerProperties().multiSize();
    }

    public AppServiceEnvironmentPatchResource withMultiSize(String multiSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withMultiSize(multiSize);
        return this;
    }

    public Integer multiRoleCount() {
        return this.innerProperties() == null ? null : this.innerProperties().multiRoleCount();
    }

    public Integer ipsslAddressCount() {
        return this.innerProperties() == null ? null : this.innerProperties().ipsslAddressCount();
    }

    public AppServiceEnvironmentPatchResource withIpsslAddressCount(Integer ipsslAddressCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withIpsslAddressCount(ipsslAddressCount);
        return this;
    }

    public String dnsSuffix() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSuffix();
    }

    public AppServiceEnvironmentPatchResource withDnsSuffix(String dnsSuffix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withDnsSuffix(dnsSuffix);
        return this;
    }

    public Integer maximumNumberOfMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfMachines();
    }

    public Integer frontEndScaleFactor() {
        return this.innerProperties() == null ? null : this.innerProperties().frontEndScaleFactor();
    }

    public AppServiceEnvironmentPatchResource withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withFrontEndScaleFactor(frontEndScaleFactor);
        return this;
    }

    public Boolean suspended() {
        return this.innerProperties() == null ? null : this.innerProperties().suspended();
    }

    public List<NameValuePair> clusterSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterSettings();
    }

    public AppServiceEnvironmentPatchResource withClusterSettings(List<NameValuePair> clusterSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withClusterSettings(clusterSettings);
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().userWhitelistedIpRanges();
    }

    public AppServiceEnvironmentPatchResource withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withUserWhitelistedIpRanges(userWhitelistedIpRanges);
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().hasLinuxWorkers();
    }

    public Integer dedicatedHostCount() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedHostCount();
    }

    public AppServiceEnvironmentPatchResource withDedicatedHostCount(Integer dedicatedHostCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withDedicatedHostCount(dedicatedHostCount);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public AppServiceEnvironmentPatchResource withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironment();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

