// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** User resource specific properties. */
@Fluent
public final class UserProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(UserProperties.class);

    /*
     * Username used for publishing.
     */
    @JsonProperty(value = "publishingUserName", required = true)
    private String publishingUsername;

    /*
     * Password used for publishing.
     */
    @JsonProperty(value = "publishingPassword")
    private String publishingPassword;

    /*
     * Password hash used for publishing.
     */
    @JsonProperty(value = "publishingPasswordHash")
    private String publishingPasswordHash;

    /*
     * Password hash salt used for publishing.
     */
    @JsonProperty(value = "publishingPasswordHashSalt")
    private String publishingPasswordHashSalt;

    /*
     * Url of SCM site.
     */
    @JsonProperty(value = "scmUri")
    private String scmUri;

    /**
     * Get the publishingUsername property: Username used for publishing.
     *
     * @return the publishingUsername value.
     */
    public String publishingUsername() {
        return this.publishingUsername;
    }

    /**
     * Set the publishingUsername property: Username used for publishing.
     *
     * @param publishingUsername the publishingUsername value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingUsername(String publishingUsername) {
        this.publishingUsername = publishingUsername;
        return this;
    }

    /**
     * Get the publishingPassword property: Password used for publishing.
     *
     * @return the publishingPassword value.
     */
    public String publishingPassword() {
        return this.publishingPassword;
    }

    /**
     * Set the publishingPassword property: Password used for publishing.
     *
     * @param publishingPassword the publishingPassword value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingPassword(String publishingPassword) {
        this.publishingPassword = publishingPassword;
        return this;
    }

    /**
     * Get the publishingPasswordHash property: Password hash used for publishing.
     *
     * @return the publishingPasswordHash value.
     */
    public String publishingPasswordHash() {
        return this.publishingPasswordHash;
    }

    /**
     * Set the publishingPasswordHash property: Password hash used for publishing.
     *
     * @param publishingPasswordHash the publishingPasswordHash value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingPasswordHash(String publishingPasswordHash) {
        this.publishingPasswordHash = publishingPasswordHash;
        return this;
    }

    /**
     * Get the publishingPasswordHashSalt property: Password hash salt used for publishing.
     *
     * @return the publishingPasswordHashSalt value.
     */
    public String publishingPasswordHashSalt() {
        return this.publishingPasswordHashSalt;
    }

    /**
     * Set the publishingPasswordHashSalt property: Password hash salt used for publishing.
     *
     * @param publishingPasswordHashSalt the publishingPasswordHashSalt value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withPublishingPasswordHashSalt(String publishingPasswordHashSalt) {
        this.publishingPasswordHashSalt = publishingPasswordHashSalt;
        return this;
    }

    /**
     * Get the scmUri property: Url of SCM site.
     *
     * @return the scmUri value.
     */
    public String scmUri() {
        return this.scmUri;
    }

    /**
     * Set the scmUri property: Url of SCM site.
     *
     * @param scmUri the scmUri value to set.
     * @return the UserProperties object itself.
     */
    public UserProperties withScmUri(String scmUri) {
        this.scmUri = scmUri;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publishingUsername() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property publishingUsername in model UserProperties"));
        }
    }
}
