// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The GitHub action configuration. */
@Fluent
public final class GitHubActionConfiguration {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(GitHubActionConfiguration.class);

    /*
     * GitHub Action code configuration.
     */
    @JsonProperty(value = "codeConfiguration")
    private GitHubActionCodeConfiguration codeConfiguration;

    /*
     * GitHub Action container configuration.
     */
    @JsonProperty(value = "containerConfiguration")
    private GitHubActionContainerConfiguration containerConfiguration;

    /*
     * This will help determine the workflow configuration to select.
     */
    @JsonProperty(value = "isLinux")
    private Boolean isLinux;

    /*
     * Workflow option to determine whether the workflow file should be
     * generated and written to the repository.
     */
    @JsonProperty(value = "generateWorkflowFile")
    private Boolean generateWorkflowFile;

    /**
     * Get the codeConfiguration property: GitHub Action code configuration.
     *
     * @return the codeConfiguration value.
     */
    public GitHubActionCodeConfiguration codeConfiguration() {
        return this.codeConfiguration;
    }

    /**
     * Set the codeConfiguration property: GitHub Action code configuration.
     *
     * @param codeConfiguration the codeConfiguration value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration withCodeConfiguration(GitHubActionCodeConfiguration codeConfiguration) {
        this.codeConfiguration = codeConfiguration;
        return this;
    }

    /**
     * Get the containerConfiguration property: GitHub Action container configuration.
     *
     * @return the containerConfiguration value.
     */
    public GitHubActionContainerConfiguration containerConfiguration() {
        return this.containerConfiguration;
    }

    /**
     * Set the containerConfiguration property: GitHub Action container configuration.
     *
     * @param containerConfiguration the containerConfiguration value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration withContainerConfiguration(
        GitHubActionContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    /**
     * Get the isLinux property: This will help determine the workflow configuration to select.
     *
     * @return the isLinux value.
     */
    public Boolean isLinux() {
        return this.isLinux;
    }

    /**
     * Set the isLinux property: This will help determine the workflow configuration to select.
     *
     * @param isLinux the isLinux value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration withIsLinux(Boolean isLinux) {
        this.isLinux = isLinux;
        return this;
    }

    /**
     * Get the generateWorkflowFile property: Workflow option to determine whether the workflow file should be generated
     * and written to the repository.
     *
     * @return the generateWorkflowFile value.
     */
    public Boolean generateWorkflowFile() {
        return this.generateWorkflowFile;
    }

    /**
     * Set the generateWorkflowFile property: Workflow option to determine whether the workflow file should be generated
     * and written to the repository.
     *
     * @param generateWorkflowFile the generateWorkflowFile value to set.
     * @return the GitHubActionConfiguration object itself.
     */
    public GitHubActionConfiguration withGenerateWorkflowFile(Boolean generateWorkflowFile) {
        this.generateWorkflowFile = generateWorkflowFile;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (codeConfiguration() != null) {
            codeConfiguration().validate();
        }
        if (containerConfiguration() != null) {
            containerConfiguration().validate();
        }
    }
}
