// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ResponseMetadata model. */
@Fluent
public final class ResponseMetadata {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ResponseMetadata.class);

    /*
     * Source of the Data
     */
    @JsonProperty(value = "dataSource")
    private DataSource dataSource;

    /**
     * Get the dataSource property: Source of the Data.
     *
     * @return the dataSource value.
     */
    public DataSource dataSource() {
        return this.dataSource;
    }

    /**
     * Set the dataSource property: Source of the Data.
     *
     * @param dataSource the dataSource value to set.
     * @return the ResponseMetadata object itself.
     */
    public ResponseMetadata withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataSource() != null) {
            dataSource().validate();
        }
    }
}
