// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Traffic weight assigned to a revision. */
@Fluent
public final class TrafficWeight {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(TrafficWeight.class);

    /*
     * Name of a revision
     */
    @JsonProperty(value = "revisionName")
    private String revisionName;

    /*
     * Traffic weight assigned to a revision
     */
    @JsonProperty(value = "weight")
    private Integer weight;

    /*
     * Indicates that the traffic weight belongs to a latest stable revision
     */
    @JsonProperty(value = "latestRevision")
    private Boolean latestRevision;

    /**
     * Get the revisionName property: Name of a revision.
     *
     * @return the revisionName value.
     */
    public String revisionName() {
        return this.revisionName;
    }

    /**
     * Set the revisionName property: Name of a revision.
     *
     * @param revisionName the revisionName value to set.
     * @return the TrafficWeight object itself.
     */
    public TrafficWeight withRevisionName(String revisionName) {
        this.revisionName = revisionName;
        return this;
    }

    /**
     * Get the weight property: Traffic weight assigned to a revision.
     *
     * @return the weight value.
     */
    public Integer weight() {
        return this.weight;
    }

    /**
     * Set the weight property: Traffic weight assigned to a revision.
     *
     * @param weight the weight value to set.
     * @return the TrafficWeight object itself.
     */
    public TrafficWeight withWeight(Integer weight) {
        this.weight = weight;
        return this;
    }

    /**
     * Get the latestRevision property: Indicates that the traffic weight belongs to a latest stable revision.
     *
     * @return the latestRevision value.
     */
    public Boolean latestRevision() {
        return this.latestRevision;
    }

    /**
     * Set the latestRevision property: Indicates that the traffic weight belongs to a latest stable revision.
     *
     * @param latestRevision the latestRevision value to set.
     * @return the TrafficWeight object itself.
     */
    public TrafficWeight withLatestRevision(Boolean latestRevision) {
        this.latestRevision = latestRevision;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
