/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.DaprMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DaprComponent {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DaprComponent.class);
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="metadata")
    private List<DaprMetadata> metadata;

    public String name() {
        return this.name;
    }

    public DaprComponent withName(String name) {
        this.name = name;
        return this;
    }

    public String type() {
        return this.type;
    }

    public DaprComponent withType(String type) {
        this.type = type;
        return this;
    }

    public String version() {
        return this.version;
    }

    public DaprComponent withVersion(String version) {
        this.version = version;
        return this;
    }

    public List<DaprMetadata> metadata() {
        return this.metadata;
    }

    public DaprComponent withMetadata(List<DaprMetadata> metadata) {
        this.metadata = metadata;
        return this;
    }

    public void validate() {
        if (this.metadata() != null) {
            this.metadata().forEach(e -> e.validate());
        }
    }
}

