// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** SSL certificate email. */
@Fluent
public final class CertificateEmailInner extends ProxyOnlyResource {
    /*
     * CertificateEmail resource specific properties
     */
    @JsonProperty(value = "properties")
    private CertificateEmailProperties innerProperties;

    /**
     * Get the innerProperties property: CertificateEmail resource specific properties.
     *
     * @return the innerProperties value.
     */
    private CertificateEmailProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public CertificateEmailInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the emailId property: Email id.
     *
     * @return the emailId value.
     */
    public String emailId() {
        return this.innerProperties() == null ? null : this.innerProperties().emailId();
    }

    /**
     * Set the emailId property: Email id.
     *
     * @param emailId the emailId value to set.
     * @return the CertificateEmailInner object itself.
     */
    public CertificateEmailInner withEmailId(String emailId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateEmailProperties();
        }
        this.innerProperties().withEmailId(emailId);
        return this;
    }

    /**
     * Get the timestamp property: Time stamp.
     *
     * @return the timestamp value.
     */
    public OffsetDateTime timestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().timestamp();
    }

    /**
     * Set the timestamp property: Time stamp.
     *
     * @param timestamp the timestamp value to set.
     * @return the CertificateEmailInner object itself.
     */
    public CertificateEmailInner withTimestamp(OffsetDateTime timestamp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CertificateEmailProperties();
        }
        this.innerProperties().withTimestamp(timestamp);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
