// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.CertificateOrderActionType;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Certificate order action. */
@Fluent
public final class CertificateOrderActionInner extends ProxyOnlyResource {
    /*
     * CertificateOrderAction resource specific properties
     */
    @JsonProperty(value = "properties")
    private CertificateOrderActionProperties innerProperties;

    /**
     * Get the innerProperties property: CertificateOrderAction resource specific properties.
     *
     * @return the innerProperties value.
     */
    private CertificateOrderActionProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public CertificateOrderActionInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the actionType property: Action type.
     *
     * @return the actionType value.
     */
    public CertificateOrderActionType actionType() {
        return this.innerProperties() == null ? null : this.innerProperties().actionType();
    }

    /**
     * Get the createdAt property: Time at which the certificate action was performed.
     *
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAt();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
