// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Push settings for the App. */
@Fluent
public final class PushSettingsInner extends ProxyOnlyResource {
    /*
     * PushSettings resource specific properties
     */
    @JsonProperty(value = "properties")
    private PushSettingsProperties innerProperties;

    /**
     * Get the innerProperties property: PushSettings resource specific properties.
     *
     * @return the innerProperties value.
     */
    private PushSettingsProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public PushSettingsInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the isPushEnabled property: Gets or sets a flag indicating whether the Push endpoint is enabled.
     *
     * @return the isPushEnabled value.
     */
    public Boolean isPushEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().isPushEnabled();
    }

    /**
     * Set the isPushEnabled property: Gets or sets a flag indicating whether the Push endpoint is enabled.
     *
     * @param isPushEnabled the isPushEnabled value to set.
     * @return the PushSettingsInner object itself.
     */
    public PushSettingsInner withIsPushEnabled(Boolean isPushEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PushSettingsProperties();
        }
        this.innerProperties().withIsPushEnabled(isPushEnabled);
        return this;
    }

    /**
     * Get the tagWhitelistJson property: Gets or sets a JSON string containing a list of tags that are whitelisted for
     * use by the push registration endpoint.
     *
     * @return the tagWhitelistJson value.
     */
    public String tagWhitelistJson() {
        return this.innerProperties() == null ? null : this.innerProperties().tagWhitelistJson();
    }

    /**
     * Set the tagWhitelistJson property: Gets or sets a JSON string containing a list of tags that are whitelisted for
     * use by the push registration endpoint.
     *
     * @param tagWhitelistJson the tagWhitelistJson value to set.
     * @return the PushSettingsInner object itself.
     */
    public PushSettingsInner withTagWhitelistJson(String tagWhitelistJson) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PushSettingsProperties();
        }
        this.innerProperties().withTagWhitelistJson(tagWhitelistJson);
        return this;
    }

    /**
     * Get the tagsRequiringAuth property: Gets or sets a JSON string containing a list of tags that require user
     * authentication to be used in the push registration endpoint. Tags can consist of alphanumeric characters and the
     * following: '_', '@', '#', '.', ':', '-'. Validation should be performed at the PushRequestHandler.
     *
     * @return the tagsRequiringAuth value.
     */
    public String tagsRequiringAuth() {
        return this.innerProperties() == null ? null : this.innerProperties().tagsRequiringAuth();
    }

    /**
     * Set the tagsRequiringAuth property: Gets or sets a JSON string containing a list of tags that require user
     * authentication to be used in the push registration endpoint. Tags can consist of alphanumeric characters and the
     * following: '_', '@', '#', '.', ':', '-'. Validation should be performed at the PushRequestHandler.
     *
     * @param tagsRequiringAuth the tagsRequiringAuth value to set.
     * @return the PushSettingsInner object itself.
     */
    public PushSettingsInner withTagsRequiringAuth(String tagsRequiringAuth) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PushSettingsProperties();
        }
        this.innerProperties().withTagsRequiringAuth(tagsRequiringAuth);
        return this;
    }

    /**
     * Get the dynamicTagsJson property: Gets or sets a JSON string containing a list of dynamic tags that will be
     * evaluated from user claims in the push registration endpoint.
     *
     * @return the dynamicTagsJson value.
     */
    public String dynamicTagsJson() {
        return this.innerProperties() == null ? null : this.innerProperties().dynamicTagsJson();
    }

    /**
     * Set the dynamicTagsJson property: Gets or sets a JSON string containing a list of dynamic tags that will be
     * evaluated from user claims in the push registration endpoint.
     *
     * @param dynamicTagsJson the dynamicTagsJson value to set.
     * @return the PushSettingsInner object itself.
     */
    public PushSettingsInner withDynamicTagsJson(String dynamicTagsJson) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PushSettingsProperties();
        }
        this.innerProperties().withDynamicTagsJson(dynamicTagsJson);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
