// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.appservice.models.RevisionHealthState;
import com.azure.resourcemanager.appservice.models.RevisionProvisioningState;
import com.azure.resourcemanager.appservice.models.Template;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** Revision resource specific properties. */
@Immutable
public final class RevisionProperties {
    /*
     * Timestamp describing when the revision was created
     * by controller
     */
    @JsonProperty(value = "createdTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdTime;

    /*
     * Fully qualified domain name of the revision
     */
    @JsonProperty(value = "fqdn", access = JsonProperty.Access.WRITE_ONLY)
    private String fqdn;

    /*
     * Container App Revision Template with all possible settings and the
     * defaults if user did not provide them. The defaults are populated
     * as they were at the creation time
     */
    @JsonProperty(value = "template", access = JsonProperty.Access.WRITE_ONLY)
    private Template template;

    /*
     * Boolean describing if the Revision is Active
     */
    @JsonProperty(value = "active", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean active;

    /*
     * Number of pods currently running for this revision
     */
    @JsonProperty(value = "replicas", access = JsonProperty.Access.WRITE_ONLY)
    private Integer replicas;

    /*
     * Traffic weight assigned to this revision
     */
    @JsonProperty(value = "trafficWeight", access = JsonProperty.Access.WRITE_ONLY)
    private Integer trafficWeight;

    /*
     * Optional Field - Platform Error Message
     */
    @JsonProperty(value = "provisioningError", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningError;

    /*
     * Current health State of the revision
     */
    @JsonProperty(value = "healthState", access = JsonProperty.Access.WRITE_ONLY)
    private RevisionHealthState healthState;

    /*
     * Current provisioning State of the revision
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private RevisionProvisioningState provisioningState;

    /**
     * Get the createdTime property: Timestamp describing when the revision was created by controller.
     *
     * @return the createdTime value.
     */
    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    /**
     * Get the fqdn property: Fully qualified domain name of the revision.
     *
     * @return the fqdn value.
     */
    public String fqdn() {
        return this.fqdn;
    }

    /**
     * Get the template property: Container App Revision Template with all possible settings and the defaults if user
     * did not provide them. The defaults are populated as they were at the creation time.
     *
     * @return the template value.
     */
    public Template template() {
        return this.template;
    }

    /**
     * Get the active property: Boolean describing if the Revision is Active.
     *
     * @return the active value.
     */
    public Boolean active() {
        return this.active;
    }

    /**
     * Get the replicas property: Number of pods currently running for this revision.
     *
     * @return the replicas value.
     */
    public Integer replicas() {
        return this.replicas;
    }

    /**
     * Get the trafficWeight property: Traffic weight assigned to this revision.
     *
     * @return the trafficWeight value.
     */
    public Integer trafficWeight() {
        return this.trafficWeight;
    }

    /**
     * Get the provisioningError property: Optional Field - Platform Error Message.
     *
     * @return the provisioningError value.
     */
    public String provisioningError() {
        return this.provisioningError;
    }

    /**
     * Get the healthState property: Current health State of the revision.
     *
     * @return the healthState value.
     */
    public RevisionHealthState healthState() {
        return this.healthState;
    }

    /**
     * Get the provisioningState property: Current provisioning State of the revision.
     *
     * @return the provisioningState value.
     */
    public RevisionProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (template() != null) {
            template().validate();
        }
    }
}
