// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.TriggerTypes;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Static Site Function Overview ARM resource. */
@Fluent
public final class StaticSiteFunctionOverviewArmResourceInner extends ProxyOnlyResource {
    /*
     * StaticSiteFunctionOverviewARMResource resource specific properties
     */
    @JsonProperty(value = "properties")
    private StaticSiteFunctionOverviewArmResourceProperties innerProperties;

    /**
     * Get the innerProperties property: StaticSiteFunctionOverviewARMResource resource specific properties.
     *
     * @return the innerProperties value.
     */
    private StaticSiteFunctionOverviewArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public StaticSiteFunctionOverviewArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the functionName property: The name for the function.
     *
     * @return the functionName value.
     */
    public String functionName() {
        return this.innerProperties() == null ? null : this.innerProperties().functionName();
    }

    /**
     * Get the triggerType property: The trigger type of the function.
     *
     * @return the triggerType value.
     */
    public TriggerTypes triggerType() {
        return this.innerProperties() == null ? null : this.innerProperties().triggerType();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
