/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.AppServiceManager;
import com.azure.resourcemanager.appservice.fluent.CertificatesClient;
import com.azure.resourcemanager.appservice.fluent.WebSiteManagementClient;
import com.azure.resourcemanager.appservice.fluent.models.CertificateInner;
import com.azure.resourcemanager.appservice.implementation.Utils;
import com.azure.resourcemanager.appservice.models.AppServiceCertificate;
import com.azure.resourcemanager.appservice.models.AppServiceCertificateOrder;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Mono;

class AppServiceCertificateImpl
extends GroupableResourceImpl<AppServiceCertificate, CertificateInner, AppServiceCertificateImpl, AppServiceManager>
implements AppServiceCertificate,
AppServiceCertificate.Definition {
    private final ClientLogger logger = new ClientLogger(this.getClass());
    private String pfxFileUrl;
    private AppServiceCertificateOrder certificateOrder;

    AppServiceCertificateImpl(String name, CertificateInner innerObject, AppServiceManager manager) {
        super(name, (Resource)innerObject, (Manager)manager);
    }

    @Override
    public String friendlyName() {
        return ((CertificateInner)((Object)this.innerModel())).friendlyName();
    }

    @Override
    public String subjectName() {
        return ((CertificateInner)((Object)this.innerModel())).subjectName();
    }

    @Override
    public List<String> hostNames() {
        return Collections.unmodifiableList(((CertificateInner)((Object)this.innerModel())).hostNames());
    }

    @Override
    public byte[] pfxBlob() {
        return ((CertificateInner)((Object)this.innerModel())).pfxBlob();
    }

    @Override
    public String siteName() {
        return ((CertificateInner)((Object)this.innerModel())).siteName();
    }

    @Override
    public String selfLink() {
        return ((CertificateInner)((Object)this.innerModel())).selfLink();
    }

    @Override
    public String issuer() {
        return ((CertificateInner)((Object)this.innerModel())).issuer();
    }

    @Override
    public OffsetDateTime issueDate() {
        return ((CertificateInner)((Object)this.innerModel())).issueDate();
    }

    @Override
    public OffsetDateTime expirationDate() {
        return ((CertificateInner)((Object)this.innerModel())).expirationDate();
    }

    @Override
    public String password() {
        return ((CertificateInner)((Object)this.innerModel())).password();
    }

    @Override
    public String thumbprint() {
        return ((CertificateInner)((Object)this.innerModel())).thumbprint();
    }

    @Override
    public Boolean valid() {
        return ((CertificateInner)((Object)this.innerModel())).valid();
    }

    @Override
    public byte[] certificateBlob() {
        return ((CertificateInner)((Object)this.innerModel())).cerBlob();
    }

    @Override
    public String publicKeyHash() {
        return ((CertificateInner)((Object)this.innerModel())).publicKeyHash();
    }

    @Override
    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return ((CertificateInner)((Object)this.innerModel())).hostingEnvironmentProfile();
    }

    protected Mono<CertificateInner> getInnerAsync() {
        return ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getCertificates().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Mono<AppServiceCertificate> createResourceAsync() {
        Mono pfxBytes = Mono.empty();
        if (this.pfxFileUrl != null) {
            pfxBytes = Utils.downloadFileAsync(this.pfxFileUrl, ((AppServiceManager)this.manager()).httpPipeline()).map(bytes -> {
                ((CertificateInner)((Object)((Object)this.innerModel()))).withPfxBlob((byte[])bytes);
                return null;
            });
        }
        Mono keyVaultBinding = Mono.empty();
        if (this.certificateOrder != null) {
            keyVaultBinding = this.certificateOrder.getKeyVaultBindingAsync().map(keyVaultBinding1 -> {
                ((CertificateInner)((Object)((Object)this.innerModel()))).withKeyVaultId(keyVaultBinding1.keyVaultId()).withKeyVaultSecretName(keyVaultBinding1.keyVaultSecretName());
                return null;
            });
        }
        CertificatesClient client = ((WebSiteManagementClient)((AppServiceManager)this.manager()).serviceClient()).getCertificates();
        return pfxBytes.then(keyVaultBinding).then(client.createOrUpdateAsync(this.resourceGroupName(), this.name(), (CertificateInner)((Object)this.innerModel()))).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public AppServiceCertificateImpl withPfxFile(File file) {
        try {
            byte[] fileContent = Files.readAllBytes(file.toPath());
            return this.withPfxByteArray(fileContent);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new RuntimeException(e));
        }
    }

    @Override
    public AppServiceCertificateImpl withPfxByteArray(byte[] pfxByteArray) {
        ((CertificateInner)((Object)this.innerModel())).withPfxBlob(pfxByteArray);
        return this;
    }

    @Override
    public AppServiceCertificateImpl withPfxFileFromUrl(String url) {
        this.pfxFileUrl = url;
        return this;
    }

    @Override
    public AppServiceCertificateImpl withExistingCertificateOrder(AppServiceCertificateOrder certificateOrder) {
        this.certificateOrder = certificateOrder;
        return this;
    }

    @Override
    public AppServiceCertificateImpl withPfxPassword(String password) {
        ((CertificateInner)((Object)this.innerModel())).withPassword(password);
        return this;
    }
}

