// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.appservice.fluent.models.ApiKVReferenceInner;
import com.azure.resourcemanager.appservice.fluent.models.AzureStoragePropertyDictionaryResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.BackupItemInner;
import com.azure.resourcemanager.appservice.fluent.models.BackupRequestInner;
import com.azure.resourcemanager.appservice.fluent.models.ConnectionStringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.ContinuousWebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmPublishingCredentialsPoliciesEntityInner;
import com.azure.resourcemanager.appservice.fluent.models.CsmUsageQuotaInner;
import com.azure.resourcemanager.appservice.fluent.models.CustomHostnameAnalysisResultInner;
import com.azure.resourcemanager.appservice.fluent.models.DeploymentInner;
import com.azure.resourcemanager.appservice.fluent.models.FunctionEnvelopeInner;
import com.azure.resourcemanager.appservice.fluent.models.FunctionSecretsInner;
import com.azure.resourcemanager.appservice.fluent.models.HostKeysInner;
import com.azure.resourcemanager.appservice.fluent.models.HostnameBindingInner;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionInner;
import com.azure.resourcemanager.appservice.fluent.models.IdentifierInner;
import com.azure.resourcemanager.appservice.fluent.models.KeyInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployLogInner;
import com.azure.resourcemanager.appservice.fluent.models.MSDeployStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.MigrateMySqlStatusInner;
import com.azure.resourcemanager.appservice.fluent.models.NetworkFeaturesInner;
import com.azure.resourcemanager.appservice.fluent.models.NetworkTraceInner;
import com.azure.resourcemanager.appservice.fluent.models.OperationInner;
import com.azure.resourcemanager.appservice.fluent.models.PerfMonResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.PremierAddOnInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateAccessInner;
import com.azure.resourcemanager.appservice.fluent.models.PrivateLinkResourcesWrapperInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessModuleInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.ProcessThreadInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.PublicCertificateInner;
import com.azure.resourcemanager.appservice.fluent.models.PushSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.RelayServiceConnectionEntityInner;
import com.azure.resourcemanager.appservice.fluent.models.RemotePrivateEndpointConnectionArmResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.RestoreRequestInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsV2Inner;
import com.azure.resourcemanager.appservice.fluent.models.SiteCloneabilityInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteConfigurationSnapshotInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteExtensionInfoInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePatchResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SitePhpErrorLogFlagInner;
import com.azure.resourcemanager.appservice.fluent.models.SiteSourceControlInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotConfigNamesResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.SlotDifferenceInner;
import com.azure.resourcemanager.appservice.fluent.models.SnapshotInner;
import com.azure.resourcemanager.appservice.fluent.models.StorageMigrationResponseInner;
import com.azure.resourcemanager.appservice.fluent.models.StringDictionaryInner;
import com.azure.resourcemanager.appservice.fluent.models.SwiftVirtualNetworkInner;
import com.azure.resourcemanager.appservice.fluent.models.TriggeredJobHistoryInner;
import com.azure.resourcemanager.appservice.fluent.models.TriggeredWebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.UserInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetGatewayInner;
import com.azure.resourcemanager.appservice.fluent.models.VnetInfoResourceInner;
import com.azure.resourcemanager.appservice.fluent.models.WebJobInner;
import com.azure.resourcemanager.appservice.fluent.models.WebSiteInstanceStatusInner;
import com.azure.resourcemanager.appservice.models.CsmPublishingProfileOptions;
import com.azure.resourcemanager.appservice.models.CsmSlotEntity;
import com.azure.resourcemanager.appservice.models.DeletedAppRestoreRequest;
import com.azure.resourcemanager.appservice.models.MSDeploy;
import com.azure.resourcemanager.appservice.models.MigrateMySqlRequest;
import com.azure.resourcemanager.appservice.models.PremierAddOnPatchResource;
import com.azure.resourcemanager.appservice.models.PrivateLinkConnectionApprovalRequestResource;
import com.azure.resourcemanager.appservice.models.SnapshotRestoreRequest;
import com.azure.resourcemanager.appservice.models.StorageMigrationOptions;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in WebAppsClient. */
public interface WebAppsClient
    extends InnerSupportsGet<SiteInner>, InnerSupportsListing<SiteInner>, InnerSupportsDelete<Void> {
    /**
     * Description for Get all apps for a subscription.
     *
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listAsync();

    /**
     * Description for Get all apps for a subscription.
     *
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> list();

    /**
     * Description for Get all apps for a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> list(Context context);

    /**
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default
     *     is false, which only gives you the production slot of all apps.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName, Boolean includeSlots);

    /**
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listByResourceGroup(String resourceGroupName);

    /**
     * Description for Gets all web, mobile, and API apps in the specified resource group.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param includeSlots Specify &lt;strong&gt;true&lt;/strong&gt; to include deployment slots in results. The default
     *     is false, which only gives you the production slot of all apps.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listByResourceGroup(String resourceGroupName, Boolean includeSlots, Context context);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteInner> getByResourceGroupAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner getByResourceGroup(String resourceGroupName, String name);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteInner> getByResourceGroupWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String name, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String name, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdate(
        String resourceGroupName, String name, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdate(
        String resourceGroupName, String name, SiteInner siteEnvelope, Context context);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteInner> createOrUpdateAsync(String resourceGroupName, String name, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner createOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner createOrUpdate(String resourceGroupName, String name, SiteInner siteEnvelope, Context context);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     *     Service plan is deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(
        String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     *     Service plan is deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String name);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     *     Service plan is deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(
        String resourceGroupName, String name, Boolean deleteMetrics, Boolean deleteEmptyServerFarm, Context context);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteInner>> updateWithResponseAsync(
        String resourceGroupName, String name, SitePatchResourceInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteInner> updateAsync(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner update(String resourceGroupName, String name, SitePatchResourceInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteInner> updateWithResponse(
        String resourceGroupName, String name, SitePatchResourceInner siteEnvelope, Context context);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostname Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameWithResponseAsync(
        String resourceGroupName, String name, String hostname);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostname Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(
        String resourceGroupName, String name, String hostname);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameAsync(String resourceGroupName, String name);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomHostnameAnalysisResultInner analyzeCustomHostname(String resourceGroupName, String name);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param hostname Custom hostname.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CustomHostnameAnalysisResultInner> analyzeCustomHostnameWithResponse(
        String resourceGroupName, String name, String hostname, Context context);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> applySlotConfigToProductionWithResponseAsync(
        String resourceGroupName, String name, CsmSlotEntity slotSwapEntity);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> applySlotConfigToProductionAsync(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void applySlotConfigToProduction(String resourceGroupName, String name, CsmSlotEntity slotSwapEntity);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> applySlotConfigToProductionWithResponse(
        String resourceGroupName, String name, CsmSlotEntity slotSwapEntity, Context context);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupItemInner>> backupWithResponseAsync(
        String resourceGroupName, String name, BackupRequestInner request);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupItemInner> backupAsync(String resourceGroupName, String name, BackupRequestInner request);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupItemInner backup(String resourceGroupName, String name, BackupRequestInner request);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupItemInner> backupWithResponse(
        String resourceGroupName, String name, BackupRequestInner request, Context context);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<BackupItemInner> listBackupsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BackupItemInner> listBackups(String resourceGroupName, String name);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BackupItemInner> listBackups(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupItemInner>> getBackupStatusWithResponseAsync(
        String resourceGroupName, String name, String backupId);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupItemInner> getBackupStatusAsync(String resourceGroupName, String name, String backupId);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupItemInner getBackupStatus(String resourceGroupName, String name, String backupId);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupItemInner> getBackupStatusWithResponse(
        String resourceGroupName, String name, String backupId, Context context);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteBackupWithResponseAsync(String resourceGroupName, String name, String backupId);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteBackupAsync(String resourceGroupName, String name, String backupId);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteBackup(String resourceGroupName, String name, String backupId);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteBackupWithResponse(String resourceGroupName, String name, String backupId, Context context);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupItemInner>> listBackupStatusSecretsWithResponseAsync(
        String resourceGroupName, String name, String backupId, BackupRequestInner request);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupItemInner> listBackupStatusSecretsAsync(
        String resourceGroupName, String name, String backupId, BackupRequestInner request);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupItemInner listBackupStatusSecrets(
        String resourceGroupName, String name, String backupId, BackupRequestInner request);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param request Information on backup request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupItemInner> listBackupStatusSecretsWithResponse(
        String resourceGroupName, String name, String backupId, BackupRequestInner request, Context context);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restoreWithResponseAsync(
        String resourceGroupName, String name, String backupId, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRestoreAsync(
        String resourceGroupName, String name, String backupId, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestore(
        String resourceGroupName, String name, String backupId, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestore(
        String resourceGroupName, String name, String backupId, RestoreRequestInner request, Context context);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restoreAsync(String resourceGroupName, String name, String backupId, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restore(String resourceGroupName, String name, String backupId, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restore(String resourceGroupName, String name, String backupId, RestoreRequestInner request, Context context);

    /**
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesAsync(
        String resourceGroupName, String name);

    /**
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPolicies(
        String resourceGroupName, String name);

    /**
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPolicies(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowedWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedAsync(String resourceGroupName, String name);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner getFtpAllowed(String resourceGroupName, String name);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedWithResponseAsync(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedAsync(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner updateFtpAllowed(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedWithResponse(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
        Context context);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowedWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedAsync(String resourceGroupName, String name);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner getScmAllowed(String resourceGroupName, String name);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedWithResponseAsync(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedAsync(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner updateScmAllowed(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedWithResponse(
        String resourceGroupName,
        String name,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
        Context context);

    /**
     * Description for List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteConfigResourceInner> listConfigurationsAsync(String resourceGroupName, String name);

    /**
     * Description for List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigResourceInner> listConfigurations(String resourceGroupName, String name);

    /**
     * Description for List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigResourceInner> listConfigurations(String resourceGroupName, String name, Context context);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> updateApplicationSettingsWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> updateApplicationSettingsAsync(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner updateApplicationSettings(
        String resourceGroupName, String name, StringDictionaryInner appSettings);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettings Application settings of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> updateApplicationSettingsWithResponse(
        String resourceGroupName, String name, StringDictionaryInner appSettings, Context context);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listApplicationSettingsWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listApplicationSettingsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listApplicationSettings(String resourceGroupName, String name);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listApplicationSettingsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsWithResponseAsync(
        String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsInner> updateAuthSettingsAsync(
        String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsInner updateAuthSettings(
        String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettings Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsInner> updateAuthSettingsWithResponse(
        String resourceGroupName, String name, SiteAuthSettingsInner siteAuthSettings, Context context);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsInner>> getAuthSettingsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsInner> getAuthSettingsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsInner getAuthSettings(String resourceGroupName, String name);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsInner> getAuthSettingsWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithoutSecretsWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsV2Inner getAuthSettingsV2WithoutSecrets(String resourceGroupName, String name);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2WithResponseAsync(
        String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsV2Inner> updateAuthSettingsV2Async(
        String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsV2Inner updateAuthSettingsV2(
        String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsV2Inner> updateAuthSettingsV2WithResponse(
        String resourceGroupName, String name, SiteAuthSettingsV2Inner siteAuthSettingsV2, Context context);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2Async(String resourceGroupName, String name);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsV2Inner getAuthSettingsV2(String resourceGroupName, String name);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsV2Inner> getAuthSettingsV2WithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsWithResponseAsync(
        String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsAsync(
        String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AzureStoragePropertyDictionaryResourceInner updateAzureStorageAccounts(
        String resourceGroupName, String name, AzureStoragePropertyDictionaryResourceInner azureStorageAccounts);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsWithResponse(
        String resourceGroupName,
        String name,
        AzureStoragePropertyDictionaryResourceInner azureStorageAccounts,
        Context context);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AzureStoragePropertyDictionaryResourceInner listAzureStorageAccounts(String resourceGroupName, String name);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupRequestInner>> updateBackupConfigurationWithResponseAsync(
        String resourceGroupName, String name, BackupRequestInner request);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupRequestInner> updateBackupConfigurationAsync(
        String resourceGroupName, String name, BackupRequestInner request);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupRequestInner updateBackupConfiguration(String resourceGroupName, String name, BackupRequestInner request);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Edited backup configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupRequestInner> updateBackupConfigurationWithResponse(
        String resourceGroupName, String name, BackupRequestInner request, Context context);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteBackupConfigurationWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteBackupConfigurationAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteBackupConfiguration(String resourceGroupName, String name);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteBackupConfigurationWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupRequestInner>> getBackupConfigurationWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupRequestInner> getBackupConfigurationAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupRequestInner getBackupConfiguration(String resourceGroupName, String name);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupRequestInner> getBackupConfigurationWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferences(String resourceGroupName, String name);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferences(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceWithResponseAsync(
        String resourceGroupName, String name, String appSettingKey);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApiKVReferenceInner> getAppSettingKeyVaultReferenceAsync(
        String resourceGroupName, String name, String appSettingKey);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiKVReferenceInner getAppSettingKeyVaultReference(String resourceGroupName, String name, String appSettingKey);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApiKVReferenceInner> getAppSettingKeyVaultReferenceWithResponse(
        String resourceGroupName, String name, String appSettingKey, Context context);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferences(String resourceGroupName, String name);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferences(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceWithResponseAsync(
        String resourceGroupName, String name, String connectionStringKey);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceAsync(
        String resourceGroupName, String name, String connectionStringKey);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiKVReferenceInner getSiteConnectionStringKeyVaultReference(
        String resourceGroupName, String name, String connectionStringKey);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceWithResponse(
        String resourceGroupName, String name, String connectionStringKey, Context context);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsWithResponseAsync(
        String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionStringDictionaryInner> updateConnectionStringsAsync(
        String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionStringDictionaryInner updateConnectionStrings(
        String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ConnectionStringDictionaryInner> updateConnectionStringsWithResponse(
        String resourceGroupName, String name, ConnectionStringDictionaryInner connectionStrings, Context context);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ConnectionStringDictionaryInner>> listConnectionStringsWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionStringDictionaryInner> listConnectionStringsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionStringDictionaryInner listConnectionStrings(String resourceGroupName, String name);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ConnectionStringDictionaryInner> listConnectionStringsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteLogsConfigInner> getDiagnosticLogsConfigurationAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteLogsConfigInner getDiagnosticLogsConfiguration(String resourceGroupName, String name);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteLogsConfigInner> getDiagnosticLogsConfigurationWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigWithResponseAsync(
        String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteLogsConfigInner> updateDiagnosticLogsConfigAsync(
        String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteLogsConfigInner updateDiagnosticLogsConfig(
        String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteLogsConfigInner> updateDiagnosticLogsConfigWithResponse(
        String resourceGroupName, String name, SiteLogsConfigInner siteLogsConfig, Context context);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> updateMetadataWithResponseAsync(
        String resourceGroupName, String name, StringDictionaryInner metadata);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> updateMetadataAsync(
        String resourceGroupName, String name, StringDictionaryInner metadata);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner updateMetadata(String resourceGroupName, String name, StringDictionaryInner metadata);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> updateMetadataWithResponse(
        String resourceGroupName, String name, StringDictionaryInner metadata, Context context);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listMetadataWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listMetadataAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listMetadata(String resourceGroupName, String name);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listMetadataWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentials(String resourceGroupName, String name);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentials(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<UserInner> listPublishingCredentialsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserInner listPublishingCredentials(String resourceGroupName, String name);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserInner listPublishingCredentials(String resourceGroupName, String name, Context context);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PushSettingsInner>> updateSitePushSettingsWithResponseAsync(
        String resourceGroupName, String name, PushSettingsInner pushSettings);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PushSettingsInner> updateSitePushSettingsAsync(
        String resourceGroupName, String name, PushSettingsInner pushSettings);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PushSettingsInner updateSitePushSettings(String resourceGroupName, String name, PushSettingsInner pushSettings);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param pushSettings Push settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PushSettingsInner> updateSitePushSettingsWithResponse(
        String resourceGroupName, String name, PushSettingsInner pushSettings, Context context);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PushSettingsInner>> listSitePushSettingsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PushSettingsInner> listSitePushSettingsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PushSettingsInner listSitePushSettings(String resourceGroupName, String name);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PushSettingsInner> listSitePushSettingsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SlotConfigNamesResourceInner>> listSlotConfigurationNamesWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SlotConfigNamesResourceInner> listSlotConfigurationNamesAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SlotConfigNamesResourceInner listSlotConfigurationNames(String resourceGroupName, String name);

    /**
     * Description for Gets the names of app settings and connection strings that stick to the slot (not swapped).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SlotConfigNamesResourceInner> listSlotConfigurationNamesWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SlotConfigNamesResourceInner>> updateSlotConfigurationNamesWithResponseAsync(
        String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames);

    /**
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SlotConfigNamesResourceInner> updateSlotConfigurationNamesAsync(
        String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames);

    /**
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SlotConfigNamesResourceInner updateSlotConfigurationNames(
        String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames);

    /**
     * Description for Updates the names of application settings and connection string that remain with the slot during
     * swap operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slotConfigNames Names of application settings and connection strings. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return slot Config names azure resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SlotConfigNamesResourceInner> updateSlotConfigurationNamesWithResponse(
        String resourceGroupName, String name, SlotConfigNamesResourceInner slotConfigNames, Context context);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> getConfigurationWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> getConfigurationAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner getConfiguration(String resourceGroupName, String name);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> getConfigurationWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> createOrUpdateConfigurationWithResponseAsync(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> createOrUpdateConfigurationAsync(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner createOrUpdateConfiguration(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> createOrUpdateConfigurationWithResponse(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig, Context context);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> updateConfigurationWithResponseAsync(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> updateConfigurationAsync(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner updateConfiguration(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> updateConfigurationWithResponse(
        String resourceGroupName, String name, SiteConfigResourceInner siteConfig, Context context);

    /**
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     *     with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     *     with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfo(
        String resourceGroupName, String name);

    /**
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     *     with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfo(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotWithResponseAsync(
        String resourceGroupName, String name, String snapshotId);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> getConfigurationSnapshotAsync(
        String resourceGroupName, String name, String snapshotId);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner getConfigurationSnapshot(String resourceGroupName, String name, String snapshotId);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> getConfigurationSnapshotWithResponse(
        String resourceGroupName, String name, String snapshotId, Context context);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> recoverSiteConfigurationSnapshotWithResponseAsync(
        String resourceGroupName, String name, String snapshotId);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> recoverSiteConfigurationSnapshotAsync(String resourceGroupName, String name, String snapshotId);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void recoverSiteConfigurationSnapshot(String resourceGroupName, String name, String snapshotId);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> recoverSiteConfigurationSnapshotWithResponse(
        String resourceGroupName, String name, String snapshotId, Context context);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StreamResponse> getWebSiteContainerLogsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Flux<ByteBuffer> getWebSiteContainerLogsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InputStream getWebSiteContainerLogs(String resourceGroupName, String name);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StreamResponse getWebSiteContainerLogsWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StreamResponse> getContainerLogsZipWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Flux<ByteBuffer> getContainerLogsZipAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InputStream getContainerLogsZip(String resourceGroupName, String name);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StreamResponse getContainerLogsZipWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ContinuousWebJobInner> listContinuousWebJobsAsync(String resourceGroupName, String name);

    /**
     * Description for List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContinuousWebJobInner> listContinuousWebJobs(String resourceGroupName, String name);

    /**
     * Description for List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContinuousWebJobInner> listContinuousWebJobs(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ContinuousWebJobInner>> getContinuousWebJobWithResponseAsync(
        String resourceGroupName, String name, String webJobName);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ContinuousWebJobInner> getContinuousWebJobAsync(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContinuousWebJobInner getContinuousWebJob(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ContinuousWebJobInner> getContinuousWebJobWithResponse(
        String resourceGroupName, String name, String webJobName, Context context);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteContinuousWebJobWithResponseAsync(
        String resourceGroupName, String name, String webJobName);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteContinuousWebJobAsync(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteContinuousWebJob(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteContinuousWebJobWithResponse(
        String resourceGroupName, String name, String webJobName, Context context);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> startContinuousWebJobWithResponseAsync(
        String resourceGroupName, String name, String webJobName);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> startContinuousWebJobAsync(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void startContinuousWebJob(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> startContinuousWebJobWithResponse(
        String resourceGroupName, String name, String webJobName, Context context);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> stopContinuousWebJobWithResponseAsync(
        String resourceGroupName, String name, String webJobName);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> stopContinuousWebJobAsync(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stopContinuousWebJob(String resourceGroupName, String name, String webJobName);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> stopContinuousWebJobWithResponse(
        String resourceGroupName, String name, String webJobName, Context context);

    /**
     * Description for List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentInner> listDeploymentsAsync(String resourceGroupName, String name);

    /**
     * Description for List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentInner> listDeployments(String resourceGroupName, String name);

    /**
     * Description for List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentInner> listDeployments(String resourceGroupName, String name, Context context);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentInner>> getDeploymentWithResponseAsync(String resourceGroupName, String name, String id);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentInner> getDeploymentAsync(String resourceGroupName, String name, String id);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentInner getDeployment(String resourceGroupName, String name, String id);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentInner> getDeploymentWithResponse(
        String resourceGroupName, String name, String id, Context context);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentInner>> createDeploymentWithResponseAsync(
        String resourceGroupName, String name, String id, DeploymentInner deployment);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentInner> createDeploymentAsync(
        String resourceGroupName, String name, String id, DeploymentInner deployment);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentInner createDeployment(String resourceGroupName, String name, String id, DeploymentInner deployment);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param deployment Deployment details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentInner> createDeploymentWithResponse(
        String resourceGroupName, String name, String id, DeploymentInner deployment, Context context);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteDeploymentWithResponseAsync(String resourceGroupName, String name, String id);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDeploymentAsync(String resourceGroupName, String name, String id);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteDeployment(String resourceGroupName, String name, String id);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteDeploymentWithResponse(String resourceGroupName, String name, String id, Context context);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentInner>> listDeploymentLogWithResponseAsync(
        String resourceGroupName, String name, String id);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentInner> listDeploymentLogAsync(String resourceGroupName, String name, String id);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentInner listDeploymentLog(String resourceGroupName, String name, String id);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentInner> listDeploymentLogWithResponse(
        String resourceGroupName, String name, String id, Context context);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RestoreRequestInner>> discoverBackupWithResponseAsync(
        String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RestoreRequestInner> discoverBackupAsync(String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RestoreRequestInner discoverBackup(String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RestoreRequestInner> discoverBackupWithResponse(
        String resourceGroupName, String name, RestoreRequestInner request, Context context);

    /**
     * Description for Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<IdentifierInner> listDomainOwnershipIdentifiersAsync(String resourceGroupName, String name);

    /**
     * Description for Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<IdentifierInner> listDomainOwnershipIdentifiers(String resourceGroupName, String name);

    /**
     * Description for Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<IdentifierInner> listDomainOwnershipIdentifiers(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<IdentifierInner>> getDomainOwnershipIdentifierWithResponseAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<IdentifierInner> getDomainOwnershipIdentifierAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IdentifierInner getDomainOwnershipIdentifier(
        String resourceGroupName, String name, String domainOwnershipIdentifierName);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IdentifierInner> getDomainOwnershipIdentifierWithResponse(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, Context context);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierWithResponseAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<IdentifierInner> createOrUpdateDomainOwnershipIdentifierAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IdentifierInner createOrUpdateDomainOwnershipIdentifier(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IdentifierInner> createOrUpdateDomainOwnershipIdentifierWithResponse(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier,
        Context context);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteDomainOwnershipIdentifierWithResponseAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDomainOwnershipIdentifierAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteDomainOwnershipIdentifier(String resourceGroupName, String name, String domainOwnershipIdentifierName);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteDomainOwnershipIdentifierWithResponse(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, Context context);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<IdentifierInner>> updateDomainOwnershipIdentifierWithResponseAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<IdentifierInner> updateDomainOwnershipIdentifierAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IdentifierInner updateDomainOwnershipIdentifier(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IdentifierInner> updateDomainOwnershipIdentifierWithResponse(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        IdentifierInner domainOwnershipIdentifier,
        Context context);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MSDeployStatusInner>> getMSDeployStatusWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployStatusInner> getMSDeployStatusAsync(String resourceGroupName, String name);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner getMSDeployStatus(String resourceGroupName, String name);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MSDeployStatusInner> getMSDeployStatusWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createMSDeployOperationWithResponseAsync(
        String resourceGroupName, String name, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperationAsync(
        String resourceGroupName, String name, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperation(
        String resourceGroupName, String name, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperation(
        String resourceGroupName, String name, MSDeploy mSDeploy, Context context);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployStatusInner> createMSDeployOperationAsync(String resourceGroupName, String name, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner createMSDeployOperation(String resourceGroupName, String name, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param mSDeploy Details of MSDeploy operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner createMSDeployOperation(
        String resourceGroupName, String name, MSDeploy mSDeploy, Context context);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MSDeployLogInner>> getMSDeployLogWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployLogInner> getMSDeployLogAsync(String resourceGroupName, String name);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployLogInner getMSDeployLog(String resourceGroupName, String name);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MSDeployLogInner> getMSDeployLogWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Invoke onedeploy status API /api/deployments and gets the deployment status for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> getOneDeployStatusWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Invoke onedeploy status API /api/deployments and gets the deployment status for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> getOneDeployStatusAsync(String resourceGroupName, String name);

    /**
     * Description for Invoke onedeploy status API /api/deployments and gets the deployment status for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object getOneDeployStatus(String resourceGroupName, String name);

    /**
     * Description for Invoke onedeploy status API /api/deployments and gets the deployment status for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> getOneDeployStatusWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Invoke the OneDeploy publish web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> createOneDeployOperationWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Invoke the OneDeploy publish web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> createOneDeployOperationAsync(String resourceGroupName, String name);

    /**
     * Description for Invoke the OneDeploy publish web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object createOneDeployOperation(String resourceGroupName, String name);

    /**
     * Description for Invoke the OneDeploy publish web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> createOneDeployOperationWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu function information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FunctionEnvelopeInner> listFunctionsAsync(String resourceGroupName, String name);

    /**
     * Description for List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu function information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FunctionEnvelopeInner> listFunctions(String resourceGroupName, String name);

    /**
     * Description for List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu function information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FunctionEnvelopeInner> listFunctions(String resourceGroupName, String name, Context context);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<String>> getFunctionsAdminTokenWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> getFunctionsAdminTokenAsync(String resourceGroupName, String name);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String getFunctionsAdminToken(String resourceGroupName, String name);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<String> getFunctionsAdminTokenWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FunctionEnvelopeInner>> getFunctionWithResponseAsync(
        String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FunctionEnvelopeInner> getFunctionAsync(String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionEnvelopeInner getFunction(String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FunctionEnvelopeInner> getFunctionWithResponse(
        String resourceGroupName, String name, String functionName, Context context);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createFunctionWithResponseAsync(
        String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of function information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateFunctionAsync(
        String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of function information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateFunction(
        String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of function information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateFunction(
        String resourceGroupName,
        String name,
        String functionName,
        FunctionEnvelopeInner functionEnvelope,
        Context context);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FunctionEnvelopeInner> createFunctionAsync(
        String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionEnvelopeInner createFunction(
        String resourceGroupName, String name, String functionName, FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param functionEnvelope Function details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionEnvelopeInner createFunction(
        String resourceGroupName,
        String name,
        String functionName,
        FunctionEnvelopeInner functionEnvelope,
        Context context);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteFunctionWithResponseAsync(String resourceGroupName, String name, String functionName);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteFunctionAsync(String resourceGroupName, String name, String functionName);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteFunction(String resourceGroupName, String name, String functionName);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteFunctionWithResponse(
        String resourceGroupName, String name, String functionName, Context context);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<KeyInfoInner>> createOrUpdateFunctionSecretWithResponseAsync(
        String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<KeyInfoInner> createOrUpdateFunctionSecretAsync(
        String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    KeyInfoInner createOrUpdateFunctionSecret(
        String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<KeyInfoInner> createOrUpdateFunctionSecretWithResponse(
        String resourceGroupName, String name, String functionName, String keyName, KeyInfoInner key, Context context);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteFunctionSecretWithResponseAsync(
        String resourceGroupName, String name, String functionName, String keyName);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteFunctionSecretAsync(String resourceGroupName, String name, String functionName, String keyName);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteFunctionSecret(String resourceGroupName, String name, String functionName, String keyName);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteFunctionSecretWithResponse(
        String resourceGroupName, String name, String functionName, String keyName, Context context);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listFunctionKeysWithResponseAsync(
        String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listFunctionKeysAsync(String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listFunctionKeys(String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listFunctionKeysWithResponse(
        String resourceGroupName, String name, String functionName, Context context);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FunctionSecretsInner>> listFunctionSecretsWithResponseAsync(
        String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FunctionSecretsInner> listFunctionSecretsAsync(String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionSecretsInner listFunctionSecrets(String resourceGroupName, String name, String functionName);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FunctionSecretsInner> listFunctionSecretsWithResponse(
        String resourceGroupName, String name, String functionName, Context context);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HostKeysInner>> listHostKeysWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HostKeysInner> listHostKeysAsync(String resourceGroupName, String name);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HostKeysInner listHostKeys(String resourceGroupName, String name);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HostKeysInner> listHostKeysWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> listSyncStatusWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> listSyncStatusAsync(String resourceGroupName, String name);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void listSyncStatus(String resourceGroupName, String name);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> listSyncStatusWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Syncs function trigger metadata to the management database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> syncFunctionsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Syncs function trigger metadata to the management database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> syncFunctionsAsync(String resourceGroupName, String name);

    /**
     * Description for Syncs function trigger metadata to the management database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void syncFunctions(String resourceGroupName, String name);

    /**
     * Description for Syncs function trigger metadata to the management database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> syncFunctionsWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Add or update a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<KeyInfoInner>> createOrUpdateHostSecretWithResponseAsync(
        String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key);

    /**
     * Description for Add or update a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<KeyInfoInner> createOrUpdateHostSecretAsync(
        String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key);

    /**
     * Description for Add or update a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    KeyInfoInner createOrUpdateHostSecret(
        String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key);

    /**
     * Description for Add or update a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @param key The key to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<KeyInfoInner> createOrUpdateHostSecretWithResponse(
        String resourceGroupName, String name, String keyType, String keyName, KeyInfoInner key, Context context);

    /**
     * Description for Delete a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteHostSecretWithResponseAsync(
        String resourceGroupName, String name, String keyType, String keyName);

    /**
     * Description for Delete a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteHostSecretAsync(String resourceGroupName, String name, String keyType, String keyName);

    /**
     * Description for Delete a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteHostSecret(String resourceGroupName, String name, String keyType, String keyName);

    /**
     * Description for Delete a host level secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param keyType The type of host key.
     * @param keyName The name of the key.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteHostSecretWithResponse(
        String resourceGroupName, String name, String keyType, String keyName, Context context);

    /**
     * Description for Get hostname bindings for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<HostnameBindingInner> listHostnameBindingsAsync(String resourceGroupName, String name);

    /**
     * Description for Get hostname bindings for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<HostnameBindingInner> listHostnameBindings(String resourceGroupName, String name);

    /**
     * Description for Get hostname bindings for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of hostname bindings as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<HostnameBindingInner> listHostnameBindings(String resourceGroupName, String name, Context context);

    /**
     * Description for Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HostnameBindingInner>> getHostnameBindingWithResponseAsync(
        String resourceGroupName, String name, String hostname);

    /**
     * Description for Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HostnameBindingInner> getHostnameBindingAsync(String resourceGroupName, String name, String hostname);

    /**
     * Description for Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HostnameBindingInner getHostnameBinding(String resourceGroupName, String name, String hostname);

    /**
     * Description for Get the named hostname binding for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HostnameBindingInner> getHostnameBindingWithResponse(
        String resourceGroupName, String name, String hostname, Context context);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @param hostnameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HostnameBindingInner>> createOrUpdateHostnameBindingWithResponseAsync(
        String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @param hostnameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HostnameBindingInner> createOrUpdateHostnameBindingAsync(
        String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @param hostnameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HostnameBindingInner createOrUpdateHostnameBinding(
        String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @param hostnameBinding Binding details. This is the JSON representation of a HostNameBinding object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a hostname binding object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HostnameBindingInner> createOrUpdateHostnameBindingWithResponse(
        String resourceGroupName, String name, String hostname, HostnameBindingInner hostnameBinding, Context context);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteHostnameBindingWithResponseAsync(String resourceGroupName, String name, String hostname);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteHostnameBindingAsync(String resourceGroupName, String name, String hostname);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteHostnameBinding(String resourceGroupName, String name, String hostname);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param hostname Hostname in the hostname binding.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteHostnameBindingWithResponse(
        String resourceGroupName, String name, String hostname, Context context);

    /**
     * Description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionInner>> getHybridConnectionWithResponseAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionInner> getHybridConnectionAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionInner getHybridConnection(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Retrieves a specific Service Bus Hybrid Connection used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionInner> getHybridConnectionWithResponse(
        String resourceGroupName, String name, String namespaceName, String relayName, Context context);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionInner>> createOrUpdateHybridConnectionWithResponseAsync(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionInner> createOrUpdateHybridConnectionAsync(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionInner createOrUpdateHybridConnection(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionInner> createOrUpdateHybridConnectionWithResponse(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope,
        Context context);

    /**
     * Description for Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteHybridConnectionWithResponseAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteHybridConnectionAsync(
        String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteHybridConnection(String resourceGroupName, String name, String namespaceName, String relayName);

    /**
     * Description for Removes a Hybrid Connection from this site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteHybridConnectionWithResponse(
        String resourceGroupName, String name, String namespaceName, String relayName, Context context);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionInner>> updateHybridConnectionWithResponseAsync(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionInner> updateHybridConnectionAsync(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionInner updateHybridConnection(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope);

    /**
     * Description for Creates a new Hybrid Connection using a Service Bus relay.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param namespaceName The namespace for this hybrid connection.
     * @param relayName The relay name for this hybrid connection.
     * @param connectionEnvelope The details of the hybrid connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionInner> updateHybridConnectionWithResponse(
        String resourceGroupName,
        String name,
        String namespaceName,
        String relayName,
        HybridConnectionInner connectionEnvelope,
        Context context);

    /**
     * Description for Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HybridConnectionInner>> listHybridConnectionsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HybridConnectionInner> listHybridConnectionsAsync(String resourceGroupName, String name);

    /**
     * Description for Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HybridConnectionInner listHybridConnections(String resourceGroupName, String name);

    /**
     * Description for Retrieves all Service Bus Hybrid Connections used by this Web App.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HybridConnectionInner> listHybridConnectionsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RelayServiceConnectionEntityInner>> listRelayServiceConnectionsWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RelayServiceConnectionEntityInner> listRelayServiceConnectionsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RelayServiceConnectionEntityInner listRelayServiceConnections(String resourceGroupName, String name);

    /**
     * Description for Gets hybrid connections configured for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RelayServiceConnectionEntityInner> listRelayServiceConnectionsWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RelayServiceConnectionEntityInner>> getRelayServiceConnectionWithResponseAsync(
        String resourceGroupName, String name, String entityName);

    /**
     * Description for Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RelayServiceConnectionEntityInner> getRelayServiceConnectionAsync(
        String resourceGroupName, String name, String entityName);

    /**
     * Description for Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RelayServiceConnectionEntityInner getRelayServiceConnection(
        String resourceGroupName, String name, String entityName);

    /**
     * Description for Gets a hybrid connection configuration by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RelayServiceConnectionEntityInner> getRelayServiceConnectionWithResponse(
        String resourceGroupName, String name, String entityName, Context context);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RelayServiceConnectionEntityInner>> createOrUpdateRelayServiceConnectionWithResponseAsync(
        String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RelayServiceConnectionEntityInner> createOrUpdateRelayServiceConnectionAsync(
        String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RelayServiceConnectionEntityInner createOrUpdateRelayServiceConnection(
        String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RelayServiceConnectionEntityInner> createOrUpdateRelayServiceConnectionWithResponse(
        String resourceGroupName,
        String name,
        String entityName,
        RelayServiceConnectionEntityInner connectionEnvelope,
        Context context);

    /**
     * Description for Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteRelayServiceConnectionWithResponseAsync(
        String resourceGroupName, String name, String entityName);

    /**
     * Description for Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteRelayServiceConnectionAsync(String resourceGroupName, String name, String entityName);

    /**
     * Description for Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteRelayServiceConnection(String resourceGroupName, String name, String entityName);

    /**
     * Description for Deletes a relay service connection by its name.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteRelayServiceConnectionWithResponse(
        String resourceGroupName, String name, String entityName, Context context);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RelayServiceConnectionEntityInner>> updateRelayServiceConnectionWithResponseAsync(
        String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RelayServiceConnectionEntityInner> updateRelayServiceConnectionAsync(
        String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RelayServiceConnectionEntityInner updateRelayServiceConnection(
        String resourceGroupName, String name, String entityName, RelayServiceConnectionEntityInner connectionEnvelope);

    /**
     * Description for Creates a new hybrid connection configuration (PUT), or updates an existing one (PATCH).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param entityName Name of the hybrid connection configuration.
     * @param connectionEnvelope Details of the hybrid connection configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return hybrid Connection for an App Service app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RelayServiceConnectionEntityInner> updateRelayServiceConnectionWithResponse(
        String resourceGroupName,
        String name,
        String entityName,
        RelayServiceConnectionEntityInner connectionEnvelope,
        Context context);

    /**
     * Description for Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app instances as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<WebSiteInstanceStatusInner> listInstanceIdentifiersAsync(String resourceGroupName, String name);

    /**
     * Description for Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app instances as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<WebSiteInstanceStatusInner> listInstanceIdentifiers(String resourceGroupName, String name);

    /**
     * Description for Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app instances as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<WebSiteInstanceStatusInner> listInstanceIdentifiers(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param instanceId The instanceId parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<WebSiteInstanceStatusInner>> getInstanceInfoWithResponseAsync(
        String resourceGroupName, String name, String instanceId);

    /**
     * Description for Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param instanceId The instanceId parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<WebSiteInstanceStatusInner> getInstanceInfoAsync(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param instanceId The instanceId parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    WebSiteInstanceStatusInner getInstanceInfo(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Gets all scale-out instances of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param instanceId The instanceId parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<WebSiteInstanceStatusInner> getInstanceInfoWithResponse(
        String resourceGroupName, String name, String instanceId, Context context);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MSDeployStatusInner>> getInstanceMsDeployStatusWithResponseAsync(
        String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployStatusInner> getInstanceMsDeployStatusAsync(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner getInstanceMsDeployStatus(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MSDeployStatusInner> getInstanceMsDeployStatusWithResponse(
        String resourceGroupName, String name, String instanceId, Context context);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createInstanceMSDeployOperationWithResponseAsync(
        String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateInstanceMSDeployOperationAsync(
        String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateInstanceMSDeployOperation(
        String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateInstanceMSDeployOperation(
        String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, Context context);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployStatusInner> createInstanceMSDeployOperationAsync(
        String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner createInstanceMSDeployOperation(
        String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param mSDeploy Details of MSDeploy operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner createInstanceMSDeployOperation(
        String resourceGroupName, String name, String instanceId, MSDeploy mSDeploy, Context context);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MSDeployLogInner>> getInstanceMSDeployLogWithResponseAsync(
        String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployLogInner> getInstanceMSDeployLogAsync(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployLogInner getInstanceMSDeployLog(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param instanceId ID of web app instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MSDeployLogInner> getInstanceMSDeployLogWithResponse(
        String resourceGroupName, String name, String instanceId, Context context);

    /**
     * Description for Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance
     * in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu process information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProcessInfoInner> listInstanceProcessesAsync(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance
     * in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu process information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessInfoInner> listInstanceProcesses(String resourceGroupName, String name, String instanceId);

    /**
     * Description for Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance
     * in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu process information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessInfoInner> listInstanceProcesses(
        String resourceGroupName, String name, String instanceId, Context context);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProcessInfoInner>> getInstanceProcessWithResponseAsync(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProcessInfoInner> getInstanceProcessAsync(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProcessInfoInner getInstanceProcess(String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProcessInfoInner> getInstanceProcessWithResponse(
        String resourceGroupName, String name, String processId, String instanceId, Context context);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteInstanceProcessWithResponseAsync(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteInstanceProcessAsync(String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteInstanceProcess(String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteInstanceProcessWithResponse(
        String resourceGroupName, String name, String processId, String instanceId, Context context);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StreamResponse> getInstanceProcessDumpWithResponseAsync(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Flux<ByteBuffer> getInstanceProcessDumpAsync(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InputStream getInstanceProcessDump(String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StreamResponse getInstanceProcessDumpWithResponse(
        String resourceGroupName, String name, String processId, String instanceId, Context context);

    /**
     * Description for List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProcessModuleInfoInner> listInstanceProcessModulesAsync(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessModuleInfoInner> listInstanceProcessModules(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessModuleInfoInner> listInstanceProcessModules(
        String resourceGroupName, String name, String processId, String instanceId, Context context);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProcessModuleInfoInner>> getInstanceProcessModuleWithResponseAsync(
        String resourceGroupName, String name, String processId, String baseAddress, String instanceId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProcessModuleInfoInner> getInstanceProcessModuleAsync(
        String resourceGroupName, String name, String processId, String baseAddress, String instanceId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProcessModuleInfoInner getInstanceProcessModule(
        String resourceGroupName, String name, String processId, String baseAddress, String instanceId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProcessModuleInfoInner> getInstanceProcessModuleWithResponse(
        String resourceGroupName,
        String name,
        String processId,
        String baseAddress,
        String instanceId,
        Context context);

    /**
     * Description for List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProcessThreadInfoInner> listInstanceProcessThreadsAsync(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessThreadInfoInner> listInstanceProcessThreads(
        String resourceGroupName, String name, String processId, String instanceId);

    /**
     * Description for List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param instanceId ID of a specific scaled-out instance. This is the value of the name property in the JSON
     *     response from "GET api/sites/{siteName}/instances".
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessThreadInfoInner> listInstanceProcessThreads(
        String resourceGroupName, String name, String processId, String instanceId, Context context);

    /**
     * Description for Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents whether or not an app is cloneable along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteCloneabilityInner>> isCloneableWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents whether or not an app is cloneable on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteCloneabilityInner> isCloneableAsync(String resourceGroupName, String name);

    /**
     * Description for Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents whether or not an app is cloneable.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteCloneabilityInner isCloneable(String resourceGroupName, String name);

    /**
     * Description for Shows whether an app can be cloned to another resource group or subscription.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return represents whether or not an app is cloneable along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteCloneabilityInner> isCloneableWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<BackupItemInner> listSiteBackupsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BackupItemInner> listSiteBackups(String resourceGroupName, String name);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BackupItemInner> listSiteBackups(String resourceGroupName, String name, Context context);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FunctionSecretsInner>> listSyncFunctionTriggersWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FunctionSecretsInner> listSyncFunctionTriggersAsync(String resourceGroupName, String name);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionSecretsInner listSyncFunctionTriggers(String resourceGroupName, String name);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FunctionSecretsInner> listSyncFunctionTriggersWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Restores a web app.
     *
     * @param subscriptionName Azure subscription.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for a migration of app content request along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> migrateStorageWithResponseAsync(
        String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions);

    /**
     * Description for Restores a web app.
     *
     * @param subscriptionName Azure subscription.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response for a migration of app content request.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<StorageMigrationResponseInner>, StorageMigrationResponseInner> beginMigrateStorageAsync(
        String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions);

    /**
     * Description for Restores a web app.
     *
     * @param subscriptionName Azure subscription.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response for a migration of app content request.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageMigrationResponseInner>, StorageMigrationResponseInner> beginMigrateStorage(
        String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions);

    /**
     * Description for Restores a web app.
     *
     * @param subscriptionName Azure subscription.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationOptions Migration migrationOptions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response for a migration of app content request.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<StorageMigrationResponseInner>, StorageMigrationResponseInner> beginMigrateStorage(
        String subscriptionName,
        String resourceGroupName,
        String name,
        StorageMigrationOptions migrationOptions,
        Context context);

    /**
     * Description for Restores a web app.
     *
     * @param subscriptionName Azure subscription.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for a migration of app content request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StorageMigrationResponseInner> migrateStorageAsync(
        String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions);

    /**
     * Description for Restores a web app.
     *
     * @param subscriptionName Azure subscription.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationOptions Migration migrationOptions.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for a migration of app content request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageMigrationResponseInner migrateStorage(
        String subscriptionName, String resourceGroupName, String name, StorageMigrationOptions migrationOptions);

    /**
     * Description for Restores a web app.
     *
     * @param subscriptionName Azure subscription.
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationOptions Migration migrationOptions.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for a migration of app content request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StorageMigrationResponseInner migrateStorage(
        String subscriptionName,
        String resourceGroupName,
        String name,
        StorageMigrationOptions migrationOptions,
        Context context);

    /**
     * Description for Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> migrateMySqlWithResponseAsync(
        String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope);

    /**
     * Description for Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an operation on a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<OperationInner>, OperationInner> beginMigrateMySqlAsync(
        String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope);

    /**
     * Description for Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an operation on a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<OperationInner>, OperationInner> beginMigrateMySql(
        String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope);

    /**
     * Description for Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an operation on a resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<OperationInner>, OperationInner> beginMigrateMySql(
        String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, Context context);

    /**
     * Description for Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<OperationInner> migrateMySqlAsync(
        String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope);

    /**
     * Description for Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    OperationInner migrateMySql(String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope);

    /**
     * Description for Migrates a local (in-app) MySql database to a remote MySql database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param migrationRequestEnvelope MySql migration options.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an operation on a resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    OperationInner migrateMySql(
        String resourceGroupName, String name, MigrateMySqlRequest migrationRequestEnvelope, Context context);

    /**
     * Description for Returns the status of MySql in app migration, if one is active, and whether or not MySql in app
     * is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mySQL migration status along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MigrateMySqlStatusInner>> getMigrateMySqlStatusWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Returns the status of MySql in app migration, if one is active, and whether or not MySql in app
     * is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mySQL migration status on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MigrateMySqlStatusInner> getMigrateMySqlStatusAsync(String resourceGroupName, String name);

    /**
     * Description for Returns the status of MySql in app migration, if one is active, and whether or not MySql in app
     * is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mySQL migration status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MigrateMySqlStatusInner getMigrateMySqlStatus(String resourceGroupName, String name);

    /**
     * Description for Returns the status of MySql in app migration, if one is active, and whether or not MySql in app
     * is enabled.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mySQL migration status along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MigrateMySqlStatusInner> getMigrateMySqlStatusWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SwiftVirtualNetworkInner>> getSwiftVirtualNetworkConnectionWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SwiftVirtualNetworkInner> getSwiftVirtualNetworkConnectionAsync(String resourceGroupName, String name);

    /**
     * Description for Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SwiftVirtualNetworkInner getSwiftVirtualNetworkConnection(String resourceGroupName, String name);

    /**
     * Description for Gets a Swift Virtual Network connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SwiftVirtualNetworkInner> getSwiftVirtualNetworkConnectionWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SwiftVirtualNetworkInner>> createOrUpdateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SwiftVirtualNetworkInner> createOrUpdateSwiftVirtualNetworkConnectionWithCheckAsync(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SwiftVirtualNetworkInner createOrUpdateSwiftVirtualNetworkConnectionWithCheck(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SwiftVirtualNetworkInner> createOrUpdateSwiftVirtualNetworkConnectionWithCheckWithResponse(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, Context context);

    /**
     * Description for Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteSwiftVirtualNetworkWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSwiftVirtualNetworkAsync(String resourceGroupName, String name);

    /**
     * Description for Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSwiftVirtualNetwork(String resourceGroupName, String name);

    /**
     * Description for Deletes a Swift Virtual Network connection from an app (or deployment slot).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteSwiftVirtualNetworkWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SwiftVirtualNetworkInner>> updateSwiftVirtualNetworkConnectionWithCheckWithResponseAsync(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SwiftVirtualNetworkInner> updateSwiftVirtualNetworkConnectionWithCheckAsync(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SwiftVirtualNetworkInner updateSwiftVirtualNetworkConnectionWithCheck(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope);

    /**
     * Description for Integrates this Web App with a Virtual Network. This requires that 1) "swiftSupported" is true
     * when doing a GET against this resource, and 2) that the target Subnet has already been delegated, and is not in
     * use by another App Service Plan other than the one this App is in.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionEnvelope Properties of the Virtual Network connection. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return swift Virtual Network Contract along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SwiftVirtualNetworkInner> updateSwiftVirtualNetworkConnectionWithCheckWithResponse(
        String resourceGroupName, String name, SwiftVirtualNetworkInner connectionEnvelope, Context context);

    /**
     * Description for Gets all network features used by the app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param view The type of view. Only "summary" is supported at this time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return full view of network features for an app (presently VNET integration and Hybrid Connections) along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkFeaturesInner>> listNetworkFeaturesWithResponseAsync(
        String resourceGroupName, String name, String view);

    /**
     * Description for Gets all network features used by the app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param view The type of view. Only "summary" is supported at this time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return full view of network features for an app (presently VNET integration and Hybrid Connections) on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkFeaturesInner> listNetworkFeaturesAsync(String resourceGroupName, String name, String view);

    /**
     * Description for Gets all network features used by the app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param view The type of view. Only "summary" is supported at this time.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return full view of network features for an app (presently VNET integration and Hybrid Connections).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkFeaturesInner listNetworkFeatures(String resourceGroupName, String name, String view);

    /**
     * Description for Gets all network features used by the app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param view The type of view. Only "summary" is supported at this time.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return full view of network features for an app (presently VNET integration and Hybrid Connections) along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkFeaturesInner> listNetworkFeaturesWithResponse(
        String resourceGroupName, String name, String view, Context context);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> getNetworkTraceOperationWithResponseAsync(
        String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> getNetworkTraceOperationAsync(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object getNetworkTraceOperation(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> getNetworkTraceOperationWithResponse(
        String resourceGroupName, String name, String operationId, Context context);

    /**
     * Description for Start capturing network packets for the site (To be deprecated).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<String>> startWebSiteNetworkTraceWithResponseAsync(
        String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl);

    /**
     * Description for Start capturing network packets for the site (To be deprecated).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> startWebSiteNetworkTraceAsync(
        String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl);

    /**
     * Description for Start capturing network packets for the site (To be deprecated).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> startWebSiteNetworkTraceAsync(String resourceGroupName, String name);

    /**
     * Description for Start capturing network packets for the site (To be deprecated).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String startWebSiteNetworkTrace(String resourceGroupName, String name);

    /**
     * Description for Start capturing network packets for the site (To be deprecated).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<String> startWebSiteNetworkTraceWithResponse(
        String resourceGroupName,
        String name,
        Integer durationInSeconds,
        Integer maxFrameLength,
        String sasUrl,
        Context context);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> startWebSiteNetworkTraceOperationWithResponseAsync(
        String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Object>, Object> beginStartWebSiteNetworkTraceOperationAsync(
        String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Object>, Object> beginStartWebSiteNetworkTraceOperation(
        String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Object>, Object> beginStartWebSiteNetworkTraceOperation(
        String resourceGroupName,
        String name,
        Integer durationInSeconds,
        Integer maxFrameLength,
        String sasUrl,
        Context context);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> startWebSiteNetworkTraceOperationAsync(
        String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> startWebSiteNetworkTraceOperationAsync(String resourceGroupName, String name);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object startWebSiteNetworkTraceOperation(
        String resourceGroupName, String name, Integer durationInSeconds, Integer maxFrameLength, String sasUrl);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object startWebSiteNetworkTraceOperation(String resourceGroupName, String name);

    /**
     * Description for Start capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param durationInSeconds The duration to keep capturing in seconds.
     * @param maxFrameLength The maximum frame length in bytes (Optional).
     * @param sasUrl The Blob URL to store capture file.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object startWebSiteNetworkTraceOperation(
        String resourceGroupName,
        String name,
        Integer durationInSeconds,
        Integer maxFrameLength,
        String sasUrl,
        Context context);

    /**
     * Description for Stop ongoing capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> stopWebSiteNetworkTraceWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Stop ongoing capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> stopWebSiteNetworkTraceAsync(String resourceGroupName, String name);

    /**
     * Description for Stop ongoing capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stopWebSiteNetworkTrace(String resourceGroupName, String name);

    /**
     * Description for Stop ongoing capturing network packets for the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> stopWebSiteNetworkTraceWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<NetworkTraceInner>>> getNetworkTracesWithResponseAsync(
        String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<NetworkTraceInner>> getNetworkTracesAsync(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<NetworkTraceInner> getNetworkTraces(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<NetworkTraceInner>> getNetworkTracesWithResponse(
        String resourceGroupName, String name, String operationId, Context context);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> getNetworkTraceOperationV2WithResponseAsync(
        String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> getNetworkTraceOperationV2Async(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object getNetworkTraceOperationV2(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> getNetworkTraceOperationV2WithResponse(
        String resourceGroupName, String name, String operationId, Context context);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<List<NetworkTraceInner>>> getNetworkTracesV2WithResponseAsync(
        String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<NetworkTraceInner>> getNetworkTracesV2Async(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<NetworkTraceInner> getNetworkTracesV2(String resourceGroupName, String name, String operationId);

    /**
     * Description for Gets a named operation for a network trace capturing (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param operationId GUID of the operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return array of NetworkTrace along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<List<NetworkTraceInner>> getNetworkTracesV2WithResponse(
        String resourceGroupName, String name, String operationId, Context context);

    /**
     * Description for Generates a new publishing password for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> generateNewSitePublishingPasswordWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Generates a new publishing password for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> generateNewSitePublishingPasswordAsync(String resourceGroupName, String name);

    /**
     * Description for Generates a new publishing password for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void generateNewSitePublishingPassword(String resourceGroupName, String name);

    /**
     * Description for Generates a new publishing password for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> generateNewSitePublishingPasswordWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets perfmon counters for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
     *     $filter=(startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     *     duration'[Hour|Minute|Day]'.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of performance monitor counters as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PerfMonResponseInner> listPerfMonCountersAsync(String resourceGroupName, String name, String filter);

    /**
     * Description for Gets perfmon counters for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of performance monitor counters as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PerfMonResponseInner> listPerfMonCountersAsync(String resourceGroupName, String name);

    /**
     * Description for Gets perfmon counters for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of performance monitor counters as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PerfMonResponseInner> listPerfMonCounters(String resourceGroupName, String name);

    /**
     * Description for Gets perfmon counters for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param filter Return only usages/metrics specified in the filter. Filter conforms to odata syntax. Example:
     *     $filter=(startTime eq 2014-01-01T00:00:00Z and endTime eq 2014-12-31T23:59:59Z and timeGrain eq
     *     duration'[Hour|Minute|Day]'.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of performance monitor counters as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PerfMonResponseInner> listPerfMonCounters(
        String resourceGroupName, String name, String filter, Context context);

    /**
     * Description for Gets web app's event logs.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return used for getting PHP error logging flag along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SitePhpErrorLogFlagInner>> getSitePhpErrorLogFlagWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets web app's event logs.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return used for getting PHP error logging flag on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SitePhpErrorLogFlagInner> getSitePhpErrorLogFlagAsync(String resourceGroupName, String name);

    /**
     * Description for Gets web app's event logs.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return used for getting PHP error logging flag.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SitePhpErrorLogFlagInner getSitePhpErrorLogFlag(String resourceGroupName, String name);

    /**
     * Description for Gets web app's event logs.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return used for getting PHP error logging flag along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SitePhpErrorLogFlagInner> getSitePhpErrorLogFlagWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the premier add-ons of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PremierAddOnInner>> listPremierAddOnsWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the premier add-ons of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PremierAddOnInner> listPremierAddOnsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the premier add-ons of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PremierAddOnInner listPremierAddOns(String resourceGroupName, String name);

    /**
     * Description for Gets the premier add-ons of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PremierAddOnInner> listPremierAddOnsWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PremierAddOnInner>> getPremierAddOnWithResponseAsync(
        String resourceGroupName, String name, String premierAddOnName);

    /**
     * Description for Gets a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PremierAddOnInner> getPremierAddOnAsync(String resourceGroupName, String name, String premierAddOnName);

    /**
     * Description for Gets a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PremierAddOnInner getPremierAddOn(String resourceGroupName, String name, String premierAddOnName);

    /**
     * Description for Gets a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PremierAddOnInner> getPremierAddOnWithResponse(
        String resourceGroupName, String name, String premierAddOnName, Context context);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PremierAddOnInner>> addPremierAddOnWithResponseAsync(
        String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PremierAddOnInner> addPremierAddOnAsync(
        String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PremierAddOnInner addPremierAddOn(
        String resourceGroupName, String name, String premierAddOnName, PremierAddOnInner premierAddOn);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PremierAddOnInner> addPremierAddOnWithResponse(
        String resourceGroupName,
        String name,
        String premierAddOnName,
        PremierAddOnInner premierAddOn,
        Context context);

    /**
     * Description for Delete a premier add-on from an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deletePremierAddOnWithResponseAsync(
        String resourceGroupName, String name, String premierAddOnName);

    /**
     * Description for Delete a premier add-on from an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deletePremierAddOnAsync(String resourceGroupName, String name, String premierAddOnName);

    /**
     * Description for Delete a premier add-on from an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deletePremierAddOn(String resourceGroupName, String name, String premierAddOnName);

    /**
     * Description for Delete a premier add-on from an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deletePremierAddOnWithResponse(
        String resourceGroupName, String name, String premierAddOnName, Context context);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PremierAddOnInner>> updatePremierAddOnWithResponseAsync(
        String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PremierAddOnInner> updatePremierAddOnAsync(
        String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PremierAddOnInner updatePremierAddOn(
        String resourceGroupName, String name, String premierAddOnName, PremierAddOnPatchResource premierAddOn);

    /**
     * Description for Updates a named add-on of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param premierAddOnName Add-on name.
     * @param premierAddOn A JSON representation of the edited premier add-on.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return premier add-on along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PremierAddOnInner> updatePremierAddOnWithResponse(
        String resourceGroupName,
        String name,
        String premierAddOnName,
        PremierAddOnPatchResource premierAddOn,
        Context context);

    /**
     * Description for Gets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PrivateAccessInner>> getPrivateAccessWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Gets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateAccessInner> getPrivateAccessAsync(String resourceGroupName, String name);

    /**
     * Description for Gets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateAccessInner getPrivateAccess(String resourceGroupName, String name);

    /**
     * Description for Gets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PrivateAccessInner> getPrivateAccessWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Sets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param access The information for the private access.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PrivateAccessInner>> putPrivateAccessVnetWithResponseAsync(
        String resourceGroupName, String name, PrivateAccessInner access);

    /**
     * Description for Sets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param access The information for the private access.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateAccessInner> putPrivateAccessVnetAsync(
        String resourceGroupName, String name, PrivateAccessInner access);

    /**
     * Description for Sets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param access The information for the private access.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateAccessInner putPrivateAccessVnet(String resourceGroupName, String name, PrivateAccessInner access);

    /**
     * Description for Sets data around private site access enablement and authorized Virtual Networks that can access
     * the site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name The name of the web app.
     * @param access The information for the private access.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of the parameters of Private Access for a Web Site along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PrivateAccessInner> putPrivateAccessVnetWithResponse(
        String resourceGroupName, String name, PrivateAccessInner access, Context context);

    /**
     * Description for Gets the list of private endpoint connections associated with a site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionListAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the list of private endpoint connections associated with a site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(
        String resourceGroupName, String name);

    /**
     * Description for Gets the list of private endpoint connections associated with a site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionList(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RemotePrivateEndpointConnectionArmResourceInner>> getPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RemotePrivateEndpointConnectionArmResourceInner getPrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Gets a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName Name of the private endpoint connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RemotePrivateEndpointConnectionArmResourceInner> getPrivateEndpointConnectionWithResponse(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param privateEndpointWrapper Private Endpoint Connection Approval ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> approveOrRejectPrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param privateEndpointWrapper Private Endpoint Connection Approval ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<
            PollResult<RemotePrivateEndpointConnectionArmResourceInner>,
            RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnectionAsync(
            String resourceGroupName,
            String name,
            String privateEndpointConnectionName,
            PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param privateEndpointWrapper Private Endpoint Connection Approval ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<RemotePrivateEndpointConnectionArmResourceInner>,
            RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnection(
            String resourceGroupName,
            String name,
            String privateEndpointConnectionName,
            PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param privateEndpointWrapper Private Endpoint Connection Approval ARM resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<
            PollResult<RemotePrivateEndpointConnectionArmResourceInner>,
            RemotePrivateEndpointConnectionArmResourceInner>
        beginApproveOrRejectPrivateEndpointConnection(
            String resourceGroupName,
            String name,
            String privateEndpointConnectionName,
            PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper,
            Context context);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param privateEndpointWrapper Private Endpoint Connection Approval ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RemotePrivateEndpointConnectionArmResourceInner> approveOrRejectPrivateEndpointConnectionAsync(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param privateEndpointWrapper Private Endpoint Connection Approval ARM resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper);

    /**
     * Description for Approves or rejects a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param privateEndpointWrapper Private Endpoint Connection Approval ARM resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return remote Private Endpoint Connection ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RemotePrivateEndpointConnectionArmResourceInner approveOrRejectPrivateEndpointConnection(
        String resourceGroupName,
        String name,
        String privateEndpointConnectionName,
        PrivateLinkConnectionApprovalRequestResource privateEndpointWrapper,
        Context context);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deletePrivateEndpointConnectionWithResponseAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Object>, Object> beginDeletePrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of any object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Object>, Object> beginDeletePrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> deletePrivateEndpointConnectionAsync(
        String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object deletePrivateEndpointConnection(String resourceGroupName, String name, String privateEndpointConnectionName);

    /**
     * Description for Deletes a private endpoint connection.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param privateEndpointConnectionName The privateEndpointConnectionName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object deletePrivateEndpointConnection(
        String resourceGroupName, String name, String privateEndpointConnectionName, Context context);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources along with {@link Response} on successful completion
     *     of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PrivateLinkResourcesWrapperInner>> getPrivateLinkResourcesWithResponseAsync(
        String resourceGroupName, String name);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesAsync(String resourceGroupName, String name);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PrivateLinkResourcesWrapperInner getPrivateLinkResources(String resourceGroupName, String name);

    /**
     * Description for Gets the private link resources.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the site.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return wrapper for a collection of private link resources along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PrivateLinkResourcesWrapperInner> getPrivateLinkResourcesWithResponse(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance
     * in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu process information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProcessInfoInner> listProcessesAsync(String resourceGroupName, String name);

    /**
     * Description for Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance
     * in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu process information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessInfoInner> listProcesses(String resourceGroupName, String name);

    /**
     * Description for Get list of processes for a web site, or a deployment slot, or for a specific scaled-out instance
     * in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu process information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessInfoInner> listProcesses(String resourceGroupName, String name, Context context);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProcessInfoInner>> getProcessWithResponseAsync(
        String resourceGroupName, String name, String processId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProcessInfoInner> getProcessAsync(String resourceGroupName, String name, String processId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProcessInfoInner getProcess(String resourceGroupName, String name, String processId);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProcessInfoInner> getProcessWithResponse(
        String resourceGroupName, String name, String processId, Context context);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteProcessWithResponseAsync(String resourceGroupName, String name, String processId);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteProcessAsync(String resourceGroupName, String name, String processId);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteProcess(String resourceGroupName, String name, String processId);

    /**
     * Description for Terminate a process by its ID for a web site, or a deployment slot, or specific scaled-out
     * instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteProcessWithResponse(String resourceGroupName, String name, String processId, Context context);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StreamResponse> getProcessDumpWithResponseAsync(String resourceGroupName, String name, String processId);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Flux<ByteBuffer> getProcessDumpAsync(String resourceGroupName, String name, String processId);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InputStream getProcessDump(String resourceGroupName, String name, String processId);

    /**
     * Description for Get a memory dump of a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StreamResponse getProcessDumpWithResponse(String resourceGroupName, String name, String processId, Context context);

    /**
     * Description for List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProcessModuleInfoInner> listProcessModulesAsync(String resourceGroupName, String name, String processId);

    /**
     * Description for List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessModuleInfoInner> listProcessModules(String resourceGroupName, String name, String processId);

    /**
     * Description for List module information for a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessModuleInfoInner> listProcessModules(
        String resourceGroupName, String name, String processId, Context context);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProcessModuleInfoInner>> getProcessModuleWithResponseAsync(
        String resourceGroupName, String name, String processId, String baseAddress);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProcessModuleInfoInner> getProcessModuleAsync(
        String resourceGroupName, String name, String processId, String baseAddress);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProcessModuleInfoInner getProcessModule(
        String resourceGroupName, String name, String processId, String baseAddress);

    /**
     * Description for Get process information by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param baseAddress Module base address.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return process Module Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProcessModuleInfoInner> getProcessModuleWithResponse(
        String resourceGroupName, String name, String processId, String baseAddress, Context context);

    /**
     * Description for List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProcessThreadInfoInner> listProcessThreadsAsync(String resourceGroupName, String name, String processId);

    /**
     * Description for List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessThreadInfoInner> listProcessThreads(String resourceGroupName, String name, String processId);

    /**
     * Description for List the threads in a process by its ID for a specific scaled-out instance in a web site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param processId PID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu thread information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProcessThreadInfoInner> listProcessThreads(
        String resourceGroupName, String name, String processId, Context context);

    /**
     * Description for Get public certificates for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of public certificates as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<PublicCertificateInner> listPublicCertificatesAsync(String resourceGroupName, String name);

    /**
     * Description for Get public certificates for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of public certificates as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PublicCertificateInner> listPublicCertificates(String resourceGroupName, String name);

    /**
     * Description for Get public certificates for an app or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of public certificates as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<PublicCertificateInner> listPublicCertificates(
        String resourceGroupName, String name, Context context);

    /**
     * Description for Get the named public certificate for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PublicCertificateInner>> getPublicCertificateWithResponseAsync(
        String resourceGroupName, String name, String publicCertificateName);

    /**
     * Description for Get the named public certificate for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PublicCertificateInner> getPublicCertificateAsync(
        String resourceGroupName, String name, String publicCertificateName);

    /**
     * Description for Get the named public certificate for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PublicCertificateInner getPublicCertificate(String resourceGroupName, String name, String publicCertificateName);

    /**
     * Description for Get the named public certificate for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PublicCertificateInner> getPublicCertificateWithResponse(
        String resourceGroupName, String name, String publicCertificateName, Context context);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @param publicCertificate Public certificate details. This is the JSON representation of a PublicCertificate
     *     object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PublicCertificateInner>> createOrUpdatePublicCertificateWithResponseAsync(
        String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @param publicCertificate Public certificate details. This is the JSON representation of a PublicCertificate
     *     object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PublicCertificateInner> createOrUpdatePublicCertificateAsync(
        String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @param publicCertificate Public certificate details. This is the JSON representation of a PublicCertificate
     *     object.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PublicCertificateInner createOrUpdatePublicCertificate(
        String resourceGroupName, String name, String publicCertificateName, PublicCertificateInner publicCertificate);

    /**
     * Description for Creates a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @param publicCertificate Public certificate details. This is the JSON representation of a PublicCertificate
     *     object.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return public certificate object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PublicCertificateInner> createOrUpdatePublicCertificateWithResponse(
        String resourceGroupName,
        String name,
        String publicCertificateName,
        PublicCertificateInner publicCertificate,
        Context context);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deletePublicCertificateWithResponseAsync(
        String resourceGroupName, String name, String publicCertificateName);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deletePublicCertificateAsync(String resourceGroupName, String name, String publicCertificateName);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deletePublicCertificate(String resourceGroupName, String name, String publicCertificateName);

    /**
     * Description for Deletes a hostname binding for an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publicCertificateName Public certificate name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deletePublicCertificateWithResponse(
        String resourceGroupName, String name, String publicCertificateName, Context context);

    /**
     * Description for Gets the publishing profile for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publishingProfileOptions Specifies publishingProfileOptions for publishing profile. For example, use
     *     {"format": "FileZilla3"} to get a FileZilla publishing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StreamResponse> listPublishingProfileXmlWithSecretsWithResponseAsync(
        String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions);

    /**
     * Description for Gets the publishing profile for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publishingProfileOptions Specifies publishingProfileOptions for publishing profile. For example, use
     *     {"format": "FileZilla3"} to get a FileZilla publishing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Flux<ByteBuffer> listPublishingProfileXmlWithSecretsAsync(
        String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions);

    /**
     * Description for Gets the publishing profile for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publishingProfileOptions Specifies publishingProfileOptions for publishing profile. For example, use
     *     {"format": "FileZilla3"} to get a FileZilla publishing profile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InputStream listPublishingProfileXmlWithSecrets(
        String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions);

    /**
     * Description for Gets the publishing profile for an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param publishingProfileOptions Specifies publishingProfileOptions for publishing profile. For example, use
     *     {"format": "FileZilla3"} to get a FileZilla publishing profile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StreamResponse listPublishingProfileXmlWithSecretsWithResponse(
        String resourceGroupName, String name, CsmPublishingProfileOptions publishingProfileOptions, Context context);

    /**
     * Description for Resets the configuration settings of the current slot if they were previously modified by calling
     * the API with POST.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> resetProductionSlotConfigWithResponseAsync(String resourceGroupName, String name);

    /**
     * Description for Resets the configuration settings of the current slot if they were previously modified by calling
     * the API with POST.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> resetProductionSlotConfigAsync(String resourceGroupName, String name);

    /**
     * Description for Resets the configuration settings of the current slot if they were previously modified by calling
     * the API with POST.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetProductionSlotConfig(String resourceGroupName, String name);

    /**
     * Description for Resets the configuration settings of the current slot if they were previously modified by calling
     * the API with POST.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> resetProductionSlotConfigWithResponse(String resourceGroupName, String name, Context context);

    /**
     * Description for Restarts an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param softRestart Specify true to apply the configuration settings and restarts the app only if necessary. By
     *     default, the API always restarts and reprovisions the app.
     * @param synchronous Specify true to block until the app is restarted. By default, it is set to false, and the API
     *     responds immediately (asynchronous).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> restartWithResponseAsync(
        String resourceGroupName, String name, Boolean softRestart, Boolean synchronous);

    /**
     * Description for Restarts an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param softRestart Specify true to apply the configuration settings and restarts the app only if necessary. By
     *     default, the API always restarts and reprovisions the app.
     * @param synchronous Specify true to block until the app is restarted. By default, it is set to false, and the API
     *     responds immediately (asynchronous).
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restartAsync(String resourceGroupName, String name, Boolean softRestart, Boolean synchronous);

    /**
     * Description for Restarts an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restartAsync(String resourceGroupName, String name);

    /**
     * Description for Restarts an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restart(String resourceGroupName, String name);

    /**
     * Description for Restarts an app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param softRestart Specify true to apply the configuration settings and restarts the app only if necessary. By
     *     default, the API always restarts and reprovisions the app.
     * @param synchronous Specify true to block until the app is restarted. By default, it is set to false, and the API
     *     responds immediately (asynchronous).
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> restartWithResponse(
        String resourceGroupName, String name, Boolean softRestart, Boolean synchronous, Context context);

    /**
     * Description for Restores an app from a backup blob in Azure Storage.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restoreFromBackupBlobWithResponseAsync(
        String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Restores an app from a backup blob in Azure Storage.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRestoreFromBackupBlobAsync(
        String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Restores an app from a backup blob in Azure Storage.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreFromBackupBlob(
        String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Restores an app from a backup blob in Azure Storage.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreFromBackupBlob(
        String resourceGroupName, String name, RestoreRequestInner request, Context context);

    /**
     * Description for Restores an app from a backup blob in Azure Storage.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restoreFromBackupBlobAsync(String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Restores an app from a backup blob in Azure Storage.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreFromBackupBlob(String resourceGroupName, String name, RestoreRequestInner request);

    /**
     * Description for Restores an app from a backup blob in Azure Storage.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreFromBackupBlob(String resourceGroupName, String name, RestoreRequestInner request, Context context);

    /**
     * Description for Restores a deleted web app to this web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Deleted web app restore information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restoreFromDeletedAppWithResponseAsync(
        String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest);

    /**
     * Description for Restores a deleted web app to this web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Deleted web app restore information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRestoreFromDeletedAppAsync(
        String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest);

    /**
     * Description for Restores a deleted web app to this web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Deleted web app restore information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreFromDeletedApp(
        String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest);

    /**
     * Description for Restores a deleted web app to this web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Deleted web app restore information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreFromDeletedApp(
        String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest, Context context);

    /**
     * Description for Restores a deleted web app to this web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Deleted web app restore information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restoreFromDeletedAppAsync(
        String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest);

    /**
     * Description for Restores a deleted web app to this web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Deleted web app restore information.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreFromDeletedApp(String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest);

    /**
     * Description for Restores a deleted web app to this web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Deleted web app restore information.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreFromDeletedApp(
        String resourceGroupName, String name, DeletedAppRestoreRequest restoreRequest, Context context);

    /**
     * Description for Restores a web app from a snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Snapshot restore settings. Snapshot information can be obtained by calling GetDeletedSites
     *     or GetSiteSnapshots API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restoreSnapshotWithResponseAsync(
        String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest);

    /**
     * Description for Restores a web app from a snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Snapshot restore settings. Snapshot information can be obtained by calling GetDeletedSites
     *     or GetSiteSnapshots API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRestoreSnapshotAsync(
        String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest);

    /**
     * Description for Restores a web app from a snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Snapshot restore settings. Snapshot information can be obtained by calling GetDeletedSites
     *     or GetSiteSnapshots API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreSnapshot(
        String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest);

    /**
     * Description for Restores a web app from a snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Snapshot restore settings. Snapshot information can be obtained by calling GetDeletedSites
     *     or GetSiteSnapshots API.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreSnapshot(
        String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest, Context context);

    /**
     * Description for Restores a web app from a snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Snapshot restore settings. Snapshot information can be obtained by calling GetDeletedSites
     *     or GetSiteSnapshots API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restoreSnapshotAsync(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest);

    /**
     * Description for Restores a web app from a snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Snapshot restore settings. Snapshot information can be obtained by calling GetDeletedSites
     *     or GetSiteSnapshots API.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreSnapshot(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest);

    /**
     * Description for Restores a web app from a snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param restoreRequest Snapshot restore settings. Snapshot information can be obtained by calling GetDeletedSites
     *     or GetSiteSnapshots API.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreSnapshot(String resourceGroupName, String name, SnapshotRestoreRequest restoreRequest, Context context);

    /**
     * Description for Get list of siteextensions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu site extension information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteExtensionInfoInner> listSiteExtensionsAsync(String resourceGroupName, String name);

    /**
     * Description for Get list of siteextensions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu site extension information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteExtensionInfoInner> listSiteExtensions(String resourceGroupName, String name);

    /**
     * Description for Get list of siteextensions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu site extension information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteExtensionInfoInner> listSiteExtensions(String resourceGroupName, String name, Context context);

    /**
     * Description for Get site extension information by its ID for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteExtensionInfoInner>> getSiteExtensionWithResponseAsync(
        String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Get site extension information by its ID for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteExtensionInfoInner> getSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Get site extension information by its ID for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteExtensionInfoInner getSiteExtension(String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Get site extension information by its ID for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteExtensionInfoInner> getSiteExtensionWithResponse(
        String resourceGroupName, String name, String siteExtensionId, Context context);

    /**
     * Description for Install site extension on a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> installSiteExtensionWithResponseAsync(
        String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Install site extension on a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of site Extension Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<SiteExtensionInfoInner>, SiteExtensionInfoInner> beginInstallSiteExtensionAsync(
        String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Install site extension on a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of site Extension Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SiteExtensionInfoInner>, SiteExtensionInfoInner> beginInstallSiteExtension(
        String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Install site extension on a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of site Extension Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SiteExtensionInfoInner>, SiteExtensionInfoInner> beginInstallSiteExtension(
        String resourceGroupName, String name, String siteExtensionId, Context context);

    /**
     * Description for Install site extension on a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteExtensionInfoInner> installSiteExtensionAsync(
        String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Install site extension on a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteExtensionInfoInner installSiteExtension(String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Install site extension on a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site Extension Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteExtensionInfoInner installSiteExtension(
        String resourceGroupName, String name, String siteExtensionId, Context context);

    /**
     * Description for Remove a site extension from a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteSiteExtensionWithResponseAsync(
        String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Remove a site extension from a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSiteExtensionAsync(String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Remove a site extension from a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSiteExtension(String resourceGroupName, String name, String siteExtensionId);

    /**
     * Description for Remove a site extension from a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param siteExtensionId Site extension name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteSiteExtensionWithResponse(
        String resourceGroupName, String name, String siteExtensionId, Context context);

    /**
     * Description for Gets an app's deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteInner> listSlotsAsync(String resourceGroupName, String name);

    /**
     * Description for Gets an app's deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listSlots(String resourceGroupName, String name);

    /**
     * Description for Gets an app's deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of App Service apps as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteInner> listSlots(String resourceGroupName, String name, Context context);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. By default, this API returns the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteInner>> getSlotWithResponseAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. By default, this API returns the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteInner> getSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. By default, this API returns the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner getSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the details of a web, mobile, or API app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. By default, this API returns the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteInner> getSlotWithResponse(String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateSlotAsync(
        String resourceGroupName, String name, String slot, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateSlot(
        String resourceGroupName, String name, String slot, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SiteInner>, SiteInner> beginCreateOrUpdateSlot(
        String resourceGroupName, String name, String slot, SiteInner siteEnvelope, Context context);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteInner> createOrUpdateSlotAsync(String resourceGroupName, String name, String slot, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner createOrUpdateSlot(String resourceGroupName, String name, String slot, SiteInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner createOrUpdateSlot(
        String resourceGroupName, String name, String slot, SiteInner siteEnvelope, Context context);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param slot Name of the deployment slot to delete. By default, the API deletes the production slot.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     *     Service plan is deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, Boolean deleteMetrics, Boolean deleteEmptyServerFarm);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param slot Name of the deployment slot to delete. By default, the API deletes the production slot.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     *     Service plan is deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSlotAsync(
        String resourceGroupName, String name, String slot, Boolean deleteMetrics, Boolean deleteEmptyServerFarm);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param slot Name of the deployment slot to delete. By default, the API deletes the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param slot Name of the deployment slot to delete. By default, the API deletes the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Deletes a web, mobile, or API app, or one of the deployment slots.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app to delete.
     * @param slot Name of the deployment slot to delete. By default, the API deletes the production slot.
     * @param deleteMetrics If true, web app metrics are also deleted.
     * @param deleteEmptyServerFarm Specify false if you want to keep empty App Service plan. By default, empty App
     *     Service plan is deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteSlotWithResponse(
        String resourceGroupName,
        String name,
        String slot,
        Boolean deleteMetrics,
        Boolean deleteEmptyServerFarm,
        Context context);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteInner>> updateSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteInner> updateSlotAsync(
        String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteInner updateSlot(String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope);

    /**
     * Description for Creates a new web, mobile, or API app in an existing resource group, or updates an existing app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Unique name of the app to create or update. To create or update a deployment slot, use the {slot}
     *     parameter.
     * @param slot Name of the deployment slot to create or update. By default, this API attempts to create or modify
     *     the production slot.
     * @param siteEnvelope A JSON representation of the app properties. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a web app, a mobile app backend, or an API app along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteInner> updateSlotWithResponse(
        String resourceGroupName, String name, String slot, SitePatchResourceInner siteEnvelope, Context context);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param hostname Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CustomHostnameAnalysisResultInner>> analyzeCustomHostnameSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, String hostname);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param hostname Custom hostname.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameSlotAsync(
        String resourceGroupName, String name, String slot, String hostname);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CustomHostnameAnalysisResultInner> analyzeCustomHostnameSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CustomHostnameAnalysisResultInner analyzeCustomHostnameSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Analyze a custom hostname.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param hostname Custom hostname.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return custom domain analysis along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CustomHostnameAnalysisResultInner> analyzeCustomHostnameSlotWithResponse(
        String resourceGroupName, String name, String slot, String hostname, Context context);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the source slot. If a slot is not specified, the production slot is used as the source slot.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> applySlotConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the source slot. If a slot is not specified, the production slot is used as the source slot.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> applySlotConfigurationSlotAsync(
        String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the source slot. If a slot is not specified, the production slot is used as the source slot.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void applySlotConfigurationSlot(String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity);

    /**
     * Description for Applies the configuration settings from the target slot onto the current slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the source slot. If a slot is not specified, the production slot is used as the source slot.
     * @param slotSwapEntity JSON object that contains the target slot name. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> applySlotConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, CsmSlotEntity slotSwapEntity, Context context);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a backup for the
     *     production slot.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupItemInner>> backupSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, BackupRequestInner request);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a backup for the
     *     production slot.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupItemInner> backupSlotAsync(
        String resourceGroupName, String name, String slot, BackupRequestInner request);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a backup for the
     *     production slot.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupItemInner backupSlot(String resourceGroupName, String name, String slot, BackupRequestInner request);

    /**
     * Description for Creates a backup of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will create a backup for the
     *     production slot.
     * @param request Backup configuration. You can use the JSON response from the POST action as input here.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupItemInner> backupSlotWithResponse(
        String resourceGroupName, String name, String slot, BackupRequestInner request, Context context);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get backups of the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<BackupItemInner> listBackupsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get backups of the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BackupItemInner> listBackupsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets existing backups of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get backups of the production
     *     slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of backup items as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<BackupItemInner> listBackupsSlot(String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get a backup of the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupItemInner>> getBackupStatusSlotWithResponseAsync(
        String resourceGroupName, String name, String backupId, String slot);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get a backup of the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupItemInner> getBackupStatusSlotAsync(String resourceGroupName, String name, String backupId, String slot);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get a backup of the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupItemInner getBackupStatusSlot(String resourceGroupName, String name, String backupId, String slot);

    /**
     * Description for Gets a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get a backup of the production
     *     slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupItemInner> getBackupStatusSlotWithResponse(
        String resourceGroupName, String name, String backupId, String slot, Context context);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete a backup of the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteBackupSlotWithResponseAsync(
        String resourceGroupName, String name, String backupId, String slot);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete a backup of the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteBackupSlotAsync(String resourceGroupName, String name, String backupId, String slot);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete a backup of the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteBackupSlot(String resourceGroupName, String name, String backupId, String slot);

    /**
     * Description for Deletes a backup of an app by its ID.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete a backup of the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteBackupSlotWithResponse(
        String resourceGroupName, String name, String backupId, String slot, Context context);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupItemInner>> listBackupStatusSecretsSlotWithResponseAsync(
        String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupItemInner> listBackupStatusSecretsSlotAsync(
        String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param request Information on backup request.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupItemInner listBackupStatusSecretsSlot(
        String resourceGroupName, String name, String backupId, String slot, BackupRequestInner request);

    /**
     * Description for Gets status of a web app backup that may be in progress, including secrets associated with the
     * backup, such as the Azure Storage SAS URL. Also can be used to update the SAS URL for the backup if a new URL is
     * passed in the request body.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param backupId ID of backup.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param request Information on backup request.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return backup description along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupItemInner> listBackupStatusSecretsSlotWithResponse(
        String resourceGroupName,
        String name,
        String backupId,
        String slot,
        BackupRequestInner request,
        Context context);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will restore a backup of the
     *     production slot.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> restoreSlotWithResponseAsync(
        String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will restore a backup of the
     *     production slot.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRestoreSlotAsync(
        String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will restore a backup of the
     *     production slot.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreSlot(
        String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will restore a backup of the
     *     production slot.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRestoreSlot(
        String resourceGroupName,
        String name,
        String backupId,
        String slot,
        RestoreRequestInner request,
        Context context);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will restore a backup of the
     *     production slot.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> restoreSlotAsync(
        String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will restore a backup of the
     *     production slot.
     * @param request Information on restore request .
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreSlot(String resourceGroupName, String name, String backupId, String slot, RestoreRequestInner request);

    /**
     * Description for Restores a specific backup to another app (or deployment slot, if specified).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param backupId ID of the backup.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will restore a backup of the
     *     production slot.
     * @param request Information on restore request .
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void restoreSlot(
        String resourceGroupName,
        String name,
        String backupId,
        String slot,
        RestoreRequestInner request,
        Context context);

    /**
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesSlot(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether Scm basic auth is allowed and whether Ftp is allowed for a given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies entity collection ARM resource as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CsmPublishingCredentialsPoliciesEntityInner> listBasicPublishingCredentialsPoliciesSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getFtpAllowedSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner getFtpAllowedSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> getFtpAllowedSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateFtpAllowedSlotWithResponseAsync(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedSlotAsync(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner updateFtpAllowedSlot(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether FTP is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> updateFtpAllowedSlotWithResponse(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
        Context context);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> getScmAllowedSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner getScmAllowedSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Returns whether Scm basic auth is allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> getScmAllowedSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CsmPublishingCredentialsPoliciesEntityInner>> updateScmAllowedSlotWithResponseAsync(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedSlotAsync(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CsmPublishingCredentialsPoliciesEntityInner updateScmAllowedSlot(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity);

    /**
     * Description for Updates whether user publishing credentials are allowed on the site or not.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param csmPublishingAccessPoliciesEntity Publishing Credentials Policies parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return publishing Credentials Policies parameters along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CsmPublishingCredentialsPoliciesEntityInner> updateScmAllowedSlotWithResponse(
        String resourceGroupName,
        String name,
        String slot,
        CsmPublishingCredentialsPoliciesEntityInner csmPublishingAccessPoliciesEntity,
        Context context);

    /**
     * Description for List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteConfigResourceInner> listConfigurationsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigResourceInner> listConfigurationsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for List the configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of site configurations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigResourceInner> listConfigurationsSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the application settings
     *     for the production slot.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> updateApplicationSettingsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, StringDictionaryInner appSettings);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the application settings
     *     for the production slot.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> updateApplicationSettingsSlotAsync(
        String resourceGroupName, String name, String slot, StringDictionaryInner appSettings);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the application settings
     *     for the production slot.
     * @param appSettings Application settings of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner updateApplicationSettingsSlot(
        String resourceGroupName, String name, String slot, StringDictionaryInner appSettings);

    /**
     * Description for Replaces the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the application settings
     *     for the production slot.
     * @param appSettings Application settings of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> updateApplicationSettingsSlotWithResponse(
        String resourceGroupName, String name, String slot, StringDictionaryInner appSettings, Context context);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the application settings
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listApplicationSettingsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the application settings
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listApplicationSettingsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the application settings
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listApplicationSettingsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the application settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the application settings
     *     for the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listApplicationSettingsSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsInner>> updateAuthSettingsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsInner> updateAuthSettingsSlotAsync(
        String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettings Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsInner updateAuthSettingsSlot(
        String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings);

    /**
     * Description for Updates the Authentication / Authorization settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettings Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsInner> updateAuthSettingsSlotWithResponse(
        String resourceGroupName, String name, String slot, SiteAuthSettingsInner siteAuthSettings, Context context);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsInner>> getAuthSettingsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsInner> getAuthSettingsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsInner getAuthSettingsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Authentication/Authorization settings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization feature along with {@link
     *     Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsInner> getAuthSettingsSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site's Authentication / Authorization settings for apps via the V2 format along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2WithoutSecretsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site's Authentication / Authorization settings for apps via the V2 format on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site's Authentication / Authorization settings for apps via the V2 format.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsV2Inner getAuthSettingsV2WithoutSecretsSlot(String resourceGroupName, String name, String slot);

    /**
     * Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return site's Authentication / Authorization settings for apps via the V2 format along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsV2Inner> getAuthSettingsV2WithoutSecretsSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsV2Inner>> updateAuthSettingsV2SlotWithResponseAsync(
        String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsV2Inner> updateAuthSettingsV2SlotAsync(
        String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsV2Inner updateAuthSettingsV2Slot(
        String resourceGroupName, String name, String slot, SiteAuthSettingsV2Inner siteAuthSettingsV2);

    /**
     * Description for Updates site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param siteAuthSettingsV2 Auth settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsV2Inner> updateAuthSettingsV2SlotWithResponse(
        String resourceGroupName,
        String name,
        String slot,
        SiteAuthSettingsV2Inner siteAuthSettingsV2,
        Context context);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteAuthSettingsV2Inner>> getAuthSettingsV2SlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteAuthSettingsV2Inner> getAuthSettingsV2SlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteAuthSettingsV2Inner getAuthSettingsV2Slot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets site's Authentication / Authorization settings for apps via the V2 format.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the settings for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration settings for the Azure App Service Authentication / Authorization V2 feature along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteAuthSettingsV2Inner> getAuthSettingsV2SlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AzureStoragePropertyDictionaryResourceInner>> updateAzureStorageAccountsSlotWithResponseAsync(
        String resourceGroupName,
        String name,
        String slot,
        AzureStoragePropertyDictionaryResourceInner azureStorageAccounts);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsSlotAsync(
        String resourceGroupName,
        String name,
        String slot,
        AzureStoragePropertyDictionaryResourceInner azureStorageAccounts);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AzureStoragePropertyDictionaryResourceInner updateAzureStorageAccountsSlot(
        String resourceGroupName,
        String name,
        String slot,
        AzureStoragePropertyDictionaryResourceInner azureStorageAccounts);

    /**
     * Description for Updates the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @param azureStorageAccounts Azure storage accounts of the app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AzureStoragePropertyDictionaryResourceInner> updateAzureStorageAccountsSlotWithResponse(
        String resourceGroupName,
        String name,
        String slot,
        AzureStoragePropertyDictionaryResourceInner azureStorageAccounts,
        Context context);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<AzureStoragePropertyDictionaryResourceInner>> listAzureStorageAccountsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AzureStoragePropertyDictionaryResourceInner listAzureStorageAccountsSlot(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Azure storage account configurations of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the Azure storage
     *     account configurations for the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azureStorageInfo dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<AzureStoragePropertyDictionaryResourceInner> listAzureStorageAccountsSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the backup configuration
     *     for the production slot.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupRequestInner>> updateBackupConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, BackupRequestInner request);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the backup configuration
     *     for the production slot.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupRequestInner> updateBackupConfigurationSlotAsync(
        String resourceGroupName, String name, String slot, BackupRequestInner request);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the backup configuration
     *     for the production slot.
     * @param request Edited backup configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupRequestInner updateBackupConfigurationSlot(
        String resourceGroupName, String name, String slot, BackupRequestInner request);

    /**
     * Description for Updates the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the backup configuration
     *     for the production slot.
     * @param request Edited backup configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupRequestInner> updateBackupConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, BackupRequestInner request, Context context);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the backup configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteBackupConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the backup configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteBackupConfigurationSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the backup configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteBackupConfigurationSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Deletes the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the backup configuration
     *     for the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteBackupConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the backup configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<BackupRequestInner>> getBackupConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the backup configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BackupRequestInner> getBackupConfigurationSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the backup configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BackupRequestInner getBackupConfigurationSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the backup configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the backup configuration
     *     for the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a backup which will be performed along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<BackupRequestInner> getBackupConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesSlot(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getAppSettingsKeyVaultReferencesSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ApiKVReferenceInner>> getAppSettingKeyVaultReferenceSlotWithResponseAsync(
        String resourceGroupName, String name, String appSettingKey, String slot);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApiKVReferenceInner> getAppSettingKeyVaultReferenceSlotAsync(
        String resourceGroupName, String name, String appSettingKey, String slot);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiKVReferenceInner getAppSettingKeyVaultReferenceSlot(
        String resourceGroupName, String name, String appSettingKey, String slot);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param appSettingKey App Setting key name.
     * @param slot The slot parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApiKVReferenceInner> getAppSettingKeyVaultReferenceSlotWithResponse(
        String resourceGroupName, String name, String appSettingKey, String slot, Context context);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesSlot(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the config reference app settings and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot The slot parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferencesSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ApiKVReferenceInner>> getSiteConnectionStringKeyVaultReferenceSlotWithResponseAsync(
        String resourceGroupName, String name, String connectionStringKey, String slot);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceSlotAsync(
        String resourceGroupName, String name, String connectionStringKey, String slot);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @param slot The slot parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ApiKVReferenceInner getSiteConnectionStringKeyVaultReferenceSlot(
        String resourceGroupName, String name, String connectionStringKey, String slot);

    /**
     * Description for Gets the config reference and status of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param connectionStringKey The connectionStringKey parameter.
     * @param slot The slot parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of site key vault references along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ApiKVReferenceInner> getSiteConnectionStringKeyVaultReferenceSlotWithResponse(
        String resourceGroupName, String name, String connectionStringKey, String slot, Context context);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the connection settings
     *     for the production slot.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ConnectionStringDictionaryInner>> updateConnectionStringsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the connection settings
     *     for the production slot.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionStringDictionaryInner> updateConnectionStringsSlotAsync(
        String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the connection settings
     *     for the production slot.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionStringDictionaryInner updateConnectionStringsSlot(
        String resourceGroupName, String name, String slot, ConnectionStringDictionaryInner connectionStrings);

    /**
     * Description for Replaces the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the connection settings
     *     for the production slot.
     * @param connectionStrings Connection strings of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ConnectionStringDictionaryInner> updateConnectionStringsSlotWithResponse(
        String resourceGroupName,
        String name,
        String slot,
        ConnectionStringDictionaryInner connectionStrings,
        Context context);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the connection settings for
     *     the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ConnectionStringDictionaryInner>> listConnectionStringsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the connection settings for
     *     the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectionStringDictionaryInner> listConnectionStringsSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the connection settings for
     *     the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectionStringDictionaryInner listConnectionStringsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the connection strings of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the connection settings for
     *     the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ConnectionStringDictionaryInner> listConnectionStringsSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the logging configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteLogsConfigInner>> getDiagnosticLogsConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the logging configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteLogsConfigInner> getDiagnosticLogsConfigurationSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the logging configuration
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteLogsConfigInner getDiagnosticLogsConfigurationSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the logging configuration
     *     for the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteLogsConfigInner> getDiagnosticLogsConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the logging
     *     configuration for the production slot.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteLogsConfigInner>> updateDiagnosticLogsConfigSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the logging
     *     configuration for the production slot.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteLogsConfigInner> updateDiagnosticLogsConfigSlotAsync(
        String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the logging
     *     configuration for the production slot.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteLogsConfigInner updateDiagnosticLogsConfigSlot(
        String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig);

    /**
     * Description for Updates the logging configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the logging
     *     configuration for the production slot.
     * @param siteLogsConfig A SiteLogsConfig JSON object that contains the logging configuration to change in the
     *     "properties" property.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return configuration of App Service site logs along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteLogsConfigInner> updateDiagnosticLogsConfigSlotWithResponse(
        String resourceGroupName, String name, String slot, SiteLogsConfigInner siteLogsConfig, Context context);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the metadata for the
     *     production slot.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> updateMetadataSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, StringDictionaryInner metadata);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the metadata for the
     *     production slot.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> updateMetadataSlotAsync(
        String resourceGroupName, String name, String slot, StringDictionaryInner metadata);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the metadata for the
     *     production slot.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner updateMetadataSlot(
        String resourceGroupName, String name, String slot, StringDictionaryInner metadata);

    /**
     * Description for Replaces the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update the metadata for the
     *     production slot.
     * @param metadata Edited metadata of the app or deployment slot. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> updateMetadataSlotWithResponse(
        String resourceGroupName, String name, String slot, StringDictionaryInner metadata, Context context);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the metadata for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listMetadataSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the metadata for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listMetadataSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the metadata for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listMetadataSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the metadata of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the metadata for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listMetadataSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listPublishingCredentialsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<UserInner>, UserInner> beginListPublishingCredentialsSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentialsSlot(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials
     *     for the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<UserInner>, UserInner> beginListPublishingCredentialsSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<UserInner> listPublishingCredentialsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials
     *     for the production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserInner listPublishingCredentialsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Git/FTP publishing credentials of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will get the publishing credentials
     *     for the production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    UserInner listPublishingCredentialsSlot(String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PushSettingsInner>> updateSitePushSettingsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, PushSettingsInner pushSettings);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PushSettingsInner> updateSitePushSettingsSlotAsync(
        String resourceGroupName, String name, String slot, PushSettingsInner pushSettings);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param pushSettings Push settings associated with web app.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PushSettingsInner updateSitePushSettingsSlot(
        String resourceGroupName, String name, String slot, PushSettingsInner pushSettings);

    /**
     * Description for Updates the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param pushSettings Push settings associated with web app.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PushSettingsInner> updateSitePushSettingsSlotWithResponse(
        String resourceGroupName, String name, String slot, PushSettingsInner pushSettings, Context context);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<PushSettingsInner>> listSitePushSettingsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<PushSettingsInner> listSitePushSettingsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    PushSettingsInner listSitePushSettingsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the Push settings associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return push settings for the App along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<PushSettingsInner> listSitePushSettingsSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> getConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> getConfigurationSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner getConfigurationSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the configuration of an app, such as platform version and bitness, default documents,
     * virtual applications, Always On, etc.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> getConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> createOrUpdateConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> createOrUpdateConfigurationSlotAsync(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner createOrUpdateConfigurationSlot(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> createOrUpdateConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig, Context context);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> updateConfigurationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> updateConfigurationSlotAsync(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner updateConfigurationSlot(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig);

    /**
     * Description for Updates the configuration of an app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will update configuration for the
     *     production slot.
     * @param siteConfig JSON representation of a SiteConfig object. See example.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> updateConfigurationSlotWithResponse(
        String resourceGroupName, String name, String slot, SiteConfigResourceInner siteConfig, Context context);

    /**
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     *     with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     *     with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoSlot(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets a list of web app configuration snapshots identifiers. Each element of the list contains a
     * timestamp and the ID of the snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of metadata for the app configuration snapshots that can be restored as paginated response
     *     with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SiteConfigurationSnapshotInfoInner> listConfigurationSnapshotInfoSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SiteConfigResourceInner>> getConfigurationSnapshotSlotWithResponseAsync(
        String resourceGroupName, String name, String snapshotId, String slot);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SiteConfigResourceInner> getConfigurationSnapshotSlotAsync(
        String resourceGroupName, String name, String snapshotId, String slot);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SiteConfigResourceInner getConfigurationSnapshotSlot(
        String resourceGroupName, String name, String snapshotId, String slot);

    /**
     * Description for Gets a snapshot of the configuration of an app at a previous point in time.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return web app configuration ARM resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SiteConfigResourceInner> getConfigurationSnapshotSlotWithResponse(
        String resourceGroupName, String name, String snapshotId, String slot, Context context);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> recoverSiteConfigurationSnapshotSlotWithResponseAsync(
        String resourceGroupName, String name, String snapshotId, String slot);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> recoverSiteConfigurationSnapshotSlotAsync(
        String resourceGroupName, String name, String snapshotId, String slot);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void recoverSiteConfigurationSnapshotSlot(String resourceGroupName, String name, String snapshotId, String slot);

    /**
     * Description for Reverts the configuration of an app to a previous snapshot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param snapshotId The ID of the snapshot to read.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will return configuration for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> recoverSiteConfigurationSnapshotSlotWithResponse(
        String resourceGroupName, String name, String snapshotId, String slot, Context context);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StreamResponse> getWebSiteContainerLogsSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Flux<ByteBuffer> getWebSiteContainerLogsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InputStream getWebSiteContainerLogsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the last lines of docker logs for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StreamResponse getWebSiteContainerLogsSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StreamResponse> getContainerLogsZipSlotWithResponseAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Flux<ByteBuffer> getContainerLogsZipSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    InputStream getContainerLogsZipSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Gets the ZIP archived docker log files for the given site.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StreamResponse getContainerLogsZipSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ContinuousWebJobInner> listContinuousWebJobsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContinuousWebJobInner> listContinuousWebJobsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for List continuous web jobs for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu continuous web job information elements as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ContinuousWebJobInner> listContinuousWebJobsSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ContinuousWebJobInner>> getContinuousWebJobSlotWithResponseAsync(
        String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ContinuousWebJobInner> getContinuousWebJobSlotAsync(
        String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ContinuousWebJobInner getContinuousWebJobSlot(
        String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Gets a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return continuous Web Job Information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ContinuousWebJobInner> getContinuousWebJobSlotWithResponse(
        String resourceGroupName, String name, String webJobName, String slot, Context context);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteContinuousWebJobSlotWithResponseAsync(
        String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteContinuousWebJobSlotAsync(String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteContinuousWebJobSlot(String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Delete a continuous web job by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteContinuousWebJobSlotWithResponse(
        String resourceGroupName, String name, String webJobName, String slot, Context context);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> startContinuousWebJobSlotWithResponseAsync(
        String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> startContinuousWebJobSlotAsync(String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void startContinuousWebJobSlot(String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Start a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> startContinuousWebJobSlotWithResponse(
        String resourceGroupName, String name, String webJobName, String slot, Context context);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> stopContinuousWebJobSlotWithResponseAsync(
        String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> stopContinuousWebJobSlotAsync(String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void stopContinuousWebJobSlot(String resourceGroupName, String name, String webJobName, String slot);

    /**
     * Description for Stop a continuous web job for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param webJobName Name of Web Job.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> stopContinuousWebJobSlotWithResponse(
        String resourceGroupName, String name, String webJobName, String slot, Context context);

    /**
     * Description for List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API returns deployments for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<DeploymentInner> listDeploymentsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API returns deployments for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentInner> listDeploymentsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for List deployments for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API returns deployments for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of app deployments as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<DeploymentInner> listDeploymentsSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API gets a deployment for the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentInner>> getDeploymentSlotWithResponseAsync(
        String resourceGroupName, String name, String id, String slot);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API gets a deployment for the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentInner> getDeploymentSlotAsync(String resourceGroupName, String name, String id, String slot);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API gets a deployment for the production
     *     slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentInner getDeploymentSlot(String resourceGroupName, String name, String id, String slot);

    /**
     * Description for Get a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API gets a deployment for the production
     *     slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentInner> getDeploymentSlotWithResponse(
        String resourceGroupName, String name, String id, String slot, Context context);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param slot Name of the deployment slot. If a slot is not specified, the API creates a deployment for the
     *     production slot.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentInner>> createDeploymentSlotWithResponseAsync(
        String resourceGroupName, String name, String id, String slot, DeploymentInner deployment);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param slot Name of the deployment slot. If a slot is not specified, the API creates a deployment for the
     *     production slot.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentInner> createDeploymentSlotAsync(
        String resourceGroupName, String name, String id, String slot, DeploymentInner deployment);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param slot Name of the deployment slot. If a slot is not specified, the API creates a deployment for the
     *     production slot.
     * @param deployment Deployment details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentInner createDeploymentSlot(
        String resourceGroupName, String name, String id, String slot, DeploymentInner deployment);

    /**
     * Description for Create a deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id ID of an existing deployment.
     * @param slot Name of the deployment slot. If a slot is not specified, the API creates a deployment for the
     *     production slot.
     * @param deployment Deployment details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentInner> createDeploymentSlotWithResponse(
        String resourceGroupName, String name, String id, String slot, DeploymentInner deployment, Context context);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteDeploymentSlotWithResponseAsync(
        String resourceGroupName, String name, String id, String slot);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDeploymentSlotAsync(String resourceGroupName, String name, String id, String slot);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteDeploymentSlot(String resourceGroupName, String name, String id, String slot);

    /**
     * Description for Delete a deployment by its ID for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id Deployment ID.
     * @param slot Name of the deployment slot. If a slot is not specified, the API deletes a deployment for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteDeploymentSlotWithResponse(
        String resourceGroupName, String name, String id, String slot, Context context);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @param slot Name of the deployment slot. If a slot is not specified, the API returns deployments for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<DeploymentInner>> listDeploymentLogSlotWithResponseAsync(
        String resourceGroupName, String name, String id, String slot);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @param slot Name of the deployment slot. If a slot is not specified, the API returns deployments for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<DeploymentInner> listDeploymentLogSlotAsync(String resourceGroupName, String name, String id, String slot);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @param slot Name of the deployment slot. If a slot is not specified, the API returns deployments for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    DeploymentInner listDeploymentLogSlot(String resourceGroupName, String name, String id, String slot);

    /**
     * Description for List deployment log for specific deployment for an app, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param id The ID of a specific deployment. This is the value of the name property in the JSON response from "GET
     *     /api/sites/{siteName}/deployments".
     * @param slot Name of the deployment slot. If a slot is not specified, the API returns deployments for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return user credentials used for publishing activity along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<DeploymentInner> listDeploymentLogSlotWithResponse(
        String resourceGroupName, String name, String id, String slot, Context context);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will perform discovery for the
     *     production slot.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<RestoreRequestInner>> discoverBackupSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, RestoreRequestInner request);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will perform discovery for the
     *     production slot.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<RestoreRequestInner> discoverBackupSlotAsync(
        String resourceGroupName, String name, String slot, RestoreRequestInner request);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will perform discovery for the
     *     production slot.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    RestoreRequestInner discoverBackupSlot(
        String resourceGroupName, String name, String slot, RestoreRequestInner request);

    /**
     * Description for Discovers an existing app backup that can be restored from a blob in Azure storage. Use this to
     * get information about the databases stored in a backup.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will perform discovery for the
     *     production slot.
     * @param request A RestoreRequest object that includes Azure storage URL and blog name for discovery of backup.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return description of a restore request along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<RestoreRequestInner> discoverBackupSlotWithResponse(
        String resourceGroupName, String name, String slot, RestoreRequestInner request, Context context);

    /**
     * Description for Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<IdentifierInner> listDomainOwnershipIdentifiersSlotAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<IdentifierInner> listDomainOwnershipIdentifiersSlot(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Lists ownership identifiers for domain associated with web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of identifiers as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<IdentifierInner> listDomainOwnershipIdentifiersSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<IdentifierInner>> getDomainOwnershipIdentifierSlotWithResponseAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<IdentifierInner> getDomainOwnershipIdentifierSlotAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IdentifierInner getDomainOwnershipIdentifierSlot(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot);

    /**
     * Description for Get domain ownership identifier for web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IdentifierInner> getDomainOwnershipIdentifierSlotWithResponse(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot, Context context);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<IdentifierInner>> createOrUpdateDomainOwnershipIdentifierSlotWithResponseAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<IdentifierInner> createOrUpdateDomainOwnershipIdentifierSlotAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IdentifierInner createOrUpdateDomainOwnershipIdentifierSlot(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IdentifierInner> createOrUpdateDomainOwnershipIdentifierSlotWithResponse(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier,
        Context context);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteDomainOwnershipIdentifierSlotWithResponseAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteDomainOwnershipIdentifierSlotAsync(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteDomainOwnershipIdentifierSlot(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot);

    /**
     * Description for Deletes a domain ownership identifier for a web app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteDomainOwnershipIdentifierSlotWithResponse(
        String resourceGroupName, String name, String domainOwnershipIdentifierName, String slot, Context context);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<IdentifierInner>> updateDomainOwnershipIdentifierSlotWithResponseAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<IdentifierInner> updateDomainOwnershipIdentifierSlotAsync(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    IdentifierInner updateDomainOwnershipIdentifierSlot(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier);

    /**
     * Description for Creates a domain ownership identifier for web app, or updates an existing ownership identifier.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param domainOwnershipIdentifierName Name of domain ownership identifier.
     * @param slot Name of the deployment slot. If a slot is not specified, the API will delete the binding for the
     *     production slot.
     * @param domainOwnershipIdentifier A JSON representation of the domain ownership properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a domain specific resource identifier along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<IdentifierInner> updateDomainOwnershipIdentifierSlotWithResponse(
        String resourceGroupName,
        String name,
        String domainOwnershipIdentifierName,
        String slot,
        IdentifierInner domainOwnershipIdentifier,
        Context context);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MSDeployStatusInner>> getMSDeployStatusSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployStatusInner> getMSDeployStatusSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner getMSDeployStatusSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Get the status of the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MSDeployStatusInner> getMSDeployStatusSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createMSDeployOperationSlotWithResponseAsync(
        String resourceGroupName, String name, String slot, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperationSlotAsync(
        String resourceGroupName, String name, String slot, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperationSlot(
        String resourceGroupName, String name, String slot, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param mSDeploy Details of MSDeploy operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<MSDeployStatusInner>, MSDeployStatusInner> beginCreateMSDeployOperationSlot(
        String resourceGroupName, String name, String slot, MSDeploy mSDeploy, Context context);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployStatusInner> createMSDeployOperationSlotAsync(
        String resourceGroupName, String name, String slot, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param mSDeploy Details of MSDeploy operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner createMSDeployOperationSlot(
        String resourceGroupName, String name, String slot, MSDeploy mSDeploy);

    /**
     * Description for Invoke the MSDeploy web app extension.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param mSDeploy Details of MSDeploy operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy ARM response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployStatusInner createMSDeployOperationSlot(
        String resourceGroupName, String name, String slot, MSDeploy mSDeploy, Context context);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<MSDeployLogInner>> getMSDeployLogSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<MSDeployLogInner> getMSDeployLogSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    MSDeployLogInner getMSDeployLogSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Get the MSDeploy Log for the last MSDeploy operation.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return mSDeploy log along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<MSDeployLogInner> getMSDeployLogSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu function information elements as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<FunctionEnvelopeInner> listInstanceFunctionsSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu function information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FunctionEnvelopeInner> listInstanceFunctionsSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for List the functions for a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return collection of Kudu function information elements as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<FunctionEnvelopeInner> listInstanceFunctionsSlot(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<String>> getFunctionsAdminTokenSlotWithResponseAsync(
        String resourceGroupName, String name, String slot);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> getFunctionsAdminTokenSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String getFunctionsAdminTokenSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Fetch a short lived token that can be exchanged for a master key.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of web app.
     * @param slot Name of web app slot. If not specified then will default to production slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<String> getFunctionsAdminTokenSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FunctionEnvelopeInner>> getInstanceFunctionSlotWithResponseAsync(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FunctionEnvelopeInner> getInstanceFunctionSlotAsync(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionEnvelopeInner getInstanceFunctionSlot(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function information by its ID for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FunctionEnvelopeInner> getInstanceFunctionSlotWithResponse(
        String resourceGroupName, String name, String functionName, String slot, Context context);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createInstanceFunctionSlotWithResponseAsync(
        String resourceGroupName,
        String name,
        String functionName,
        String slot,
        FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of function information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateInstanceFunctionSlotAsync(
        String resourceGroupName,
        String name,
        String functionName,
        String slot,
        FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of function information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateInstanceFunctionSlot(
        String resourceGroupName,
        String name,
        String functionName,
        String slot,
        FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param functionEnvelope Function details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of function information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FunctionEnvelopeInner>, FunctionEnvelopeInner> beginCreateInstanceFunctionSlot(
        String resourceGroupName,
        String name,
        String functionName,
        String slot,
        FunctionEnvelopeInner functionEnvelope,
        Context context);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FunctionEnvelopeInner> createInstanceFunctionSlotAsync(
        String resourceGroupName,
        String name,
        String functionName,
        String slot,
        FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param functionEnvelope Function details.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionEnvelopeInner createInstanceFunctionSlot(
        String resourceGroupName,
        String name,
        String functionName,
        String slot,
        FunctionEnvelopeInner functionEnvelope);

    /**
     * Description for Create function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param functionEnvelope Function details.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionEnvelopeInner createInstanceFunctionSlot(
        String resourceGroupName,
        String name,
        String functionName,
        String slot,
        FunctionEnvelopeInner functionEnvelope,
        Context context);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteInstanceFunctionSlotWithResponseAsync(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteInstanceFunctionSlotAsync(String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteInstanceFunctionSlot(String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Delete a function for web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteInstanceFunctionSlotWithResponse(
        String resourceGroupName, String name, String functionName, String slot, Context context);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<KeyInfoInner>> createOrUpdateFunctionSecretSlotWithResponseAsync(
        String resourceGroupName, String name, String functionName, String keyName, String slot, KeyInfoInner key);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<KeyInfoInner> createOrUpdateFunctionSecretSlotAsync(
        String resourceGroupName, String name, String functionName, String keyName, String slot, KeyInfoInner key);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @param key The key to create or update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    KeyInfoInner createOrUpdateFunctionSecretSlot(
        String resourceGroupName, String name, String functionName, String keyName, String slot, KeyInfoInner key);

    /**
     * Description for Add or update a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @param key The key to create or update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function key info along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<KeyInfoInner> createOrUpdateFunctionSecretSlotWithResponse(
        String resourceGroupName,
        String name,
        String functionName,
        String keyName,
        String slot,
        KeyInfoInner key,
        Context context);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteFunctionSecretSlotWithResponseAsync(
        String resourceGroupName, String name, String functionName, String keyName, String slot);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteFunctionSecretSlotAsync(
        String resourceGroupName, String name, String functionName, String keyName, String slot);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void deleteFunctionSecretSlot(
        String resourceGroupName, String name, String functionName, String keyName, String slot);

    /**
     * Description for Delete a function secret.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName The name of the function.
     * @param keyName The name of the key.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteFunctionSecretSlotWithResponse(
        String resourceGroupName, String name, String functionName, String keyName, String slot, Context context);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<StringDictionaryInner>> listFunctionKeysSlotWithResponseAsync(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<StringDictionaryInner> listFunctionKeysSlotAsync(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    StringDictionaryInner listFunctionKeysSlot(String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function keys for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return string dictionary resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<StringDictionaryInner> listFunctionKeysSlotWithResponse(
        String resourceGroupName, String name, String functionName, String slot, Context context);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<FunctionSecretsInner>> listFunctionSecretsSlotWithResponseAsync(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FunctionSecretsInner> listFunctionSecretsSlotAsync(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FunctionSecretsInner listFunctionSecretsSlot(
        String resourceGroupName, String name, String functionName, String slot);

    /**
     * Description for Get function secrets for a function in a web site, or a deployment slot.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param functionName Function name.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return function secrets along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<FunctionSecretsInner> listFunctionSecretsSlotWithResponse(
        String resourceGroupName, String name, String functionName, String slot, Context context);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<HostKeysInner>> listHostKeysSlotWithResponseAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<HostKeysInner> listHostKeysSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    HostKeysInner listHostKeysSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for Get host secrets for a function app.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Site name.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return functions host level keys along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<HostKeysInner> listHostKeysSlotWithResponse(
        String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> listSyncStatusSlotWithResponseAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> listSyncStatusSlotAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void listSyncStatusSlot(String resourceGroupName, String name, String slot);

    /**
     * Description for This is to allow calling via powershell and ARM template.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> listSyncStatusSlotWithResponse(String resourceGroupName, String name, String slot, Context context);

    /**
     * Description for Syncs function trigger metadata to the management database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> syncFunctionsSlotWithResponseAsync(String resourceGroupName, String name, String slot);

    /**
     * Description for Syncs function trigger metadata to the management database.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param name Name of the app.
     * @param slot Name of the deployment slot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.appservice.models.DefaultErrorResponseErrorException thrown if the request is
     *     rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @ret