// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** CustomHostnameSites resource specific properties. */
@Fluent
public final class CustomHostnameSitesProperties {
    /*
     * The customHostname property.
     */
    @JsonProperty(value = "customHostname")
    private String customHostname;

    /*
     * The region property.
     */
    @JsonProperty(value = "region")
    private String region;

    /*
     * The siteResourceIds property.
     */
    @JsonProperty(value = "siteResourceIds")
    private List<IdentifierInner> siteResourceIds;

    /**
     * Get the customHostname property: The customHostname property.
     *
     * @return the customHostname value.
     */
    public String customHostname() {
        return this.customHostname;
    }

    /**
     * Set the customHostname property: The customHostname property.
     *
     * @param customHostname the customHostname value to set.
     * @return the CustomHostnameSitesProperties object itself.
     */
    public CustomHostnameSitesProperties withCustomHostname(String customHostname) {
        this.customHostname = customHostname;
        return this;
    }

    /**
     * Get the region property: The region property.
     *
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: The region property.
     *
     * @param region the region value to set.
     * @return the CustomHostnameSitesProperties object itself.
     */
    public CustomHostnameSitesProperties withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the siteResourceIds property: The siteResourceIds property.
     *
     * @return the siteResourceIds value.
     */
    public List<IdentifierInner> siteResourceIds() {
        return this.siteResourceIds;
    }

    /**
     * Set the siteResourceIds property: The siteResourceIds property.
     *
     * @param siteResourceIds the siteResourceIds value to set.
     * @return the CustomHostnameSitesProperties object itself.
     */
    public CustomHostnameSitesProperties withSiteResourceIds(List<IdentifierInner> siteResourceIds) {
        this.siteResourceIds = siteResourceIds;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (siteResourceIds() != null) {
            siteResourceIds().forEach(e -> e.validate());
        }
    }
}
