// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.RetryHistory;
import com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** The workflow run action properties. */
@Fluent
public final class WorkflowRunActionProperties {
    /*
     * Gets the start time.
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;

    /*
     * Gets the end time.
     */
    @JsonProperty(value = "endTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endTime;

    /*
     * Gets the status.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private WorkflowStatus status;

    /*
     * Gets the code.
     */
    @JsonProperty(value = "code", access = JsonProperty.Access.WRITE_ONLY)
    private String code;

    /*
     * Gets the error.
     */
    @JsonProperty(value = "error", access = JsonProperty.Access.WRITE_ONLY)
    private Object error;

    /*
     * Gets the tracking id.
     */
    @JsonProperty(value = "trackingId", access = JsonProperty.Access.WRITE_ONLY)
    private String trackingId;

    /*
     * The correlation properties.
     */
    @JsonProperty(value = "correlation")
    private RunActionCorrelation correlation;

    /*
     * Gets the link to inputs.
     */
    @JsonProperty(value = "inputsLink", access = JsonProperty.Access.WRITE_ONLY)
    private ContentLink inputsLink;

    /*
     * Gets the link to outputs.
     */
    @JsonProperty(value = "outputsLink", access = JsonProperty.Access.WRITE_ONLY)
    private ContentLink outputsLink;

    /*
     * Gets the tracked properties.
     */
    @JsonProperty(value = "trackedProperties", access = JsonProperty.Access.WRITE_ONLY)
    private Object trackedProperties;

    /*
     * Gets the retry histories.
     */
    @JsonProperty(value = "retryHistory")
    private List<RetryHistory> retryHistory;

    /**
     * Get the startTime property: Gets the start time.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: Gets the end time.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the status property: Gets the status.
     *
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.status;
    }

    /**
     * Get the code property: Gets the code.
     *
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the error property: Gets the error.
     *
     * @return the error value.
     */
    public Object error() {
        return this.error;
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     *
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.trackingId;
    }

    /**
     * Get the correlation property: The correlation properties.
     *
     * @return the correlation value.
     */
    public RunActionCorrelation correlation() {
        return this.correlation;
    }

    /**
     * Set the correlation property: The correlation properties.
     *
     * @param correlation the correlation value to set.
     * @return the WorkflowRunActionProperties object itself.
     */
    public WorkflowRunActionProperties withCorrelation(RunActionCorrelation correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Get the inputsLink property: Gets the link to inputs.
     *
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    /**
     * Get the outputsLink property: Gets the link to outputs.
     *
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    /**
     * Get the trackedProperties property: Gets the tracked properties.
     *
     * @return the trackedProperties value.
     */
    public Object trackedProperties() {
        return this.trackedProperties;
    }

    /**
     * Get the retryHistory property: Gets the retry histories.
     *
     * @return the retryHistory value.
     */
    public List<RetryHistory> retryHistory() {
        return this.retryHistory;
    }

    /**
     * Set the retryHistory property: Gets the retry histories.
     *
     * @param retryHistory the retryHistory value to set.
     * @return the WorkflowRunActionProperties object itself.
     */
    public WorkflowRunActionProperties withRetryHistory(List<RetryHistory> retryHistory) {
        this.retryHistory = retryHistory;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (correlation() != null) {
            correlation().validate();
        }
        if (inputsLink() != null) {
            inputsLink().validate();
        }
        if (outputsLink() != null) {
            outputsLink().validate();
        }
        if (retryHistory() != null) {
            retryHistory().forEach(e -> e.validate());
        }
    }
}
