// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.StackMajorVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** ARM resource for a ApplicationStack. */
@Fluent
public final class ApplicationStackResourceInner extends ProxyOnlyResource {
    /*
     * Core resource properties
     */
    @JsonProperty(value = "properties")
    private ApplicationStack innerProperties;

    /** Creates an instance of ApplicationStackResourceInner class. */
    public ApplicationStackResourceInner() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     *
     * @return the innerProperties value.
     */
    private ApplicationStack innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public ApplicationStackResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the name property: Application stack name.
     *
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Set the name property: Application stack name.
     *
     * @param name the name value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withNamePropertiesName(String name) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withName(name);
        return this;
    }

    /**
     * Get the display property: Application stack display name.
     *
     * @return the display value.
     */
    public String display() {
        return this.innerProperties() == null ? null : this.innerProperties().display();
    }

    /**
     * Set the display property: Application stack display name.
     *
     * @param display the display value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDisplay(String display) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withDisplay(display);
        return this;
    }

    /**
     * Get the dependency property: Application stack dependency.
     *
     * @return the dependency value.
     */
    public String dependency() {
        return this.innerProperties() == null ? null : this.innerProperties().dependency();
    }

    /**
     * Set the dependency property: Application stack dependency.
     *
     * @param dependency the dependency value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withDependency(String dependency) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withDependency(dependency);
        return this;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     *
     * @return the majorVersions value.
     */
    public List<StackMajorVersion> majorVersions() {
        return this.innerProperties() == null ? null : this.innerProperties().majorVersions();
    }

    /**
     * Set the majorVersions property: List of major versions available.
     *
     * @param majorVersions the majorVersions value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withMajorVersions(List<StackMajorVersion> majorVersions) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withMajorVersions(majorVersions);
        return this;
    }

    /**
     * Get the frameworks property: List of frameworks associated with application stack.
     *
     * @return the frameworks value.
     */
    public List<ApplicationStack> frameworks() {
        return this.innerProperties() == null ? null : this.innerProperties().frameworks();
    }

    /**
     * Set the frameworks property: List of frameworks associated with application stack.
     *
     * @param frameworks the frameworks value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withFrameworks(List<ApplicationStack> frameworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withFrameworks(frameworks);
        return this;
    }

    /**
     * Get the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isDeprecated value.
     */
    public List<ApplicationStack> isDeprecated() {
        return this.innerProperties() == null ? null : this.innerProperties().isDeprecated();
    }

    /**
     * Set the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param isDeprecated the isDeprecated value to set.
     * @return the ApplicationStackResourceInner object itself.
     */
    public ApplicationStackResourceInner withIsDeprecated(List<ApplicationStack> isDeprecated) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationStack();
        }
        this.innerProperties().withIsDeprecated(isDeprecated);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
