// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The workflow trigger history properties. */
@Fluent
public final class WorkflowTriggerHistoryProperties {
    /*
     * Gets the start time.
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;

    /*
     * Gets the end time.
     */
    @JsonProperty(value = "endTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endTime;

    /*
     * The scheduled time.
     */
    @JsonProperty(value = "scheduledTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime scheduledTime;

    /*
     * Gets the status.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private WorkflowStatus status;

    /*
     * Gets the code.
     */
    @JsonProperty(value = "code", access = JsonProperty.Access.WRITE_ONLY)
    private String code;

    /*
     * Gets the error.
     */
    @JsonProperty(value = "error", access = JsonProperty.Access.WRITE_ONLY)
    private Object error;

    /*
     * Gets the tracking id.
     */
    @JsonProperty(value = "trackingId", access = JsonProperty.Access.WRITE_ONLY)
    private String trackingId;

    /*
     * The run correlation.
     */
    @JsonProperty(value = "correlation")
    private Correlation correlation;

    /*
     * Gets the link to input parameters.
     */
    @JsonProperty(value = "inputsLink", access = JsonProperty.Access.WRITE_ONLY)
    private ContentLink inputsLink;

    /*
     * Gets the link to output parameters.
     */
    @JsonProperty(value = "outputsLink", access = JsonProperty.Access.WRITE_ONLY)
    private ContentLink outputsLink;

    /*
     * The value indicating whether trigger was fired.
     */
    @JsonProperty(value = "fired", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean fired;

    /*
     * Gets the reference to workflow run.
     */
    @JsonProperty(value = "run", access = JsonProperty.Access.WRITE_ONLY)
    private ResourceReference run;

    /** Creates an instance of WorkflowTriggerHistoryProperties class. */
    public WorkflowTriggerHistoryProperties() {
    }

    /**
     * Get the startTime property: Gets the start time.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: Gets the end time.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the scheduledTime property: The scheduled time.
     *
     * @return the scheduledTime value.
     */
    public OffsetDateTime scheduledTime() {
        return this.scheduledTime;
    }

    /**
     * Get the status property: Gets the status.
     *
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.status;
    }

    /**
     * Get the code property: Gets the code.
     *
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the error property: Gets the error.
     *
     * @return the error value.
     */
    public Object error() {
        return this.error;
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     *
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.trackingId;
    }

    /**
     * Get the correlation property: The run correlation.
     *
     * @return the correlation value.
     */
    public Correlation correlation() {
        return this.correlation;
    }

    /**
     * Set the correlation property: The run correlation.
     *
     * @param correlation the correlation value to set.
     * @return the WorkflowTriggerHistoryProperties object itself.
     */
    public WorkflowTriggerHistoryProperties withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Get the inputsLink property: Gets the link to input parameters.
     *
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    /**
     * Get the outputsLink property: Gets the link to output parameters.
     *
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    /**
     * Get the fired property: The value indicating whether trigger was fired.
     *
     * @return the fired value.
     */
    public Boolean fired() {
        return this.fired;
    }

    /**
     * Get the run property: Gets the reference to workflow run.
     *
     * @return the run value.
     */
    public ResourceReference run() {
        return this.run;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (correlation() != null) {
            correlation().validate();
        }
        if (inputsLink() != null) {
            inputsLink().validate();
        }
        if (outputsLink() != null) {
            outputsLink().validate();
        }
        if (run() != null) {
            run().validate();
        }
    }
}
