/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpFluxBBResponse
extends HttpResponse {
    private final int statusCode;
    private final HttpHeaders httpHeaders;
    private final Response<Flux<ByteBuffer>> originResponse;

    HttpFluxBBResponse(Response<Flux<ByteBuffer>> originResponse) {
        super(null);
        this.statusCode = originResponse.getStatusCode();
        this.httpHeaders = originResponse.getHeaders();
        this.originResponse = originResponse;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getHeaderValue(String s) {
        return this.httpHeaders.getValue(s);
    }

    public HttpHeaders getHeaders() {
        return this.httpHeaders;
    }

    public Flux<ByteBuffer> getBody() {
        return (Flux)this.originResponse.getValue();
    }

    public Mono<byte[]> getBodyAsByteArray() {
        return FluxUtil.collectBytesInByteBufferStream((Flux)((Flux)this.originResponse.getValue()));
    }

    public Mono<String> getBodyAsString() {
        return this.getBodyAsByteArray().map(String::new);
    }

    public Mono<String> getBodyAsString(Charset charset) {
        return this.getBodyAsByteArray().map(bytes -> new String((byte[])bytes, charset));
    }
}

