// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.CustomDnsSuffixProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** CustomDnsSuffixConfiguration resource specific properties. */
@Fluent
public final class CustomDnsSuffixConfigurationProperties {
    /*
     * The provisioningState property.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private CustomDnsSuffixProvisioningState provisioningState;

    /*
     * The provisioningDetails property.
     */
    @JsonProperty(value = "provisioningDetails", access = JsonProperty.Access.WRITE_ONLY)
    private String provisioningDetails;

    /*
     * The default custom domain suffix to use for all sites deployed on the ASE.
     */
    @JsonProperty(value = "dnsSuffix")
    private String dnsSuffix;

    /*
     * The URL referencing the Azure Key Vault certificate secret that should be used as the default SSL/TLS
     * certificate for sites with the custom domain suffix.
     */
    @JsonProperty(value = "certificateUrl")
    private String certificateUrl;

    /*
     * The user-assigned identity to use for resolving the key vault certificate reference. If not specified, the
     * system-assigned ASE identity will be used if available.
     */
    @JsonProperty(value = "keyVaultReferenceIdentity")
    private String keyVaultReferenceIdentity;

    /** Creates an instance of CustomDnsSuffixConfigurationProperties class. */
    public CustomDnsSuffixConfigurationProperties() {
    }

    /**
     * Get the provisioningState property: The provisioningState property.
     *
     * @return the provisioningState value.
     */
    public CustomDnsSuffixProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the provisioningDetails property: The provisioningDetails property.
     *
     * @return the provisioningDetails value.
     */
    public String provisioningDetails() {
        return this.provisioningDetails;
    }

    /**
     * Get the dnsSuffix property: The default custom domain suffix to use for all sites deployed on the ASE.
     *
     * @return the dnsSuffix value.
     */
    public String dnsSuffix() {
        return this.dnsSuffix;
    }

    /**
     * Set the dnsSuffix property: The default custom domain suffix to use for all sites deployed on the ASE.
     *
     * @param dnsSuffix the dnsSuffix value to set.
     * @return the CustomDnsSuffixConfigurationProperties object itself.
     */
    public CustomDnsSuffixConfigurationProperties withDnsSuffix(String dnsSuffix) {
        this.dnsSuffix = dnsSuffix;
        return this;
    }

    /**
     * Get the certificateUrl property: The URL referencing the Azure Key Vault certificate secret that should be used
     * as the default SSL/TLS certificate for sites with the custom domain suffix.
     *
     * @return the certificateUrl value.
     */
    public String certificateUrl() {
        return this.certificateUrl;
    }

    /**
     * Set the certificateUrl property: The URL referencing the Azure Key Vault certificate secret that should be used
     * as the default SSL/TLS certificate for sites with the custom domain suffix.
     *
     * @param certificateUrl the certificateUrl value to set.
     * @return the CustomDnsSuffixConfigurationProperties object itself.
     */
    public CustomDnsSuffixConfigurationProperties withCertificateUrl(String certificateUrl) {
        this.certificateUrl = certificateUrl;
        return this;
    }

    /**
     * Get the keyVaultReferenceIdentity property: The user-assigned identity to use for resolving the key vault
     * certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     *
     * @return the keyVaultReferenceIdentity value.
     */
    public String keyVaultReferenceIdentity() {
        return this.keyVaultReferenceIdentity;
    }

    /**
     * Set the keyVaultReferenceIdentity property: The user-assigned identity to use for resolving the key vault
     * certificate reference. If not specified, the system-assigned ASE identity will be used if available.
     *
     * @param keyVaultReferenceIdentity the keyVaultReferenceIdentity value to set.
     * @return the CustomDnsSuffixConfigurationProperties object itself.
     */
    public CustomDnsSuffixConfigurationProperties withKeyVaultReferenceIdentity(String keyVaultReferenceIdentity) {
        this.keyVaultReferenceIdentity = keyVaultReferenceIdentity;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
