// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.RequestHistoryProperties;
import com.azure.resourcemanager.appservice.models.WorkflowResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/** The request history. */
@Fluent
public final class RequestHistoryInner extends WorkflowResource {
    /*
     * The request history properties.
     */
    @JsonProperty(value = "properties")
    private RequestHistoryProperties properties;

    /** Creates an instance of RequestHistoryInner class. */
    public RequestHistoryInner() {
    }

    /**
     * Get the properties property: The request history properties.
     *
     * @return the properties value.
     */
    public RequestHistoryProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: The request history properties.
     *
     * @param properties the properties value to set.
     * @return the RequestHistoryInner object itself.
     */
    public RequestHistoryInner withProperties(RequestHistoryProperties properties) {
        this.properties = properties;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RequestHistoryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public RequestHistoryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (properties() != null) {
            properties().validate();
        }
    }
}
