// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration. */
@Fluent
public final class SwiftVirtualNetworkInner extends ProxyOnlyResource {
    /*
     * SwiftVirtualNetwork resource specific properties
     */
    @JsonProperty(value = "properties")
    private SwiftVirtualNetworkProperties innerProperties;

    /** Creates an instance of SwiftVirtualNetworkInner class. */
    public SwiftVirtualNetworkInner() {
    }

    /**
     * Get the innerProperties property: SwiftVirtualNetwork resource specific properties.
     *
     * @return the innerProperties value.
     */
    private SwiftVirtualNetworkProperties innerProperties() {
        return this.innerProperties;
    }

    /** {@inheritDoc} */
    @Override
    public SwiftVirtualNetworkInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the subnetResourceId property: The Virtual Network subnet's resource ID. This is the subnet that this Web App
     * will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
     *
     * @return the subnetResourceId value.
     */
    public String subnetResourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetResourceId();
    }

    /**
     * Set the subnetResourceId property: The Virtual Network subnet's resource ID. This is the subnet that this Web App
     * will join. This subnet must have a delegation to Microsoft.Web/serverFarms defined first.
     *
     * @param subnetResourceId the subnetResourceId value to set.
     * @return the SwiftVirtualNetworkInner object itself.
     */
    public SwiftVirtualNetworkInner withSubnetResourceId(String subnetResourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SwiftVirtualNetworkProperties();
        }
        this.innerProperties().withSubnetResourceId(subnetResourceId);
        return this;
    }

    /**
     * Get the swiftSupported property: A flag that specifies if the scale unit this Web App is on supports Swift
     * integration.
     *
     * @return the swiftSupported value.
     */
    public Boolean swiftSupported() {
        return this.innerProperties() == null ? null : this.innerProperties().swiftSupported();
    }

    /**
     * Set the swiftSupported property: A flag that specifies if the scale unit this Web App is on supports Swift
     * integration.
     *
     * @param swiftSupported the swiftSupported value to set.
     * @return the SwiftVirtualNetworkInner object itself.
     */
    public SwiftVirtualNetworkInner withSwiftSupported(Boolean swiftSupported) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SwiftVirtualNetworkProperties();
        }
        this.innerProperties().withSwiftSupported(swiftSupported);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
