// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.TriggeredJobRun;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** TriggeredJobHistory resource specific properties. */
@Fluent
public final class TriggeredJobHistoryProperties {
    /*
     * List of triggered web job runs.
     */
    @JsonProperty(value = "runs")
    private List<TriggeredJobRun> runs;

    /** Creates an instance of TriggeredJobHistoryProperties class. */
    public TriggeredJobHistoryProperties() {
    }

    /**
     * Get the runs property: List of triggered web job runs.
     *
     * @return the runs value.
     */
    public List<TriggeredJobRun> runs() {
        return this.runs;
    }

    /**
     * Set the runs property: List of triggered web job runs.
     *
     * @param runs the runs value to set.
     * @return the TriggeredJobHistoryProperties object itself.
     */
    public TriggeredJobHistoryProperties withRuns(List<TriggeredJobRun> runs) {
        this.runs = runs;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (runs() != null) {
            runs().forEach(e -> e.validate());
        }
    }
}
