// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowOutputParameter;
import com.azure.resourcemanager.appservice.models.WorkflowRunTrigger;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.Map;

/** The workflow run properties. */
@Fluent
public final class WorkflowRunProperties {
    /*
     * Gets the wait end time.
     */
    @JsonProperty(value = "waitEndTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime waitEndTime;

    /*
     * Gets the start time.
     */
    @JsonProperty(value = "startTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime startTime;

    /*
     * Gets the end time.
     */
    @JsonProperty(value = "endTime", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime endTime;

    /*
     * Gets the status.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private WorkflowStatus status;

    /*
     * Gets the code.
     */
    @JsonProperty(value = "code", access = JsonProperty.Access.WRITE_ONLY)
    private String code;

    /*
     * Gets the error.
     */
    @JsonProperty(value = "error", access = JsonProperty.Access.WRITE_ONLY)
    private Object error;

    /*
     * Gets the correlation id.
     */
    @JsonProperty(value = "correlationId", access = JsonProperty.Access.WRITE_ONLY)
    private String correlationId;

    /*
     * The run correlation.
     */
    @JsonProperty(value = "correlation")
    private Correlation correlation;

    /*
     * Gets the reference to workflow version.
     */
    @JsonProperty(value = "workflow", access = JsonProperty.Access.WRITE_ONLY)
    private ResourceReference workflow;

    /*
     * Gets the fired trigger.
     */
    @JsonProperty(value = "trigger", access = JsonProperty.Access.WRITE_ONLY)
    private WorkflowRunTrigger trigger;

    /*
     * Gets the outputs.
     */
    @JsonProperty(value = "outputs", access = JsonProperty.Access.WRITE_ONLY)
    @JsonInclude(value = JsonInclude.Include.NON_NULL, content = JsonInclude.Include.ALWAYS)
    private Map<String, WorkflowOutputParameter> outputs;

    /*
     * Gets the response of the flow run.
     */
    @JsonProperty(value = "response", access = JsonProperty.Access.WRITE_ONLY)
    private WorkflowRunTrigger response;

    /** Creates an instance of WorkflowRunProperties class. */
    public WorkflowRunProperties() {
    }

    /**
     * Get the waitEndTime property: Gets the wait end time.
     *
     * @return the waitEndTime value.
     */
    public OffsetDateTime waitEndTime() {
        return this.waitEndTime;
    }

    /**
     * Get the startTime property: Gets the start time.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: Gets the end time.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the status property: Gets the status.
     *
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.status;
    }

    /**
     * Get the code property: Gets the code.
     *
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the error property: Gets the error.
     *
     * @return the error value.
     */
    public Object error() {
        return this.error;
    }

    /**
     * Get the correlationId property: Gets the correlation id.
     *
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.correlationId;
    }

    /**
     * Get the correlation property: The run correlation.
     *
     * @return the correlation value.
     */
    public Correlation correlation() {
        return this.correlation;
    }

    /**
     * Set the correlation property: The run correlation.
     *
     * @param correlation the correlation value to set.
     * @return the WorkflowRunProperties object itself.
     */
    public WorkflowRunProperties withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Get the workflow property: Gets the reference to workflow version.
     *
     * @return the workflow value.
     */
    public ResourceReference workflow() {
        return this.workflow;
    }

    /**
     * Get the trigger property: Gets the fired trigger.
     *
     * @return the trigger value.
     */
    public WorkflowRunTrigger trigger() {
        return this.trigger;
    }

    /**
     * Get the outputs property: Gets the outputs.
     *
     * @return the outputs value.
     */
    public Map<String, WorkflowOutputParameter> outputs() {
        return this.outputs;
    }

    /**
     * Get the response property: Gets the response of the flow run.
     *
     * @return the response value.
     */
    public WorkflowRunTrigger response() {
        return this.response;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (correlation() != null) {
            correlation().validate();
        }
        if (workflow() != null) {
            workflow().validate();
        }
        if (trigger() != null) {
            trigger().validate();
        }
        if (outputs() != null) {
            outputs()
                .values()
                .forEach(
                    e -> {
                        if (e != null) {
                            e.validate();
                        }
                    });
        }
        if (response() != null) {
            response().validate();
        }
    }
}
