// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** List of channels that this recommendation can apply. */
public enum Channels {
    /** Enum value Notification. */
    NOTIFICATION("Notification"),

    /** Enum value Api. */
    API("Api"),

    /** Enum value Email. */
    EMAIL("Email"),

    /** Enum value Webhook. */
    WEBHOOK("Webhook"),

    /** Enum value All. */
    ALL("All");

    /** The actual serialized value for a Channels instance. */
    private final String value;

    Channels(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a Channels instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed Channels object, or null if unable to parse.
     */
    @JsonCreator
    public static Channels fromString(String value) {
        if (value == null) {
            return null;
        }
        Channels[] items = Channels.values();
        for (Channels item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
