// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The configuration settings of a forward proxy used to make the requests. */
@Fluent
public final class ForwardProxy {
    /*
     * The convention used to determine the url of the request made.
     */
    @JsonProperty(value = "convention")
    private ForwardProxyConvention convention;

    /*
     * The name of the header containing the host of the request.
     */
    @JsonProperty(value = "customHostHeaderName")
    private String customHostHeaderName;

    /*
     * The name of the header containing the scheme of the request.
     */
    @JsonProperty(value = "customProtoHeaderName")
    private String customProtoHeaderName;

    /** Creates an instance of ForwardProxy class. */
    public ForwardProxy() {
    }

    /**
     * Get the convention property: The convention used to determine the url of the request made.
     *
     * @return the convention value.
     */
    public ForwardProxyConvention convention() {
        return this.convention;
    }

    /**
     * Set the convention property: The convention used to determine the url of the request made.
     *
     * @param convention the convention value to set.
     * @return the ForwardProxy object itself.
     */
    public ForwardProxy withConvention(ForwardProxyConvention convention) {
        this.convention = convention;
        return this;
    }

    /**
     * Get the customHostHeaderName property: The name of the header containing the host of the request.
     *
     * @return the customHostHeaderName value.
     */
    public String customHostHeaderName() {
        return this.customHostHeaderName;
    }

    /**
     * Set the customHostHeaderName property: The name of the header containing the host of the request.
     *
     * @param customHostHeaderName the customHostHeaderName value to set.
     * @return the ForwardProxy object itself.
     */
    public ForwardProxy withCustomHostHeaderName(String customHostHeaderName) {
        this.customHostHeaderName = customHostHeaderName;
        return this;
    }

    /**
     * Get the customProtoHeaderName property: The name of the header containing the scheme of the request.
     *
     * @return the customProtoHeaderName value.
     */
    public String customProtoHeaderName() {
        return this.customProtoHeaderName;
    }

    /**
     * Set the customProtoHeaderName property: The name of the header containing the scheme of the request.
     *
     * @param customProtoHeaderName the customProtoHeaderName value to set.
     * @return the ForwardProxy object itself.
     */
    public ForwardProxy withCustomProtoHeaderName(String customProtoHeaderName) {
        this.customProtoHeaderName = customProtoHeaderName;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
