// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.StackMajorVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Application stack. */
@Fluent
public final class ApplicationStack {
    /*
     * Application stack name.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * Application stack display name.
     */
    @JsonProperty(value = "display")
    private String display;

    /*
     * Application stack dependency.
     */
    @JsonProperty(value = "dependency")
    private String dependency;

    /*
     * List of major versions available.
     */
    @JsonProperty(value = "majorVersions")
    private List<StackMajorVersion> majorVersions;

    /*
     * List of frameworks associated with application stack.
     */
    @JsonProperty(value = "frameworks")
    private List<ApplicationStack> frameworks;

    /*
     * <code>true</code> if this is the stack is deprecated; otherwise, <code>false</code>.
     */
    @JsonProperty(value = "isDeprecated")
    private List<ApplicationStack> isDeprecated;

    /** Creates an instance of ApplicationStack class. */
    public ApplicationStack() {
    }

    /**
     * Get the name property: Application stack name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Application stack name.
     *
     * @param name the name value to set.
     * @return the ApplicationStack object itself.
     */
    public ApplicationStack withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the display property: Application stack display name.
     *
     * @return the display value.
     */
    public String display() {
        return this.display;
    }

    /**
     * Set the display property: Application stack display name.
     *
     * @param display the display value to set.
     * @return the ApplicationStack object itself.
     */
    public ApplicationStack withDisplay(String display) {
        this.display = display;
        return this;
    }

    /**
     * Get the dependency property: Application stack dependency.
     *
     * @return the dependency value.
     */
    public String dependency() {
        return this.dependency;
    }

    /**
     * Set the dependency property: Application stack dependency.
     *
     * @param dependency the dependency value to set.
     * @return the ApplicationStack object itself.
     */
    public ApplicationStack withDependency(String dependency) {
        this.dependency = dependency;
        return this;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     *
     * @return the majorVersions value.
     */
    public List<StackMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    /**
     * Set the majorVersions property: List of major versions available.
     *
     * @param majorVersions the majorVersions value to set.
     * @return the ApplicationStack object itself.
     */
    public ApplicationStack withMajorVersions(List<StackMajorVersion> majorVersions) {
        this.majorVersions = majorVersions;
        return this;
    }

    /**
     * Get the frameworks property: List of frameworks associated with application stack.
     *
     * @return the frameworks value.
     */
    public List<ApplicationStack> frameworks() {
        return this.frameworks;
    }

    /**
     * Set the frameworks property: List of frameworks associated with application stack.
     *
     * @param frameworks the frameworks value to set.
     * @return the ApplicationStack object itself.
     */
    public ApplicationStack withFrameworks(List<ApplicationStack> frameworks) {
        this.frameworks = frameworks;
        return this;
    }

    /**
     * Get the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @return the isDeprecated value.
     */
    public List<ApplicationStack> isDeprecated() {
        return this.isDeprecated;
    }

    /**
     * Set the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if this is the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     *
     * @param isDeprecated the isDeprecated value to set.
     * @return the ApplicationStack object itself.
     */
    public ApplicationStack withIsDeprecated(List<ApplicationStack> isDeprecated) {
        this.isDeprecated = isDeprecated;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (majorVersions() != null) {
            majorVersions().forEach(e -> e.validate());
        }
        if (frameworks() != null) {
            frameworks().forEach(e -> e.validate());
        }
        if (isDeprecated() != null) {
            isDeprecated().forEach(e -> e.validate());
        }
    }
}
