// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.appservice.models.FunctionAppMajorVersion;
import com.azure.resourcemanager.appservice.models.StackPreferredOs;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** FunctionAppStack resource specific properties. */
@Immutable
public final class FunctionAppStackProperties {
    /*
     * Function App stack (display only).
     */
    @JsonProperty(value = "displayText", access = JsonProperty.Access.WRITE_ONLY)
    private String displayText;

    /*
     * Function App stack name.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private String value;

    /*
     * List of major versions available.
     */
    @JsonProperty(value = "majorVersions", access = JsonProperty.Access.WRITE_ONLY)
    private List<FunctionAppMajorVersion> majorVersions;

    /*
     * Function App stack preferred OS.
     */
    @JsonProperty(value = "preferredOs", access = JsonProperty.Access.WRITE_ONLY)
    private StackPreferredOs preferredOs;

    /** Creates an instance of FunctionAppStackProperties class. */
    public FunctionAppStackProperties() {
    }

    /**
     * Get the displayText property: Function App stack (display only).
     *
     * @return the displayText value.
     */
    public String displayText() {
        return this.displayText;
    }

    /**
     * Get the value property: Function App stack name.
     *
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     *
     * @return the majorVersions value.
     */
    public List<FunctionAppMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    /**
     * Get the preferredOs property: Function App stack preferred OS.
     *
     * @return the preferredOs value.
     */
    public StackPreferredOs preferredOs() {
        return this.preferredOs;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (majorVersions() != null) {
            majorVersions().forEach(e -> e.validate());
        }
    }
}
