// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.appservice.models.MySqlMigrationType;
import com.fasterxml.jackson.annotation.JsonProperty;

/** MigrateMySqlRequest resource specific properties. */
@Fluent
public final class MigrateMySqlRequestProperties {
    /*
     * Connection string to the remote MySQL database.
     */
    @JsonProperty(value = "connectionString", required = true)
    private String connectionString;

    /*
     * The type of migration operation to be done
     */
    @JsonProperty(value = "migrationType", required = true)
    private MySqlMigrationType migrationType;

    /** Creates an instance of MigrateMySqlRequestProperties class. */
    public MigrateMySqlRequestProperties() {
    }

    /**
     * Get the connectionString property: Connection string to the remote MySQL database.
     *
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.connectionString;
    }

    /**
     * Set the connectionString property: Connection string to the remote MySQL database.
     *
     * @param connectionString the connectionString value to set.
     * @return the MigrateMySqlRequestProperties object itself.
     */
    public MigrateMySqlRequestProperties withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        return this;
    }

    /**
     * Get the migrationType property: The type of migration operation to be done.
     *
     * @return the migrationType value.
     */
    public MySqlMigrationType migrationType() {
        return this.migrationType;
    }

    /**
     * Set the migrationType property: The type of migration operation to be done.
     *
     * @param migrationType the migrationType value to set.
     * @return the MigrateMySqlRequestProperties object itself.
     */
    public MigrateMySqlRequestProperties withMigrationType(MySqlMigrationType migrationType) {
        this.migrationType = migrationType;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectionString() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property connectionString in model MigrateMySqlRequestProperties"));
        }
        if (migrationType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property migrationType in model MigrateMySqlRequestProperties"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(MigrateMySqlRequestProperties.class);
}
