// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** StaticSiteUserInvitationResponseResource resource specific properties. */
@Immutable
public final class StaticSiteUserInvitationResponseResourceProperties {
    /*
     * The expiration time of the invitation
     */
    @JsonProperty(value = "expiresOn", access = JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime expiresOn;

    /*
     * The url for the invitation link
     */
    @JsonProperty(value = "invitationUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String invitationUrl;

    /** Creates an instance of StaticSiteUserInvitationResponseResourceProperties class. */
    public StaticSiteUserInvitationResponseResourceProperties() {
    }

    /**
     * Get the expiresOn property: The expiration time of the invitation.
     *
     * @return the expiresOn value.
     */
    public OffsetDateTime expiresOn() {
        return this.expiresOn;
    }

    /**
     * Get the invitationUrl property: The url for the invitation link.
     *
     * @return the invitationUrl value.
     */
    public String invitationUrl() {
        return this.invitationUrl;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
