// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.WorkflowEnvelopeProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Workflow properties definition. */
@Fluent
public final class WorkflowEnvelopeInner {
    /*
     * The resource id.
     */
    @JsonProperty(value = "id", access = JsonProperty.Access.WRITE_ONLY)
    private String id;

    /*
     * Gets the resource name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Gets the resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /*
     * The resource kind.
     */
    @JsonProperty(value = "kind")
    private String kind;

    /*
     * The resource location.
     */
    @JsonProperty(value = "location")
    private String location;

    /*
     * Additional workflow properties.
     */
    @JsonProperty(value = "properties")
    private WorkflowEnvelopeProperties properties;

    /** Creates an instance of WorkflowEnvelopeInner class. */
    public WorkflowEnvelopeInner() {
    }

    /**
     * Get the id property: The resource id.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Gets the resource name.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Gets the resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the kind property: The resource kind.
     *
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: The resource kind.
     *
     * @param kind the kind value to set.
     * @return the WorkflowEnvelopeInner object itself.
     */
    public WorkflowEnvelopeInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the location property: The resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: The resource location.
     *
     * @param location the location value to set.
     * @return the WorkflowEnvelopeInner object itself.
     */
    public WorkflowEnvelopeInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the properties property: Additional workflow properties.
     *
     * @return the properties value.
     */
    public WorkflowEnvelopeProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Additional workflow properties.
     *
     * @param properties the properties value to set.
     * @return the WorkflowEnvelopeInner object itself.
     */
    public WorkflowEnvelopeInner withProperties(WorkflowEnvelopeProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }
}
