// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The access control configuration policy. */
@Fluent
public final class FlowAccessControlConfigurationPolicy {
    /*
     * The allowed caller IP address ranges.
     */
    @JsonProperty(value = "allowedCallerIpAddresses")
    private List<IpAddressRange> allowedCallerIpAddresses;

    /*
     * The authentication policies for workflow.
     */
    @JsonProperty(value = "openAuthenticationPolicies")
    private OpenAuthenticationAccessPolicies openAuthenticationPolicies;

    /** Creates an instance of FlowAccessControlConfigurationPolicy class. */
    public FlowAccessControlConfigurationPolicy() {
    }

    /**
     * Get the allowedCallerIpAddresses property: The allowed caller IP address ranges.
     *
     * @return the allowedCallerIpAddresses value.
     */
    public List<IpAddressRange> allowedCallerIpAddresses() {
        return this.allowedCallerIpAddresses;
    }

    /**
     * Set the allowedCallerIpAddresses property: The allowed caller IP address ranges.
     *
     * @param allowedCallerIpAddresses the allowedCallerIpAddresses value to set.
     * @return the FlowAccessControlConfigurationPolicy object itself.
     */
    public FlowAccessControlConfigurationPolicy withAllowedCallerIpAddresses(
        List<IpAddressRange> allowedCallerIpAddresses) {
        this.allowedCallerIpAddresses = allowedCallerIpAddresses;
        return this;
    }

    /**
     * Get the openAuthenticationPolicies property: The authentication policies for workflow.
     *
     * @return the openAuthenticationPolicies value.
     */
    public OpenAuthenticationAccessPolicies openAuthenticationPolicies() {
        return this.openAuthenticationPolicies;
    }

    /**
     * Set the openAuthenticationPolicies property: The authentication policies for workflow.
     *
     * @param openAuthenticationPolicies the openAuthenticationPolicies value to set.
     * @return the FlowAccessControlConfigurationPolicy object itself.
     */
    public FlowAccessControlConfigurationPolicy withOpenAuthenticationPolicies(
        OpenAuthenticationAccessPolicies openAuthenticationPolicies) {
        this.openAuthenticationPolicies = openAuthenticationPolicies;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (allowedCallerIpAddresses() != null) {
            allowedCallerIpAddresses().forEach(e -> e.validate());
        }
        if (openAuthenticationPolicies() != null) {
            openAuthenticationPolicies().validate();
        }
    }
}
