// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/** Provisioning state of the Kubernetes Environment. */
public enum KubeEnvironmentProvisioningState {
    /** Enum value Succeeded. */
    SUCCEEDED("Succeeded"),

    /** Enum value Failed. */
    FAILED("Failed"),

    /** Enum value Canceled. */
    CANCELED("Canceled"),

    /** Enum value Waiting. */
    WAITING("Waiting"),

    /** Enum value InitializationInProgress. */
    INITIALIZATION_IN_PROGRESS("InitializationInProgress"),

    /** Enum value InfrastructureSetupInProgress. */
    INFRASTRUCTURE_SETUP_IN_PROGRESS("InfrastructureSetupInProgress"),

    /** Enum value InfrastructureSetupComplete. */
    INFRASTRUCTURE_SETUP_COMPLETE("InfrastructureSetupComplete"),

    /** Enum value ScheduledForDelete. */
    SCHEDULED_FOR_DELETE("ScheduledForDelete"),

    /** Enum value UpgradeRequested. */
    UPGRADE_REQUESTED("UpgradeRequested"),

    /** Enum value UpgradeFailed. */
    UPGRADE_FAILED("UpgradeFailed");

    /** The actual serialized value for a KubeEnvironmentProvisioningState instance. */
    private final String value;

    KubeEnvironmentProvisioningState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a KubeEnvironmentProvisioningState instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed KubeEnvironmentProvisioningState object, or null if unable to parse.
     */
    @JsonCreator
    public static KubeEnvironmentProvisioningState fromString(String value) {
        if (value == null) {
            return null;
        }
        KubeEnvironmentProvisioningState[] items = KubeEnvironmentProvisioningState.values();
        for (KubeEnvironmentProvisioningState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
