// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The request history. */
@Fluent
public final class RequestHistoryProperties {
    /*
     * The time the request started.
     */
    @JsonProperty(value = "startTime")
    private OffsetDateTime startTime;

    /*
     * The time the request ended.
     */
    @JsonProperty(value = "endTime")
    private OffsetDateTime endTime;

    /*
     * The request.
     */
    @JsonProperty(value = "request")
    private Request request;

    /*
     * The response.
     */
    @JsonProperty(value = "response")
    private Response response;

    /** Creates an instance of RequestHistoryProperties class. */
    public RequestHistoryProperties() {
    }

    /**
     * Get the startTime property: The time the request started.
     *
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Set the startTime property: The time the request started.
     *
     * @param startTime the startTime value to set.
     * @return the RequestHistoryProperties object itself.
     */
    public RequestHistoryProperties withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    /**
     * Get the endTime property: The time the request ended.
     *
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Set the endTime property: The time the request ended.
     *
     * @param endTime the endTime value to set.
     * @return the RequestHistoryProperties object itself.
     */
    public RequestHistoryProperties withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    /**
     * Get the request property: The request.
     *
     * @return the request value.
     */
    public Request request() {
        return this.request;
    }

    /**
     * Set the request property: The request.
     *
     * @param request the request value to set.
     * @return the RequestHistoryProperties object itself.
     */
    public RequestHistoryProperties withRequest(Request request) {
        this.request = request;
        return this;
    }

    /**
     * Get the response property: The response.
     *
     * @return the response value.
     */
    public Response response() {
        return this.response;
    }

    /**
     * Set the response property: The response.
     *
     * @param response the response value to set.
     * @return the RequestHistoryProperties object itself.
     */
    public RequestHistoryProperties withResponse(Response response) {
        this.response = response;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (request() != null) {
            request().validate();
        }
        if (response() != null) {
            response().validate();
        }
    }
}
