// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.fluent.models.WorkflowVersionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The list of workflow versions. */
@Fluent
public final class WorkflowVersionListResult {
    /*
     * A list of workflow versions.
     */
    @JsonProperty(value = "value")
    private List<WorkflowVersionInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of WorkflowVersionListResult class. */
    public WorkflowVersionListResult() {
    }

    /**
     * Get the value property: A list of workflow versions.
     *
     * @return the value value.
     */
    public List<WorkflowVersionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of workflow versions.
     *
     * @param value the value value to set.
     * @return the WorkflowVersionListResult object itself.
     */
    public WorkflowVersionListResult withValue(List<WorkflowVersionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the WorkflowVersionListResult object itself.
     */
    public WorkflowVersionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
