// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * ASE region resource specific properties.
 */
@Fluent
public final class AseRegionProperties {
    /*
     * Display name for region.
     */
    @JsonProperty(value = "displayName", access = JsonProperty.Access.WRITE_ONLY)
    private String displayName;

    /*
     * Is region standard.
     */
    @JsonProperty(value = "standard", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean standard;

    /*
     * Dedicated host enabled.
     */
    @JsonProperty(value = "dedicatedHost", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean dedicatedHost;

    /*
     * Zone redundant deployment enabled.
     */
    @JsonProperty(value = "zoneRedundant", access = JsonProperty.Access.WRITE_ONLY)
    private Boolean zoneRedundant;

    /*
     * Available Skus in region.
     */
    @JsonProperty(value = "availableSku")
    private List<String> availableSku;

    /*
     * Available OSs in region.
     */
    @JsonProperty(value = "availableOS")
    private List<String> availableOS;

    /**
     * Creates an instance of AseRegionProperties class.
     */
    public AseRegionProperties() {
    }

    /**
     * Get the displayName property: Display name for region.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Get the standard property: Is region standard.
     * 
     * @return the standard value.
     */
    public Boolean standard() {
        return this.standard;
    }

    /**
     * Get the dedicatedHost property: Dedicated host enabled.
     * 
     * @return the dedicatedHost value.
     */
    public Boolean dedicatedHost() {
        return this.dedicatedHost;
    }

    /**
     * Get the zoneRedundant property: Zone redundant deployment enabled.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    /**
     * Get the availableSku property: Available Skus in region.
     * 
     * @return the availableSku value.
     */
    public List<String> availableSku() {
        return this.availableSku;
    }

    /**
     * Set the availableSku property: Available Skus in region.
     * 
     * @param availableSku the availableSku value to set.
     * @return the AseRegionProperties object itself.
     */
    public AseRegionProperties withAvailableSku(List<String> availableSku) {
        this.availableSku = availableSku;
        return this;
    }

    /**
     * Get the availableOS property: Available OSs in region.
     * 
     * @return the availableOS value.
     */
    public List<String> availableOS() {
        return this.availableOS;
    }

    /**
     * Set the availableOS property: Available OSs in region.
     * 
     * @param availableOS the availableOS value to set.
     * @return the AseRegionProperties object itself.
     */
    public AseRegionProperties withAvailableOS(List<String> availableOS) {
        this.availableOS = availableOS;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
