// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Backup description.
 */
@Fluent
public final class BackupItemInner extends ProxyOnlyResource {
    /*
     * BackupItem resource specific properties
     */
    @JsonProperty(value = "properties")
    private BackupItemProperties innerProperties;

    /**
     * Creates an instance of BackupItemInner class.
     */
    public BackupItemInner() {
    }

    /**
     * Get the innerProperties property: BackupItem resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private BackupItemProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BackupItemInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the backupId property: Id of the backup.
     * 
     * @return the backupId value.
     */
    public Integer backupId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupId();
    }

    /**
     * Get the storageAccountUrl property: SAS URL for the storage account container which contains this backup.
     * 
     * @return the storageAccountUrl value.
     */
    public String storageAccountUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountUrl();
    }

    /**
     * Get the blobName property: Name of the blob which contains data for this backup.
     * 
     * @return the blobName value.
     */
    public String blobName() {
        return this.innerProperties() == null ? null : this.innerProperties().blobName();
    }

    /**
     * Get the name property: Name of this backup.
     * 
     * @return the name value.
     */
    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    /**
     * Get the status property: Backup status.
     * 
     * @return the status value.
     */
    public BackupItemStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the sizeInBytes property: Size of the backup in bytes.
     * 
     * @return the sizeInBytes value.
     */
    public Long sizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInBytes();
    }

    /**
     * Get the created property: Timestamp of the backup creation.
     * 
     * @return the created value.
     */
    public OffsetDateTime created() {
        return this.innerProperties() == null ? null : this.innerProperties().created();
    }

    /**
     * Get the log property: Details regarding this backup. Might contain an error message.
     * 
     * @return the log value.
     */
    public String log() {
        return this.innerProperties() == null ? null : this.innerProperties().log();
    }

    /**
     * Get the databases property: List of databases included in the backup.
     * 
     * @return the databases value.
     */
    public List<DatabaseBackupSetting> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    /**
     * Get the scheduled property: True if this backup has been created due to a schedule being triggered.
     * 
     * @return the scheduled value.
     */
    public Boolean scheduled() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduled();
    }

    /**
     * Get the lastRestoreTimestamp property: Timestamp of a last restore operation which used this backup.
     * 
     * @return the lastRestoreTimestamp value.
     */
    public OffsetDateTime lastRestoreTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRestoreTimestamp();
    }

    /**
     * Get the finishedTimestamp property: Timestamp when this backup finished.
     * 
     * @return the finishedTimestamp value.
     */
    public OffsetDateTime finishedTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().finishedTimestamp();
    }

    /**
     * Get the correlationId property: Unique correlation identifier. Please use this along with the timestamp while
     * communicating with Azure support.
     * 
     * @return the correlationId value.
     */
    public String correlationId() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationId();
    }

    /**
     * Get the websiteSizeInBytes property: Size of the original web app which has been backed up.
     * 
     * @return the websiteSizeInBytes value.
     */
    public Long websiteSizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().websiteSizeInBytes();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
