// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/**
 * User credentials used for publishing activity.
 */
@Fluent
public final class DeploymentInner extends ProxyOnlyResource {
    /*
     * Deployment resource specific properties
     */
    @JsonProperty(value = "properties")
    private DeploymentProperties innerProperties;

    /**
     * Creates an instance of DeploymentInner class.
     */
    public DeploymentInner() {
    }

    /**
     * Get the innerProperties property: Deployment resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private DeploymentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DeploymentInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the status property: Deployment status.
     * 
     * @return the status value.
     */
    public Integer status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Set the status property: Deployment status.
     * 
     * @param status the status value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withStatus(Integer status) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withStatus(status);
        return this;
    }

    /**
     * Get the message property: Details about deployment status.
     * 
     * @return the message value.
     */
    public String message() {
        return this.innerProperties() == null ? null : this.innerProperties().message();
    }

    /**
     * Set the message property: Details about deployment status.
     * 
     * @param message the message value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withMessage(String message) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withMessage(message);
        return this;
    }

    /**
     * Get the author property: Who authored the deployment.
     * 
     * @return the author value.
     */
    public String author() {
        return this.innerProperties() == null ? null : this.innerProperties().author();
    }

    /**
     * Set the author property: Who authored the deployment.
     * 
     * @param author the author value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withAuthor(String author) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withAuthor(author);
        return this;
    }

    /**
     * Get the deployer property: Who performed the deployment.
     * 
     * @return the deployer value.
     */
    public String deployer() {
        return this.innerProperties() == null ? null : this.innerProperties().deployer();
    }

    /**
     * Set the deployer property: Who performed the deployment.
     * 
     * @param deployer the deployer value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withDeployer(String deployer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withDeployer(deployer);
        return this;
    }

    /**
     * Get the authorEmail property: Author email.
     * 
     * @return the authorEmail value.
     */
    public String authorEmail() {
        return this.innerProperties() == null ? null : this.innerProperties().authorEmail();
    }

    /**
     * Set the authorEmail property: Author email.
     * 
     * @param authorEmail the authorEmail value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withAuthorEmail(String authorEmail) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withAuthorEmail(authorEmail);
        return this;
    }

    /**
     * Get the startTime property: Start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Set the startTime property: Start time.
     * 
     * @param startTime the startTime value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withStartTime(OffsetDateTime startTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withStartTime(startTime);
        return this;
    }

    /**
     * Get the endTime property: End time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Set the endTime property: End time.
     * 
     * @param endTime the endTime value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withEndTime(OffsetDateTime endTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withEndTime(endTime);
        return this;
    }

    /**
     * Get the active property: True if deployment is currently active, false if completed and null if not started.
     * 
     * @return the active value.
     */
    public Boolean active() {
        return this.innerProperties() == null ? null : this.innerProperties().active();
    }

    /**
     * Set the active property: True if deployment is currently active, false if completed and null if not started.
     * 
     * @param active the active value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withActive(Boolean active) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withActive(active);
        return this;
    }

    /**
     * Get the details property: Details on deployment.
     * 
     * @return the details value.
     */
    public String details() {
        return this.innerProperties() == null ? null : this.innerProperties().details();
    }

    /**
     * Set the details property: Details on deployment.
     * 
     * @param details the details value to set.
     * @return the DeploymentInner object itself.
     */
    public DeploymentInner withDetails(String details) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DeploymentProperties();
        }
        this.innerProperties().withDetails(details);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
