// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.appservice.models.PrivateAccessVirtualNetwork;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Description of the parameters of Private Access for a Web Site.
 */
@Fluent
public final class PrivateAccessInner extends ProxyOnlyResource {
    /*
     * PrivateAccess resource specific properties
     */
    @JsonProperty(value = "properties")
    private PrivateAccessProperties innerProperties;

    /**
     * Creates an instance of PrivateAccessInner class.
     */
    public PrivateAccessInner() {
    }

    /**
     * Get the innerProperties property: PrivateAccess resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private PrivateAccessProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PrivateAccessInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the enabled property: Whether private access is enabled or not.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Whether private access is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the PrivateAccessInner object itself.
     */
    public PrivateAccessInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateAccessProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the virtualNetworks property: The Virtual Networks (and subnets) allowed to access the site privately.
     * 
     * @return the virtualNetworks value.
     */
    public List<PrivateAccessVirtualNetwork> virtualNetworks() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworks();
    }

    /**
     * Set the virtualNetworks property: The Virtual Networks (and subnets) allowed to access the site privately.
     * 
     * @param virtualNetworks the virtualNetworks value to set.
     * @return the PrivateAccessInner object itself.
     */
    public PrivateAccessInner withVirtualNetworks(List<PrivateAccessVirtualNetwork> virtualNetworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateAccessProperties();
        }
        this.innerProperties().withVirtualNetworks(virtualNetworks);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
