// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Site seal.
 */
@Fluent
public final class SiteSealInner {
    /*
     * HTML snippet
     */
    @JsonProperty(value = "html", required = true)
    private String html;

    /**
     * Creates an instance of SiteSealInner class.
     */
    public SiteSealInner() {
    }

    /**
     * Get the html property: HTML snippet.
     * 
     * @return the html value.
     */
    public String html() {
        return this.html;
    }

    /**
     * Set the html property: HTML snippet.
     * 
     * @param html the html value to set.
     * @return the SiteSealInner object itself.
     */
    public SiteSealInner withHtml(String html) {
        this.html = html;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (html() == null) {
            throw LOGGER.logExceptionAsError(
                new IllegalArgumentException("Missing required property html in model SiteSealInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SiteSealInner.class);
}
