// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.resourcemanager.appservice.models.StackPreferredOs;
import com.azure.resourcemanager.appservice.models.WebAppMajorVersion;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * WebAppStack resource specific properties.
 */
@Immutable
public final class WebAppStackProperties {
    /*
     * Web App stack (display only).
     */
    @JsonProperty(value = "displayText", access = JsonProperty.Access.WRITE_ONLY)
    private String displayText;

    /*
     * Web App stack name.
     */
    @JsonProperty(value = "value", access = JsonProperty.Access.WRITE_ONLY)
    private String value;

    /*
     * List of major versions available.
     */
    @JsonProperty(value = "majorVersions", access = JsonProperty.Access.WRITE_ONLY)
    private List<WebAppMajorVersion> majorVersions;

    /*
     * Web App stack preferred OS.
     */
    @JsonProperty(value = "preferredOs", access = JsonProperty.Access.WRITE_ONLY)
    private StackPreferredOs preferredOs;

    /**
     * Creates an instance of WebAppStackProperties class.
     */
    public WebAppStackProperties() {
    }

    /**
     * Get the displayText property: Web App stack (display only).
     * 
     * @return the displayText value.
     */
    public String displayText() {
        return this.displayText;
    }

    /**
     * Get the value property: Web App stack name.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Get the majorVersions property: List of major versions available.
     * 
     * @return the majorVersions value.
     */
    public List<WebAppMajorVersion> majorVersions() {
        return this.majorVersions;
    }

    /**
     * Get the preferredOs property: Web App stack preferred OS.
     * 
     * @return the preferredOs value.
     */
    public StackPreferredOs preferredOs() {
        return this.preferredOs;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (majorVersions() != null) {
            majorVersions().forEach(e -> e.validate());
        }
    }
}
