// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.RetryHistory;
import com.azure.resourcemanager.appservice.models.RunActionCorrelation;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The workflow run action.
 */
@Fluent
public final class WorkflowRunActionInner extends SubResource {
    /*
     * The workflow run action properties.
     */
    @JsonProperty(value = "properties")
    private WorkflowRunActionProperties innerProperties;

    /*
     * Gets the workflow run action name.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /*
     * Gets the workflow run action type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Creates an instance of WorkflowRunActionInner class.
     */
    public WorkflowRunActionInner() {
    }

    /**
     * Get the innerProperties property: The workflow run action properties.
     * 
     * @return the innerProperties value.
     */
    private WorkflowRunActionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Gets the workflow run action name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: Gets the workflow run action type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public WorkflowRunActionInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the startTime property: Gets the start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.innerProperties() == null ? null : this.innerProperties().startTime();
    }

    /**
     * Get the endTime property: Gets the end time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.innerProperties() == null ? null : this.innerProperties().endTime();
    }

    /**
     * Get the status property: Gets the status.
     * 
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the code property: Gets the code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.innerProperties() == null ? null : this.innerProperties().code();
    }

    /**
     * Get the error property: Gets the error.
     * 
     * @return the error value.
     */
    public Object error() {
        return this.innerProperties() == null ? null : this.innerProperties().error();
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     * 
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.innerProperties() == null ? null : this.innerProperties().trackingId();
    }

    /**
     * Get the correlation property: The correlation properties.
     * 
     * @return the correlation value.
     */
    public RunActionCorrelation correlation() {
        return this.innerProperties() == null ? null : this.innerProperties().correlation();
    }

    /**
     * Set the correlation property: The correlation properties.
     * 
     * @param correlation the correlation value to set.
     * @return the WorkflowRunActionInner object itself.
     */
    public WorkflowRunActionInner withCorrelation(RunActionCorrelation correlation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowRunActionProperties();
        }
        this.innerProperties().withCorrelation(correlation);
        return this;
    }

    /**
     * Get the inputsLink property: Gets the link to inputs.
     * 
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.innerProperties() == null ? null : this.innerProperties().inputsLink();
    }

    /**
     * Get the outputsLink property: Gets the link to outputs.
     * 
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.innerProperties() == null ? null : this.innerProperties().outputsLink();
    }

    /**
     * Get the trackedProperties property: Gets the tracked properties.
     * 
     * @return the trackedProperties value.
     */
    public Object trackedProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().trackedProperties();
    }

    /**
     * Get the retryHistory property: Gets the retry histories.
     * 
     * @return the retryHistory value.
     */
    public List<RetryHistory> retryHistory() {
        return this.innerProperties() == null ? null : this.innerProperties().retryHistory();
    }

    /**
     * Set the retryHistory property: Gets the retry histories.
     * 
     * @param retryHistory the retryHistory value to set.
     * @return the WorkflowRunActionInner object itself.
     */
    public WorkflowRunActionInner withRetryHistory(List<RetryHistory> retryHistory) {
        if (this.innerProperties() == null) {
            this.innerProperties = new WorkflowRunActionProperties();
        }
        this.innerProperties().withRetryHistory(retryHistory);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
